      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. json.

       CONFIGURATION SECTION.
       REPOSITORY. 
           class json-stream     as "com.iscobol.rts.JSONStream"
           class output-keys     as "javax.xml.transform.OutputKeys"
           class j-string-buffer as "java.lang.StringBuffer"
           .

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.

       77  idx                     pic 9(5).
       77  my-stream               object reference json-stream.
       77  my-stream2              object reference json-stream.

       77  buffer                  object reference j-string-buffer.

       01  gd-record.
           03 gd-first-name        pic x(32).
           03 gd-name              pic x(32).
           03 gd-age               pic xx.

       77  w-first-name            pic x(32).
       77  w-name                  pic x(32).
       77  w-age                   pic xx.

       77  w-indentation-level     pic s99.
       77  e-indentation-level     pic 9.
       77  w-indentation           pic 9.
       77  w-trim                  pic 9.
       77  w-omit-element          pic 9.

       77  path-json               pic x any length.

       01  file-info.
           02  file-size           pic x(8) comp-x.
           02  file-date           pic 9(8) comp-x.
           02  file-time           pic 9(8) comp-x.

       77  wstatus                 pic s9.

      *    You can obtain the following data structure using the
      *    STREAM2WRK  utility
       01  json-memberlist identified by "memberlist".
           03 json-record identified by "record" 
                             occurs dynamic capacity json-record-count.
              05 json-first-name identified by "first_name".
                 07 json-first-name-data pic x any length.
              05 json-name identified by "name".
                 07 json-name-data pic x any length.
              05 json-age identified by "age".
                 07 json-age-data pic x any length.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 1
              col                  2
              title                "Content of Members.json"
              .
           03 gdContent
              grid 
              line                 3
              col                  2
              lines                07 cells
              size                 68 cells
              column-headings
              tiled-headings
              heading-color        257
              display-columns      (1, 20, 40)
              virtual-width        64
              data-columns         (record-position of gd-first-name
                                    record-position of gd-name
                                    record-position of gd-age)
              cursor-frame-width   2
              vscroll
              Row-Background-Color-Pattern = (0, -14675438)
              event                 GRID-EVENT
              .
           03 frame
              engraved
              line                 11
              col                  2
              lines                4  cells
              size                 68 cells
              title                "Insert new records"
              .
           03 label
              line                 13
              col                  4
              size                 11 cells
              title                "First Name:" 
              .
           03 entry-field
              line                 13
              col                  14
              size                 10 cells
              value                w-first-name
              max-text             32
              .
           03 label
              line                 13
              col                  26
              size                 6 cells
              title                "Name:" 
              .
           03 entry-field
              line                 13
              col                  32
              size                 10 cells
              value                w-name
              max-text             32
              .
           03 label
              line                 13
              col                  44
              size                 4 cells
              title                "Age:" 
              .
           03 entry-field
              numeric
              line                 13
              col                  48
              size                 3 cells
              value                w-age
              max-text             2
              .
           03 push-button
              line                 13
              col                  54
              size                 15 cells
              title                "&Add new record"
              exception-value      100
              .
           03 cb-indentation
              check-box
              line                 16
              col                  2
              size                 33 cells
              title               "Generate elements on different lines"
              value w-indentation
              exception-value      103
              .
           03 label
              line                 16
              col                  40
              size                 10 cells
              title                "indentation:"
              .
           03 ef-indentation-level
              entry-field
              numeric
              auto-spin
              min-Val              0
              max-val              99
              line                 16
              col                  51
              size                 6 cells
              value                w-indentation-level
              max-text             2
              enabled              e-indentation-level
              .

           03 cb-trim
              check-box
              line                 18
              col                  2
              size                 33 cells
              title               "Left trim"
              value w-trim
              .
           03 cb-omit-element
              check-box
              line                 18
              col                  40
              size                 33 cells
              title               "Omit empty elements"
              value w-omit-element
              .
           03 push-button
              multiline
              line                 20
              col                  2
              size                 30 cells
              title                "Generate JSON stream in &memory"
              exception-value      200
              self-act
              .
           03 push-button
              multiline
              line                 20
              col                  32
              size                 30 cells
              title                "Generate &JSON"
              exception-value      201
              self-act
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
       PROCEDURE DIVISION.
       MAIN.
           move zero   to e-indentation-level
                          w-indentation
                          w-indentation-level
                          w-trim
                          w-omit-element

           perform VERIFY-EXIST-JSON

           set my-stream to json-stream:>new (json-memberlist)

           my-stream:>readFromFile (path-json)

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "JSONSTREAM Objects"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin
                   event  WIN-EVT

           display Mask
 
           perform LOAD-GRID
           
           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    evaluate crt-status 
                    when 100   
                         perform ADD-JSON-RECORD
                    when 103
                         inquire cb-indentation 
                         value w-indentation
                         if w-indentation = 0
                            move zero to w-indentation 
                                         e-indentation-level
                         else
                            move 1  to w-indentation 
                                       e-indentation-level
                         end-if
                         modify ef-indentation-level 
                                         enabled e-indentation-level 
                    when 200   
                         perform SHOW-JSON
                    when 201   
                         perform WRITE-JSON-STREAM
                    end-evaluate
              end-accept
              move 4   to accept-control
           end-perform 

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       LOAD-GRID.
           modify gdContent reset-grid 1

           modify gdContent (1, 1) cell-data "First Name"
           modify gdContent (1, 2) cell-data "Name"
           modify gdContent (1, 3) cell-data "Age"
           modify gdContent insertion-index 2

           perform varying idx from 1 by 1 until idx > json-record-count
             move json-first-name-data(idx) to gd-first-name
             move json-name-data(idx)       to gd-name
             move json-age-data(idx)        to gd-age
             modify gdContent              record-to-add gd-record
           end-perform
           .

       ADD-JSON-RECORD.
           add 1 to json-record-count
           move w-first-name to json-first-name-data (json-record-count)
           move w-name       to json-name-data (json-record-count)
           move w-age        to json-age-data (json-record-count).

           move spaces to w-first-name, w-name, w-age
           display Mask

           perform LOAD-GRID
           .

       WRITE-JSON-STREAM.
           perform MAKE-SETTING.

           my-stream:>setOutputProperty (output-keys::"ENCODING"
                                         "ISO-8859-1").
           my-stream:>writeToFile (path-json).

       SHOW-JSON. 
           perform MAKE-SETTING
           set my-stream2 to json-stream:>new(json-memberlist)
           set buffer to j-string-buffer:>new
           my-stream2:>writeToStringBuffer ( buffer )
           
           display message buffer:>toString()
           set buffer     to null
           set my-stream2 to null
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       VERIFY-EXIST-JSON.
           call  "C$GETENV" USING "user.home"
                                  path-json.
           string path-json         delimited by trailing space
                  "/Members.json"   delimited by size
                  into path-json.
                  
           call "C$FILEINFO" using path-json, file-info
                             giving wstatus
           evaluate wstatus
           when 0
                continue
           when 1
                perform CREATE-JSON
           end-evaluate.
           
       CREATE-JSON.
           move 1 to idx
           move "John" to gd-first-name
           move "Do"   to gd-name
           move "58"   to gd-age
           perform MOVE-FROM-GRID-TO-OCCURS

           add 1 to idx
           move "Jane"    to gd-first-name
           move "Smith"   to gd-name
           move "24"      to gd-age
           perform MOVE-FROM-GRID-TO-OCCURS

           add 1 to idx
           move "Edwin"   to gd-first-name
           move "Brown"   to gd-name
           move "18"      to gd-age
           perform MOVE-FROM-GRID-TO-OCCURS

           add 1 to idx
           move "Jack"    to gd-first-name
           move "Frost"   to gd-name
           move "60"      to gd-age
           perform MOVE-FROM-GRID-TO-OCCURS

           set my-stream to json-stream:>new (json-memberlist)
           perform WRITE-JSON-STREAM.

       GRID-EVENT.
           if event-type = msg-finish-entry
              inquire gdContent record-data gd-record
              subtract 1 from event-data-2 giving idx
              perform MOVE-FROM-GRID-TO-OCCURS
           end-if.

       MAKE-SETTING.
           if w-indentation = zero
              move -1  to w-indentation-level
           end-if

           set environment "jsonstream.indent_number" 
                    to w-indentation-level.

           set environment "jsonstream.rtrim"   to w-trim.
           
           set environment "jsonstream.omit_empty_elements"
                                               to w-omit-element.

       MOVE-FROM-GRID-TO-OCCURS.
           move gd-first-name to json-first-name-data(idx).
           move gd-name       to json-name-data(idx).
           move gd-age        to json-age-data(idx).