      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.

       PROGRAM-ID. httphandler2.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           CLASS WEB-AREA AS "com.iscobol.rts.HTTPHandler"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       01  input-buffer identified by "_input_buffer".
           03 filler identified by "_input_name".
              05  xml-name         pic x any length.

       01 output-buffer identified by "_output_buffer".
           03  filler identified by "_status".
              05 response-status   pic x(2).
           03  filler identified by "_message".
              05 response-message  pic x any length.
           03 filler identified by "_returntext".
              05  xml-returntext   pic x any length.

       77  version                 pic x any length.

       LINKAGE SECTION.
       01 LNK-AREA OBJECT REFERENCE WEB-AREA.

       PROCEDURE DIVISION USING LNK-AREA.

       MAIN.
      *    recive data from html
           LNK-AREA:>accept(input-buffer).

           move "Operation successful" to response-message.
           move "OK" to response-status.

           call "C$VERSION" using version
           string "Hello "                  delimited by size
                  xml-name                  delimited by trailing space
                  ".<BR>"                   delimited by size
                  "Your isCOBOL version is: "  delimited by size
                  "<BR>"                    delimited by size
                  version                   delimited by size
                  into xml-returntext

      *    send data to html
           lnk-area:>displayXML (output-buffer).
           goback.


