      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. border.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.    
       77  close-win               pic 9 value 0.     
       77  control-font            handle of font.

       77  hToolBar                handle of window.
       77  hBmpTB                  pic s9(9) comp-4.
       77  hEf                     handle of entry-field.
       77  help-enabled            pic 9.
       77  bmp-num-help            pic 99.
       78  78-help-enabled         value 8.
       78  78-help-disabled        value 7.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 8 cells
              title                "Title:"
              transparent
              .       
           03 Ef1
              entry-field
              line                 2
              col                  12
              size                 58 cells
              help-id              1
              border-width         (0, 0, 2, 0)
              border-color         rgb x#dae1e5
              .
           03 label
              line                 4 
              col                  2
              size                 8 cells
              title                "Length:"
              transparent
              .
           03 Ef2
              entry-field
              line                 4
              col                  12
              size                 58 cells
              help-id              2
              border-width         (0, 0, 2, 0)
              border-color         rgb x#dae1e5
              .
           03 label
              line                 6
              col                  2
              size                 8 cells
              title                "Artist:"
              transparent
              .
           03 Ef3
              entry-field
              line                 6
              col                  12
              size                 58 cells
              help-id              3
              border-width         (0, 0, 2, 0)
              border-color         rgb x#dae1e5
              .
           03 label
              line                 8
              col                  2
              size                 8 cells
              title                "Genre:"
              transparent
              .
           03 Ef4
              entry-field
              line                 8
              col                  12
              size                 58 cells
              help-id              4
              border-width         (0, 0, 2, 0)
              border-color         rgb x#dae1e5
              .
           03 label
              line                 10
              col                  2
              size                 8 cells
              title                "Label:"
              transparent
              .
           03 Ef5
              entry-field
              line                 10
              col                  12
              size                 58 cells
              help-id              5
              border-width         (0, 0, 2, 0)
              border-color         rgb x#dae1e5
              .
           03 label
              line                 12
              col                  2
              size                 8 cells
              title                "Year:"
              transparent
              .
           03 Ef6
              entry-field
              line                 12
              col                  12
              size                 58 cells
              help-id              6
              border-width         (0, 0, 2, 0)
              border-color         rgb x#dae1e5
              .
           03 label
              line                 14
              col                  2
              size                 9 cells
              title                "Comments:"
              transparent
              .
           03 Ef6
              entry-field
              line                 14
              lines                4
              multiline
              col                  12
              size                 58 cells
              help-id              7
              border-width         (0, 0, 2, 0)
              border-color         rgb x#dae1e5
              .
           03 push-button
              flat
              line                 19.7
              col                  2 
              size                 20 cells
              title                "Help program source" 
              background-color     rgb x#6883AE
              foreground-color     rgb x#FFFFFF
              exception-value      110
              .
           03 Pb-exit  
              push-button
              flat
              line                 19.7
              col                  50
              size                 20 cells
              title                "Exit" 
              background-color     rgb x#6883AE
              foreground-color     rgb x#FFFFFF
              exception-value      27
              .

       01  Mask-Tool.
           03 push-button 
              title                "Exit"
              title-position       1
              hint                 "Esc"
              self-act
              line                 2
              col                  2
              lines                16 
              size                 10 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        1
              bitmap-width         16
              exception-value      27
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              .
           03 push-button 
              title                "Cut"
              self-act
              line                 2 
              col                  + 1
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        2
              bitmap-width         16
              exception-value      101
              .
           03 push-button 
              title                "Copy"
              self-act
              line                 2
              col                  + 1
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        3
              bitmap-width         16
              exception-value      102
              .
           03 push-button
              title                "Paste"
              self-act
              line                 2 
              col                  + 1  
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        4
              bitmap-width         16
              exception-value      103
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              .
           03 pb-help
              push-button 
              title                "Help"
              self-act
              line                 2 
              col                  + 1  
              lines                16 
              size                 16
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        bmp-num-help
              bitmap-width         16
              exception-value      104
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".

           move 0   to help-enabled
           perform HELP
           
           set environment "gui.curr_border_color"   to "-10079487"
           set environment "gui.curr_border_width"   to "1 1 1 1"

           set environment "gui.rollover_border_color"   to "-10079487"
           set environment "gui.rollover_border_width"   to "2 2 2 2"

           set exception value 1 to item-help 
           set environment "HELP-PROGRAM" to "helpprg"
           set environment "key.^f1" to "exception=104"


           call "W$BITMAP" using wbitmap-load, "files/tools.gif"
                          giving hBmpTB.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "BORDERS and Mouseover HOOK"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   gradient-color-1 rgb x#ffffff
                   gradient-color-2 rgb x#F2F6F9 
                   handle hWin
                   event  WIN-EVT

           display Mask

           display tool-bar control font control-font 
                    handle hToolBar.
           display Mask-Tool upon hToolBar.

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    move control-handle to hEf
              end-accept
              evaluate crt-status
              when 101 
                   perform CUT-TEXT
              when 102 
                   perform COPY-TEXT
              when 103 
                   perform PASTE-TEXT
              when 104
                   perform HELP
              when 110
                   perform VIEW-SOURCE
              end-evaluate
              move 4 to accept-control
           end-perform
                    
           destroy Mask
           destroy Mask-Tool
           destroy hToolBar
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, hBmpTB
           goback
           .
       HELP.
           if help-enabled = 0
              move 1 to help-enabled
              set environment "help_program_mouse_stop_delay"   to 300
      *        set environment "HELP-PROGRAM" to "helpprg"
              move 78-help-enabled to bmp-num-help
           else
              move 0 to help-enabled
              set environment "help_program_mouse_stop_delay"   to 0
      *        set environment "HELP-PROGRAM" to " "
              move 78-help-disabled to bmp-num-help
           end-if
           modify pb-help bitmap-number bmp-num-help
           .

       COPY-TEXT.
           modify hEf action action-copy
           .

       CUT-TEXT.
           modify hEf action action-cut
           .

       PASTE-TEXT.
           modify hEf action action-paste
           .
            
       VIEW-SOURCE.
           initialize command
           string base-sorg-path delimited by trailing space
                  "s-news"       delimited by space
                  "/HELPPRG.cbl" delimited by size
                                 into command.
           call run "TEXTVIEWER" using command
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
