      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. mdi.

       WORKING-STORAGE SECTION. 
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  close-win               pic 9 value 0.
       77  control-font            handle of font.
       77  h-mdi-parent            handle of window.
       77  h-mdi-child-1           handle of window.
       77  h-mdi-child-2           handle of window.

       77  curr-win-handle         handle of window.
       
       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       77  h-tool-mdi-parent       handle of window.
       77  h-sb-child-1            handle of status-bar.
       77  h-sb-child-2            handle of status-bar.
       
       77  hBmpTB                  pic s9(9) comp-4.

       SCREEN SECTION.
       01  s-mdi-1.
           03 label 
              line                 2 
              col                  2 
              title                "Code:"
              .
           03 entry-field 
              line                 4 
              col                  2 
              size                 25
              .
           03 push-button
              line                 8 
              col                  2 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
       01  s-mdi-2.
           03 label 
              line                 2 
              col                  2 
              title                "Name:"
              .
           03 entry-field 
              line                 4 
              col                  2 
              size                 25
              .
           03 push-button
              line                 8 
              col                  2 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .
       01  s-tool-mdi-parent.
           03 push-button 
              title                "Child 1"
              title-position       2
              hint                 "Show MDI child 1"
              self-act
              line                 2 
              col                  2  
              lines                16 
              size                 10 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        1
              bitmap-width         16
              exception-value      11
              .
           03 push-button 
              title                "Child 2"
              title-position       2
              hint                 "Show MDI child 2"
              self-act
              line                 2 
              col                  + 1  
              lines                16 
              size                 10 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        1
              bitmap-width         16
              exception-value      12
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              .
           03 push-button 
              title                "View &Source [F2]"
              self-act
              line                 2 
              col                  + 1  
              size                 16 cells
              exception-value      2
              .
           03 bar
              col                  + 1
              lines                2 
              width                2
              color                16
              shading              (-1, 1)
              .
           03 push-button 
              title                "Exit"
              title-position       1
              hint                 "Esc"
              self-act
              line                 2 
              col                  + 1
              lines                16 
              size                 10 cells
              bitmap 
              bitmap-handle        hBmpTB
              bitmap-number        2
              bitmap-width         16
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept base-sorg-path from environment "home_source".
           call "W$BITMAP" using wbitmap-load, "files/mditool.png"
                          giving hBmpTB.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           perform MDI-PARENT-MENU.

           display mdi-parent  window
                   background-low 
                   resizable
                   line           2
                   col            50
                   lines          15
                   size           60
                   min-lines      15
                   min-size       60
                   title          "MDI Parent Window"
                   system menu
                   control font   control-font
                   event          WIN-EVT
                   handle         h-mdi-parent

           call "w$menu" using wmenu-show menu-handle.

           display tool-bar upon h-mdi-parent handle h-tool-mdi-parent
                   control font control-font
           display s-tool-mdi-parent upon h-tool-mdi-parent.
           call "w$flush" using 1 h-mdi-parent.

           perform CREATE-CHILD-1
           perform CREATE-CHILD-2

           move h-mdi-child-2 to curr-win-handle

           perform until crt-status = 27 or close-win = 1
              if h-mdi-child-1 = 0 and 
                 h-mdi-child-2
                 accept omitted 
                    on exception 
                       continue 
                 end-accept
              else 
                 evaluate curr-win-handle
                 when h-mdi-child-1 
                      accept s-mdi-1 
                         on exception 
                             continue 
                      end-accept
                 when h-mdi-child-2 
                      accept s-mdi-2 
                         on exception 
                            continue 
                      end-accept
                 end-evaluate
              end-if
              evaluate crt-status
              when 2
                   perform VIEW-SORG
              when 27
                   perform WINDOW-CLOSE
              when 96
                   evaluate event-type
                   when cmd-activate 
                        perform WINDOW-FOCUS
                   when cmd-close    
                        perform WINDOW-CLOSE
                   end-evaluate
              when 11
              when 1001
                   if h-mdi-child-1 = zero
                      perform CREATE-CHILD-1
                   end-if
                   move h-mdi-child-1 to curr-win-handle
              when 12
              when 1002
                   if h-mdi-child-2 = zero
                      perform CREATE-CHILD-2
                   end-if
                   move h-mdi-child-2 to curr-win-handle
              when 1003
                   display message "MDI Parent menu"
              end-evaluate
              move 4   to accept-control
           end-perform

           move 0 to crt-status

           destroy h-mdi-child-1 h-mdi-child-2
           destroy h-mdi-parent.

           call "W$BITMAP" using wbitmap-destroy, hBmpTB
           goback.


       WIN-EVT.
           evaluate event-type
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       WINDOW-FOCUS.
           if event-window-handle = h-mdi-child-1 or h-mdi-child-2
              set input window         to event-window-handle
              move event-window-handle to curr-win-handle
           end-if
           .

       WINDOW-CLOSE.
           evaluate event-window-handle
           when h-mdi-child-1 
                destroy h-mdi-child-1
                move h-mdi-child-2 to curr-win-handle
                move 0             to crt-status
           when h-mdi-child-2
                destroy h-mdi-child-2
                move h-mdi-child-1 to curr-win-handle
                move 0             to crt-status
           end-evaluate
           .

       CREATE-CHILD-1.
           display mdi-child window 
                   upon           h-mdi-parent
                   title          "MDI Child 1"
                   line           2
                   col            2
                   size           30
                   lines          9
                   layout-manager lm-zoom
                   resizable
                   system menu
                   control font   control-font
                   handle         h-mdi-child-1.

           display s-mdi-1 upon h-mdi-child-1
           .

       CREATE-CHILD-2.
           display mdi-child window 
                   upon           h-mdi-parent
                   title          "MDI Child 2"
                   line           4
                   col            6 
                   size           30
                   lines          9
                   layout-manager lm-zoom
                   resizable
                   system menu
                   control font   control-font
                   handle         h-mdi-child-2

           display s-mdi-2 upon h-mdi-child-2
           .

       MDI-PARENT-MENU.
           call "w$menu" using wmenu-new giving menu-handle.
           call "w$menu" using wmenu-new giving sub-handle-1.
           call "w$menu" using wmenu-new giving sub-handle-1.
           call "w$menu" using wmenu-add menu-handle 0 0 "Menu" 
                                                         1000 
           sub-handle-1.
           call "w$menu" using wmenu-add sub-handle-1 0 0 "CHILD 1" 
                                                          1001.
           call "w$menu" using wmenu-add sub-handle-1 0 0 "CHILD 2" 
                                                          1002.
           call "w$menu" using wmenu-add sub-handle-1 0 0 "Menu Parent" 
                                                          1003.
           call "w$menu" using wmenu-add sub-handle-1 0 0 "Exit" 27.
           
       VIEW-SORG.
           initialize command
           string base-sorg-path   delimited by trailing space
                  "s-gui"          delimited by space
                  "/MDI.cbl"       delimited by size
                  into command.

           call run "TEXTVIEWER"  using command.
           