      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. grid.

       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status                 special-names crt status pic 9(5).
       77  hWin                       handle of window.
       77  control-font               handle of font.
       77  close-win                  pic 9    value 0.

       77  title-grid                 pic x(150).
       77  title-grid-load-on-demand  pic x(200).
       77  title-paged-grid           pic x(150).
       
       SCREEN SECTION.

       01  mask.
           03 frame
              engraved
              line 2
              col 3
              size 32
              lines 10
              title "Standard Grid"
              .
           03 push-button 
              line                 4 
              col                  4 
              size                 18
              title                "Grid" 
              exception-value      1
              .
           03 label
              line 6
              lines 5
              col 4
              size 30
              title title-grid
              .
           03 frame
              engraved
              line 2
              col 38
              size 32
              lines 10
              title "Paged Grid"
              .
           03 push-button 
              line                 4
              col                  39
              size                 18
              title                "Paged Grid"
              exception-value      2
              .
           03 label
              line 6
              lines 5
              col 39
              size 30
              title title-paged-grid 
              .

           03 frame
              engraved
              line 12
              col 3
              size 32
              lines 8
              title "Grid Load on demand"
              .
           03 push-button 
              line                 14
              col                  4
              size                 18
              title                "Grid Load on demand" 
              exception-value      3
              .
           03 label
              line 16
              lines 3
              col 4
              size 30
              title title-grid-load-on-demand
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.   
       MAIN.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           initialize title-grid
           string "This is the standard grid used to display and "
                  "accept data inside cells."
                  x"0A"
                  "It shows scroll-bars to show more data if required."
                  delimited by size
                  into title-grid

           initialize title-paged-grid
           string "This paged grid is suggested when handling a large "
                  "amount of data, to save memory and loading time." 
                  x"0A"
                  "It only loads one screen of data at a time."
                  delimited by size
                  into title-paged-grid

           initialize title-grid-load-on-demand 
           string "This is a grid that loads records when needed, "
                  "as the user navigates the grid"
                  delimited by size
                  into title-grid-load-on-demand 

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "GRID and PAGED GRID Controls"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT
                   control font control-font

           display mask

           perform until crt-status = 27 or close-win = 1
              accept  mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 1 
                   call run "GRID-STD"
              when 2 
                   call run "GRID-PAGED"
              when 3 
                   call run "GRID-ON-DEMAND"
              end-evaluate
              move 4   to accept-control
           end-perform 

           destroy mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

