*> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.

 PROGRAM-ID. LOOKUP.
 configuration section.
 special-names.

 INPUT-OUTPUT SECTION.
 FILE-CONTROL.
 DATA DIVISION.
 FILE SECTION.

 WORKING-STORAGE SECTION.

 
 copy "isfonts.def".
 copy "isgui.def".
 copy "iscobol.def".
 copy "iscrt.def".
 copy "isresize.def".
 copy "songs.wrk".
 copy "color.wrk".
 
 77 key-status         is special-names crt status pic 9(5).
 77 h-tool             handle of window.
 77 h-sta              handle of window.

 01  rec-grid.
    05 rg-title        pic x(30).
    05 rg-Artist       pic x(20).

 01                    pic 9.
    88 no-record       value 1 false zero.

 01                    pic 9.
   88 record-selected  value 1 false zero.
   
 77 key-used           pic x.
 77 wrk-y              pic 9(3).
 
 LINKAGE SECTION.
 copy "lookup-link.wrk". 
 screen section.
  01 mask-main.
    05  h-grid, grid
        reordering-columns
        sortable-columns
        line 2 col 2
        lines 15 size 45
        width-in-cells
        height-in-cells
        data-columns (1, 31)
        alignment ( "L", "L")
        data-types ( "I", "I")
        display-columns (1, 23) 
        color 513  
        vscroll
        tiled-headings
        centered-headings 
        column-headings
        heading-color 257
        adjustable-columns
        use-tab
        cursor-frame-width 1
        Row-Cursor-Background-Color rgb 78-row-cursor-background-color
        Row-Cursor-foreground-Color rgb 78-row-cursor-foreground-color
        event H-GRID-EVENT
        border-color rgb 78-border-color
        .

 01 mask-tool.
    05  Push-Button
        col + 1.2 
        line 3
        lines 2.2 
        cells
        size 13 cells
        bitmap-handle lnk-bmp-toolbar-handle
        bitmap-width 18
        bitmap-number 2
        exception-value 3
        title "&Select"
        hint "(F3)"
        title-position 2
        self-act
        .
    05  bar
        col + 1.2
        lines 2 width 2
        color 16
        shading (-1, 1)
        .
    05  push-button 
        title "&Exit"
        hint "(Esc)"
        bitmap-handle lnk-bmp-toolbar-handle
        bitmap-number 1
        title-position 2
        lines 2.2 cells
        size 12 cells
        bitmap-width 18
        col + 1.2
        exception-value 27
        self-act
        .

 PROCEDURE DIVISION using  lnk-lookup.

 MAIN.

  set record-selected  to false.
  initialize  lnk-songs-title.

  display floating graphical window
          title "LookUp"
          lines 17
          size 47
          control font lnk-h-font
          background-low
          handle h-sta
          visible 0
          system menu
          .
  
  display tool-bar lines 2.5 control font lnk-h-font handle h-tool upon h-sta

  display mask-main upon h-sta
  display mask-tool upon h-tool

  perform LOAD-GRID

  if no-record
     display message box "No record in File"
  else
     perform ACCEPT-SCREEN
  end-if
  perform EXIT-PRG.
  goback
  .

 ACCEPT-SCREEN.
  modify h-sta visible 1

  perform until key-status = 27
     accept mask-main
        on exception continue
     end-accept
     perform AFTER-ACCEPT
     move 4 to accept-control
  end-perform       
  .

 AFTER-ACCEPT.
  evaluate key-status
  when 3
       set record-selected   to true
  when w-event
       evaluate event-type
       when cmd-close
            move 27 to key-status
       end-evaluate
  end-evaluate.

  if record-selected
     inquire h-grid cursor-y = wrk-y
     inquire h-grid(wrk-y ) record-data = rec-grid
     move rg-title     to lnk-songs-title
     move 27  to key-status
  end-if.

 LOAD-GRID.

  set no-record  to true.

  modify h-grid(1, 1) cell-data "Title"
  modify h-grid(1, 2) cell-data "Artist"

  perform varying wrk-y from 1 by 1 until wrk-y > 20
     set no-record   to false
     initialize rec-grid
     move ta-title(wrk-y)   to rg-title
     move ta-Artist(wrk-y)  to rg-Artist
     modify h-grid record-to-add rec-grid
  end-perform.

 EXIT-PRG.              
  perform DESTROY-RESOURCE
  .

 DESTROY-RESOURCE.
  modify h-sta visible 0
  destroy mask-main mask-tool h-tool 
          h-sta 
  .

 H-GRID-EVENT.
  evaluate event-type
  when MSG-BEGIN-ENTRY
       inquire h-grid entry-reason = key-used
       if key-used = x"0D" or
          key-used = x"00"
          set record-selected   to true
          set event-action   to EVENT-ACTION-FAIL-TERMINATE
       else
           set event-action   to EVENT-ACTION-FAIL
       end-if
  end-evaluate.

