      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. cart.

       working-storage section.
       copy "isgui.def".
       copy "iscrt.def".
       77  keystatus      special-names crt status pic 9(5).
       77  mouse-flags    pic 9(5) value 0.
       77  h-win          handle of window.

       77  himg1          pic s9(9) comp-4.
       77  hgimg1         pic s9(9) comp-4.
       77  hsimg1         pic s9(9) comp-4.
       77  hrimg1         pic s9(9) comp-4.
       77  himg2          pic s9(9) comp-4.
       77  hgimg2         pic s9(9) comp-4.
       77  hsimg2         pic s9(9) comp-4.
       77  hrimg2         pic s9(9) comp-4.
       77  himg3          pic s9(9) comp-4. 
       77  hgimg3         pic s9(9) comp-4.
       77  hsimg3         pic s9(9) comp-4.
       77  hrimg3         pic s9(9) comp-4.

       77  todrop         pic s9(9) comp-4.

       77  imgX           pic s9999.
       77  imgY           pic s9999.
       77  scrX           pic s9999.
       77  scrY           pic s9999.

       77  value1         pic 99.
       77  value2         pic 99.
       77  value3         pic 99.

       77  buff           pic x any length.

       77  curr           pic 9.
       77  counter        pic 99.
       77  nextbreak      pic 999.
       77  cartrow        pic 999.
       77  cartcol        pic 999.

       77  close-window   pic 9.

       78  PI             value 3.14159265358979323.

       screen section.
       01  mask.
           03 sh1 bitmap
              line 20 col 20
              bitmap-handle himg1
              lines 132
              size 132.
           03 lb1 label transparent line 20 col 20 
              lines 132 pixel
              size 132 pixel
              foreground-color rgb x#d0d0d0
              title "<html><h2 style='margin:3px'>05</h2></html>".

           03 sh2 bitmap
              line 20 col 170
              bitmap-handle himg2
              lines 132
              size 132.
           03 lb2 label transparent line 20 col 170 
              lines 132 pixel
              size 132 pixel
              foreground-color rgb x#d0d0d0
              title "<html><h2 style='margin:3px'>05</h2></html>".

           03 sh3 bitmap
              line 20 col 320
              bitmap-handle himg3
              lines 132
              size 132.
           03 lb3 label transparent line 20 col 320 
              lines 132 pixel
              size 132 pixel
              foreground-color rgb x#d0d0d0
              title "<html><h2 style='margin:3px'>05</h2></html>".

           03 label transparent line 230 col 20
              lines 50 pixel
              size 435 pixel
              foreground-color rgb x#d0d0d0
              title "<html><h1 style='margin:3px'>Drag the shirts into t
      -"he box below</h1></html>".
           03 frame
              full-height
              line 280 col 20
              lines 280 pixel
              size 666 pixel
              color 8.

           03 prw bitmap
              lines 132
              size 132
              visible 0.

       procedure division.
       main.
           move 5 to value1 value2 value3
           move 0 to close-window counter curr nextbreak cartrow cartcol
                     keystatus
           display floating graphical window
                   title "Drag 'n Drop" system menu
                   cell width 1 cell height 1
                   size 703 lines 577 
                   color 513
                   event CLOSE-WIN
                   handle h-win

           perform LOAD-RES

           compute mouse-flags = allow-left-down + allow-left-up + 
                                 allow-mouse-move 

           display mask.

           perform until keystatus = 27
              accept omitted mouse flags mouse-flags
                 on exception continue
              end-accept
              if close-window = 1
                 move 0 to  close-window
                 exit perform
              end-if
              if keystatus = 81
                 perform GET-SHIRT
              end-if
              if keystatus = 82
                 perform PUT-SHIRT
              end-if
              if keystatus = 80 and curr > 0
                 perform DRAG-SHIRT
              end-if
           end-perform.

           perform DESTROY-RES

           destroy mask
           destroy h-win

           goback.

       LOAD-RES.
           copy resource "../resources/item1.png".
           call "W$BITMAP" using wbitmap-load "item1.png" 
                          giving himg1
           copy resource "../resources/gitem1.png".
           call "W$BITMAP" using wbitmap-load "gitem1.png" 
                          giving hgimg1
           call "W$SCALE" using himg1 70 70 h-win 1 5 giving hsimg1
           call "W$ROTATE" using himg1 PI giving hrimg1
           copy resource "../resources/item2.png".
           call "W$BITMAP" using wbitmap-load "item2.png" 
                          giving himg2
           copy resource "../resources/gitem2.png".
           call "W$BITMAP" using wbitmap-load "gitem2.png" 
                          giving hgimg2
           call "W$SCALE" using himg2 70 70 h-win 1 5 giving hsimg2
           call "W$ROTATE" using himg2 PI giving hrimg2
           copy resource "../resources/item3.png".
           call "W$BITMAP" using wbitmap-load "item3.png" 
                          giving himg3
           copy resource "../resources/gitem3.png".
           call "W$BITMAP" using wbitmap-load "gitem3.png" 
                          giving hgimg3
           call "W$SCALE" using himg3 70 70 h-win 1 5 giving hsimg3
           call "W$ROTATE" using himg3 PI giving hrimg3
           .

       DESTROY-RES.
           call "W$BITMAP" using wbitmap-destroy himg1
           call "W$BITMAP" using wbitmap-destroy hgimg1
           call "W$BITMAP" using wbitmap-destroy hsimg1
           call "W$BITMAP" using wbitmap-destroy himg2
           call "W$BITMAP" using wbitmap-destroy hgimg2
           call "W$BITMAP" using wbitmap-destroy hsimg2
           call "W$BITMAP" using wbitmap-destroy himg3
           call "W$BITMAP" using wbitmap-destroy hgimg3
           call "W$BITMAP" using wbitmap-destroy hsimg3
           .

       GET-SHIRT.
           call "W$MOUSE" using get-mouse-status mouse-info
           if mouse-row >= 20 and <= 152 and
              mouse-col >= 20 and <= 152 and value1 > 0
              compute imgX = mouse-col - 30
              compute imgY = mouse-row - 30
              move 1 to curr
              modify prw bitmap-handle hgimg1 line 30 col 30 visible 1
           end-if 
           if mouse-row >= 20 and <= 152 and
              mouse-col >= 170 and <= 302 and value2 > 0
              compute imgX = mouse-col - 180
              compute imgY = mouse-row - 30
              move 2 to curr
              modify prw bitmap-handle hgimg2 line 30 col 180 visible 1
           end-if
           if mouse-row >= 20 and <= 152 and
              mouse-col >= 320 and <= 552 and value3 > 0
              compute imgX = mouse-col - 330
              compute imgY = mouse-row - 30
              move 3 to curr
              modify prw bitmap-handle hgimg3 line 30 col 330 visible 1
           end-if
           .

       PUT-SHIRT.
           modify prw visible 0
           call "W$MOUSE" using get-mouse-status mouse-info
           if mouse-row >= 280 and <= 560 and mouse-col >= 20 and <= 686
              evaluate curr
                 when 1
                      if value1 > 0
                         subtract 1 from value1
                         string "<html><h2 style='margin:3px'>"
                                  value1 "</h2></html>" into buff
                         modify lb1 title buff
                         perform DROP-SHIRT
                         if value1 = 0
                            modify sh1 bitmap-handle hrimg1
                         end-if
                      end-if
                 when 2
                      if value2 > 0
                         subtract 1 from value2
                         string "<html><h2 style='margin:3px'>"
                                  value2 "</h2></html>" into buff
                         modify lb2 title buff
                         perform DROP-SHIRT
                         if value2 = 0
                            modify sh2 bitmap-handle hrimg2
                         end-if
                      end-if
                 when 3
                      if value3 > 0
                         subtract 1 from value3
                         string "<html><h2 style='margin:3px'>"
                                  value3 "</h2></html>" into buff
                         modify lb3 title buff
                         perform DROP-SHIRT
                         if value3 = 0
                            modify sh3 bitmap-handle hrimg3
                         end-if
                      end-if
              end-evaluate
           end-if
           move 0 to curr
           .

       DRAG-SHIRT.
           call "W$MOUSE" using get-mouse-status mouse-info
           compute scrX = mouse-col - imgX
           compute scrY = mouse-row - imgY
           modify prw line scrY col scrX
           .

       DROP-SHIRT.
           if nextbreak = counter
             compute nextbreak = counter + 8
             add 1 to cartrow
           end-if
           add 1 to counter
           compute cartcol = counter - (8 * (cartrow - 1))
           compute scrX = 20 + (10 * cartcol) + (70 * (cartcol - 1))
           compute scrY = 280 + (10 * cartrow) + (70 * (cartrow - 1))
           evaluate curr
              when 1 move hsimg1 to todrop
              when 2 move hsimg2 to todrop
              when 3 move hsimg3 to todrop
           end-evaluate
           display bitmap bitmap-handle todrop
                          line scrY col scrX
                          lines 70 size 70
           destroy prw
           display prw
           .

       CLOSE-WIN.
           if event-type = msg-close
              move 1 to close-window
              set event-action to event-action-terminate
           end-if
           .