      *    Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.
      
       PROGRAM-ID. AUDIT resident.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "auditfilesettings.sl".
           copy "auditlogsettings.sl".
           copy "auditlog.sl".

       DATA DIVISION.
       FILE SECTION.
           copy "auditfilesettings.fd".
           copy "auditlogsettings.fd".
           copy "auditlog.fd".

       WORKING-STORAGE SECTION.
           copy "common.wrk".
           copy "audit.wrk".

       77  wrk-audit-user-logged            pic x(20) is external.

       LINKAGE SECTION.
           copy "audit-linkage.wrk".

       PROCEDURE DIVISION USING audit-link. 

       DECLARATIVES.
       AUDITLOG-ERR section.
           use after standard error procedure on auditlog.
           perform ERROR-FILE
           .
       
       AUDITLOGSETTINGS-ERR section.
           use after standard error procedure on auditlogsettings.
           perform ERROR-FILE
           .

       AUDITFILESETTINGS-ERR section.
           use after standard error procedure on auditfilesettings.
           perform ERROR-FILE
           .

       END DECLARATIVES.

       MAIN.

           evaluate true
           when audit-load-settings
                perform LOAD-AUDIT-SETTINGS
           when audit-start-log
                perform START-AUDIT-LOG
           when audit-stop-log
                perform STOP-AUDIT-LOG
           when audit-register-login
                perform REGISTER-LOGIN
           when audit-register-logout
                perform REGISTER-LOGOUT
           when audit-register-pgm-start
                perform REGISTER-PGM-START
           when audit-register-pgm-end
                perform REGISTER-PGM-END
           end-evaluate.

           goback.

       START-AUDIT-LOG.
           accept th-main from thread
           call thread "auditlog" handle in th-auditlog
                using th-main 
           .

       STOP-AUDIT-LOG.
           send "AUDIT-END"  to th-auditlog
           wait              for th-auditlog
           move 0            to th-auditlog.

       LOAD-AUDIT-SETTINGS.
           move audit-user-logged     to wrk-audit-user-logged
           set environment "userid"   to audit-user-logged.
           move zero                  to audit-idx.
           initialize audit-setting.
           open input auditfilesettings
           move wrk-audit-user-logged to afs-users-id
           move low-value    to afs-file.
              
           start auditfilesettings key not < afs-key
              invalid
                 continue
              not invalid
                 continue
                 perform until 1 = 2
                    read auditfilesettings next
                       at end
                          exit perform
                    end-read
                    if afs-users-id not = wrk-audit-user-logged
                       exit perform
                    end-if
                    add 1 to audit-idx
                    move afs-file  to aso-file(audit-idx)
                    move afs-data  to aso-data(audit-idx)
                    if afs-file = "ALL"
                       exit perform
                    end-if
                 end-perform
           end-start.
           close auditfilesettings
           .

       REGISTER-LOGIN.
           open input auditlogsettings
           
           move wrk-audit-user-logged     to als-users-id
           read auditlogsettings no lock
              invalid 
                 set als-login-yes    to false
                 set als-logout-yes   to false
           end-read
           close auditlogsettings
           
           if als-login-yes
              open i-o auditlog
              move wrk-audit-user-logged  to al-users-id
              accept al-date          from century-date
              accept al-time          from time
              set al-login            to true
              move space              to al-file-program-name
                                         al-file-key
              write auditlog-r
              close auditlog
           end-if.

       REGISTER-LOGOUT.
           if als-logout-yes
              open i-o auditlog
              move wrk-audit-user-logged  to al-users-id
              accept al-date          from century-date
              accept al-time          from time
              set al-logout           to true
              move space              to al-file-program-name
                                         al-file-key
              write auditlog-r
              close auditlog
           end-if.

       REGISTER-PGM-START.
           open input auditlogsettings
           
           move wrk-audit-user-logged        to als-users-id
           read auditlogsettings no lock
              invalid 
                 set als-pgm-start-yes   to false
                 set als-pgm-end-yes     to false
           end-read
           close auditlogsettings
           
           if als-pgm-start-yes
              open i-o auditlog
              move wrk-audit-user-logged to al-users-id
              accept al-date             from century-date
              accept al-time             from time
              set al-start-program       to true
              move audit-prg-to-launch   to al-file-program-name
              move space                 to al-file-key
              write AUDITLOG-R
              close auditlog
           end-if.

       REGISTER-PGM-END.
           if als-pgm-end-yes
              open i-o auditlog
              move wrk-audit-user-logged to al-users-id
              accept al-date             from century-date
              accept al-time             from time
              set al-stop-program        to true
              move audit-prg-to-launch   to al-file-program-name
              move space                 to al-file-key
              write auditlog-r
              close auditlog
           end-if.

       ERROR-FILE.
           call "C$RERR"     using crerr-status
           call "C$RERRNAME" using rerrname
           display message "Error " file-status "-" 
                           ext-status " on " rerrname  
                   title "ISAPPLICATION"
                   icon 2.
           stop run.

