      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
      
       PROGRAM-ID. ZINVOICE.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "customer.sl".
           copy "invoice.sl".
       DATA DIVISION.
       FILE SECTION.
           COPY "customer.fd".
           copy "invoice.fd".
      
       WORKING-STORAGE SECTION.
      
           copy "common.wrk".
           copy "color.wrk".
      
       77  STATUS-customer   PIC XX.
       77  STATUS-invoice   PIC XX.
      
       01  rec-grid.
           05 rg-filler         pic x.
           05 rg-inv-year       pic 9(4).
           05 rg-inv-number     pic z(10).
           05 rg-inv-date       pic 99/99/9999.
           05 rg-inv-customer   pic x(10).
           05 rg-cust-name      pic x(71).
           
       01                       pic 9.
           88 no-record         value 1 false zero.
           
       01                       pic 9.
           88 record-selected   value 1 false zero.
         
       77  key-used             pic x.
       77  wrk-y                pic 9(3).
       77  wrk-date             pic 9(8).
       
       LINKAGE SECTION.
       01  lnk-inv-key.
           05 lnk-inv-year      pic  9(4).
           05 lnk-inv-number    pic  9(10).
 
       screen section.

       01  mask-main.
           05  h-grid, grid
               reordering-columns
               sortable-columns
               adjustable-rows
               line 2 col 2
               lines 28 size 78
               width-in-cells
               height-in-cells
               data-columns (1, 2, 6, 16, 26, 36)
               alignment ( "C", "R", "R", "C", "L", "L")
               data-types ( "I", "I", "I", "I", "I", "I")
               display-columns (3, 9, 18, 30, 42) 
               color 513  
               vscroll
               tiled-headings
               centered-headings 
               column-headings
               row-headings
               heading-color 257
               adjustable-columns
               use-tab
               cursor-frame-width 1
               Row-Cursor-Background-Color rgb 
                                            78-lbl-menu-background-color
               Row-Cursor-foreground-Color rgb 
                                            78-lbl-menu-foreground-color
               Cursor-Foreground-Color rgb 78-cursor-foreground-color 
               Cursor-Background-Color rgb 78-cursor-background-color
               event H-GRID-EVENT
               .

           copy "standard-lookup-tool.scr".

       PROCEDURE DIVISION using  lnk-inv-key.
       DECLARATIVES.
       INVOICE-ERR section.
           use after standard error procedure on invoice.
           perform ERROR-FILE
           .
       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       
       MAIN.

           set record-selected  to false.
           initialize  lnk-inv-key.
           
           perform OPEN-FILES.
           
           display floating graphical window      
                   title R"isCOBOL_Application_List_of_Invoice"
                   lines 30
                   size 80
                   control font h-font
                   background-low
                   handle h-sta
                   visible 0
                   system menu
                   gradient-color-1 rgb 78-gradient-color-1
                   gradient-color-2 rgb 78-gradient-color-2 
                   .
           
           display tool-bar 
                   lines 2.5 
                   control font h-font 
                   handle h-tool 
                   upon h-sta
           
           display mask-main upon h-sta
           display mask-tool upon h-tool
           
           perform LOAD-GRID
           
           if no-record
              display message box R"No_record_in_File"
           else
              perform ACCEPT-SCREEN
           end-if
           perform EXIT-PRG.
           goback
           .

       ACCEPT-SCREEN.
           modify h-sta visible 1

           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform       
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-selected
                set record-selected   to true
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           end-evaluate.
           
           if record-selected
              inquire h-grid cursor-y = wrk-y
              inquire h-grid(wrk-y ) record-data = rec-grid
              move rg-inv-year     to lnk-inv-year
              move rg-inv-number   to lnk-inv-number
              move 27  to key-status
           end-if.

       LOAD-GRID.

           set no-record  to true.
           
           modify h-grid(1, 2) cell-data R"Year"
           modify h-grid(1, 3) cell-data R"Number"
           modify h-grid(1, 4) cell-data R"Date"
           modify h-grid(1, 5) cell-data R"Customer"
           modify h-grid(1, 6) cell-data R"Name"
           
           move low-value  to inv-key
           start invoice key not < inv-key
              invalid
                 continue
              not invalid
                 perform until 1 = 2
                    read invoice next no lock
                       at end
                          exit perform
                       not at end 
                          set no-record   to false
                          initialize rec-grid
                          move inv-year  to rg-inv-year
                          move inv-number   to rg-inv-number
                          move inv-date(7:2)   to wrk-date(1:2)
                          move inv-date(5:2)   to wrk-date(3:2)
                          move inv-date(1:4)   to wrk-date(5:4)
                          move wrk-date        to rg-inv-date
                          move inv-customer    to rg-inv-customer
                                                  cust-id
                          read customer no lock
                             invalid
                                move space  to cust-name
                          end-read
                          string cust-fname delimited by trailing space
                                 " "        delimited by size
                                 cust-lname delimited by size
                                 into rg-cust-name
                          modify h-grid record-to-add rec-grid
                    end-read
                 end-perform
           end-start.

       OPEN-FILES.
           open input invoice.
           open input customer.

       EXIT-PRG.              
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close Customer.
           close invoice.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       H-GRID-EVENT.
           evaluate event-type
           when MSG-BEGIN-ENTRY
                inquire h-grid entry-reason = key-used
                if key-used = x"0D" or
                   key-used = x"00"
                   set record-selected   to true
                   set event-action   to EVENT-ACTION-FAIL-TERMINATE
                else
                    set event-action   to EVENT-ACTION-FAIL
                end-if
           end-evaluate.

           copy "dec-file.prd". 
