      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       identification division.
       program-id. MYPROG.
       environment division.
       configuration section.
       special-names.
           switch-1 on status is is-on-1 
           switch-2 on status is is-on-2
           switch-3 on status is is-on-3
           switch-4 on status is is-on-4
           switch-5 on status is is-on-5
           switch-6 on status is is-on-6
           switch-7 on status is is-on-7
           switch-8 on status is is-on-8
           .

       WORKING-STORAGE SECTION.
       77  wrk-switches   pic x any length.

       77  wrk-memsize    pic 9(10).

       linkage section.
       01  main-parameter.
           02 parameter-length pic s9(4) binary (2).
           02 parameter-text.
              03 parameter-char pic x occurs 0 to 2048 times
                             depending on parameter-length.

       PROCEDURE DIVISION USING main-parameter.
       main.
           if parameter-length > 0
              display "Parameter length: " parameter-length
              display "Parameter values: "
                                   parameter-text(1:parameter-length)
           else
              display "Received 0 bytes"
           end-if

           move "Activated switches: " to wrk-switches
           if is-on-1
              string wrk-switches delimited by size
                     " 1"         delimited by size
                     into wrk-switches
           end-if
           if is-on-2
              string wrk-switches delimited by size
                     " 2"         delimited by size
                     into wrk-switches
           end-if
           if is-on-3
              string wrk-switches delimited by size
                     " 3"         delimited by size
                     into wrk-switches
           end-if
           if is-on-4 
              string wrk-switches delimited by size
                     " 4"         delimited by size
                     into wrk-switches
           end-if
           if is-on-5
              string wrk-switches delimited by size
                     " 5"         delimited by size
                     into wrk-switches
           end-if
           if is-on-6
              string wrk-switches delimited by size
                     " 6"         delimited by size
                     into wrk-switches
           end-if
           if is-on-7
              string wrk-switches delimited by size
                     " 7"         delimited by size
                     into wrk-switches
           end-if
           if is-on-8
              string wrk-switches delimited by size
                     " 8"         delimited by size
                     into wrk-switches
           end-if

           display wrk-switches

           accept wrk-memsize from environment "sort.memsize"
           if wrk-memsize > 0
              display "Allocated sort memory: " wrk-memsize
           end-if

           goback.
