      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION. 
       CLASS-ID. RedirectLineSequential AS "RedirectLineSequential"
                            INHERITS DYNAMICLINESEQ.
       
       CONFIGURATION SECTION.
       REPOSITORY.
           CLASS JINT            AS "int"
           CLASS JLONG           AS "long"
           CLASS JSTRING         AS "java.lang.String"
           CLASS JBOOL           AS "boolean"
           CLASS JBYTEARRAY      AS "byte[]"
           CLASS DYNAMICFILE     AS "com.iscobol.rts.DynamicFile"
           CLASS KEYDESCRIPTION  AS "com.iscobol.rts.KeyDescription"
           CLASS KEYDESCRIPTIONS AS "com.iscobol.rts.KeyDescription[]"
           CLASS DYNAMICLINESEQ  AS "com.iscobol.io.DynamicLSeq8bit"
           .

       IDENTIFICATION DIVISION.
       OBJECT.

       WORKING-STORAGE SECTION.
       
       PROCEDURE DIVISION.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. NEW AS "new" OVERRIDE.
      * PROCEDURE DIVISION.
      * MAIN.
      *     GOBACK.
      * END METHOD.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-OPEN AS "open" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT      OBJECT REFERENCE JINT. 
      * 77  MYPATH      PIC X ANY LENGTH.
      * LINKAGE SECTION.
      * 77  PATH        OBJECT REFERENCE JSTRING.
      * 77  OPENTYPE    OBJECT REFERENCE JINT.
      * 77  LOCKTYPE    OBJECT REFERENCE JINT.
      * 77  KEYS        OBJECT REFERENCE KEYDESCRIPTIONS.
      * 77  MAXREC      OBJECT REFERENCE JINT.
      * 77  MINREC      OBJECT REFERENCE JINT.
      * 77  NKEYS       OBJECT REFERENCE JINT.
      * 77  ACCESSMODE  OBJECT REFERENCE JINT.
      * 77  OPTIONL     OBJECT REFERENCE "boolean".
      * 77  ASSIGNEXT   OBJECT REFERENCE "boolean".
      * PROCEDURE DIVISION USING PATH, 
      *                          OPENTYPE, 
      *                          LOCKTYPE,
      *                          KEYS, 
      *                          MAXREC, 
      *                          MINREC, 
      *                          NKEYS, 
      *                          ACCESSMODE,
      *                          OPTIONL,
      *                          ASSIGNEXT
      *               RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>open(PATH, 
      *                               OPENTYPE, 
      *                               LOCKTYPE,
      *                               KEYS, 
      *                               MAXREC, 
      *                               MINREC, 
      *                               NKEYS, 
      *                               ACCESSMODE,
      *                               OPTIONL,
      *                               ASSIGNEXT). 
      *     GOBACK.
      * END METHOD.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. ISOPEN AS "isOpen" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JBOOL.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>isOpen().
      *     GOBACK.
      * END METHOD.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETDESCRIPTION AS "getDescription" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JSTRING.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getDescription().
      *     GOBACK.
      * END METHOD.    

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETCOBERRNO AS "getCobErrno" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getCobErrno().
      *     GOBACK.
      * END METHOD.    

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETSYSERRNO AS "getSysErrno" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JSTRING.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getSysErrno().
      *     GOBACK.
      * END METHOD.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETERRMSG AS "getErrMsg" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JSTRING.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getErrMsg().
      *     GOBACK.
      * END METHOD.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-CLOSE AS "close" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>close().
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. BUILD AS "build" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.
      * LINKAGE SECTION.
      * 77  PATH              OBJECT REFERENCE JSTRING.
      * 77  COMMENT           OBJECT REFERENCE JSTRING.
      * 77  BLOCKINGFACTOR    OBJECT REFERENCE JINT.
      * 77  PREALLOCATE       OBJECT REFERENCE JINT.
      * 77  EXTENSIONFACTOR   OBJECT REFERENCE JINT.
      * 77  COMPRESSIONFACTOR OBJECT REFERENCE JINT.
      * 77  ENCRYPTIONFLAG    OBJECT REFERENCE JINT.
      * 77  MAXRECORDSIZE     OBJECT REFERENCE JINT.
      * 77  MINRECORDSIZE     OBJECT REFERENCE JINT.
      * 77  KEYS              OBJECT REFERENCE KEYDESCRIPTIONS.
      * 77  COLLATINGSEQUENCE OBJECT REFERENCE JBYTEARRAY.
      * 77  ASSIGNEXT         OBJECT REFERENCE "boolean".
      *
      * PROCEDURE DIVISION USING PATH,
      *                          COMMENT,
      *                          BLOCKINGFACTOR,
      *                          PREALLOCATE,
      *                          EXTENSIONFACTOR,
      *                          COMPRESSIONFACTOR,
      *                          ENCRYPTIONFLAG,
      *                          MAXRECORDSIZE,
      *                          MINRECORDSIZE,
      *                          KEYS,
      *                          COLLATINGSEQUENCE,
      *                          ASSIGNEXT
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>build(PATH,
      *                                COMMENT,
      *                                BLOCKINGFACTOR,
      *                                PREALLOCATE,      
      *                                EXTENSIONFACTOR,  
      *                                COMPRESSIONFACTOR,
      *                                ENCRYPTIONFLAG,   
      *                                MAXRECORDSIZE,    
      *                                MINRECORDSIZE,    
      *                                KEYS,             
      *                                COLLATINGSEQUENCE,
      *                                ASSIGNEXT).
      *
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETNUMKEYS AS "getNumKeys" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getNumKeys().
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETMAXRECORDSIZE AS "getMaxRecordSize" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getMaxRecordSize().
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETMINRECORDSIZE AS "getMinRecordSize" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getMinRecordSize().
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETKEY AS "getKey" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE KEYDESCRIPTION.
      * LINKAGE SECTION.
      * 77  KEYNUM  OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING KEYNUM
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getKey(KEYNUM).
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETSEQUENCE AS "getSequence" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JBYTEARRAY.
      * LINKAGE SECTION.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getSequence().
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETNUMRECORDS AS "getNumRecords" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getNumRecords().
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. SETCURRENTRECORD AS "setCurrentRecord" OVERRIDE.
      * LINKAGE SECTION.   
      * 77  NREC OBJECT REFERENCE JLONG.
      * PROCEDURE DIVISION USING NREC.
      * MAIN.
      *     SUPER:>setCurrentRecord(NREC).
      *     GOBACK.
      * END METHOD. 

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. GETCURRENTRECORD AS "getCurrentRecord" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getCurrentRecord().
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-READ AS "read" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS      OBJECT REFERENCE JINT. 
      * 77  KEYNUM    OBJECT REFERENCE JINT.
      * 77  FLAGLOCK  OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          KEYNUM,
      *                          FLAGLOCK
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>read (THERECORD,
      *                                  OFFS,
      *                                  KEYNUM,
      *                                  FLAGLOCK).
      *     GOBACK.
      * END METHOD.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-READ AS "read" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS      OBJECT REFERENCE JINT. 
      * 77  KEYS      OBJECT REFERENCE KEYDESCRIPTION.
      * 77  FLAGLOCK  OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          KEYS,
      *                          FLAGLOCK
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>read(THERECORD,
      *                               OFFS,
      *                               KEYS,
      *                               FLAGLOCK).
      *     GOBACK.
      * END METHOD.  

      ****************************************************************** 

      * IDENTIFICATION DIVISION.
      * METHOD-ID. READ-NEXT AS "next" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS      OBJECT REFERENCE JINT.      
      * 77  FLAGLOCK  OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          FLAGLOCK
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>next(THERECORD,
      *                               OFFS,
      *                               FLAGLOCK).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. READ-PREV AS "previous" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS      OBJECT REFERENCE JINT.      
      * 77  FLAGLOCK  OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          FLAGLOCK
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>previous(THERECORD,
      *                                   OFFS,
      *                                   FLAGLOCK).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-START AS "start" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS       OBJECT REFERENCE JINT.  
      * 77  KEYNUM     OBJECT REFERENCE JINT.     
      * 77  KEYSIZE    OBJECT REFERENCE JINT.     
      * 77  STARTMODE  OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          KEYNUM,
      *                          KEYSIZE,
      *                          STARTMODE
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>start(THERECORD,
      *                                OFFS,
      *                                KEYNUM,
      *                                KEYSIZE,
      *                                STARTMODE).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-START AS "start" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS       OBJECT REFERENCE JINT.  
      * 77  KEYS       OBJECT REFERENCE KEYDESCRIPTION.     
      * 77  KEYSIZE    OBJECT REFERENCE JINT.     
      * 77  STARTMODE  OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          KEYS,
      *                          KEYSIZE,
      *                          STARTMODE
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>start(THERECORD,
      *                                OFFS,
      *                                KEYS,
      *                                KEYSIZE,
      *                                STARTMODE).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-WRITE AS "write" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS       OBJECT REFERENCE JINT.  
      * 77  RECSIZE    OBJECT REFERENCE JINT.     
      * 77  FLAGLOCK   OBJECT REFERENCE JBOOL.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          RECSIZE,
      *                          FLAGLOCK
      *                RETURNING RESULT.
      * MAIN.       
      *     SET RESULT TO SUPER:>write(THERECORD,
      *                                OFFS,
      *                                RECSIZE,
      *                                FLAGLOCK).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-REWRITE AS "rewrite" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS       OBJECT REFERENCE JINT.  
      * 77  RECSIZE    OBJECT REFERENCE JINT.     
      * 77  FLAGLOCK   OBJECT REFERENCE JBOOL.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS,
      *                          RECSIZE,
      *                          FLAGLOCK
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>rewrite(THERECORD,
      *                                  OFFS,
      *                                  RECSIZE,
      *                                  FLAGLOCK).
      *     GOBACK.
      * END METHOD.

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-DELETE AS "delete" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JLONG.
      * LINKAGE SECTION.
      * 77  THERECORD  OBJECT REFERENCE JBYTEARRAY.
      * 77  OFFS       OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING THERECORD,
      *                          OFFS
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>delete(THERECORD,
      *                                 OFFS).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-UNLOCK AS "unlock" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.   
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>unlock().
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. REMOVE AS "remove" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT. 
      * LINKAGE SECTION.
      * 77  NAME    OBJECT REFERENCE JSTRING.
      * PROCEDURE DIVISION USING NAME
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>remove(NAME).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. RENAME AS "rename" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT. 
      * LINKAGE SECTION.
      * 77  SRC-NAME   OBJECT REFERENCE JSTRING.
      * 77  DEST-NAME  OBJECT REFERENCE JSTRING.
      * PROCEDURE DIVISION USING SRC-NAME, DEST-NAME
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>rename(SRC-NAME, 
      *                                 DEST-NAME).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-SYNC AS "sync" OVERRIDE.
      * LINKAGE SECTION.
      * 77  SYNC-MODE OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING SYNC-MODE.
      * MAIN.
      *     SUPER:>sync(SYNC-MODE).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. BEGIN AS "begin" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.   
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>begin().
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-COMMIT AS "commit" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.
      * LINKAGE SECTION.
      * 77  CTX     OBJECT REFERENCE JINT.
      * PROCEDURE DIVISION USING CTX
      *                RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>commit(CTX).
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. MY-ROLLBACK AS "rollback" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.   
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>rollback().
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. RECOVER AS "recover" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JINT.   
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>recover().
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. VERSION AS "getVersion" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JSTRING.   
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>getVersion().
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

      * IDENTIFICATION DIVISION.
      * METHOD-ID. IS-KEYSEL AS "isKeySelectedByNum" OVERRIDE.
      * WORKING-STORAGE SECTION.
      * 77  RESULT OBJECT REFERENCE JBOOL.   
      * PROCEDURE DIVISION RETURNING RESULT.
      * MAIN.
      *     SET RESULT TO SUPER:>isKeySelectedByNum().
      *     GOBACK.
      * END METHOD.  

      ******************************************************************

       END OBJECT.

      ******************************************************************
