      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       program-id. clientH.
       configuration section.
       repository.
           class http-client as "com.iscobol.rts.HTTPClient"
           class http-param as "com.iscobol.rts.HTTPData.Params"
           .
           
       data division.
       working-storage section.
       77  http object reference http-client.
       77  params object reference http-param.
       01  response-code pic S9(3).
       01  response-message pic x any length.
       01  cookie pic x any length.

       01  isfunction-getZipCode identified by "".
           03 identified by "get_Zip_Code".
              05 city-zipCode  pic x any length.

       01  isfunction-receivedZipCode identified by "".
           03 identified by "Zip_Code".
              05 zipCode  pic x any length.

       01  isfunction-getcity identified by "".
           03 identified by "get_City".
              05 zipCode-city  pic x any length.

       01  isfunction-receivedCity identified by "".
           03 identified by "City".
              05 City  pic x any length.

       01  connection-result identified by "_comm_buffer".
           03 filler identified by "_status".
              05 com-status pic x any length.
           03  filler identified by "_message".
              05 con-message pic x any length.

       01  filler            pic 9.
           88 connection-ok  value 1 false zero.

       77  webapp-base-url   pic x any length.
       77  function-url      pic x any length.

       procedure division.
       MAIN.

           perform SERVER-CONNECTION

           if connection-ok 
              perform GET-ZIPCODE
           end-if.
           
           if connection-ok 
              perform GET-CITY
           end-if.

           goback.
           
       SERVER-CONNECTION.
           accept webapp-base-url  from environment "webapp_base_url".
           set connection-ok to true
           
           set http = http-client:>new()
           initialize function-url
           string webapp-base-url                  delimited by size
                  "/servlet/isCobol(ISFUNCTIONS)"  delimited by size
                  into   function-url
           try
             http:>doGet (function-url)
           catch exception
              set connection-ok to false
              display exception-object:>toString
           end-try.
           if connection-ok
              http:>getResponseCode (response-code)
              if response-code = 200
                 display "Connection to the server Ok"
                 display "Response code: " response-code;;
                 http:>getResponseJSON (connection-result)
                 display "Response message: " con-message;;
                 http:>getHeaderProperty ("set-cookie" cookie)
              else
                 set connection-ok to false
                 perform GET-ERROR
              end-if
           end-if.

       GET-ZIPCODE.
           display " "
           move "San Diego" to city-zipCode.

           set params = http-param:>new()
               :>add("get_Zip_Code", city-zipCode).

           display "Call the server to retrieve the zip code of "
                   "San Diego".

           http:>setHeaderProperty ("cookie" cookie)
           initialize function-url
           string webapp-base-url    delimited by size
                  "/servlet/isCobol(ISFUNCTION_GETZIP)" 
                                     delimited by size
                  into   function-url
           try
             http:>doGet (function-url, params)
           catch exception
              set connection-ok to false
              display exception-object:>toString
           end-try.
           if connection-ok
              http:>getResponseCode (response-code);;
              if response-code = 200
                 http:>getResponseJSON (isfunction-receivedZipCode)
                 display "The zip code is " zipCode
              else   
                 perform GET-ERROR
              end-if
           end-if.
       

       GET-CITY.
           display " "

           move "89044" to zipCode-city.
           set params = http-param:>new()
               :>add("get_City", zipCode-city)

           display "Call the server to retrieve the name of the city of"
                   " the zip code 89044".

           http:>setHeaderProperty ("cookie" cookie)
           initialize function-url
           string webapp-base-url    delimited by size
                  "/servlet/isCobol(ISFUNCTION_GETCITY)" 
                                     delimited by size
                  into   function-url
           try
             http:>doGet (function-url, params)
           catch exception
              set connection-ok to false
              display exception-object:>toString
           end-try.
           if connection-ok
              http:>getResponseCode (response-code);;
              if response-code = 200
                 http:>getResponseJSON (isfunction-receivedCity)
                 display "The city is " city
              else   
                 perform GET-ERROR
              end-if
           end-if.
       
       GET-ERROR.                                  
              display "Response code=" response-code;;
              http:>getResponsePlain (response-message)              
              display response-message.
