callServer("AWEBX");

var appTutorial = angular.module('appTutorial', ['ngGrid', 'ui.bootstrap']);


appTutorial.controller('CustomersCtrl',
    function ($scope, $http, $modal) {

        $scope.customer = {};
        $scope.searchEmail = "";

        $scope.getNextCustomer = function() {
            // to avoid issues with Internet Explorer's caching mechanism, we add a random parameter to the URL
            // This will guarantee that each request has a different URL from the previous
            // Not doing so could cause requests not be actually sent to the server, and is only needed for GET requests
            $http.get("servlet/isCobol(AWEBX_NEXT)?nc=" + Math.random())
                .then(function (response) {
                    $scope.checkForErrors(response.data._comm_buffer);
                })
        };

        $scope.getPreviousCustomer = function() {
            // to avoid issues with Internet Explorer's caching mechanism, we add a random parameter to the URL
            // This will guarantee that each request has a different URL from the previous
            // Not doing so could cause requests not be actually sent to the server, and is only needed for GET requests
            $http.get("servlet/isCobol(AWEBX_PREVIOUS)?nc=" + Math.random())
                .then(function (response) {
                    $scope.checkForErrors(response.data._comm_buffer);
                })
        };

        $scope.clear = function() {
            $scope.customer={};
        };

        $scope.firstCustomer = function() {
            // to avoid issues with Internet Explorer's caching mechanism, we add a random parameter to the URL
            // This will guarantee that each request has a different URL from the previous
            // Not doing so could cause requests not be actually sent to the server, and is only needed for GET requests
            $http.get("servlet/isCobol(AWEBX_FIRST)?nc=" + Math.random())
                .then(function (response) {
                    $scope.checkForErrors(response.data._comm_buffer);
                })

        };
        
        $scope.print = function() {
            window.open("servlet/isCobol(AWEBX_PRINTALL)");
        };
        
        $scope.saveCustomer = function() {
            callServerWithJson("AWEBX_UPDATE",  $scope.customer, $scope.onSuccess, $scope.onError);
        };
        $scope.newCustomer = function() {
            callServerWithJson("AWEBX_INSERT",  $scope.customer, $scope.onSuccess, $scope.onError);
        };

        $scope.deleteCustomer = function() {
            callServerWithJson("AWEBX_DELETE",  $scope.customer, $scope.onSuccess, $scope.onError);
            $scope.customer = {};
        };
        $scope.insertCustomer = function() {
            callServerWithJson("AWEBX_INSERT",  $scope.customer, $scope.onSuccess, $scope.onError);
        };
        $scope.performSearch = function() {
            if ($scope.searchEmail!='')
                $scope.customer.email = $scope.searchEmail;
            $http.post("servlet/isCobol(AWEBX_SEARCH)", $scope.customer)
                .then(function (response) {
                    if (response.data._comm_buffer._status=="OK")
                        $scope.customer = response.data._comm_buffer;

                })
        };


         $scope.listCustomers = function (size) {

            var modalInstance = $modal.open({
              templateUrl: 'modalCustomerPicker.html',
              controller: 'zoomCtrl',
              size: size
            });

            modalInstance.result.then(function (selectedCustomer) {
                $scope.customer = selectedCustomer;
            });
        }

 

        $scope.onError = function (jqXHR, textStatus, errorThrown) {
           $scope.showError(textStatus +" "+ jqXHR.status + " "+jqXHR.statusText +
                "\n" + jqXHR.responseText);


        };

        $scope.onSuccess = function (data, textStatus, jqXHR) {
            var response = jqXHR.responseText;
            try {
                jsonDoc = $.parseJSON( response );
            } catch (err) {
                $("#rsperror").html(response);
                return false;
            }
            var $status = jsonDoc._comm_buffer._status;
            var $message = jsonDoc._comm_buffer._message;

            if ($status == "OK") {
                $scope.showMessage($message);

                form = $("form")[0];
                for (i = 0; i < form.length; i++)  {
                    field = form[i];
                    for (var j in jsonDoc._comm_buffer) {
                        if (j == field.name) {
                            field.value = $.trim(jsonDoc._comm_buffer[j]);
                        }
                    }
                }
                return true;
            } else {
                $scope.showError ($message + ", status: " + $status);
                return false;
            }
        }

        // Utility methods for error checking 

        $scope.checkForErrors = function (response) {
            var nonFatalErrors = ["00","10"];
            if (response._status=="OK") {
                $scope.customer = response;
                $scope.showMessage("Operation successful");
            } else if (nonFatalErrors.indexOf(response._status)<0)
                    $scope.showMessage(response._message);
                else
                    $scope.showError(response._message);
        }

        $scope.showMessage = function(msg) {
            $("#messageDiv").slideUp(300, function() {
                $("#rsperror").html(msg);
                $("#rsperror").css('display','inline');
                $('#messageDiv').removeClass('alert-danger');
                $('#messageDiv').addClass('alert-info');
                $("#messageDiv").slideDown(300);
            });
        }

        $scope.showError = function (msg) {
            $("#messageDiv").slideUp(300, function() {
                $("#rsperror").html(msg);
                $("#rsperror").css('display','inline');
                $('#messageDiv').removeClass('alert-info');
                $('#messageDiv').addClass('alert-danger');
                $("#messageDiv").slideDown(300);

            })
        }

        $scope.checkForErrorsCustomersList = function (response) {
            var nonFatalErrors = ["00","10"];
            if (response._status=="OK") {
                $scope.customerList = response.customers;
                $scope.showMessage("Operation successful");
            } else {
                if (nonFatalErrors.indexOf(response._status)<0)
                    $scope.showMessage(response._message);
                else
                    $scope.showError(response._message);
            }
        }

    }    
);

appTutorial.controller("zoomCtrl", function($scope, $http, $modalInstance) {
           // customer zoom grid definition

        var gridPage = 1;
        var pageSize = 50;

        $scope.customers = [];

        $scope.customersGrid = {
            data: 'customers',
            columnDefs: [
                {field:"name", displayName:"Name", width:150},
                {field:"surname", displayName:"Surame", width: 250},
                {field:"email", displayName:"Email", width: 250},
                {field:"country", displayName:"Country", width:150}
            ],
            beforeSelectionChange: function(rowItem, event) {
                $modalInstance.close(rowItem.entity);
            }
        };

        $scope.$on('ngGridEventScroll', function(p) {
            $scope.getCustomerList(gridPage, pageSize);
        });


        $scope.getCustomerList = function (page, size) {
            $http.get("servlet/isCobol(AWEBX_ZOOM)?page="+page+"&pageSize="+size+"&nc=" + Math.random())
            .then(function (response) {
                $scope.customers = $scope.customers.concat(response.data._zoom_buffer.customerList.customers);
                ++gridPage;
            });
        }

        // get the first batch of customers
        $scope.getCustomerList(gridPage, pageSize);

})

function callServer (cobolProg, form, onSuccess, onError) {
    var url = "servlet/isCobol(" + cobolProg + ")";
    var parm = $(form).serialize();
    $.ajax({
            type: "POST",
            url: url,
            data:  JSON.stringify(parm),
            success: onSuccess,
            error: onError,
            contentType: "application/json",
            dataType: 'json',
            data: parm
        });
    return;
}

function callServerWithData (cobolProg, data, onSuccess, onError) {
    var url = "servlet/isCobol(" + cobolProg + ")";
    $.ajax(url, {
        success: onSuccess,
        error: onError,
        data: data,
        contentType: "application/json",
        dataType: 'json'
    });
    return;
}


function callServerWithJson (cobolProg, json, onSuccess) {
    var url = "servlet/isCobol(" + cobolProg + ")";
    var jsonStr = JSON.stringify(json);
    $.ajax(url, {
        type: "POST",
        success: onSuccess,
        data: jsonStr,
        contentType: "application/json",
        dataType: 'json'
    });


    return;
}

