           >>SOURCE FORMAT TERMINAL
*> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.

$SET "oop.trim_parameters" "0"
******************************************************************
*   A Preprocessor that analyzes these tags (4 bytes). In the Sequence Number Area (ANSI format sources required):
*   '*MY '  = single line
*   '**MY'  = start/end multi line block
*   '**  '  = continuation in the block
*
*   This Preprocessor program replaces the content in the lines that are tagged to change:
*   " display " with 
*   " call ' C$WRITELOG' using 'MY:' "
******************************************************************

 identification division.
 class-id. LogPreProc as "LogPreProc" implements LinePreProcessor.
 environment division.
 configuration section.
 repository.
     class LinePreProcessor as "com.iscobol.compiler.custpreproc.LinePreProcessor"
     class JString          as "java.lang.String"
     class JStringArr       as "java.lang.String[]"
     class ProcessResult    as "com.iscobol.compiler.custpreproc.ProcessResult"
     class ProcessException as "com.iscobol.compiler.custpreproc.ProcessException"
     .

 identification division.
 object.
 working-storage section.
 77                    pic 9 value 1.
     88 w-first-time   value 1 false 0.
 77  w-init-block      pic 9 value 0.
 77  w-main-source     pic x any length.
 77  w-new-block       pic x any length.
 procedure division.

 identification division.
 method-id. process as "process" override.
 working-storage section.
 77  w-curr-source     pic x any length.
 77  w-curr-line       pic x any length.
 77  w-new-line        pic x any length.
 77  w-comp-option     pic x any length.
 77  w-num-opts        pic 99.
 77  w-cont            pic 99.
 78  78-word-display   value " display ".
 linkage section.
*    The original line of the source code
*    Initialized to NULL at program end
 77  original-line     object reference JString.
*    Contains the source format
*    0 = UNKNOWN_FORMAT
*    1 = ANSI_FIXED
*    2 = TERMINAL_FIXED
*    3 = ANSI_FREE
*    4 = VARIABLE
*    5 = LONG_LINE
 77  source-format     object reference "int".
*    Source file name
 77  source-file-name  object reference JString.
*    The line number of the line being processed
*    Initialized to zero at program end
 77  line-number       object reference "int".
*    Contains the compiler options
 77  compiler-options  object reference JStringArr.
*    Contains the result of the preprocessor
 77  result            object reference ProcessResult.
 procedure division using original-line, 
                          source-format,
                          source-file-name, 
                          line-number, 
                          compiler-options,
                          result
                  raising ProcessException.
 MAIN.
*    At the first execution I retreive the name of the source code
     if w-first-time
        set w-main-source to source-file-name:>toString()
        set w-first-time  to false
        set w-num-opts = compiler-options:>length
        perform varying w-cont from 0 by 1 until w-cont = w-num-opts
           set w-comp-option = compiler-options(w-cont)
           if function upper-case(w-comp-option) = "-SF" or "-SMAT" or "-SA" or "-SV"
              raise ProcessException:>new(2, "unexpected compiler option on source format", result)
           end-if
        end-perform
     end-if
     if line-number = 0 and original-line = null
*    This condition is true when the source code is at the end. It can be the main source code or any copy source 
        perform MANAGE-AT-END-OF-SOURCE-CODE
     else
        set w-curr-line to original-line:>toString()
        perform MANAGE-SOURCE-CODE
     end-if
     goback
     .
 MANAGE-AT-END-OF-SOURCE-CODE.
     set w-curr-source to source-file-name:>toString()
*    If I'm at the end of the main source, I'll add some code. In that sample a comment, but it can be any source code
     if w-curr-source = w-main-source
        string "              === " w-main-source ": source preprocessed by LOGPREPROC ===" into w-new-line
        result:>setReplace(w-new-line)
        result:>setComment(true)
     end-if
     .
 MANAGE-SOURCE-CODE.
     evaluate w-curr-line(1:4) 
     when "*MY " | tag single line
          perform CHECK-SOURCE-FORMAT
          perform REPLACE-DISPLAY;;
          result:>setReplace(w-new-line)
     when "**MY" | tag multi line
          perform CHECK-SOURCE-FORMAT
          perform REPLACE-DISPLAY
          perform APPEND-TO-NEW-BLOCK
          if w-init-block = 0
             move 1 to w-init-block;;
             result:>setComment(true)
          else
             result:>setReplace(w-new-block)
             move 0 to w-init-block     
             initialize w-new-block
          end-if
     when "**  " | tag in the block
          perform CHECK-SOURCE-FORMAT
          if w-init-block = 0
             raise ProcessException:>new(2, "tag <*> outside block", result)
          else
             perform REPLACE-DISPLAY
             perform APPEND-TO-NEW-BLOCK;;
             result:>setComment(true)
          end-if
     when other | different tag
          if w-init-block = 1
             raise ProcessException:>new(2, "unexpected tag inside block", result)
          end-if
     end-evaluate
     .
 REPLACE-DISPLAY.
     initialize w-cont
     inspect function lower-case(w-curr-line) tallying w-cont for all 78-word-display
     if w-cont > 0
        initialize w-cont
        inspect function lower-case(w-curr-line) tallying w-cont for characters before 78-word-display
        add 9 to w-cont
        string "      call 'C$WRITELOG' using 'MY:' " w-curr-line(w-cont:) into w-new-line
     else
        if w-init-block = 1
           move w-curr-line(8:) to w-new-line
        end-if
     end-if
     .
 APPEND-TO-NEW-BLOCK.
     string w-new-block w-new-line into w-new-block
     .
 CHECK-SOURCE-FORMAT.
     if source-format = 1 or 4 or 5 |ANSI_FIXED or VARIABLE or LONG_LINE 
        raise ProcessException:>new(2, "unexpected source format", result)
     end-if
     .
 end method.

 end object.

 end class.
