      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. relative.
       environment division.
       input-output section.
       file-control.
      *    Local file
           select file1 assign to "LocalRelative"
                 organization is relative
                 relative key is key-val
                 file status is file-status.

      *    Remote file using the ISF notation into the File Name
           select file2 assign to file2-remote-path 
                 organization is relative
                 relative key is key-val
                 file status is file-status.

      *    Remote file using the configuration file
           select file3 assign to "RemoteRelative"
                 organization is relative
                 relative key is key-val
                 file status is file-status.

       data division.
       file section.
       fd  file1.
       01  file1-rec.
           03 file1-field-1       pic 99.
           03 file1-field-2       pic x(20).
       fd  file2.
       01  file2-rec.
           03 file2-field-1       pic 99.
           03 file2-field-2       pic x(20).
       fd  file3.
       01  file3-rec.
           03 file3-field-1       pic 99.
           03 file3-field-2       pic x(20).

       working-storage section.
       77  wrk-hostname            pic x any length.
       77  wrk-port-number         pic x any length.
       77  file2-remote-path       pic x any length.
       77  file-status             pic x(2).
       01  crerr-status.
           03 crerr-file-status    pic xx.
           03 crerr-ext-status     pic xxx.
       77  rerrname                pic x(50).
       77  fileop                  pic x(50).
       77  key-val                 pic 9(5) value 0.

       procedure division.
       declaratives.
       FILE1-ERROR section.
           use after error procedure on file1 file2 file3.
           call "C$RERR"          using crerr-status
           call "C$RERRNAME"      using rerrname
           call "C$GETLASTFILEOP" using fileOp
           display " "  
           display "Error " crerr-status " on " rerrname  
           display "on statement " fileOp.
       END DECLARATIVES.

       MAIN.
      *    Create the "assign to" variable for the file2 
           perform BUILD-REMOTE-PATH.

      *    creates the file
           display "Creating files..."
           open output file1
           close file1
           open output file2
           close file2
           open output file3
           close file3
              
      *    opening 
           display " "
           display "Opening files..."
           open i-o file1
           open i-o file2
           open i-o file3

      *    record writing
           display " "
           display "Writing into files..."  
           move 0 to key-val
           perform 3 times
              add 1        to key-val
              move 1       to file1-field-1 
              move "00xxx" to file1-field-2
              write file1-rec
           end-perform
           move 0 to key-val
           perform 3 times
              add 1        to key-val
              move 1       to file2-field-1 
              move "00xxx" to file2-field-2
              write file2-rec
           end-perform
           move 0 to key-val
           perform 3 times
              add 1        to key-val
              move 1       to file3-field-1 
              move "00xxx" to file3-field-2
              write file3-rec
           end-perform

      *    start
           display " " 
           display "Getting the first records..." 
           move low-value to key-val
           start file1 key not < key-val
              invalid
                 continue
           end-start

           move low-value to key-val
           start file2 key not < key-val
              invalid
                 continue
           end-start

           move low-value to key-val
           start file3 key not < key-val
              invalid
                 continue
           end-start

      *    read next
           display " "
           display "Reading next records..."
           read file1 next 
           read file2 next 
           read file3 next 

      *    rewrite current record
           display " "  
           display "Rewriting into files..."  

           move 2      to file1-field-1 
           move "bbb"  to file1-field-2
           rewrite file1-rec

           move 2      to file2-field-1 
           move "bbb"  to file2-field-2
           rewrite file2-rec

           move 2      to file3-field-1 
           move "bbb"  to file3-field-2
           rewrite file3-rec

      *    close
           display " "
           display "Closing files..."
           close file1
           close file2
           close file3

           goback.

       BUILD-REMOTE-PATH.
           accept wrk-hostname from environment "file.remote.host"
           if wrk-hostname = space
              move "127.0.0.1"   to wrk-hostname
           end-if
             
           accept wrk-port-number from environment "file.remote.port"
           if wrk-port-number = space
              move "10997"       to wrk-port-number
           end-if

           initialize file2-remote-path      
           string "isf://"               delimited by size
                  wrk-hostname           delimited by trailing space
                  ":"                    delimited by size
                  wrk-port-number        delimited by trailing space
                  ":./RemoteISFRelative" delimited by size
                  into file2-remote-path
           .
           