/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;

public class PicoUtil {
    public static String BytesToChars(String string, byte[] byArray) throws UnsupportedEncodingException {
        int n;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        return new String(byArray, 0, n, string);
    }

    protected static void dumpByte(byte[] byArray, int n) {
        PicoUtil.trace("Dump (" + n + " bytes):");
        int n2 = 0;
        while (n2 * 16 < n) {
            String string = PicoUtil.toHex(n2 * 16);
            PicoUtil.trace(" " + PicoUtil.hexPad(string, 8) + "  ", false);
            String string2 = "";
            for (int i = 0; i < 16; ++i) {
                String string3;
                int n3 = n2 * 16 + i;
                if (n3 >= n) {
                    string3 = "  ";
                    string2 = string2 + " ";
                } else {
                    string3 = PicoUtil.toHex(byArray[n3]);
                    string3 = PicoUtil.hexPad(string3, 2);
                    string2 = byArray[n3] < 32 || byArray[n3] > 128 ? string2 + "." : string2 + new String(byArray, n3, 1);
                }
                PicoUtil.trace(string3 + " ", false);
            }
            PicoUtil.trace("   " + string2);
            ++n2;
        }
    }

    public static String hexPad(String string, int n) {
        if (!string.startsWith("0x")) {
            return string;
        }
        String string2 = string.substring(2);
        int n2 = string2.length();
        if (n2 > n) {
            string2 = string2.substring(n2 - n);
        } else if (n2 < n) {
            String string3;
            String string4 = "0000000000000000";
            string2 = string3 = string4.substring(0, n - n2) + string2;
        }
        string2 = string2.toUpperCase();
        return string2;
    }

    public static int hexPairToInt(String string) throws NumberFormatException {
        String string2 = "0123456789ABCDEF";
        String string3 = string.toUpperCase();
        int n = 0;
        boolean bl = false;
        int n2 = string3.length();
        if (n2 > 2) {
            n2 = 2;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = string2.indexOf(string3.substring(i, i + 1));
            if (n3 < 0) {
                throw new NumberFormatException();
            }
            if (i == 0) {
                n3 *= 16;
            }
            n += n3;
        }
        return n;
    }

    public static byte[] hexStringToByteArray(String string) throws NumberFormatException {
        int n = string.length();
        int n2 = (n + 1) / 2;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)PicoUtil.hexPairToInt(string.substring(i * 2, (i + 1) * 2));
        }
        return byArray;
    }

    protected static boolean isTracing() {
        return DriverManager.getLogWriter() != null;
    }

    public static String toHex(int n) {
        char[] cArray = new char[8];
        String string = "0123456789ABCDEF";
        for (int i = 0; i < 4; ++i) {
            byte by = (byte)(n & 0xFF);
            cArray[6 - i * 2] = string.charAt(by >> 4 & 0xF);
            cArray[7 - i * 2] = string.charAt(by & 0xF);
            n >>= 8;
        }
        return "0x" + new String(cArray);
    }

    protected static void trace(String string) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            printWriter.println(string);
        }
    }

    protected static void trace(String string, boolean bl) {
        PrintWriter printWriter;
        if (bl) {
            PicoUtil.trace(string);
        }
        if ((printWriter = DriverManager.getLogWriter()) != null) {
            printWriter.print(string);
        }
    }
}

