/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.OdbcStatement;
import com.veryant.jdbc.PicoDbApi;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Statement;

public class PicoInputStream
extends InputStream {
    protected PicoDbApi odbcApi;
    protected OdbcStatement hStmt;
    protected int column;
    protected short type;
    public static final short ASCII = 1;
    public static final short UNICODE = 2;
    public static final short BINARY = 3;
    public static final short LOCAL = 4;
    protected byte[] localByteArray;
    protected int localOffset;
    protected boolean invalid;
    protected boolean highRead;
    protected int sqlType;
    protected byte[] buf;
    public static final int MAX_BUF_LEN = 5120;
    protected int convertType;
    public static final int CONVERT_NONE = 0;
    public static final int CONVERT_UNICODE = 1;
    public static final int CONVERT_ASCII = 2;
    public static final int CONVERT_BOTH = 3;
    protected int convertMultiplier;
    protected int bytesInBuf;
    protected int bufOffset;
    protected Statement ownerStatement;

    public PicoInputStream(PicoDbApi api, OdbcStatement stmt, int col, short ty, int k, Statement statement) {
        this.odbcApi = api;
        this.hStmt = stmt;
        this.column = col;
        this.type = ty;
        this.invalid = false;
        this.ownerStatement = statement;
        this.sqlType = -2;
        switch (k) {
            case -1: 
            case 1: 
            case 12: {
                this.sqlType = 1;
            }
        }
        this.convertMultiplier = 1;
        this.convertType = 0;
        switch (this.type) {
            default: {
                break;
            }
            case 1: {
                if (this.sqlType != -2) break;
                this.convertMultiplier = 2;
                this.convertType = 2;
                break;
            }
            case 2: {
                if (this.sqlType == -2) {
                    this.convertType = 3;
                    this.convertMultiplier = 4;
                    break;
                }
                this.convertType = 1;
                this.convertMultiplier = 2;
            }
        }
        this.buf = new byte[5120 * this.convertMultiplier];
        this.bytesInBuf = 0;
        this.bufOffset = 0;
    }

    public PicoInputStream(PicoDbApi api, OdbcStatement stmt, int col, byte[] abyte0) {
        this.odbcApi = api;
        this.hStmt = stmt;
        this.column = col;
        this.type = (short)4;
        this.localByteArray = abyte0;
        this.localOffset = 0;
        this.invalid = false;
    }

    public int available() throws IOException {
        throw new IOException();
    }

    protected int convertData(byte[] abyte0, int i) {
        if (this.convertType == 0) {
            return i;
        }
        String s = "0123456789ABCDEF";
        if (i <= 0) {
            return i;
        }
        for (int j = i - 1; j >= 0; --j) {
            if (this.convertType == 3) {
                abyte0[j * 4 + 3] = (byte)s.charAt(abyte0[j] & 0xF);
                abyte0[j * 4 + 2] = 0;
                abyte0[j * 4 + 1] = (byte)s.charAt(abyte0[j] >> 4 & 0xF);
                abyte0[j * 4] = 0;
                continue;
            }
            if (this.convertType == 2) {
                abyte0[j * 2 + 1] = (byte)s.charAt(abyte0[j] & 0xF);
                abyte0[j * 2] = (byte)s.charAt(abyte0[j] >> 4 & 0xF);
                continue;
            }
            abyte0[j * 2 + 1] = abyte0[j];
            abyte0[j * 2] = 0;
        }
        return i * this.convertMultiplier;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public int read() throws IOException {
        byte[] abyte0 = new byte[1];
        int i = this.read(abyte0);
        if (i != -1) {
            i = abyte0[0] & 0xFF;
        }
        return i;
    }

    public int read(byte[] abyte0) throws IOException {
        if (abyte0.length == 0) {
            return -1;
        }
        int i = 0;
        if (this.invalid) {
            throw new IOException("InputStream is no longer valid - the Statement has been closed, or the cursor has been moved");
        }
        switch (this.type) {
            case 4: {
                i = abyte0.length;
                if (this.localOffset + i > this.localByteArray.length) {
                    i = this.localByteArray.length - this.localOffset;
                }
                if (i == 0) {
                    i = -1;
                    break;
                }
                for (int j = 0; j < i; ++j) {
                    abyte0[j] = this.localByteArray[this.localOffset + j];
                }
                this.localOffset += i;
                break;
            }
            default: {
                i = this.readData(abyte0);
            }
        }
        return i;
    }

    public int read(byte[] abyte0, int i, int j) throws IOException {
        throw new IOException("Method not implemented");
    }

    protected int readBinaryData(byte[] abyte0, int i) throws IOException {
        throw new IOException("Method not implemented");
    }

    protected int readData(byte[] abyte0) throws IOException {
        int i = -1;
        int j = 0;
        while (this.bytesInBuf != -1 && j < abyte0.length) {
            if (this.bufOffset >= this.bytesInBuf) {
                this.bytesInBuf = this.readBinaryData(this.buf, 5120);
                this.bytesInBuf = this.convertData(this.buf, this.bytesInBuf);
                this.bufOffset = 0;
                continue;
            }
            abyte0[j] = this.buf[this.bufOffset];
            ++j;
            ++this.bufOffset;
        }
        if (j > 0) {
            i = j;
        }
        return i;
    }
}

