/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.OdbcConnection;
import com.veryant.jdbc.OdbcStatement;
import com.veryant.jdbc.PicoDatabaseMetaData;
import com.veryant.jdbc.PicoDbApi;
import com.veryant.jdbc.PicoPreparedStatement;
import com.veryant.jdbc.PicoStatement;
import com.veryant.jdbc.VerySQLDriver;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class PicoConnection
implements Connection {
    public final String rcsid = "$Id: PicoConnection.java,v 1.2 2009/04/02 10:02:46 picoSoft Exp pico $";
    protected PicoDbApi odbcApi = new PicoDbApi();
    protected VerySQLDriver myDriver;
    protected int hEnv;
    protected OdbcConnection hDbc;
    protected SQLWarning lastWarning;
    protected boolean closed;
    protected String url;
    protected int odbcVer;
    protected String catalog;
    protected Hashtable statements;

    public PicoConnection(int hE, VerySQLDriver driver) {
        this.myDriver = driver;
        this.hEnv = hE;
        this.hDbc = null;
        this.url = null;
        this.lastWarning = null;
        this.closed = true;
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.close");
        }
        if (!this.closed) {
            this.closeAllStatements();
            this.myDriver.closeConnection(this.hDbc);
            this.hDbc = null;
            this.odbcApi.finalize();
            this.odbcApi = null;
            this.closed = true;
        }
        this.url = null;
    }

    public synchronized void closeAllStatements() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println(this.statements.size() + " Statement(s) to close");
        }
        if (this.statements.size() == 0) {
            return;
        }
        Enumeration en = this.statements.keys();
        while (en.hasMoreElements()) {
            Statement statement = (Statement)en.nextElement();
            statement.close();
        }
    }

    public void commit() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.commit");
        }
        this.odbcApi.SQLTransact(this.hEnv, this.hDbc, (short)0);
    }

    public Statement createStatement() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.createStatement");
        }
        PicoStatement stmt = new PicoStatement(this, this.odbcApi);
        this.registerStatement(stmt);
        return stmt;
    }

    public Statement createStatement(int rsSetType, int rsSetConurrency) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoConnection.createStatement(int " + rsSetType + ", int " + rsSetConurrency + ")");
        }
        return this.createStatement();
    }

    public Statement createStatement(int rsSetType, int rsSetConurrency, int rsSetHoldability) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoConnection.createStatement(int " + rsSetType + ", int " + rsSetConurrency + ", int " + rsSetHoldability + ")");
        }
        return this.createStatement();
    }

    public void deregisterStatement(Statement statement) {
        if (this.statements.get(statement) != null) {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("deregistering Statement " + statement);
            }
            this.statements.remove(statement);
        }
    }

    protected void finalize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Connection.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean getAutoCommit() throws SQLException {
        boolean Return = false;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getAutoCommit");
        }
        this.validateConnection();
        int i = this.odbcApi.SQLGetConnectOption(this.hDbc, (short)102);
        if (i == 1) {
            Return = true;
        }
        return Return;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public OdbcConnection getHDBC() {
        return this.hDbc;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getMetaData");
        }
        this.validateConnection();
        PicoDatabaseMetaData metadata = new PicoDatabaseMetaData(this.odbcApi, this);
        return metadata;
    }

    public int getTransactionIsolation() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getTransactionIsolation");
        }
        this.validateConnection();
        return this.odbcApi.SQLGetConnectOption(this.hDbc, (short)108);
    }

    public Map getTypeMap() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.getTypeMap()");
        }
        throw new UnsupportedOperationException();
    }

    public String getURL() {
        return this.url;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.getWarnings");
        }
        return this.lastWarning;
    }

    public void initialize(String dsn, Properties info, int timeOut) throws SQLException {
        DatabaseMetaData md;
        String user = info.getProperty("user", "");
        String pass = info.getProperty("password", "");
        this.odbcApi.charSet = info.getProperty("charSet", System.getProperty("file.encoding"));
        try {
            this.hDbc = new OdbcConnection(this.odbcApi, dsn);
            this.hDbc.connect(user, pass);
        }
        catch (SQLException ex) {
            try {
                if (this.hDbc != null) {
                    this.odbcApi.SQLFreeConnect(this.hDbc);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (this.hDbc != null) {
                this.hDbc.finalize();
                this.hDbc = null;
            }
            throw ex;
        }
        this.closed = false;
        this.statements = new Hashtable();
        if (DriverManager.getLogWriter() != null && (md = this.getMetaData()) != null) {
            DriverManager.println("Driver name:   " + md.getDriverName());
            DriverManager.println("Driver version: " + md.getDriverVersion());
        }
        this.catalog = dsn;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.isReadOnly");
        }
        boolean flag = false;
        this.validateConnection();
        int i = this.odbcApi.SQLGetConnectOption(this.hDbc, (short)101);
        if (i == 1) {
            flag = true;
        }
        return flag;
    }

    public String nativeSQL(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.nativeSQL(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.prepareCall(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String s, int rsSetType, int rsSetConurrency) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.prepareCall(String s, int rsSetType, int rsSetConurrency)");
        }
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String s, int rsSetType, int rsSetConurrency, int rsSetHoldability) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.prepareCall(String s, int rsSetType, int rsSetConurrency, int rsSetHoldability)");
        }
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.prepareStatement (" + s + ")");
        }
        SQLWarning sqlwarning = null;
        PicoPreparedStatement pstmt = new PicoPreparedStatement(this, this.odbcApi);
        OdbcStatement hstmt = pstmt.getHSTMT();
        try {
            this.odbcApi.SQLPrepare(hstmt, s);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            pstmt.close();
            throw sqlexception;
        }
        pstmt.setWarning(sqlwarning);
        this.registerStatement(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String s, int rsSetType, int rsSetConurrency) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoConnection.prepareStatement(String s, int " + rsSetType + ", int " + rsSetConurrency + ")");
        }
        return this.prepareStatement(s);
    }

    public PreparedStatement prepareStatement(String s, int rsSetType, int rsSetConurrency, int rsSetHoldability) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoConnection.prepareStatement(String s, int " + rsSetType + ", int " + rsSetConurrency + ", int " + rsSetHoldability + ")");
        }
        return this.prepareStatement(s);
    }

    public PreparedStatement prepareStatement(String s, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(s);
    }

    public PreparedStatement prepareStatement(String s, int[] columnIndexes) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.prepareStatement(String s, int columnIndexes[])");
        }
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String s, String[] columnIndexes) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.prepareStatement(String s, String columnIndexes[])");
        }
        throw new UnsupportedOperationException();
    }

    protected void registerStatement(Statement statement) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Registering Statement " + statement);
        }
        this.statements.put(statement, "");
    }

    public void rollback() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.rollback");
        }
        this.odbcApi.SQLTransact(this.hEnv, this.hDbc, (short)1);
    }

    public void setAutoCommit(boolean flag) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.setAutoCommit (" + flag + ")");
        }
        int i = 1;
        this.validateConnection();
        if (!flag) {
            i = 0;
        }
        this.odbcApi.SQLSetConnectOption(this.hDbc, (short)102, i);
    }

    public void setCatalog(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.setCatalog (" + s + ")");
        }
        this.validateConnection();
        this.odbcApi.SQLSetConnectOption(this.hDbc, (short)109, s);
    }

    protected void setLoginTimeout(int i) throws SQLException {
        this.odbcApi.SQLSetConnectOption(this.hDbc, (short)103, i);
    }

    public void setReadOnly(boolean flag) throws SQLException {
        block4: {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("*Connection.setReadOnly (" + flag + ")");
            }
            int i = 0;
            this.validateConnection();
            if (flag) {
                i = 1;
            }
            try {
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)101, i);
            }
            catch (SQLException ex) {
                if (DriverManager.getLogWriter() == null) break block4;
                DriverManager.println("setReadOnly exception ignored");
            }
        }
    }

    public void setTransactionIsolation(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Connection.setTransactionIsolation (" + i + ")");
        }
        this.validateConnection();
        switch (i) {
            case 0: {
                this.setAutoCommit(true);
                break;
            }
            case 1: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 1);
                break;
            }
            case 2: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 2);
                break;
            }
            case 4: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 4);
                break;
            }
            case 8: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, 8);
                break;
            }
            default: {
                this.setAutoCommit(false);
                this.odbcApi.SQLSetConnectOption(this.hDbc, (short)108, i);
            }
        }
    }

    public void setTypeMap(Map map) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.setTypeMap(Map map)");
        }
        throw new UnsupportedOperationException();
    }

    public void setURL(String s) {
        this.url = s;
    }

    public void validateConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.setHoldability(int holdability)");
        }
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.getHoldability()");
        }
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.setSavepoint ()");
        }
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String name) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.setSavepoint (String name)");
        }
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.rollback(Savepoint savepoint)");
        }
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoConnection.releaseSavepoint (Savepoint savepoint)");
        }
        throw new UnsupportedOperationException();
    }
}

