/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

import com.veryant.vision4j.file.internals.KeyInfo;

public class LogicalAttributes {
    private final int minRecordSize;
    private final int maxRecordSize;
    private final int compressFactor;
    private final int numKeys;
    private int maxKeySize;
    private int duplicates;
    private final KeyInfo[] keys;

    public KeyInfo getKey(int index) {
        return this.keys[index];
    }

    public boolean isCompressed() {
        return this.compressFactor > 0;
    }

    public LogicalAttributes(int minRecordSize, int maxRecordSize, KeyInfo[] keys, int compressFactor) {
        this.maxRecordSize = Math.max(1, maxRecordSize);
        this.minRecordSize = minRecordSize < 1 ? this.maxRecordSize : minRecordSize;
        this.numKeys = keys.length;
        this.keys = keys;
        for (KeyInfo k : keys) {
            this.maxKeySize = Math.max(this.maxKeySize, k.getTotalSize());
            if (!k.isDuplicate()) continue;
            ++this.duplicates;
        }
        this.compressFactor = compressFactor < 0 ? 0 : Math.min(compressFactor, 100);
    }

    public String toString() {
        return "min record size: " + this.minRecordSize + ", max record size: " + this.maxRecordSize + ", compress factor: " + this.compressFactor + ", keys: " + this.numKeys + ", max key size: " + this.maxKeySize + ", duplicates: " + this.duplicates;
    }

    public int getMinRecordSize() {
        return this.minRecordSize;
    }

    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    public int getCompressFactor() {
        return this.compressFactor;
    }

    public int getNumKeys() {
        return this.numKeys;
    }

    public int getMaxKeySize() {
        return this.maxKeySize;
    }

    public int getDuplicates() {
        return this.duplicates;
    }
}

