/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.data;

import com.veryant.cobol.data.IMemory;
import java.util.Arrays;

public class CobolBigDecimal {
    public static final int MAX_DIGITS = 38;
    public static final int MAX_REGISTER_SIZE = 40;
    public static final int HALF_REGISTER_SIZE = 20;
    public static final int MAX_ULONG_DIGITS = 20;
    public static final int MAX_UINT_DIGITS = 10;
    public static final int MAX_LONG_DIGITS = 18;
    private static final int WORD_DIGITS = 8;
    private static final int WORD_ROUNDER = 7;
    private static final int WORD_DIV = 3;
    private static final long WORD_SHIFTER = 100000000L;
    private static final int[] WORD_ALIGNER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000};
    private static final int NO_ALIGN = -1;
    public static final CobolBigDecimal ZERO = new CobolBigDecimal(null, 0);
    private static final CobolBigDecimal OVERFLOW = new CobolBigDecimal(null, 0);
    private static final byte[] ONE_DIGIT = new byte[]{1};
    public static final CobolBigDecimal POSITIVE_ONE = new CobolBigDecimal(false, ONE_DIGIT, 1);
    public static final CobolBigDecimal NEGATIVE_ONE = new CobolBigDecimal(true, ONE_DIGIT, 1);
    private static final byte[] TWO_DIGIT = new byte[]{2};
    private static final CobolBigDecimal POSITIVE_TWO = new CobolBigDecimal(false, TWO_DIGIT, 1);
    private static final CobolBigDecimal TWO_THIRDS = new CobolBigDecimal(false, new byte[]{6, 6, 6}, 0);
    private static final byte[] LOGN_TEN_DIGITS = new byte[]{2, 3, 0, 2, 5, 8, 5, 0, 9, 2, 9, 9, 4, 0, 4, 5, 6, 8, 4, 0, 1, 7, 9, 9, 1, 4, 5, 4, 6, 8, 4, 3, 6, 4, 2, 0, 7, 6, 0, 1, 1};
    private static final CobolBigDecimal LOGN_TEN = new CobolBigDecimal(false, LOGN_TEN_DIGITS, 1);
    private static final byte[] LOGN_HALF_DIGITS = new byte[]{6, 9, 3, 1, 4, 7, 1, 8, 0, 5, 5, 9, 9, 4, 5, 3, 0, 9, 4, 1, 7, 2, 3, 2, 1, 2, 1, 4, 5, 8, 1, 7, 6, 5, 6, 8, 0, 7, 5, 5};
    private static final CobolBigDecimal LOGN_HALF = new CobolBigDecimal(true, LOGN_HALF_DIGITS, 0);
    private static final byte[] E_DIGITS = new byte[]{2, 7, 1, 8, 2, 8, 1, 8, 2, 8, 4, 5, 9, 0, 4, 5, 2, 3, 5, 3, 6, 0, 2, 8, 7, 4, 7, 1, 3, 5, 2, 6, 6, 2, 4, 9, 7, 7, 5, 7, 2, 5};
    private static final CobolBigDecimal E = new CobolBigDecimal(false, E_DIGITS, 1);
    private boolean negative;
    private byte[] mantissa;
    private int digits;
    private int exp;

    public CobolBigDecimal(byte[] byArray, int n) {
        this(false, byArray, n);
    }

    public CobolBigDecimal(boolean bl, byte[] byArray, int n) {
        if (byArray != null && byArray.length > 0) {
            this.negative = bl;
            this.mantissa = byArray;
            this.digits = byArray.length;
            this.exp = n;
        }
    }

    public byte[] getMantissa() {
        if (this.isZero()) {
            return new byte[]{0};
        }
        byte[] byArray = new byte[this.digits];
        System.arraycopy(this.mantissa, 0, byArray, 0, this.digits);
        return byArray;
    }

    public int getDigits() {
        return this.digits;
    }

    public int getExp() {
        return this.exp;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean isZero() {
        return this.digits == 0;
    }

    public boolean isOne() {
        return this.exp == 1 && this.digits == 1 && this.mantissa[0] == 1;
    }

    public boolean isPositiveOne() {
        return !this.negative && this.isOne();
    }

    public boolean isPowerOfTen() {
        return this.digits == 1 && this.mantissa[0] == 1;
    }

    public boolean sizeError() {
        return this == OVERFLOW;
    }

    public boolean sizeError(int n) {
        return this.sizeError() || this.exp > n;
    }

    public static boolean sizeError(float f) {
        return (double)f == Double.NEGATIVE_INFINITY || (double)f == Double.POSITIVE_INFINITY || Float.isNaN(f);
    }

    public static boolean sizeError(double d) {
        return d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY || Double.isNaN(d);
    }

    public CobolBigDecimal negate() {
        return this.isZero() ? this : new CobolBigDecimal(!this.negative, this.mantissa, this.exp);
    }

    public CobolBigDecimal abs() {
        return this.negative ? this.negate() : this;
    }

    public CobolBigDecimal add(CobolBigDecimal cobolBigDecimal) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return cobolBigDecimal;
        }
        if (this.negative == cobolBigDecimal.isNegative()) {
            return this.absAdd(cobolBigDecimal);
        }
        return this.absSubtract(cobolBigDecimal);
    }

    public CobolBigDecimal subtract(CobolBigDecimal cobolBigDecimal) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return cobolBigDecimal.negate();
        }
        if (this.negative == cobolBigDecimal.isNegative()) {
            return this.absSubtract(cobolBigDecimal);
        }
        return this.absAdd(cobolBigDecimal);
    }

    public CobolBigDecimal multiply(CobolBigDecimal cobolBigDecimal, int n) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.isZero() || this.isZero()) {
            return ZERO;
        }
        return this.alignedMultiply(cobolBigDecimal, n);
    }

    public CobolBigDecimal divide(CobolBigDecimal cobolBigDecimal, int n, boolean bl) {
        return this.divideWithReminder(cobolBigDecimal, n, bl).getQuotient();
    }

    public DivResult divideWithReminder(CobolBigDecimal cobolBigDecimal, int n, boolean bl) {
        if (cobolBigDecimal.sizeError()) {
            return new DivResult(cobolBigDecimal, cobolBigDecimal);
        }
        if (cobolBigDecimal.isZero()) {
            return new DivResult(OVERFLOW, OVERFLOW);
        }
        if (this.isZero()) {
            return new DivResult(ZERO, ZERO);
        }
        return this.alignedDivide(cobolBigDecimal, n, bl);
    }

    public CobolBigDecimal power(CobolBigDecimal cobolBigDecimal) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.exp > 20) {
            return this.exp <= 0 ? ZERO : OVERFLOW;
        }
        if (this.isPositiveOne() || cobolBigDecimal.isPositiveOne()) {
            return this;
        }
        if (this.isZero()) {
            if (cobolBigDecimal.negative || cobolBigDecimal.isZero()) {
                return OVERFLOW;
            }
            return ZERO;
        }
        if (cobolBigDecimal.isZero()) {
            return POSITIVE_ONE;
        }
        if (cobolBigDecimal.exp - cobolBigDecimal.digits >= 0) {
            CobolBigDecimal cobolBigDecimal2 = this.power(cobolBigDecimal.getLong(0, 0, true));
            return cobolBigDecimal2.round(cobolBigDecimal2.exp - 38);
        }
        if (this.negative) {
            return OVERFLOW;
        }
        CobolBigDecimal cobolBigDecimal3 = this.power(cobolBigDecimal.integer().getLong(0, 0, true)).multiply(cobolBigDecimal.decimals().multiply(this.log(), Integer.MIN_VALUE).antilog(), Integer.MIN_VALUE);
        return cobolBigDecimal3.round(cobolBigDecimal3.exp - 38);
    }

    private CobolBigDecimal power(long l) {
        if (l == 0L) {
            return POSITIVE_ONE;
        }
        boolean bl = l < 0L;
        l = Math.abs(l);
        CobolBigDecimal cobolBigDecimal = POSITIVE_ONE;
        CobolBigDecimal cobolBigDecimal2 = this;
        while (true) {
            int n = (int)l & 1;
            l /= 2L;
            if (n != 0) {
                cobolBigDecimal = cobolBigDecimal.multiply(cobolBigDecimal2, Integer.MIN_VALUE);
                if (l == 0L) {
                    if (bl) {
                        cobolBigDecimal = POSITIVE_ONE.divide(cobolBigDecimal, Integer.MIN_VALUE, false);
                    }
                    return cobolBigDecimal;
                }
            }
            cobolBigDecimal2 = cobolBigDecimal2.multiply(cobolBigDecimal2, Integer.MIN_VALUE);
        }
    }

    private CobolBigDecimal integer() {
        if (!this.isZero() && this.exp - this.digits < 0) {
            if (this.exp <= 0) {
                return ZERO;
            }
            int n = this.exp;
            while (this.mantissa[n - 1] == 0) {
                --n;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.mantissa, 0, byArray, 0, n);
            return new CobolBigDecimal(this.negative, byArray, this.exp);
        }
        return this;
    }

    private CobolBigDecimal decimals() {
        if (!this.isZero() && this.exp > 0) {
            if (this.exp - this.digits >= 0) {
                return ZERO;
            }
            int n = 0;
            while (this.mantissa[this.exp - n] == 0) {
                --n;
            }
            int n2 = this.exp - n;
            int n3 = this.digits - n2;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.mantissa, n2, byArray, 0, n3);
            return new CobolBigDecimal(this.negative, byArray, n);
        }
        return this;
    }

    private CobolBigDecimal log() {
        if (this.isPowerOfTen()) {
            return LOGN_TEN.multiply(CobolBigDecimal.from(this.exp - 1, 0), Integer.MIN_VALUE);
        }
        CobolBigDecimal cobolBigDecimal = new CobolBigDecimal(this.negative, this.mantissa, 0);
        CobolBigDecimal cobolBigDecimal2 = LOGN_TEN.multiply(CobolBigDecimal.from(this.exp, 0), Integer.MIN_VALUE);
        while (cobolBigDecimal.compare(TWO_THIRDS) < 0) {
            cobolBigDecimal = cobolBigDecimal.multiply(POSITIVE_TWO, Integer.MIN_VALUE);
            cobolBigDecimal2 = cobolBigDecimal2.add(LOGN_HALF);
        }
        if (cobolBigDecimal.compare(POSITIVE_ONE) == 0) {
            return cobolBigDecimal2;
        }
        CobolBigDecimal cobolBigDecimal3 = cobolBigDecimal.subtract(POSITIVE_ONE);
        CobolBigDecimal cobolBigDecimal4 = cobolBigDecimal.add(POSITIVE_ONE);
        CobolBigDecimal cobolBigDecimal5 = cobolBigDecimal3.multiply(cobolBigDecimal3, Integer.MIN_VALUE);
        CobolBigDecimal cobolBigDecimal6 = cobolBigDecimal4.multiply(cobolBigDecimal4, Integer.MIN_VALUE);
        CobolBigDecimal cobolBigDecimal7 = ZERO;
        int n = 0;
        while (true) {
            CobolBigDecimal cobolBigDecimal8 = cobolBigDecimal3.divide(cobolBigDecimal4.multiply(CobolBigDecimal.from(2 * n + 1, 0), Integer.MIN_VALUE), Integer.MIN_VALUE, true);
            cobolBigDecimal7 = cobolBigDecimal7.add(cobolBigDecimal8);
            if (cobolBigDecimal8.exp <= -44) {
                cobolBigDecimal7 = cobolBigDecimal7.multiply(POSITIVE_TWO, Integer.MIN_VALUE);
                cobolBigDecimal7 = cobolBigDecimal7.add(cobolBigDecimal2);
                return cobolBigDecimal7;
            }
            cobolBigDecimal3 = cobolBigDecimal3.multiply(cobolBigDecimal5, Integer.MIN_VALUE);
            cobolBigDecimal4 = cobolBigDecimal4.multiply(cobolBigDecimal6, Integer.MIN_VALUE);
            ++n;
        }
    }

    private CobolBigDecimal antilog() {
        CobolBigDecimal cobolBigDecimal = this.round(0);
        CobolBigDecimal cobolBigDecimal2 = this.subtract(cobolBigDecimal);
        CobolBigDecimal cobolBigDecimal3 = cobolBigDecimal2.multiply(cobolBigDecimal2, Integer.MIN_VALUE);
        CobolBigDecimal cobolBigDecimal4 = POSITIVE_ONE;
        CobolBigDecimal cobolBigDecimal5 = cobolBigDecimal2.add(POSITIVE_ONE);
        CobolBigDecimal cobolBigDecimal6 = POSITIVE_ONE;
        CobolBigDecimal cobolBigDecimal7 = cobolBigDecimal5;
        CobolBigDecimal cobolBigDecimal8 = cobolBigDecimal5;
        int n = 2;
        while (cobolBigDecimal7.digits != 0 && cobolBigDecimal8.exp - cobolBigDecimal7.exp <= 42) {
            cobolBigDecimal4 = cobolBigDecimal4.multiply(cobolBigDecimal3, Integer.MIN_VALUE);
            cobolBigDecimal5 = cobolBigDecimal5.add(POSITIVE_TWO);
            cobolBigDecimal6 = cobolBigDecimal6.multiply(CobolBigDecimal.from(n * (n + 1), 0), Integer.MIN_VALUE);
            cobolBigDecimal7 = cobolBigDecimal4.multiply(cobolBigDecimal5, Integer.MIN_VALUE).divide(cobolBigDecimal6, Integer.MIN_VALUE, true);
            cobolBigDecimal8 = cobolBigDecimal8.add(cobolBigDecimal7);
            n += 2;
        }
        return cobolBigDecimal8.multiply(E.power(cobolBigDecimal.getLong(0, 0, true)), Integer.MIN_VALUE);
    }

    public CobolBigDecimal round(int n) {
        if (!this.isZero() && this.exp - this.digits < n) {
            if (this.exp < n) {
                return ZERO;
            }
            CobolBigDecimal cobolBigDecimal = this.add(CobolBigDecimal.from(5, n - 1));
            int n2 = cobolBigDecimal.exp - n;
            if (cobolBigDecimal.exp <= n) {
                return ZERO;
            }
            while (cobolBigDecimal.mantissa[n2 - 1] == 0) {
                --n2;
            }
            return new CobolBigDecimal(cobolBigDecimal.isNegative(), Arrays.copyOf(cobolBigDecimal.mantissa, n2), cobolBigDecimal.exp);
        }
        return this;
    }

    private CobolBigDecimal absAdd(CobolBigDecimal cobolBigDecimal) {
        int n;
        CobolBigDecimal cobolBigDecimal2;
        CobolBigDecimal cobolBigDecimal3;
        int n2 = cobolBigDecimal.exp - this.exp;
        if (n2 < 0) {
            cobolBigDecimal3 = this;
            cobolBigDecimal2 = cobolBigDecimal;
            n2 = -n2;
        } else {
            cobolBigDecimal3 = cobolBigDecimal;
            cobolBigDecimal2 = this;
        }
        int n3 = cobolBigDecimal3.exp;
        int n4 = Math.max(cobolBigDecimal3.digits, n2 + cobolBigDecimal2.digits);
        byte[] byArray = new byte[n4 + 1];
        System.arraycopy(cobolBigDecimal3.mantissa, 0, byArray, 0, cobolBigDecimal3.digits);
        if (n2 >= cobolBigDecimal3.digits) {
            System.arraycopy(cobolBigDecimal2.mantissa, 0, byArray, n2, cobolBigDecimal2.digits);
        } else {
            int n5;
            n = n4 - cobolBigDecimal3.digits;
            if (n > 0) {
                System.arraycopy(cobolBigDecimal2.mantissa, cobolBigDecimal2.digits - n, byArray, cobolBigDecimal3.digits, n);
            }
            byte by = 0;
            int n6 = cobolBigDecimal2.digits - n;
            int n7 = n2 + n6;
            while (n6 > 0) {
                n5 = byArray[--n7] + cobolBigDecimal2.mantissa[--n6];
                if ((n5 += by) < 10) {
                    by = 0;
                } else {
                    by = 1;
                    n5 -= 10;
                }
                byArray[n7] = (byte)n5;
            }
            while (by != 0 && n7 > 0) {
                if ((n5 = byArray[--n7] + by) < 10) {
                    by = 0;
                } else {
                    by = 1;
                    n5 = 0;
                }
                byArray[n7] = (byte)n5;
            }
            if (by != 0) {
                System.arraycopy(byArray, 0, byArray, 1, n4);
                ++n3;
                byArray[0] = 1;
            }
        }
        n = Math.min(byArray.length, 40);
        while (byArray[n - 1] == 0) {
            --n;
        }
        if (n != byArray.length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        return new CobolBigDecimal(this.negative, byArray, n3);
    }

    private CobolBigDecimal absSubtract(CobolBigDecimal cobolBigDecimal) {
        int n;
        int n2;
        CobolBigDecimal cobolBigDecimal2;
        CobolBigDecimal cobolBigDecimal3;
        boolean bl = this.negative;
        int n3 = cobolBigDecimal.exp - this.exp;
        if (n3 > 0) {
            cobolBigDecimal3 = cobolBigDecimal;
            cobolBigDecimal2 = this;
            bl = !bl;
        } else {
            cobolBigDecimal3 = this;
            cobolBigDecimal2 = cobolBigDecimal;
            n3 = -n3;
        }
        int n4 = cobolBigDecimal3.exp;
        int n5 = Math.max(cobolBigDecimal3.digits, n3 + cobolBigDecimal2.digits);
        byte[] byArray = new byte[n5];
        System.arraycopy(cobolBigDecimal3.mantissa, 0, byArray, 0, cobolBigDecimal3.digits);
        byte by = 0;
        int n6 = cobolBigDecimal2.digits;
        int n7 = n3 + n6;
        while (n6 > 0) {
            n2 = byArray[--n7] - cobolBigDecimal2.mantissa[--n6];
            if ((n2 -= by) < 0) {
                n2 += 10;
                by = 1;
            } else {
                by = 0;
            }
            byArray[n7] = (byte)n2;
        }
        while (by != 0 && n7 > 0) {
            if ((n2 = byArray[--n7] - by) < 0) {
                n2 += 10;
            } else {
                by = 0;
            }
            byArray[n7] = (byte)n2;
        }
        while (n5 != 0 && byArray[n5 - 1] == 0) {
            --n5;
        }
        if (by != 0) {
            byArray[n5 - 1] = (byte)(10 - byArray[n5 - 1]);
            for (n = n5 - 2; n >= 0; --n) {
                byArray[n] = (byte)(9 - byArray[n]);
            }
            while (n5 != 0 && byArray[n5 - 1] == 0) {
                --n5;
            }
            bl = !bl;
        }
        for (n = 0; n < n5 && byArray[n] == 0; ++n) {
        }
        n4 -= n;
        if ((n5 -= n) == 0) {
            return ZERO;
        }
        if (n5 != byArray.length) {
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, n, byArray2, 0, n5);
            byArray = byArray2;
        }
        return new CobolBigDecimal(bl, byArray, n4);
    }

    private CobolBigDecimal alignedMultiply(CobolBigDecimal cobolBigDecimal, int n) {
        int n2;
        int n3;
        int n4 = this.exp + cobolBigDecimal.exp;
        if (this.isPowerOfTen()) {
            return new CobolBigDecimal(cobolBigDecimal.negative != this.negative, cobolBigDecimal.mantissa, n4 - 1);
        }
        if (cobolBigDecimal.isPowerOfTen()) {
            return new CobolBigDecimal(this.negative != cobolBigDecimal.negative, this.mantissa, n4 - 1);
        }
        int n5 = this.digits + cobolBigDecimal.digits;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        int n7 = this.digits - 1;
        int n8 = cobolBigDecimal.digits - 1;
        while (n8 >= 0) {
            n3 = n7;
            for (n2 = n8; n3 < this.digits && n2 >= 0; ++n3, --n2) {
                n6 += this.mantissa[n3] * cobolBigDecimal.mantissa[n2];
            }
            byArray[--n5] = (byte)(n6 % 10);
            n6 /= 10;
            if (n7 > 0) {
                --n7;
                continue;
            }
            --n8;
        }
        byArray[0] = (byte)n6;
        n3 = n4 - Math.max(n, n4 - byArray.length);
        n2 = 0;
        if (n6 == 0) {
            n2 = 1;
            --n3;
            --n4;
        }
        n3 = Math.min(n3, 40);
        for (int i = n3 + n2 - 1; i >= n2 && byArray[i] == 0; --i) {
            --n3;
        }
        if (n2 != 0 || n3 != byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            byArray = byArray2;
        }
        return new CobolBigDecimal(this.negative != cobolBigDecimal.negative, byArray, n4);
    }

    private DivResult alignedDivide(CobolBigDecimal cobolBigDecimal, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.exp - cobolBigDecimal.exp + (bl ? 1 : 0) < n) {
            return new DivResult(ZERO, this);
        }
        int n6 = n == Integer.MIN_VALUE ? 7 : this.exp - cobolBigDecimal.exp - n & 7;
        int n7 = 8 - n6;
        int n8 = n == Integer.MIN_VALUE ? 11 : this.exp - cobolBigDecimal.exp - n + 7 + n7 >> 3;
        int n9 = this.digits + 7 + n7 >> 3;
        int n10 = cobolBigDecimal.digits + 7 >> 3;
        int n11 = Math.max(n10, n9 - n8);
        boolean bl2 = false;
        int[] nArray = new int[23];
        int[] nArray2 = new int[n10];
        int[] nArray3 = new int[n8];
        CobolBigDecimal.convert(this.mantissa, n6, nArray);
        CobolBigDecimal.convert(cobolBigDecimal.mantissa, -1, nArray2);
        if (n10 == 1) {
            CobolBigDecimal.oneWordDivide(nArray, nArray2[0], nArray3);
            if (bl) {
                bl2 = nArray[n8] * 2 >= nArray2[0];
            }
        } else {
            n5 = 100000000 / (nArray2[0] + 1);
            if (n5 > 1) {
                CobolBigDecimal.normalize(nArray2, n10, n5);
                CobolBigDecimal.normalize(nArray, n9, n5);
            }
            CobolBigDecimal.multiWordDivide(nArray, nArray2, nArray3);
            if (bl) {
                n4 = 0;
                n3 = 0;
                for (n2 = 0; n4 == 0 && n2 <= n9; n4 -= nArray[n9 + n2], ++n2) {
                    n4 = n3 + nArray2[n2] >> 1;
                    n3 = (nArray2[n2] & 1) != 0 ? 100000000 : 0;
                }
                boolean bl3 = bl2 = n4 < 0;
            }
            if (n5 > 1) {
                CobolBigDecimal.unnormalize(nArray, n8, n11, n5);
            }
        }
        n5 = this.exp - cobolBigDecimal.exp + n7;
        n4 = this.exp + n7 - n8 * 8;
        n3 = n8;
        if (bl2) {
            n2 = 1;
            for (int i = n8 - 1; i >= 0; --i) {
                int n12 = i;
                nArray3[n12] = nArray3[n12] + 1;
                if ((long)nArray3[n12] != 100000000L) {
                    n2 = 0;
                    break;
                }
                nArray3[i] = 0;
            }
            if (n2 != 0) {
                nArray3[0] = 1;
                n3 = 1;
                n5 += 8;
            }
        }
        return new DivResult(CobolBigDecimal.from(this.negative != cobolBigDecimal.negative, nArray3, 0, n3, n5), CobolBigDecimal.from(this.negative, nArray, n8, n11, n4));
    }

    private static void multiWordDivide(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i != nArray3.length; ++i) {
            long l;
            int n;
            long l2;
            long l3 = (long)nArray[i] * 100000000L + (long)nArray[i + 1];
            long l4 = l3 - l2 * (long)nArray2[0];
            for (l2 = l3 / (long)nArray2[0]; l2 >= 100000000L || l2 * (long)nArray2[1] > 100000000L * l4 + (long)nArray[i + 2]; --l2) {
                if ((l4 += (long)nArray2[0]) < 100000000L) continue;
            }
            l3 = 0L;
            for (n = nArray2.length; n > 0; --n) {
                long l5 = (long)nArray[n + i] + l3 - l2 * (long)nArray2[n - 1];
                l3 = l5 / 100000000L;
                l = l5 % 100000000L;
                if (l < 0L) {
                    l += 100000000L;
                    --l3;
                }
                nArray[n + i] = (int)l;
            }
            int n2 = i;
            nArray[n2] = (int)((long)nArray[n2] + l3);
            if (nArray[i] < 0) {
                --l2;
                int n3 = i;
                nArray[n3] = (int)((long)nArray[n3] + 100000000L);
                l3 = 0L;
                for (n = nArray2.length; n > 0; --n) {
                    l = (long)(nArray[i + n] + nArray2[n - 1]) + l3;
                    nArray[i + n] = (int)(l % 100000000L);
                    l3 = l / 100000000L;
                }
            }
            nArray3[i] = (int)l2;
        }
    }

    private static void oneWordDivide(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray[0];
        for (int i = 0; i < nArray2.length; ++i) {
            long l = (long)n2 * 100000000L + (long)nArray[i + 1];
            nArray2[i] = (int)(l / (long)n);
            n2 = (int)(l % (long)n);
        }
        nArray[nArray2.length] = n2;
    }

    private static void normalize(int[] nArray, int n, int n2) {
        long l = 0L;
        while (n > 0) {
            long l2 = (long)nArray[--n] * (long)n2 + l;
            nArray[n] = (int)(l2 % 100000000L);
            l = l2 / 100000000L;
        }
    }

    private static void unnormalize(int[] nArray, int n, int n2, int n3) {
        long l = 0L;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            long l2 = l * 100000000L + (long)nArray[i];
            nArray[i] = (int)(l2 / (long)n3);
            l = l2 % (long)n3;
        }
    }

    private static void convert(byte[] byArray, int n, int[] nArray) {
        int n2;
        int n3 = n2 = byArray.length;
        if (n > -1) {
            n3 += 8 - n;
        }
        n3 >>= 3;
        if (n > n2) {
            int n4 = 0;
            while (n4 < n2) {
                nArray[0] = nArray[0] * 10 + byArray[n4++];
            }
            nArray[0] = nArray[0] * WORD_ALIGNER[n - n4];
        } else {
            int n5 = 0;
            int n6 = 0;
            if (n > -1) {
                while (n5 < n) {
                    nArray[0] = nArray[0] * 10 + byArray[n5++];
                }
                n6 = 1;
            }
            while (n6 < n3) {
                nArray[n6++] = byArray[n5++] * 10000000 + byArray[n5++] * 1000000 + byArray[n5++] * 100000 + byArray[n5++] * 10000 + byArray[n5++] * 1000 + byArray[n5++] * 100 + byArray[n5++] * 10 + byArray[n5++];
            }
            if (n5 != n2) {
                int n7 = 8;
                while (n5 < n2) {
                    nArray[n6] = nArray[n6] * 10 + byArray[n5++];
                    --n7;
                }
                int n8 = n6;
                nArray[n8] = nArray[n8] * WORD_ALIGNER[n7];
            }
        }
    }

    public int compare(CobolBigDecimal cobolBigDecimal) {
        if (this.negative != cobolBigDecimal.negative) {
            return this.negative ? -1 : 1;
        }
        if (this.isZero()) {
            return cobolBigDecimal.isZero() ? 0 : -1;
        }
        if (cobolBigDecimal.isZero()) {
            return 1;
        }
        return this.negative ? -this.absCompare(cobolBigDecimal) : this.absCompare(cobolBigDecimal);
    }

    private int absCompare(CobolBigDecimal cobolBigDecimal) {
        if (this.exp != cobolBigDecimal.exp) {
            return this.exp - cobolBigDecimal.exp;
        }
        int n = Math.min(this.digits, cobolBigDecimal.digits);
        for (int i = 0; i < n; ++i) {
            int n2 = this.mantissa[i] - cobolBigDecimal.mantissa[i];
            if (n2 == 0) continue;
            return n2;
        }
        return this.digits - cobolBigDecimal.digits;
    }

    public static CobolBigDecimal from(boolean bl, byte[] byArray, int n) {
        int n2 = 0;
        int n3 = byArray.length;
        if (n3 > 38) {
            n2 = n3 - 38;
            n3 = 38;
        }
        return CobolBigDecimal.from(bl, byArray, n2, n3, n);
    }

    public static CobolBigDecimal from(boolean bl, byte[] byArray, int n, int n2, int n3) {
        int n4 = n + n2;
        while (n2 != 0 && (byArray[--n4] & 0xF) == 0) {
            ++n3;
            --n2;
        }
        if (n2 == 0) {
            return ZERO;
        }
        while ((byArray[n] & 0xF) == 0) {
            ++n;
            --n2;
        }
        byte[] byArray2 = new byte[n2];
        while (n2 != 0) {
            byArray2[--n2] = (byte)(byArray[n + n2] & 0xF);
        }
        return new CobolBigDecimal(bl, byArray2, n3 + byArray2.length);
    }

    public static CobolBigDecimal from(boolean bl, IMemory iMemory, int n, int n2, int n3) {
        int n4 = n + n2;
        while (n2 != 0 && (iMemory.get(--n4) & 0xF) == 0) {
            ++n3;
            --n2;
        }
        if (n2 == 0) {
            return ZERO;
        }
        while ((iMemory.get(n) & 0xF) == 0) {
            ++n;
            --n2;
        }
        byte[] byArray = new byte[n2];
        while (n2 != 0) {
            byArray[--n2] = (byte)(iMemory.get(n + n2) & 0xF);
        }
        return new CobolBigDecimal(bl, byArray, n3 + byArray.length);
    }

    public static CobolBigDecimal from(boolean bl, int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        for (n6 = n + n2; n6 > n && nArray[n6 - 1] == 0; --n6) {
        }
        if (n6 == n) {
            return ZERO;
        }
        int n7 = n;
        while (nArray[n7] == 0) {
            ++n7;
            n3 -= 8;
        }
        int n8 = (n6 - n7) * 8;
        byte[] byArray = new byte[n8];
        int n9 = 1;
        for (n5 = 7; n5 > 0; --n5) {
            if (nArray[n7] < WORD_ALIGNER[n5]) continue;
            n9 += n5;
            break;
        }
        n3 -= 8 - n9;
        n5 = nArray[n7];
        for (n4 = n9 - 1; n4 > 0; --n4) {
            byArray[n4] = (byte)(n5 % 10);
            n5 /= 10;
        }
        byArray[0] = (byte)n5;
        while (++n7 < n6) {
            n5 = nArray[n7];
            for (n4 = n9 + 8 - 1; n4 > n9; --n4) {
                byArray[n4] = (byte)(n5 % 10);
                n5 /= 10;
            }
            byArray[n9] = (byte)n5;
            n9 += 8;
        }
        if (n9 > 40) {
            n9 = 40;
        }
        while (byArray[n9 - 1] == 0) {
            --n9;
        }
        if (n9 != n8) {
            byte[] byArray2 = new byte[n9];
            System.arraycopy(byArray, 0, byArray2, 0, n9);
            byArray = byArray2;
        }
        return new CobolBigDecimal(bl, byArray, n3);
    }

    public static CobolBigDecimal from(int n, int n2) {
        byte by;
        boolean bl;
        if (n == 0) {
            return ZERO;
        }
        if (n == Integer.MIN_VALUE) {
            return CobolBigDecimal.from((long)n, n2);
        }
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        do {
            by = (byte)(n % 10);
            n /= 10;
            ++n2;
        } while (by == 0);
        byte[] byArray = new byte[10];
        byArray[9] = by;
        int n3 = 1;
        while (n != 0) {
            by = (byte)(n % 10);
            n /= 10;
            byArray[10 - ++n3] = by;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 10 - n3, byArray2, 0, n3);
        return new CobolBigDecimal(bl, byArray2, n2 - 1 + n3);
    }

    public static CobolBigDecimal from(long l, int n) {
        byte by;
        boolean bl;
        if (l == 0L) {
            return ZERO;
        }
        if (l > Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return CobolBigDecimal.from((int)l, n);
        }
        if (l == Long.MIN_VALUE) {
            return CobolBigDecimal.from(0L, l, true, n);
        }
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        do {
            by = (byte)(l % 10L);
            l /= 10L;
            ++n;
        } while (by == 0);
        byte[] byArray = new byte[20];
        byArray[19] = by;
        int n2 = 1;
        while (l != 0L) {
            by = (byte)(l % 10L);
            l /= 10L;
            byArray[20 - ++n2] = by;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 20 - n2, byArray2, 0, n2);
        return new CobolBigDecimal(bl, byArray2, n - 1 + n2);
    }

    public static CobolBigDecimal from(long l, long l2, boolean bl, int n) {
        if (l == 0L && l2 >= 0L) {
            return CobolBigDecimal.from(bl ? -l2 : l2, n);
        }
        long[] lArray = new long[]{l >>> 32, l & 0xFFFFFFFFL, l2 >>> 32, l2 & 0xFFFFFFFFL};
        byte[] byArray = new byte[40];
        int n2 = 0;
        long l3 = 0L;
        while (true) {
            if (lArray[n2] != 0L) {
                int n3;
                for (n3 = n2; n3 < lArray.length; ++n3) {
                    long l4 = lArray[n3] + (l3 << 32);
                    long l5 = l4 / 10L;
                    l3 = l4 % 10L;
                    lArray[n3] = l5;
                }
                ++n;
                if (l3 == 0L) continue;
                byArray[39] = (byte)l3;
                n3 = 1;
                while (true) {
                    if (n2 >= lArray.length || lArray[n2] != 0L) {
                        if (n2 == lArray.length) {
                            byte[] byArray2 = new byte[n3];
                            System.arraycopy(byArray, 40 - n3, byArray2, 0, n3);
                            return new CobolBigDecimal(bl, byArray2, n - 1 + n3);
                        }
                        ++n3;
                        l3 = 0L;
                        for (int i = n2; i < lArray.length; ++i) {
                            long l6 = lArray[i] + (l3 << 32);
                            long l7 = l6 / 10L;
                            l3 = l6 % 10L;
                            lArray[i] = l7;
                        }
                        byArray[40 - n3] = (byte)l3;
                        continue;
                    }
                    ++n2;
                }
            }
            ++n2;
        }
    }

    public int getInt(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = n != 0 && n2 + n < this.exp ? this.exp - (n2 + n) : 0;
        int n5 = this.exp - n2;
        int n6 = 0;
        if (n5 > this.digits) {
            n6 = n5 - this.digits;
            n5 = this.digits;
        }
        while (n4 < n5) {
            n3 = n3 * 10 + this.mantissa[n4++];
        }
        while (n6 != 0) {
            n3 *= 10;
            --n6;
        }
        return bl && this.negative ? -n3 : n3;
    }

    public long getLong(int n, int n2, boolean bl) {
        long l = 0L;
        int n3 = n != 0 && n2 + n < this.exp ? this.exp - (n2 + n) : 0;
        int n4 = this.exp - n2;
        int n5 = 0;
        if (n4 > this.digits) {
            n5 = n4 - this.digits;
            n4 = this.digits;
        }
        while (n3 < n4) {
            l = l * 10L + (long)this.mantissa[n3++];
        }
        while (n5 != 0) {
            l *= 10L;
            --n5;
        }
        return bl && this.negative ? -l : l;
    }

    public String toString() {
        return "CobolBigDecimal{negative=" + this.negative + ", mantissa=" + Arrays.toString(this.mantissa) + ", digits=" + this.digits + ", exp=" + this.exp + '}';
    }

    public class DivResult {
        private final CobolBigDecimal quotient;
        private final CobolBigDecimal remainder;

        public CobolBigDecimal getQuotient() {
            return this.quotient;
        }

        public CobolBigDecimal getRemainder() {
            return this.remainder;
        }

        public DivResult(CobolBigDecimal cobolBigDecimal2, CobolBigDecimal cobolBigDecimal3) {
            this.quotient = cobolBigDecimal2;
            this.remainder = cobolBigDecimal3;
        }

        public String toString() {
            return "quotient: " + this.quotient + ", remainder: " + this.remainder;
        }
    }
}

