/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.scope;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.scope.IDeclaration;
import com.veryant.cobol.rununit.Environment;

public abstract class AbstractDeclaration
implements IDeclaration {
    private final String name;
    private ISourceReference owner;
    private int referenceCount;

    @Override
    public boolean isUsed() {
        return this.referenceCount > 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInternalName() {
        return '$' + Environment.translateToValidJavaIdentifier(this.getName()) + '$' + Utils.intToHex(this.hashCode());
    }

    @Override
    public int getSourceLine() {
        return this.owner.getSourceLine();
    }

    @Override
    public int getSourceColumn() {
        return this.owner.getSourceColumn();
    }

    @Override
    public String getSourceFile() {
        return this.owner.getSourceFile();
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void markAsUsed() {
        ++this.referenceCount;
    }

    public AbstractDeclaration(ISourceReference iSourceReference, String string) {
        this.owner = iSourceReference;
        this.name = string;
    }
}

