/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Label;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.LocalReference;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.Mapper;
import com.veryant.cobol.compiler.stmts.Ztring;
import com.veryant.cobol.compiler.types.AbstractOperand;

public abstract class StringEmitter
extends BaseEmitter {
    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        Ztring ztring = (Ztring)iStatement;
        StringData stringData = new StringData(jvmCode, ztring);
        if (ztring.getPointer() != null) {
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, ztring.getPointer());
            Opcodes.DEC(jvmCode);
            Opcodes.CAST(jvmCode, VMType.INT32);
        } else {
            Opcodes.LOAD_CONST(jvmCode, 0);
        }
        Local local = Opcodes.STORE_LOCAL(jvmCode);
        Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Loading pointer");
        Opcodes.LOAD_CONST(jvmCode, 0);
        Local local2 = Opcodes.STORE_LOCAL(jvmCode);
        Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Loading search index");
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_CONST(jvmCode, 0);
        Opcodes.GE(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_LOCAL(jvmCode, stringData.into.length);
        Opcodes.LT(jvmCode);
        Opcodes.AND(jvmCode);
        Opcodes.IF(jvmCode);
        Label label = Opcodes.DECLARE_LABEL(jvmCode);
        for (StringDataSource stringDataSource : stringData.sources) {
            if (!stringDataSource.isDelimitedBySize()) {
                Opcodes.LOAD_CONST(jvmCode, 0);
                Opcodes.STORE_LOCAL(jvmCode, local2);
                Opcodes.LOAD_LOCAL(jvmCode, stringDataSource.source.length);
                Opcodes.LOAD_LOCAL(jvmCode, stringDataSource.delimiter.length);
                Opcodes.SUB(jvmCode);
                Local local3 = Opcodes.STORE_LOCAL(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, local2);
                Opcodes.LOAD_LOCAL(jvmCode, local3);
                Opcodes.LE(jvmCode);
                Opcodes.DO_WHILE(jvmCode);
                StringEmitter.emitCompareAlpha(jvmCode, stringDataSource.source, local2, stringDataSource.delimiter);
                Opcodes.IF(jvmCode);
                Opcodes.BREAK(jvmCode);
                Opcodes.FI(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, local2);
                Opcodes.INC(jvmCode);
                Opcodes.STORE_LOCAL(jvmCode, local2);
                Opcodes.DONE(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, local2);
                Opcodes.STORE_LOCAL(jvmCode, stringDataSource.source.length);
            } else {
                Opcodes.LOAD_LOCAL(jvmCode, stringDataSource.source.length);
                Opcodes.STORE_LOCAL(jvmCode, local2);
            }
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            Opcodes.ADD(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, stringData.into.length);
            Opcodes.GT(jvmCode);
            Opcodes.IF(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, stringData.into.length);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.SUB(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local2);
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            Opcodes.INC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, stringDataSource.source.length);
            Opcodes.FI(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            Opcodes.LOAD_CONST(jvmCode, 0);
            Opcodes.GT(jvmCode);
            Opcodes.IF(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, stringDataSource.source.memory);
            Opcodes.LOAD_LOCAL(jvmCode, stringDataSource.source.offset);
            Opcodes.LOAD_LOCAL(jvmCode, stringData.into.memory);
            Opcodes.LOAD_LOCAL(jvmCode, stringData.into.offset);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.ADD(jvmCode);
            Opcodes.CAST(jvmCode, VMType.INT32);
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            StringEmitter.emitMemoryCopy(jvmCode);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Store bytes");
            Opcodes.FI(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, stringDataSource.source.length);
            Opcodes.ADD(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, stringData.into.length);
            Opcodes.GT(jvmCode);
            Opcodes.IF(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, stringData.into.length);
            Opcodes.INC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local);
            if (ztring.getPointer() != null) {
                Opcodes.LOAD_LOCAL(jvmCode, local);
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, ztring.getPointer());
            }
            Opcodes.JUMP_TO_LABEL(jvmCode, label);
            Opcodes.FI(jvmCode);
        }
        if (ztring.getPointer() != null) {
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.INC(jvmCode);
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, ztring.getPointer());
        }
        Opcodes.PLACE_LABEL(jvmCode, label);
        Opcodes.FI(jvmCode);
        if (ztring.getOnOverflow() != null || ztring.getNotOnOverflow() != null) {
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_CONST(jvmCode, 0);
            Opcodes.LT(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, stringData.into.length);
            Opcodes.GT(jvmCode);
            Opcodes.OR(jvmCode);
            Opcodes.IF(jvmCode);
            if (ztring.getOnOverflow() != null) {
                Mapper.emit(jvmCode, ztring.getOnOverflow());
            }
            Opcodes.ELSE(jvmCode);
            if (ztring.getNotOnOverflow() != null) {
                Mapper.emit(jvmCode, ztring.getNotOnOverflow());
            }
            Opcodes.FI(jvmCode);
        }
    }

    private static class StringDataSource {
        protected final LocalReference source;
        protected final LocalReference delimiter;

        public boolean isDelimitedBySize() {
            return this.delimiter == null;
        }

        private StringDataSource(JvmCode jvmCode, Ztring.ZtringItem ztringItem) {
            this.source = BaseEmitter.emitStoreToLocalReference(jvmCode, ztringItem.operand);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Source");
            if (ztringItem.delimiter != null) {
                this.delimiter = BaseEmitter.emitStoreToLocalReference(jvmCode, ztringItem.delimiter);
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Delimiter");
            } else {
                this.delimiter = null;
            }
        }

        public static StringDataSource[] getItemArray(JvmCode jvmCode, Ztring ztring) {
            int n = ztring.getSourceItemCount();
            if (n == 0) {
                return null;
            }
            StringDataSource[] stringDataSourceArray = new StringDataSource[n];
            int n2 = 0;
            Ztring.ZtringItem ztringItem = ztring.getSourceItem();
            while (true) {
                stringDataSourceArray[n2] = new StringDataSource(jvmCode, ztringItem);
                if (ztringItem.getNextItem() == null) break;
                ztringItem = (Ztring.ZtringItem)ztringItem.getNextItem();
                ++n2;
            }
            return stringDataSourceArray;
        }
    }

    private static class StringData {
        protected final StringDataSource[] sources;
        protected final LocalReference into;
        protected final AbstractOperand pointer;

        private StringData(JvmCode jvmCode, Ztring ztring) {
            this.sources = StringDataSource.getItemArray(jvmCode, ztring);
            this.into = BaseEmitter.emitStoreToLocalReference(jvmCode, ztring.getInto());
            this.pointer = ztring.getPointer();
        }
    }
}

