/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;
import com.veryant.cobol.compiler.emitters.jvm.core.Functions;
import com.veryant.cobol.compiler.memory.IChunk;
import com.veryant.cobol.converters.Binary;
import com.veryant.cobol.data.CobolBigDecimal;

public abstract class NumericLiteral {
    static final BuiltInEmitter LOAD = (jvmCode, abstractOperand) -> {
        String string;
        Magnitude magnitude = abstractOperand.getMagnitude();
        VMType vMType = VMType.from(magnitude);
        if (vMType == VMType.INT8 || vMType == VMType.INT16) {
            vMType = VMType.INT32;
        } else if (vMType == VMType.FLOAT32) {
            vMType = VMType.FLOAT64;
        }
        CobolBigDecimal cobolBigDecimal = ((com.veryant.cobol.compiler.types.NumericLiteral)abstractOperand).getCobolBigDecimal();
        if (vMType == VMType.INT32) {
            string = Binary.toInt(cobolBigDecimal, 0, magnitude.getScale(), magnitude.isSigned()) + "";
        } else if (vMType == VMType.INT64) {
            string = Binary.toLong(cobolBigDecimal, 0, magnitude.getScale(), magnitude.isSigned()) + "L";
        } else if (vMType == VMType.INT128) {
            IChunk iChunk = abstractOperand.getChunk();
            string = "CobolBigDecimal.from(" + cobolBigDecimal.isNegative() + ',' + Functions.f_resolve_region_name(abstractOperand) + ',' + iChunk.getOffset() + ',' + iChunk.getSize() + ',' + magnitude.getScale() + ')';
        } else if (vMType == VMType.FLOAT64) {
            string = "0D";
        } else {
            throw Errors.e_types_system_fail();
        }
        jvmCode.push(abstractOperand, vMType, string, magnitude);
    };
}

