/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm;

import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.emitters.IOutputFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class JavaSourceFile
extends SimpleJavaFileObject
implements IOutputFile {
    private final String outputFolder;
    private final String content;
    private final boolean dumpCode;
    private final List<IOutputFile> resources = new ArrayList<IOutputFile>(5);

    private static URI createURI(String string, String string2, String string3) {
        File file;
        if (string2 != null) {
            string2 = string2.replace('.', Utils.SEPARATOR);
            file = new File(string, string2);
        } else {
            file = new File(string);
        }
        file.mkdirs();
        return new File(file, string3 + JavaFileObject.Kind.SOURCE.extension).getAbsoluteFile().toURI();
    }

    public JavaSourceFile(String string, String string2, String string3, String string4, String string5, boolean bl) {
        super(JavaSourceFile.createURI(string2.length() == 0 ? string : string2, string3, string4), JavaFileObject.Kind.SOURCE);
        this.outputFolder = string;
        this.content = string5;
        this.dumpCode = bl;
    }

    public void addResourceFile(IOutputFile iOutputFile) {
        this.resources.add(iOutputFile);
    }

    @Override
    public CharSequence getCharContent(boolean bl) {
        return this.content;
    }

    @Override
    public void save() throws IOException {
        for (IOutputFile object : this.resources) {
            object.save();
        }
        if (this.dumpCode) {
            Throwable throwable = null;
            try (PrintWriter printWriter = new PrintWriter(this.getName());){
                printWriter.append(this.content);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }
}

