/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm;

import com.veryant.cobol.compiler.ClassField;
import com.veryant.cobol.compiler.ClassFieldSet;
import com.veryant.cobol.compiler.Code;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.EntryPoint;
import com.veryant.cobol.compiler.ErrorProcedures;
import com.veryant.cobol.compiler.LinkageParam;
import com.veryant.cobol.compiler.Procedure;
import com.veryant.cobol.compiler.Section;
import com.veryant.cobol.compiler.Truncation;
import com.veryant.cobol.compiler.directives.TRUNC;
import com.veryant.cobol.compiler.emitters.jvm.BinaryFile;
import com.veryant.cobol.compiler.emitters.jvm.CodeConstants;
import com.veryant.cobol.compiler.emitters.jvm.JavaSourceFile;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Functions;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Templates;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseFileIOEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.Mapper;
import com.veryant.cobol.compiler.memory.Chunk;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.IChunk;
import com.veryant.cobol.compiler.memory.Region;
import com.veryant.cobol.compiler.scope.AbstractDeclaration;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.scope.NamedConditionDeclaration;
import com.veryant.cobol.compiler.stmts.Move;
import com.veryant.cobol.compiler.types.DataItemReference;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.Arrays;
import java.util.List;

public abstract class CobolProgramEmitter
extends BaseFileIOEmitter {
    private static void PACKAGE(JvmCode jvmCode, Collector collector) {
        if (collector.getPackageName() != null) {
            Opcodes.INJECT(jvmCode, "package " + collector.getPackageName() + ';');
        }
    }

    private static void HEADER(JvmCode jvmCode) {
        Opcodes.INJECT_COMMENT(jvmCode, "Veryant COBOL Compiler 2024.11.1 (generated on " + CodeConstants.TODAY + ")");
    }

    private static void IMPORTS(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "import com.veryant.cobol.annotations.*;");
        Opcodes.INJECT(jvmCode, "import com.veryant.cobol.rununit.*;");
        Opcodes.INJECT(jvmCode, "import com.veryant.cobol.converters.*;");
        Opcodes.INJECT(jvmCode, "import com.veryant.cobol.filehandler.*;");
        Opcodes.INJECT(jvmCode, "import com.veryant.cobol.exceptions.*;");
        Opcodes.INJECT(jvmCode, "import com.veryant.cobol.data.*;");
    }

    private static void ANNOTATIONS(JvmCode jvmCode, Collector collector) {
        Context context = collector.getContext();
        Opcodes.INJECT(jvmCode, "@CCSID(" + context.getCodepage().getCcsid() + ") ");
        Opcodes.INJECT(jvmCode, "@Encoding(\"" + context.getCodepage().getCharset().name() + "\") ");
        if (context.isNativeMemory()) {
            Opcodes.INJECT(jvmCode, "@MemoryModel(Model.Native) ");
        } else {
            Opcodes.INJECT(jvmCode, "@MemoryModel(Model.Managed) ");
        }
    }

    private static void CLASS(JvmCode jvmCode, Collector collector) {
        Opcodes.INJECT(jvmCode, "public class " + collector.getModuleName() + " implements ICallable {");
    }

    private static void FIELDS(JvmCode jvmCode, Collector collector) {
        Context context = collector.getContext();
        Opcodes.INJECT(jvmCode, "private static final java.nio.charset.Charset $CHARSET$ = java.nio.charset.Charset.forName(\"" + context.getCodepage().getCharset().name() + "\");");
        Opcodes.INJECT(jvmCode, "private static final byte $SPACE$ = (byte)" + context.getSpaceSymbol() + ";");
        Opcodes.INJECT(jvmCode, "private static final byte[] $GLYPH$ = {(byte)" + context.getDecimalSymbol() + ",(byte)" + context.getThousandsSymbol() + ",(byte)" + context.getCurrencySymbol() + "};");
        if (collector.getWorkingStorage().size() > 0) {
            Object object = "ManagedMemory";
            if (context.isNativeMemory()) {
                object = "NativeMemory";
            }
            Opcodes.INJECT(jvmCode, "private final IMemory " + Functions.f_resolve_region_name(Region.WORKING_STORAGE) + " = new " + (String)object + "(" + collector.getWorkingStorage().size() + ");");
        }
        for (LinkageParam linkageParam : collector.getLinkage()) {
            if (!linkageParam.isUsed()) continue;
            Opcodes.INJECT(jvmCode, "private CobolDataReference " + Functions.f_resolve_region_name(Region.LINKAGE) + linkageParam.getDataItemDeclaration().getRecordIndex() + ";");
        }
        Opcodes.INJECT(jvmCode, "private final RunUnitThread $RUT$ = Environment.init();");
        Opcodes.INJECT(jvmCode, "private boolean $INITIALIZED$;");
    }

    private static void GET_RUN_UNIT(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "@Override ");
        Opcodes.INJECT(jvmCode, "public RunUnitThread getRunUnitThread() { return $RUT$; }");
    }

    private static void LONG_JMP_MAP(JvmCode jvmCode) {
        int[] nArray = jvmCode.getLongJmps();
        if (nArray.length > 0) {
            Opcodes.INJECT(jvmCode, "protected ICobolProcedure[]$LJM$= new ICobolProcedure[]{");
            Opcodes.INJECT(jvmCode, "null");
            for (int n : nArray) {
                Opcodes.INJECT(jvmCode, ",this::$RANGE$" + n);
            }
            Opcodes.INJECT(jvmCode, "};");
            Opcodes.INJECT(jvmCode, "protected int $LJ$(int a, int b, CobolLocalData c) {");
            Opcodes.INJECT(jvmCode, "int i;");
            Opcodes.INJECT(jvmCode, "while ((i = a >>> 16) > 0 && i < 0xfffe) a=$LJM$[i].range(a & 0xffff, b, c);");
            Opcodes.INJECT(jvmCode, "return a;");
            Opcodes.INJECT(jvmCode, "}");
        }
    }

    private static void EXTFH(JvmCode jvmCode, Collector collector) {
        Opcodes.INJECT(jvmCode, "private EXTFH $INST$EXTFH = null;");
        for (FileDeclaration fileDeclaration : collector.getFiles(false)) {
            Opcodes.INJECT(jvmCode, "private boolean " + fileDeclaration.getOpenStatusName("file") + " = false;");
            Opcodes.INJECT(jvmCode, "private void " + fileDeclaration.getMethodName("file") + "(int opcode) {");
            Opcodes.INJECT(jvmCode, "if($INST$EXTFH==null){$INST$EXTFH=(EXTFH)Environment.load($RUT$,EXTFH.class);}");
            Object t = fileDeclaration.getFcdDataItem().getChunk();
            String string = Functions.f_resolve_region_name(t.getRegion());
            Opcodes.LOAD_CONST(jvmCode, 250);
            CobolProgramEmitter.emitSimpleStoreByte(jvmCode, t, 68);
            Local local = new Local(VMType.INT32, "opcode");
            Opcodes.LOAD_LOCAL(jvmCode, local);
            CobolProgramEmitter.emitSimpleStoreByte(jvmCode, t, 69);
            Opcodes.INJECT(jvmCode, "$INST$EXTFH.extfh(new CobolDataReference(" + string + "," + (t.getOffset() + 68) + ",2),new CobolDataReference(" + string + "," + t.getOffset() + "," + 216 + "));");
            if (fileDeclaration.getFileStatuses().length > 0) {
                Chunk chunk = fileDeclaration.getFileStatuses()[0].getChunk();
                CobolProgramEmitter.emitSimpleLoadUByte(jvmCode, t, 0);
                CobolProgramEmitter.emitSimpleStoreByte(jvmCode, chunk, 0);
                CobolProgramEmitter.emitSimpleLoadUByte(jvmCode, t, 1);
                CobolProgramEmitter.emitSimpleStoreByte(jvmCode, chunk, 1);
            }
            Opcodes.INJECT(jvmCode, "}");
        }
    }

    private static void INIT_METHOD(JvmCode jvmCode, Collector collector) {
        Opcodes.INJECT(jvmCode, "private void init(CobolLocalData $CLD$) {");
        if (collector.getWorkingStorage().size() > 0) {
            int n;
            Object object;
            Opcodes.INJECT(jvmCode, "if (!$INITIALIZED$) {");
            Opcodes.INJECT(jvmCode, "Raw.initMemory(" + Functions.f_resolve_region_name(Region.WORKING_STORAGE) + ", 0, " + collector.getWorkingStorage().size() + ", (byte) " + collector.getContext().getDEFAULTBYTE().getByteValue() + ");");
            for (FileDeclaration abstractDeclaration : collector.getFiles(false)) {
                IChunk iChunk;
                object = Functions.f_resolve_region_name(abstractDeclaration.getFcdLiteral().getRegion());
                String string = Functions.f_resolve_region_name(((DynamicChunk)abstractDeclaration.getFcdDataItem().getChunk()).getRegion());
                n = ((DynamicChunk)abstractDeclaration.getFcdDataItem().getChunk()).getOffset();
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Copying FCD from literals");
                Opcodes.INJECT(jvmCode, "Raw.copyMemory(" + (String)object + "," + abstractDeclaration.getFcdLiteral().getOffset() + "," + string + "," + n + "," + ((DynamicChunk)abstractDeclaration.getFcdDataItem().getChunk()).getSize() + ");");
                if (abstractDeclaration.getFileName() == null) continue;
                if (abstractDeclaration.getKeyBlockLiteral() != null) {
                    iChunk = abstractDeclaration.getKeyBlockLiteral();
                    Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Storing key definition address");
                    Opcodes.INJECT(jvmCode, "Comp5.store($RUT$.getRunUnit().getAddress(" + Functions.f_resolve_region_name(iChunk.getRegion()) + "," + iChunk.getOffset() + ")," + string + "," + (n + 184) + "," + 8 + ");");
                }
                iChunk = abstractDeclaration.getFileName().getChunk();
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Storing file name address");
                Opcodes.INJECT(jvmCode, "Comp5.store($RUT$.getRunUnit().getAddress(" + Functions.f_resolve_region_name(iChunk.getRegion()) + "," + iChunk.getOffset() + ")," + string + "," + (n + 168) + "," + 8 + ");");
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Storing file name length");
                Opcodes.INJECT(jvmCode, "CompX.store(" + iChunk.getSize() + "," + string + "," + (n + 54) + "," + 2 + ");");
                iChunk = abstractDeclaration.getRecords()[0].getChunk();
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Storing record address");
                Opcodes.INJECT(jvmCode, "Comp5.store($RUT$.getRunUnit().getAddress(" + Functions.f_resolve_region_name(iChunk.getRegion()) + "," + iChunk.getOffset() + ")," + string + "," + (n + 160) + "," + 8 + ");");
            }
            for (AbstractDeclaration abstractDeclaration : collector.getInitializationList()) {
                object = ((DataItemDeclaration)abstractDeclaration).getDataItem();
                int n2 = ((DataItem)object).getOccursRank();
                if (n2 > 0) {
                    if (!((DataItem)object).isOccurs()) {
                        object = ((DataItem)object).getParentOccurs();
                    }
                    for (n = n2 - 1; n >= 0; --n) {
                        Opcodes.INJECT(jvmCode, "for(int i" + n + "=0;i" + n + "<" + ((DataItem)object).getDeclaredTimes() + ";i" + n + "++){");
                        object = ((DataItem)object).getParentOccurs();
                    }
                }
                Mapper.emit(jvmCode, new Move(abstractDeclaration, ((DataItemDeclaration)abstractDeclaration).getValue(), new DataItemReference(abstractDeclaration, (DataItemDeclaration)abstractDeclaration, true, true)));
                for (n = 0; n < n2; ++n) {
                    Opcodes.INJECT(jvmCode, "}");
                }
            }
            Opcodes.INJECT(jvmCode, "}");
        }
        if (collector.getLocalStorage().size() > 0) {
            Opcodes.INJECT(jvmCode, "Raw.initMemory(" + Functions.f_resolve_region_name(Region.LOCAL_STORAGE) + ", 0, " + collector.getLocalStorage().size() + ", (byte) 0);");
        }
        Opcodes.INJECT(jvmCode, "}");
    }

    private static void CANCEL_METHOD(JvmCode jvmCode, Collector collector) {
        Opcodes.INJECT(jvmCode, "@Override ");
        Opcodes.INJECT(jvmCode, "public void cancel() {");
        Opcodes.INJECT(jvmCode, "if ($INITIALIZED$) {");
        for (FileDeclaration fileDeclaration : collector.getFiles(false)) {
            Object t = fileDeclaration.getFcdDataItem().getChunk();
            if (!fileDeclaration.getNeedsClose()) continue;
            Opcodes.INJECT(jvmCode, "if (" + Templates.T_MEM_GET_UNSIGNED_BYTE.format(Functions.f_resolve_region_name(t.getRegion()), 7) + " >= " + 128 + "){" + fileDeclaration.getMethodName("file") + "(" + 128 + ");}");
        }
        Opcodes.INJECT(jvmCode, "$INITIALIZED$ = false;}}");
    }

    private static void CONDITION_NAMES(JvmCode jvmCode, Collector collector) {
        NamedConditionDeclaration[] namedConditionDeclarationArray;
        for (NamedConditionDeclaration namedConditionDeclaration : namedConditionDeclarationArray = collector.getScope().getNamedConditions()) {
            if (!namedConditionDeclaration.isUsed()) continue;
            Opcodes.INJECT(jvmCode, "protected boolean " + namedConditionDeclaration.getInternalName() + '(');
            DataItemReference dataItemReference = namedConditionDeclaration.getSyntheticReference();
            DataItem dataItem = dataItemReference.getDataItem();
            int n = dataItem.getOccursRank();
            if (n > 0) {
                Opcodes.INJECT(jvmCode, "int i0");
                for (int i = 1; i < n; ++i) {
                    Opcodes.INJECT(jvmCode, ",int i" + i);
                }
            }
            Opcodes.INJECT(jvmCode, "){");
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, namedConditionDeclaration.getSyntheticCondition());
            Opcodes.INJECT(jvmCode, "return (" + jvmCode.pop() + ");");
            Opcodes.INJECT(jvmCode, "}");
        }
    }

    private static void CODE_SLICES(JvmCode jvmCode, Collector collector) {
        Code code = collector.getCode();
        int n = code.getProceduresCount();
        for (int i = 0; i < n; ++i) {
            Procedure procedure = code.getProcedure(i);
            if (!procedure.isReached() || code.getLinkedRanges()[procedure.getRange()].simpleProc() || procedure.isInline()) continue;
            Opcodes.INJECT(jvmCode, "private int $SLICE$" + i + "(CobolLocalData " + "$CLD$" + "){");
            Mapper.emit(jvmCode, procedure.getCode());
            if (!procedure.isStopFlow()) {
                Opcodes.INJECT(jvmCode, "return -1;");
            }
            Opcodes.INJECT(jvmCode, "}");
        }
    }

    private static void JMP_RANGES(JvmCode jvmCode, Collector collector) {
        Code code = collector.getCode();
        Code.LinkedRange[] linkedRangeArray = code.getLinkedRanges();
        for (int i = 0; i < linkedRangeArray.length; ++i) {
            Opcodes.INJECT(jvmCode, "private int $RANGE$" + i + "(int " + "$from$" + ",int " + "$to$" + ",CobolLocalData " + "$CLD$" + "){");
            if (linkedRangeArray[i].simpleProc()) {
                Procedure procedure = code.getProcedure(linkedRangeArray[i].getFrom());
                Mapper.emit(jvmCode, procedure.getCode());
                if (!procedure.isStopFlow()) {
                    Opcodes.INJECT(jvmCode, "return -1;");
                }
            } else {
                if (linkedRangeArray[i].isContainsShortJump() || linkedRangeArray[i].getOutboundCount() > 0) {
                    Opcodes.INJECT(jvmCode, "$RANGE$:");
                    Opcodes.INJECT(jvmCode, "while(true)");
                }
                boolean bl = false;
                Opcodes.INJECT(jvmCode, "switch($from$){");
                int n = linkedRangeArray[i].getFrom();
                int n2 = linkedRangeArray[i].getTo();
                for (int j = n; j <= n2; ++j) {
                    Procedure procedure = code.getProcedure(j);
                    if (bl || procedure.isLabelNeeded()) {
                        Opcodes.INJECT(jvmCode, "case " + j + ':');
                    }
                    bl = procedure.isStopFlow();
                    if (procedure.isInline()) {
                        jvmCode.setInlineMode(true);
                        Mapper.emit(jvmCode, procedure.getCode());
                        jvmCode.setInlineMode(false);
                    } else {
                        if (procedure.hasGoto() || jvmCode.isRetTfo() && !procedure.isLeafCode()) {
                            Opcodes.INJECT(jvmCode, "$from$=");
                        }
                        Opcodes.INJECT(jvmCode, "$SLICE$" + j + '(' + "$CLD$" + ");");
                        if (procedure.hasGoto() || jvmCode.isRetTfo() && !procedure.isLeafCode()) {
                            Opcodes.INJECT(jvmCode, "if ($from$!= -1){");
                            Opcodes.INJECT(jvmCode, "continue $RANGE$;");
                            Opcodes.INJECT(jvmCode, "}");
                        }
                    }
                    if (procedure.isStopFlow() || !procedure.isRetNeeded()) continue;
                    if (procedure.isSlideAllowed()) {
                        Opcodes.INJECT(jvmCode, "if($to$==" + j + "){");
                    }
                    Opcodes.INJECT(jvmCode, "return -1;");
                    if (!procedure.isSlideAllowed()) continue;
                    Opcodes.INJECT(jvmCode, "}");
                }
                Opcodes.INJECT(jvmCode, "default:");
                Opcodes.INJECT(jvmCode, "if ($from$>>> 16 == 0) throw new InvalidInstructionPointer();");
                Opcodes.INJECT(jvmCode, "return $from$;");
                Opcodes.INJECT(jvmCode, "}");
            }
            Opcodes.INJECT(jvmCode, "}");
        }
    }

    private static void ERROR_STUB(JvmCode jvmCode) {
        ErrorProcedures errorProcedures = jvmCode.getErrorProcedures();
        if (errorProcedures.isEmpty()) {
            return;
        }
        Opcodes.INJECT(jvmCode, "private boolean $IO_MODE_ERR$(int mode){");
        Opcodes.INJECT(jvmCode, "switch(mode){");
        for (int i = 0; i < 4; ++i) {
            Section section = errorProcedures.get(i);
            if (section == null) continue;
            Opcodes.INJECT(jvmCode, "case " + i + ':');
            Opcodes.JMP_RET_PROC(jvmCode, section.getStart(), section.getEnd());
            Opcodes.INJECT(jvmCode, "return true;");
        }
        Opcodes.INJECT(jvmCode, "}");
        Opcodes.INJECT(jvmCode, "return false;");
        Opcodes.INJECT(jvmCode, "}");
    }

    private static void ENTRYPOINTS(JvmCode jvmCode, Collector collector) {
        for (int i = 0; i < collector.getCode().getEntryPointsCount(); ++i) {
            EntryPoint entryPoint = collector.getCode().getEntryPoint(i);
            Opcodes.INJECT(jvmCode, "@Entrypoint(\"" + entryPoint.getName() + "\") ");
            Opcodes.INJECT(jvmCode, "public long $ENTRY$" + i + "(Object... params){");
            Opcodes.INJECT(jvmCode, "long ret = 0;");
            Opcodes.INJECT(jvmCode, "try {");
            Opcodes.INJECT(jvmCode, "Environment.enter($RUT$, this);");
            if (entryPoint.getEntryPointArguments() != null) {
                int n = 0;
                for (LinkageParam linkageParam : entryPoint.getEntryPointArguments().getArguments()) {
                    Opcodes.INJECT(jvmCode, Functions.f_resolve_region_name(Region.LINKAGE) + linkageParam.getDataItemDeclaration().getRecordIndex() + "=params[" + n++ + "];");
                }
            }
            Opcodes.INJECT(jvmCode, "final CobolLocalData $CLD$ = new CobolLocalData();");
            if (collector.getLocalStorage().size() > 0) {
                Opcodes.INJECT(jvmCode, Functions.f_resolve_region_name(Region.LOCAL_STORAGE) + " = Environment.allocStack(" + "$RUT$" + ',' + (collector.getContext().isNativeMemory() ? "NativeMemory.class" : "ManagedMemory.class") + ',' + collector.getLocalStorage().size() + ");");
            }
            Opcodes.INJECT(jvmCode, "init");
            Opcodes.INJECT(jvmCode, "($CLD$);");
            Opcodes.JMP_RET_PROC(jvmCode, entryPoint.getProcedureIndex(), 65535, true);
            Opcodes.INJECT(jvmCode, "ret = $RUT$.retrieveReturnCode();");
            Opcodes.INJECT(jvmCode, "} finally {");
            Opcodes.INJECT(jvmCode, "Environment.exit($RUT$, this);");
            Opcodes.INJECT(jvmCode, "}");
            Opcodes.INJECT(jvmCode, "return ret;");
            Opcodes.INJECT(jvmCode, "}");
        }
    }

    private static void MAIN(JvmCode jvmCode, Collector collector) {
        Opcodes.INJECT(jvmCode, "public static void main (String[] args) {");
        Opcodes.INJECT(jvmCode, "Environment.storeCommandLine(args);");
        Opcodes.INJECT(jvmCode, collector.getModuleName() + " instance = (" + collector.getModuleName() + ")Environment.load(" + collector.getModuleName() + ".class);");
        Opcodes.INJECT(jvmCode, "Environment.stop(instance.getRunUnitThread(), instance.$ENTRY$0());");
        Opcodes.INJECT(jvmCode, "}");
    }

    private static void LIT_TABLE(JvmCode jvmCode, Collector collector) {
        String string = Functions.f_resolve_region_name(Region.STATIC);
        byte[] byArray = collector.getContext().getLiterals().toByteArray();
        if (byArray.length > 0) {
            if (byArray.length <= collector.getContext().getLTSIZE().getSize()) {
                Opcodes.INJECT(jvmCode, "private static final IMemory " + string + " = new LocalMemory(new byte[]{" + byArray[0]);
                for (int i = 1; i < byArray.length; ++i) {
                    Opcodes.INJECT(jvmCode, "," + byArray[i]);
                }
                Opcodes.INJECT(jvmCode, "});");
            } else {
                Opcodes.INJECT(jvmCode, "private static final IMemory " + string + " = new LocalMemory(new byte[" + byArray.length + "]);");
                Opcodes.INJECT(jvmCode, "static{Raw.initMemory(" + collector.getModuleName() + ".class, " + string + ", \"" + "literals" + "\");}");
            }
        }
    }

    private static void PROMOTED_VARS(JvmCode jvmCode, Collector collector) {
        ClassFieldSet classFieldSet = collector.getFields();
        for (ClassField classField : classFieldSet.toArray()) {
            Opcodes.INJECT(jvmCode, "private " + VMType.from(classField.getMagnitude()).getClassName() + ' ' + classField.getName() + ';');
        }
    }

    private static void END(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, "}");
    }

    public static List<JavaSourceFile> emit(Collector collector) {
        Context context = collector.getContext();
        JvmCode jvmCode = new JvmCode();
        jvmCode.setNameGenerator(collector.getNameGenerator());
        jvmCode.setStaticData(context.getLiterals().toByteArray());
        jvmCode.setErrorProcedures(collector.getCode().getErrorProcedures());
        jvmCode.setJmps(collector.getCode().getJumpsMap());
        jvmCode.setLongJmps(collector.getCode().getLongJumpsMap());
        jvmCode.setRanges(collector.getCode().getLinkedRanges());
        jvmCode.setRetTfo(collector.getCode().hasGoback());
        TRUNC tRUNC = collector.getContext().getTRUNC();
        if (tRUNC.isNo()) {
            jvmCode.setTruncation(Truncation.NONE);
        } else {
            jvmCode.setTruncation(tRUNC.getDialect() == null ? Truncation.ENFORCED : Truncation.ANSI);
        }
        CobolProgramEmitter.PACKAGE(jvmCode, collector);
        CobolProgramEmitter.HEADER(jvmCode);
        CobolProgramEmitter.IMPORTS(jvmCode);
        CobolProgramEmitter.ANNOTATIONS(jvmCode, collector);
        CobolProgramEmitter.CLASS(jvmCode, collector);
        CobolProgramEmitter.FIELDS(jvmCode, collector);
        CobolProgramEmitter.GET_RUN_UNIT(jvmCode);
        CobolProgramEmitter.LONG_JMP_MAP(jvmCode);
        CobolProgramEmitter.EXTFH(jvmCode, collector);
        CobolProgramEmitter.INIT_METHOD(jvmCode, collector);
        CobolProgramEmitter.CANCEL_METHOD(jvmCode, collector);
        CobolProgramEmitter.CONDITION_NAMES(jvmCode, collector);
        CobolProgramEmitter.CODE_SLICES(jvmCode, collector);
        CobolProgramEmitter.JMP_RANGES(jvmCode, collector);
        CobolProgramEmitter.ERROR_STUB(jvmCode);
        CobolProgramEmitter.ENTRYPOINTS(jvmCode, collector);
        CobolProgramEmitter.MAIN(jvmCode, collector);
        CobolProgramEmitter.LIT_TABLE(jvmCode, collector);
        CobolProgramEmitter.PROMOTED_VARS(jvmCode, collector);
        CobolProgramEmitter.END(jvmCode);
        if (jvmCode.evaluationStackSize() > 0) {
            throw new COBOLCompilerException("Internal error, evaluation stack non-empty");
        }
        JavaSourceFile javaSourceFile = new JavaSourceFile(context.getILOUTPUT().getOutputPath(), context.getCODEDUMP().getPath(), collector.getPackageName(), collector.getModuleName(), jvmCode.toString(), false);
        if (jvmCode.getStaticData().length > collector.getContext().getLTSIZE().getSize()) {
            javaSourceFile.addResourceFile(new BinaryFile(collector.getContext().getILOUTPUT().getOutputPath(), collector.getPackageName(), collector.getModuleName() + '.' + "literals", jvmCode.getStaticData()));
        }
        return Arrays.asList(javaSourceFile);
    }
}

