/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.ast.AstCobolProgram;
import com.veryant.cobol.compiler.ast.AstLazyDataItemReference;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.common.AstAssign;
import com.veryant.cobol.compiler.ast.statements.AstSelectStatement;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.types.DataItemReference;

public class AstDataDivision
extends AstNode {
    public AstDataDivision(Collector collector) {
        super(collector);
    }

    @Override
    public void validate() {
        AstCobolProgram astCobolProgram = this.findParent(AstCobolProgram.class);
        for (AstLazyDataItemReference astNode : (AstLazyDataItemReference[])astCobolProgram.findAllChildren(AstLazyDataItemReference.class)) {
            AstAssign astAssign = astNode.findParent(AstAssign.class);
            if (astAssign != null) {
                AstSelectStatement astSelectStatement = astNode.findParent(AstSelectStatement.class);
                FileDeclaration fileDeclaration = astSelectStatement.getFile();
                boolean bl = astNode.createDataItemReference(false);
                if (bl) {
                    fileDeclaration.setFileName(astNode.getOperand());
                    continue;
                }
                DataItem dataItem = new DataItem(astNode.getToken().image, BuiltIn.ALPHA, null, 254);
                this.getCollector().getWorkingStorage().add(dataItem);
                DataItemDeclaration dataItemDeclaration = new DataItemDeclaration((ISourceReference)fileDeclaration, dataItem);
                this.getCollector().getScope().add(dataItemDeclaration);
                dataItemDeclaration.markAsUsed();
                fileDeclaration.setFileName(new DataItemReference(astNode.getToken(), dataItemDeclaration));
                continue;
            }
            astNode.createDataItemReference(true);
        }
        for (AstNode astNode : (AstSelectStatement[])astCobolProgram.findAllChildren(AstSelectStatement.class)) {
            ((AstSelectStatement)astNode).validateAfterDataDivision();
        }
    }

    @Override
    public String toString() {
        return "data-division";
    }
}

