/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.updater.server;

import com.iscobol.as.HttpServerIntf;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RtsUtil;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HttpServer
implements HttpServerIntf {
    private Logger log;
    private Properties serverProps;
    private String baseDir;
    private long serverPropsLastLoad;

    private static void sendResponse(HttpExchange httpExc, int responseCode, String responseBody) throws IOException {
        byte[] data = responseBody.getBytes();
        httpExc.sendResponseHeaders(responseCode, data.length);
        OutputStream out = httpExc.getResponseBody();
        out.write(data, 0, data.length);
        out.close();
    }

    @Override
    public void start(int serverPort, String baseDir) throws Exception {
        this.baseDir = baseDir;
        this.loadServerProps();
        com.sun.net.httpserver.HttpServer server = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(serverPort), 0);
        server.createContext("/", new FileDownloadHandler(this.baseDir));
        server.setExecutor(null);
        server.start();
        this.info("HttpServer listening on port " + serverPort + " ...");
    }

    private File getPropFileName() {
        String propFileName = "swupdater.properties";
        if (this.baseDir != null && this.baseDir.length() > 0) {
            propFileName = this.baseDir + "/" + propFileName;
        }
        return new File(propFileName);
    }

    private synchronized Properties getServerProps() {
        File propFileName = this.getPropFileName();
        if (propFileName.lastModified() > this.serverPropsLastLoad) {
            this.loadServerProps();
        }
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.serverProps);
        return p;
    }

    private void loadServerProps() {
        this.serverProps = new Properties();
        try {
            File propFileName = this.getPropFileName();
            RtsUtil.loadProperties(this.serverProps, propFileName);
            String zipfilepfx = "swupdater.zipfile.";
            Enumeration<?> e = this.serverProps.propertyNames();
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                if (!n.startsWith(zipfilepfx)) continue;
                this.serverProps.setProperty("swupdater.lib." + n.substring(zipfilepfx.length()), this.serverProps.getProperty(n));
                this.serverProps.remove(n);
            }
            this.serverPropsLastLoad = propFileName.lastModified();
        }
        catch (IOException ex) {
            this.error("error reading 'swupdater.properties' file");
        }
    }

    private void info(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
        System.out.println(msg);
    }

    private void error(String msg) {
        if (this.log != null) {
            this.log.warning(msg);
        }
        System.err.println(msg);
    }

    @Override
    public void setLogger(Logger log) {
        this.log = log;
    }

    public static void main(String[] args) throws Exception {
        int port = 10996;
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String baseDir = "";
        if (args.length > 1) {
            baseDir = args[1];
        }
        new HttpServer().start(port, baseDir);
    }

    private class FileDownloadHandler
    implements HttpHandler {
        private final String baseDir;

        FileDownloadHandler(String baseDir) {
            this.baseDir = baseDir;
        }

        void addZipEntry(File file, String path, ZipOutputStream zout, FilenameFilter filter) throws IOException {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files.length > 0) {
                    for (File f : file.listFiles()) {
                        this.addZipEntry(f, path + "/" + f.getName(), zout, filter);
                    }
                } else if (filter == null || filter.accept(null, path)) {
                    ZipEntry ze = new ZipEntry(path + "/");
                    zout.putNextEntry(ze);
                    zout.closeEntry();
                }
            } else if (filter == null || filter.accept(null, path)) {
                ZipEntry ze = new ZipEntry(path);
                zout.putNextEntry(ze);
                FileInputStream in = new FileInputStream(file);
                byte[] b = new byte[in.available()];
                in.read(b);
                in.close();
                zout.write(b);
                zout.closeEntry();
            }
        }

        @Override
        public void handle(final HttpExchange httpExc) throws IOException {
            new Thread(){

                @Override
                public void run() {
                    try {
                        FileDownloadHandler.this.handleRequest(httpExc);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRequest(HttpExchange httpExc) throws IOException {
            File file;
            String filename = httpExc.getRequestURI().getPath();
            if (filename == null || filename.isEmpty()) {
                HttpServer.sendResponse(httpExc, 400, "No file specified");
                HttpServer.this.error("No file specified");
                return;
            }
            if (filename.startsWith("/")) {
                filename = filename.substring(1);
            }
            Properties serverProps = HttpServer.this.getServerProps();
            String libraryName = null;
            if (!filename.equals("swupdater.properties")) {
                String tmp = filename;
                if ((filename = serverProps.getProperty(filename)) == null || filename.isEmpty()) {
                    HttpServer.sendResponse(httpExc, 404, "Not found: " + tmp + "");
                    HttpServer.this.error("Not found: " + tmp);
                    return;
                }
                libraryName = tmp.substring(tmp.lastIndexOf(46) + 1);
            }
            if (!(file = new File(filename)).isAbsolute() && this.baseDir != null && this.baseDir.length() > 0) {
                filename = this.baseDir + "/" + filename;
                file = new File(filename);
            }
            if (!file.exists()) {
                HttpServer.sendResponse(httpExc, 404, "Not found: " + filename + "");
                HttpServer.this.error("Not found: " + filename);
                return;
            }
            OutputStream out = httpExc.getResponseBody();
            if (file.isFile()) {
                if (file.getName().equals("swupdater.properties")) {
                    httpExc.sendResponseHeaders(200, 0L);
                    Properties props = new Properties();
                    Enumeration<?> e = serverProps.propertyNames();
                    while (e.hasMoreElements()) {
                        String n = (String)e.nextElement();
                        if (n.startsWith("swupdater.lib.")) {
                            props.setProperty(n, "");
                            continue;
                        }
                        props.setProperty(n, serverProps.getProperty(n));
                    }
                    props.store(out, null);
                } else {
                    FileInputStream in = null;
                    byte[] buffer = new byte[4096];
                    long rspLen = file.length();
                    httpExc.sendResponseHeaders(200, rspLen);
                    try {
                        in = new FileInputStream(file);
                    }
                    catch (IOException e) {
                        HttpServer.sendResponse(httpExc, 500, "Error reading file: " + filename + "");
                        HttpServer.this.error("Error reading file: " + filename);
                        return;
                    }
                    try {
                        int len;
                        while ((len = in.read(buffer)) != -1) {
                            out.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        HttpServer.sendResponse(httpExc, 500, "Error writing file: " + filename + "");
                        HttpServer.this.error("Error writing file: " + filename);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    out.close();
                }
                catch (IOException in) {}
            } else {
                httpExc.sendResponseHeaders(200, 0L);
                ZipOutputStream zout = null;
                try {
                    String itemsList;
                    zout = new ZipOutputStream(out);
                    FilenameFilter filter = null;
                    String excludeItemsList = serverProps.getProperty("swupdater.exclude_items_list." + libraryName);
                    final int exclValue = "0".equals(excludeItemsList) ? 0 : ("1".equals(excludeItemsList) ? 1 : -1);
                    if (exclValue >= 0 && (itemsList = serverProps.getProperty("swupdater.items_list." + libraryName)) != null) {
                        String[] ss = itemsList.split("\\,");
                        final String[] regex = new String[ss.length];
                        final boolean caseInsensitive = OSValidator.isWindows();
                        for (int i = 0; i < ss.length; ++i) {
                            String path = ss[i].trim();
                            if (caseInsensitive) {
                                path = path.toLowerCase();
                            }
                            StringBuilder sb = new StringBuilder();
                            StringBuilder sb0 = new StringBuilder();
                            block25: for (char c : path.toCharArray()) {
                                switch (c) {
                                    case '*': {
                                        if (sb0.length() > 0) {
                                            sb.append(Pattern.quote(sb0.toString()));
                                        }
                                        sb.append(".*");
                                        sb0 = new StringBuilder();
                                        continue block25;
                                    }
                                    default: {
                                        sb0.append(c);
                                    }
                                }
                            }
                            if (sb0.length() > 0) {
                                sb.append(Pattern.quote(sb0.toString()));
                            }
                            regex[i] = sb.toString();
                        }
                        filter = new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                if (caseInsensitive) {
                                    name = name.toLowerCase();
                                }
                                if (exclValue == 0) {
                                    for (String r : regex) {
                                        if (!name.matches(r)) continue;
                                        return true;
                                    }
                                    return false;
                                }
                                for (String r : regex) {
                                    if (!name.matches(r)) continue;
                                    return false;
                                }
                                return true;
                            }
                        };
                    }
                    for (File f : file.listFiles()) {
                        this.addZipEntry(f, f.getName(), zout, filter);
                    }
                    zout.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    HttpServer.sendResponse(httpExc, 500, "Error writing file: " + filename + "");
                    HttpServer.this.error("Error writing file: " + filename);
                }
                finally {
                    if (zout != null) {
                        try {
                            zout.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

