/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Config;
import com.iscobol.rts.Memory;
import com.iscobol.rts.Native;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.PicBinary;

public abstract class PicNativeBinary
extends PicBinary
implements Native {
    private boolean bigEndian = false;
    private static final long serialVersionUID = 123L;

    public PicNativeBinary(Memory mem, int offs, int pl, boolean s, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(mem, offs, pl, s, il, dl, dimSize, dim, name, pComma);
        this.bigEndian = !Config.getProperty("iscobol.little_endian", Config.LITTLE_ENDIAN);
    }

    public PicNativeBinary(CobolVar par, int offs, int pl, boolean s, int il, int dl, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, offs, pl, s, il, dl, dimSize, dim, name, pComma);
        this.bigEndian = !Config.getProperty("iscobol.little_endian", Config.LITTLE_ENDIAN);
    }

    public PicNativeBinary(long initValue, int pl, boolean s, int il, int dl, boolean pComma) {
        super(initValue, pl, s, il, dl, pComma);
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        this.internalSet(mem, cn.getUnscaledLong());
    }

    @Override
    void updateMemory(Memory mem) {
        this.internalSet(mem, this.num().getUnscaledLong());
    }

    protected void internalSet(Memory buf, long unscaled) {
        if (!this.signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        if (buf != null) {
            int i = 8 - this.len + 1;
            if (this.bigEndian) {
                int start = this.curOffset;
                while (start < this.end - 1) {
                    int r_shift = 64 - 8 * i;
                    buf.put(start, (byte)(unscaled >>> r_shift));
                    ++start;
                    ++i;
                }
                buf.put(start, (byte)unscaled);
            } else {
                int start = this.end - 1;
                while (start > this.curOffset) {
                    int r_shift = 64 - 8 * i;
                    buf.put(start, (byte)(unscaled >>> r_shift));
                    --start;
                    ++i;
                }
                buf.put(start, (byte)unscaled);
            }
        }
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        cn.set(this.getLongFromMem(mem), this.decLen);
    }

    @Override
    protected long getLongFromMem(Memory buf) {
        long unscaled;
        if (buf != null) {
            int i = 8 - this.len + 1;
            unscaled = 0L;
            if (this.bigEndian) {
                int start = this.curOffset;
                while (start < this.end - 1) {
                    int l_shift = 64 - 8 * i;
                    unscaled |= (long)(buf.get(start) & 0xFF) << l_shift;
                    ++start;
                    ++i;
                }
                unscaled |= (long)(buf.get(start) & 0xFF);
                if (this.len < 8 && this.signed) {
                    boolean negative;
                    boolean bl = negative = (buf.get(this.curOffset) >>> 7 & 1) == 1;
                    if (negative) {
                        unscaled -= this.u_max;
                    }
                }
            } else {
                int start = this.end - 1;
                while (start > this.curOffset) {
                    int l_shift = 64 - 8 * i;
                    unscaled |= (long)(buf.get(start) & 0xFF) << l_shift;
                    --start;
                    ++i;
                }
                unscaled |= (long)(buf.get(start) & 0xFF);
                if (this.len < 8 && this.signed) {
                    boolean negative;
                    boolean bl = negative = (buf.get(this.end - 1) >>> 7 & 1) == 1;
                    if (negative) {
                        unscaled -= this.u_max;
                    }
                }
            }
        } else {
            unscaled = this.value.getUnscaledLong();
        }
        if (!this.signed && unscaled < 0L) {
            unscaled = -unscaled;
        }
        return unscaled;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }
}

