/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;
import com.iscobol.types.CobolNum;
import com.iscobol.types.EncBytes;
import java.io.Serializable;

public class PictureAnalyzer
implements EncBytes,
Serializable {
    private static final long serialVersionUID = 123L;
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int CR = 2;
    public static final int DB = 3;
    public static final byte defaultCurrencySign = 36;
    public static final boolean storeValueWithoutEdit = Config.getProperty(".memory.alpha_edited", false);
    private final char[] picture;
    private final byte[] memoryMap;
    private final boolean isDecPointComma;
    public final char currencyChar;
    public final byte currencyByte;
    private int intLen;
    private int decLen;
    private boolean signed;
    private boolean pOnLeft;
    private long pDecFact = 1L;
    private CobolNum pNum;
    private int pNumCount;
    private int pNumPos;
    private int decimalPointPosition = -1;
    private boolean foundDigit;
    private boolean foundP;
    private boolean foundSign;
    private boolean signOnHead;
    private boolean foundNine;
    private boolean foundCurrencyChar;
    private int ccStart = -1;
    private int replacementPosition;
    private byte replacementChar;
    private int sign;
    private int signPosition = -1;
    private boolean blankWhenZero;

    public PictureAnalyzer(String pic, boolean decPointComma, char currChar) {
        byte[] cb;
        pic = PictureAnalyzer.expandParenthesis(pic);
        this.picture = pic.toCharArray();
        this.memoryMap = new byte[this.picture.length];
        this.isDecPointComma = decPointComma;
        this.currencyChar = currChar;
        this.currencyByte = this.currencyChar > '\u007f' ? ((cb = new String(new char[]{currChar}).getBytes()).length == 1 && cb[0] < 0 ? cb[0] : (byte)36) : (byte)this.currencyChar;
        this.analyzePicture();
    }

    public static String expandParenthesis(String pic) {
        StringBuffer Return2 = new StringBuffer();
        char[] chars = pic.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '(') {
                int idx = pic.indexOf(41, i);
                if (idx == -1) {
                    return pic;
                }
                int n = 0;
                try {
                    n = Integer.parseInt(pic.substring(i + 1, idx)) - 1;
                }
                catch (NumberFormatException e) {
                    return pic;
                }
                if (i > 0) {
                    for (int j = 0; j < n; ++j) {
                        Return2.append(chars[i - 1]);
                    }
                } else {
                    return pic;
                }
                i = idx;
                continue;
            }
            Return2.append(chars[i]);
        }
        return Return2.toString();
    }

    private void analyzePicture() {
        this.intLen = 0;
        this.decLen = 0;
        int lastDigitPos = 0;
        int len = this.picture.length;
        block20: for (int i = 0; i < len; ++i) {
            char c = this.picture[i];
            switch (c) {
                case '/': {
                    this.memoryMap[i] = C_SLASH;
                    continue block20;
                }
                case '0': {
                    this.memoryMap[i] = C_0;
                    continue block20;
                }
                case '&': {
                    this.memoryMap[i] = this.isDecPointComma ? C_COMMA : C_POINT;
                    if (this.decimalPointPosition != -1) continue block20;
                    this.decimalPointPosition = i;
                    continue block20;
                }
                case '^': {
                    if (this.isDecPointComma) {
                        this.memoryMap[i] = C_POINT;
                        continue block20;
                    }
                    this.memoryMap[i] = C_COMMA;
                    continue block20;
                }
                case '.': {
                    this.memoryMap[i] = C_POINT;
                    if (this.isDecPointComma || this.decimalPointPosition != -1) continue block20;
                    this.decimalPointPosition = i;
                    continue block20;
                }
                case ',': {
                    this.memoryMap[i] = C_COMMA;
                    if (!this.isDecPointComma || this.decimalPointPosition != -1) continue block20;
                    this.decimalPointPosition = i;
                    continue block20;
                }
                case 'V': {
                    if (!this.foundP) {
                        this.decimalPointPosition = i;
                    }
                    for (int j = i; j < len - 1; ++j) {
                        this.picture[j] = this.picture[j + 1];
                    }
                    --i;
                    --len;
                    continue block20;
                }
                case 'P': {
                    this.foundP = true;
                    this.decimalPointPosition = -1;
                    if (!this.foundDigit) {
                        this.pOnLeft = true;
                    }
                    this.pDecFact *= 10L;
                    ++this.pNumCount;
                    this.pNumPos = i;
                    continue block20;
                }
                case 'Z': {
                    if (!this.foundNine) {
                        this.replacementChar = C_SPACE;
                        this.replacementPosition = i + 1;
                    }
                    this.digit();
                    lastDigitPos = i;
                    continue block20;
                }
                case '*': {
                    if (!this.foundNine) {
                        this.replacementChar = C_STAR;
                        this.replacementPosition = i + 1;
                    }
                    this.digit();
                    lastDigitPos = i;
                    continue block20;
                }
                case '+': {
                    if (this.signed) {
                        if (this.checkSign(i)) continue block20;
                        lastDigitPos = i;
                        continue block20;
                    }
                    if (this.checkSign(0, i)) continue block20;
                    lastDigitPos = i;
                    continue block20;
                }
                case '-': {
                    if (this.signed) {
                        if (this.checkSign(i)) continue block20;
                        lastDigitPos = i;
                        continue block20;
                    }
                    if (this.checkSign(1, i)) continue block20;
                    lastDigitPos = i;
                    continue block20;
                }
                case 'C': {
                    continue block20;
                }
                case 'R': {
                    this.signed = true;
                    this.sign = 2;
                    continue block20;
                }
                case 'D': {
                    continue block20;
                }
                case 'B': {
                    if (i > 0 && this.picture[i - 1] == 'D') {
                        this.signed = true;
                        this.sign = 3;
                        continue block20;
                    }
                    this.memoryMap[i] = C_SPACE;
                    continue block20;
                }
                case '9': {
                    this.foundNine = true;
                    this.digit();
                    lastDigitPos = i;
                    continue block20;
                }
                case '#': {
                    c = this.currencyChar;
                }
                default: {
                    if (c != this.currencyChar) continue block20;
                    if (this.foundCurrencyChar) {
                        this.replacementPosition = i + 1;
                        this.replacementChar = C_SPACE;
                        this.digit();
                        lastDigitPos = i;
                    } else {
                        this.foundCurrencyChar = true;
                    }
                    this.ccStart = i;
                }
            }
        }
        if (this.replacementPosition == lastDigitPos + 1 && this.replacementChar != C_STAR) {
            this.blankWhenZero = true;
        }
        if (this.decimalPointPosition != -1 && this.decimalPointPosition < this.replacementPosition) {
            this.replacementPosition = this.decimalPointPosition;
        } else if (!(this.decimalPointPosition != -1 || this.foundP || this.foundSign || this.foundCurrencyChar || this.replacementPosition <= 0 || this.replacementChar == C_STAR)) {
            int end = this.memoryMap.length - 1;
            while (this.replacementPosition < end && this.memoryMap[this.replacementPosition] != 0) {
                ++this.replacementPosition;
            }
        }
        if (this.foundP) {
            this.pNum = CobolNum.noo(this.pDecFact, 0);
        }
    }

    private void digit() {
        if (!this.foundDigit) {
            this.foundDigit = true;
        }
        if (this.decimalPointPosition != -1) {
            ++this.decLen;
        } else {
            if (this.pOnLeft) {
                this.pDecFact *= 10L;
            }
            ++this.intLen;
        }
    }

    private boolean checkSign(int i) {
        boolean Return2 = false;
        if (this.foundSign) {
            if (this.replacementPosition == i - 1) {
                this.signOnHead = true;
            }
            this.replacementPosition = i + 1;
            this.replacementChar = C_SPACE;
            this.digit();
        } else {
            int idx;
            block3: for (idx = 0; idx < this.picture.length; ++idx) {
                switch (this.picture[idx]) {
                    case '/': 
                    case '0': 
                    case 'B': {
                        continue block3;
                    }
                }
            }
            if (i == idx) {
                this.signOnHead = true;
            }
            this.foundSign = true;
            Return2 = true;
        }
        this.signPosition = i;
        this.signed = true;
        return Return2;
    }

    private final boolean checkSign(int s, int i) {
        boolean Return2 = this.checkSign(i);
        this.sign = s;
        return Return2;
    }

    public final boolean getSigned() {
        return this.signed;
    }

    public final int getIntLen() {
        return this.intLen;
    }

    public final int getDecLen() {
        return this.decLen;
    }

    public final int getTotLen() {
        return this.intLen + this.decLen;
    }

    public final char getCurrencyChar() {
        return this.currencyChar;
    }

    public final int getCCStart() {
        return this.ccStart;
    }

    public final int length() {
        return this.memoryMap.length;
    }

    public final byte getByte(int i) {
        return this.memoryMap[i];
    }

    public final char getChar(int i) {
        return (char)this.memoryMap[i];
    }

    public final boolean getPOnLeft() {
        return this.pOnLeft;
    }

    public final boolean getFoundP() {
        return this.foundP;
    }

    public final boolean getFoundSign() {
        return this.foundSign;
    }

    public final boolean getSignOnHead() {
        return this.signOnHead;
    }

    public final boolean getFoundCurrencyChar() {
        return this.foundCurrencyChar;
    }

    public final int getDecimalPointPosition() {
        return this.decimalPointPosition;
    }

    public final int getReplacementPosition() {
        return this.replacementPosition;
    }

    public final byte getReplacementByte() {
        return this.replacementChar;
    }

    public final int getSign() {
        return this.sign;
    }

    public final int getSignPosition() {
        if (this.signPosition < this.pNumPos) {
            return this.signPosition;
        }
        return this.signPosition - this.pNumCount;
    }

    public final CobolNum getPNum() {
        return this.pNum;
    }

    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public boolean isStarWhenZero() {
        return this.replacementChar == C_STAR && !this.foundNine;
    }

    public char[] getPicture() {
        return this.picture;
    }

    public static void main(String[] argv) {
        PictureAnalyzer fmt = new PictureAnalyzer("Z9(4)", false, '$');
        System.out.println(fmt.picture);
    }
}

