/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Factory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;

public class PicShort
extends NumericVar {
    private static final long serialVersionUID = 123L;

    public PicShort(byte[] mem, int offs, int il, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(mem, offs, PicShort.bDigits(2, il, 0), 0, true, 2, dimSize, dim, name, pComma);
        if (mem != null) {
            this.updateCache(mem, this.theValue);
        }
    }

    public PicShort(CobolVar par, int offs, int il, int[] dimSize, int[] dim, String name, boolean pComma) {
        super(par, offs, PicShort.bDigits(2, il, 0), 0, true, 2, dimSize, dim, name, pComma);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[2] + 1;
    }

    @Override
    void updateMemory(byte[] mem, CobolNum cn) {
        this.internalSet(mem, cn.getUnscaledLong());
    }

    @Override
    void updateMemory(byte[] mem) {
        this.internalSet(mem, this.num().getUnscaledLong());
    }

    protected void internalSet(byte[] buf, long unscaled) {
        int start = this.curOffset;
        buf[start++] = (byte)(unscaled >>> 8);
        buf[start] = (byte)unscaled;
    }

    @Override
    void updateCache(byte[] mem, CobolNum cn) {
        cn.set(this.getLongFromMem(mem), this.decLen);
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        byte[] mem = this.getMemory();
        Factory.myFill(mem, this.curOffset, this.end, (byte)0);
    }

    protected long getLongFromMem(byte[] buf) {
        int start = this.curOffset;
        short unscaled = (short)((buf[start++] & 0xFF) << 8);
        unscaled = (short)(unscaled | (short)(buf[start] & 0xFF));
        return unscaled;
    }

    @Override
    public boolean set(long unscaled) {
        this.theValue.lnUnscValue = (short)unscaled;
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public boolean set(long unscaled, int scale, boolean rounded, boolean checkOverflow) {
        if (checkOverflow && CobolNum.isLongOverflowByte(unscaled, this.len, this.signed, scale - this.decLen)) {
            return true;
        }
        this.theValue.set((short)unscaled, scale);
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public boolean set(CobolNum d, boolean rounded, boolean checkOverflow) {
        if (checkOverflow && d.isOverflowByte(this.theValue, this.len, this.signed)) {
            return true;
        }
        this.theValue.set(d.shortValue(rounded), 0);
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public void addToMe(long i) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.addToMe((short)i);
        this.memory.setUnsync(this);
    }

    @Override
    public void subFromMe(long i) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.subFromMe((short)i);
        this.memory.setUnsync(this);
    }

    @Override
    public void multiplyByMe(long i) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.multiplyByMe((short)i);
        this.memory.setUnsync(this);
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, long i) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.divideIntoMe(checkdivbyzero, (short)i);
        this.memory.setUnsync(this);
    }
}

