/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVP18;
import java.math.BigDecimal;

public class CobolInt
extends CobolVP18 {
    public CobolInt(long unscaledVal) {
        super(unscaledVal, 0);
    }

    @Override
    public CobolNum set(long nLong, int nScale, boolean rounded) {
        this.lnUnscValue = CobolInt.computeUnscValue(nLong, nScale, 0, rounded, true);
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bd) {
        this.lnUnscValue = bd.unscaled18Digits(0);
        return this;
    }

    @Override
    public CobolNum set(double db) {
        this.lnUnscValue = (long)db;
        return this;
    }

    @Override
    public CobolNum set(CobolNum val, boolean rounded, boolean lenInBytes) {
        switch (val.type) {
            case 0: {
                return this.set(val.lnUnscValue, val.scale(), rounded);
            }
            case 3: {
                this.lnUnscValue = (long)val.floatValue();
                if (rounded) {
                    if (val.floatValue() > 0.0f) {
                        if ((double)(val.floatValue() - (float)this.lnUnscValue) >= 0.5) {
                            ++this.lnUnscValue;
                        }
                    } else if ((double)(val.floatValue() - (float)this.lnUnscValue) <= -0.5) {
                        --this.lnUnscValue;
                    }
                }
                return this;
            }
            case 2: {
                this.lnUnscValue = (long)val.doubleValue();
                if (rounded) {
                    if (val.doubleValue() > 0.0) {
                        if (val.doubleValue() - (double)this.lnUnscValue >= 0.5) {
                            ++this.lnUnscValue;
                        }
                    } else if (val.doubleValue() - (double)this.lnUnscValue <= -0.5) {
                        --this.lnUnscValue;
                    }
                }
                return this;
            }
            case 1: {
                this.lnUnscValue = lenInBytes ? (rounded ? val.bigCobDecValue().setScale(0, 1).longValue() : val.bigCobDecValue().longValue()) : (rounded ? val.bigCobDecValue().setScale(0, 1).unscaled18Digits(0) : val.bigCobDecValue().unscaled18Digits(0));
                return this;
            }
        }
        return this;
    }

    @Override
    public void divideIntoMeByZero(boolean checkdivbyzero) throws DivideByZeroException {
        int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
        switch (v) {
            default: {
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.lnUnscValue = 0L;
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.lnUnscValue = 0L;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public CobolNum add(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolInt.addLn(this.lnUnscValue, this.lnScale, val.lnUnscValue, val.scale());
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] + (double)val.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] + val.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue());
            }
        }
        return this;
    }

    @Override
    public void addToMe(short i) {
        this.lnUnscValue = (short)this.lnUnscValue + i;
    }

    @Override
    public void subFromMe(short i) {
        this.lnUnscValue = (short)this.lnUnscValue - i;
    }

    @Override
    public void multiplyByMe(short i) {
        this.lnUnscValue = (short)this.lnUnscValue * i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, short i) {
        if (i == 0) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.lnUnscValue = (short)this.lnUnscValue / i;
        }
    }

    @Override
    public void addToMe(int i) {
        this.lnUnscValue = (int)this.lnUnscValue + i;
    }

    @Override
    public void subFromMe(int i) {
        this.lnUnscValue = (int)this.lnUnscValue - i;
    }

    @Override
    public void multiplyByMe(int i) {
        this.lnUnscValue = (int)this.lnUnscValue * i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, int i) {
        if (i == 0) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.lnUnscValue = (int)this.lnUnscValue / i;
        }
    }

    @Override
    public void addToMe(long i) {
        this.lnUnscValue += i;
    }

    @Override
    public void subFromMe(long i) {
        this.lnUnscValue -= i;
    }

    @Override
    public void multiplyByMe(long i) {
        this.lnUnscValue *= i;
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, long i) {
        if (i == 0L) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.lnUnscValue /= i;
        }
    }

    @Override
    public CobolNum add1() {
        return CobolInt.addLn(this.lnUnscValue, this.lnScale, 1L, 0);
    }

    @Override
    public CobolNum subtract(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolInt.addLn(this.lnUnscValue, this.lnScale, -val.lnUnscValue, val.scale());
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] - (double)val.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] - val.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue().negate());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return CobolInt.addLn(this.lnUnscValue, this.lnScale, -1L, 0);
    }

    @Override
    public CobolNum multiply(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolInt.multiplyLn(this.lnUnscValue, this.lnScale, val.lnUnscValue, val.scale());
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] * (double)val.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] * val.doubleValue());
            }
            case 1: {
                return this.multiplyBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum divide(boolean checkdivbyzero, CobolNum val, int scale, boolean rounding) {
        switch (val.type) {
            case 0: {
                return CobolInt.divideLn(checkdivbyzero, this.lnUnscValue, this.lnScale, val.lnUnscValue, val.scale(), scale, rounding);
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] / (double)val.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] / val.doubleValue());
            }
            case 1: {
                return CobolInt.divideBd(checkdivbyzero, new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue(), scale, rounding);
            }
        }
        return null;
    }

    @Override
    public int compareTo(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolInt.compareLn(this.lnUnscValue, this.lnScale, val.lnUnscValue, val.scale());
            }
            case 1: 
            case 2: 
            case 3: {
                return this.compareBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue());
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long val, int scale) {
        return CobolInt.compareLn(this.lnUnscValue, this.lnScale, val, scale);
    }

    @Override
    public CobolNum max(CobolNum val) {
        switch (val.type) {
            case 0: {
                return CobolInt.compareLn(this.lnUnscValue, this.lnScale, val.lnUnscValue, val.scale()) < 0 ? val : this;
            }
            case 1: 
            case 2: 
            case 3: {
                return this.compareBd(new BigCobolDec(this.lnUnscValue, this.lnScale), val.bigCobDecValue()) < 0 ? val : this;
            }
        }
        return null;
    }

    @Override
    public long getUnscaledLong(boolean[] overflow) {
        overflow[0] = false;
        return this.lnUnscValue;
    }

    @Override
    public long getUnscaledLong() {
        return this.lnUnscValue;
    }

    @Override
    public void setSizeDigit(int intPart, int decPart) {
        this.lnUnscValue %= fact[intPart + decPart];
    }

    @Override
    public void setSizeByteUnsigned(int nBytes) {
        this.lnUnscValue &= factBytes[nBytes][0];
    }

    @Override
    public void setSizeByteSigned(int nBytes) {
        if ((this.lnUnscValue & factBytes[nBytes][3]) != 0L) {
            this.lnUnscValue &= factBytes[nBytes][1];
            this.lnUnscValue |= factBytes[nBytes][2];
        } else {
            this.lnUnscValue &= factBytes[nBytes][1];
        }
    }

    public void setScale(int scale, boolean rounding) {
        if (scale != 0) {
            throw new IscobolRuntimeException(3, "CobolInt scale != 0: " + scale);
        }
    }

    @Override
    public int scale() {
        return 0;
    }

    @Override
    public int precision() {
        return CobolInt.getNumDigits(this.lnUnscValue);
    }

    @Override
    public int signum() {
        if (this.lnUnscValue > 0L) {
            return 1;
        }
        if (this.lnUnscValue == 0L) {
            return 0;
        }
        return -1;
    }

    @Override
    public void negateMe() {
        this.lnUnscValue = -this.lnUnscValue;
    }

    @Override
    public CobolNum negate() {
        return CobolNum.noo(-this.lnUnscValue, this.lnScale);
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.lnUnscValue).toString();
    }

    @Override
    public double doubleValue() {
        return this.lnUnscValue;
    }

    @Override
    public float floatValue() {
        return this.lnUnscValue;
    }

    @Override
    public int shortValue() {
        return (short)this.lnUnscValue;
    }

    @Override
    public int intValue() {
        return (int)this.lnUnscValue;
    }

    @Override
    public long longValue() {
        return this.lnUnscValue;
    }

    @Override
    public final int shortValue(boolean rounding) {
        return (short)this.lnUnscValue;
    }

    @Override
    public final int intValue(boolean rounding) {
        return (int)this.lnUnscValue;
    }

    @Override
    public final long longValue(boolean rounding) {
        return this.lnUnscValue;
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        return BigCobolDec.valueOf(this.lnUnscValue, this.lnScale);
    }

    @Override
    public int toByteArray(byte[] Return2) {
        return CobolInt.toByteArray(this.lnUnscValue, this.lnScale, Return2);
    }

    @Override
    public boolean isOverflow(CobolNum dest, int destIntPart) {
        switch (dest.type) {
            case 0: {
                int tot = destIntPart + this.lnScale;
                if (tot > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[tot];
                }
                return this.lnUnscValue > factMax[tot];
            }
            case 1: {
                int tot = destIntPart + this.lnScale;
                if (tot > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[tot];
                }
                return this.lnUnscValue > factMax[tot];
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum dest, int nBytes, boolean signed) {
        switch (dest.type) {
            case 0: 
            case 1: {
                if (nBytes <= 8) {
                    if (this.lnUnscValue < 0L) {
                        if (signed) {
                            return this.lnUnscValue < -factBytes[nBytes][1];
                        }
                        return this.lnUnscValue < -factBytes[nBytes][0];
                    }
                    if (signed) {
                        return this.lnUnscValue > factBytes[nBytes][1];
                    }
                    return this.lnUnscValue > factBytes[nBytes][0];
                }
                return false;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.lnUnscValue, this.lnScale);
    }
}

