/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.GraphBrush;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetGraphBrush
extends PrintCommand {
    private Color color;
    private int style;
    private GraphBrush brush;

    public SetGraphBrush(GuiFactory gf, int style, Color color) {
        super(gf, 7);
        this.style = style;
        this.color = color == null ? new Color(0, 0, 0) : color;
        this.brush = new GraphBrush(style, color);
    }

    public SetGraphBrush(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 7);
        this.style = inOut.readInt();
        this.color = new Color(inOut.readInt(), true);
        this.brush = new GraphBrush(this.style, this.color);
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeInt(this.style);
        inOut.writeInt(this.color.getRGB());
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        pc.graphBrush = this.brush;
        return true;
    }
}

