/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParseGenerate
extends DefaultHandler
implements LexicalHandler {
    static final int START_OF_DOCUMENT = 0;
    static final int VERSION_INFORMATION = 1;
    static final int ENCODING_DECLARATION = 2;
    static final int STANDALONE_DECLARATION = 3;
    static final int DOCUMENT_TYPE_DECLARATION = 4;
    static final int COMMENT = 5;
    static final int START_OF_ELEMENT = 6;
    static final int ATTRIBUTE_NAME = 7;
    static final int ATTRIBUTE_CHARACTERS = 8;
    static final int ATTRIBUTE_CHARACTER = 9;
    static final int ATTRIBUTE_NATIONAL_CHARACTER = 10;
    static final int END_OF_ELEMENT = 11;
    static final int PROCESSING_INSTRUCTION_TARGET = 12;
    static final int PROCESSING_INSTRUCTION_DATA = 13;
    static final int CONTENT_CHARACTERS = 14;
    static final int CONTENT_CHARACTER = 15;
    static final int CONTENT_NATIONAL_CHARACTER = 16;
    static final int START_OF_CDATA_SECTION = 17;
    static final int END_OF_CDATA_SECTION = 18;
    static final int UNKNOWN_REFERENCE_IN_ATTRIBUTE = 19;
    static final int UNKNOWN_REFERENCE_IN_CONTENT = 20;
    static final int END_OF_DOCUMENT = 21;
    static final int EXCEPTION = 22;
    static final byte[][] events = new byte[][]{"START-OF-DOCUMENT             ".getBytes(), "VERSION-INFORMATION           ".getBytes(), "ENCODING-DECLARATION          ".getBytes(), "STANDALONE-DECLARATION        ".getBytes(), "DOCUMENT-TYPE-DECLARATION     ".getBytes(), "COMMENT                       ".getBytes(), "START-OF-ELEMENT              ".getBytes(), "ATTRIBUTE-NAME                ".getBytes(), "ATTRIBUTE-CHARACTERS          ".getBytes(), "ATTRIBUTE-CHARACTER           ".getBytes(), "ATTRIBUTE-NATIONAL-CHARACTER  ".getBytes(), "END-OF-ELEMENT                ".getBytes(), "PROCESSING-INSTRUCTION-TARGET ".getBytes(), "PROCESSING-INSTRUCTION-DATA   ".getBytes(), "CONTENT-CHARACTERS            ".getBytes(), "CONTENT-CHARACTER             ".getBytes(), "CONTENT-NATIONAL-CHARACTER    ".getBytes(), "START-OF-CDATA-SECTION        ".getBytes(), "END-OF-CDATA-SECTION          ".getBytes(), "UNKNOWN-REFERENCE-IN-ATTRIBUTE".getBytes(), "UNKNOWN-REFERENCE-IN-CONTENT  ".getBytes(), "END-OF-DOCUMENT               ".getBytes(), "EXCEPTION                     ".getBytes()};
    private final boolean versionOn = false;
    private final boolean standaloneOn = false;
    private final ICobolVar code;
    private final ICobolVar event;
    private final ICobolVar text;
    private final ICobolVar errmsg;
    private String source;
    private final SAXException stopParsing = new SAXException("");
    private SAXParser saxParser;
    private String version;
    private String encoding;
    private String standalone;

    public XMLParseGenerate(ICobolVar src, ICobolVar c, ICobolVar e, ICobolVar t, ICobolVar err) {
        this.source = src.toStringNoGui();
        this.code = c;
        this.event = e;
        this.text = t;
        this.errmsg = err;
    }

    public void parse() {
        SAXParserFactory factory = RtsUtil.newSAXParserFactory();
        try {
            this.saxParser = factory.newSAXParser();
            this.saxParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.saxParser.parse(new InputSource(new StringReader(this.source)), (DefaultHandler)this);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (ParserConfigurationException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            Exception e = _ex.getException();
            if (e == null) {
                e = _ex;
            }
            if (e instanceof SAXException) {
                throw new XMLException(e);
            }
            throw new IscobolRuntimeException(e);
        }
    }

    public abstract void processing();

    private void progProcess(int ercd) throws SAXException {
        this.code.set(ercd);
        this.processing();
        ercd = this.code.toint();
        if (ercd == -1) {
            throw this.stopParsing;
        }
    }

    private void setStandalone() {
        if (this.standalone == null) {
            try {
                this.standalone = this.saxParser.getXMLReader().getFeature("http://xml.org/sax/features/is-standalone") ? "yes" : "no";
            }
            catch (Throwable _ex) {
                this.standalone = "unknown";
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        Method m1;
        try {
            m1 = locator.getClass().getDeclaredMethod("getXMLVersion", null);
            this.version = m1.invoke((Object)locator, null).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            m1 = locator.getClass().getDeclaredMethod("getEncoding", null);
            this.encoding = m1.invoke((Object)locator, null).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.event.set(events[0]);
        this.text.set(this.source);
        this.progProcess(0);
        if (this.encoding != null) {
            this.event.set(events[2]);
            this.text.set(this.encoding);
            this.progProcess(0);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void endDocument() throws SAXException {
        this.text.set("");
        this.event.set(events[21]);
        this.progProcess(0);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        this.setStandalone();
        this.text.set(qName);
        this.event.set(events[6]);
        this.progProcess(0);
        int attrCount = attr.getLength();
        if (attrCount > 0) {
            for (int i = 0; i < attrCount; ++i) {
                this.text.set(attr.getQName(i));
                this.event.set(events[7]);
                this.progProcess(0);
                this.text.set(attr.getValue(i));
                this.event.set(events[8]);
                this.progProcess(0);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.text.set(qName);
        this.event.set(events[11]);
        this.progProcess(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i;
        for (i = 0; i < length && Character.isWhitespace(ch[i + start]); ++i) {
        }
        if (i == length) {
            return;
        }
        if (length == 2 && ch[start] >= '\ud800' && ch[start] <= '\udbff') {
            this.event.set(events[16]);
        } else if (length == 1 && (ch[start] == '&' || ch[start] == '\'' || ch[start] == '\"' || ch[start] == '<' || ch[start] == '>')) {
            this.event.set(events[15]);
        } else {
            this.event.set(events[14]);
        }
        this.text.set(new String(ch, start, length));
        this.progProcess(0);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.text.set(target);
        this.event.set(events[12]);
        this.progProcess(0);
        this.text.set(data);
        this.event.set(events[13]);
        this.progProcess(0);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.skippedEntity(name);
    }

    void procException(SAXParseException e, int ercd) throws SAXException {
        String eol = System.getProperty("line.separator", "\n");
        int el = eol.length();
        int line = e.getLineNumber();
        int col = e.getColumnNumber();
        int i = 0;
        for (int j = 1; j < line && (i = this.source.indexOf(eol, i)) >= 0; ++j) {
            i += el;
        }
        i += col;
        if (--i > 0) {
            if (i < this.source.length()) {
                this.text.set(this.source.substring(0, i));
            } else {
                this.text.set(this.source);
            }
        } else {
            this.text.set("");
        }
        this.errmsg.set("(" + line + ":" + col + ") " + e.getMessage());
        this.event.set(events[22]);
        this.progProcess(ercd);
        if (this.code.toint() != 0 && ercd < 100) {
            throw new SAXException(e);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.procException(e, 1);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.procException(e, 10);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.procException(e, 100);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.setStandalone();
        this.text.set(new String(ch, start, length));
        this.event.set(events[5]);
        this.progProcess(0);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.setStandalone();
        this.text.set("<![CDATA[");
        this.event.set(events[17]);
        this.progProcess(0);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.text.set("]]>");
        this.event.set(events[18]);
        this.progProcess(0);
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.setStandalone();
        if (publicId != null) {
            if (systemId != null) {
                this.text.set("<!DOCTYPE " + name + " PUBLIC \"" + publicId + "\" \"" + systemId + "\">'");
            } else {
                this.text.set("<!DOCTYPE " + name + " PUBLIC \"" + publicId + "\">'");
            }
        } else if (systemId != null) {
            this.text.set("<!DOCTYPE " + name + " SYSTEM \"" + systemId + "\">'");
        } else {
            this.text.set("<!DOCTYPE " + name + ">'");
        }
        this.event.set(events[4]);
        this.progProcess(0);
    }

    @Override
    public void endDTD() throws SAXException {
    }

    public static void generate(ICobolVar to, ICobolVar from, ICobolVar count) {
        XMLParseGenerate.generate(to, from, null, count, null);
    }

    public static void generate(ICobolVar to, ICobolVar from, int[] at, ICobolVar count) {
        XMLParseGenerate.generate(to, from, at, count, null);
    }

    public static void generate(ICobolVar to, ICobolVar from, int[] at, ICobolVar count, ICobolVar rCode) {
        StringBuffer output = new StringBuffer();
        XMLParseGenerate.scanElement(from, null, output, "", at);
        to.set(output.toString(), false);
        int lengthMax = to.length();
        int length = output.length();
        if (length > lengthMax) {
            length = lengthMax;
        }
        if (count != null) {
            count.set(length);
        }
        if (output.length() > to.length()) {
            if (rCode != null) {
                rCode.set(400);
            }
            throw new XMLException(new SAXException("Buffer overflow"));
        }
        if (rCode != null) {
            rCode.set(0);
        }
    }

    private static String myTrim(ICobolVar v) {
        String Return2 = v.toStringNoGui();
        for (int i = Return2.length() - 1; i >= 0; --i) {
            if (Return2.charAt(i) == ' ') continue;
            return Return2.substring(0, i + 1);
        }
        return " ";
    }

    private static void scanElement(ICobolVar var, int[] dim, StringBuffer out, String indent, int[] startDim) {
        int[] myDim = var.getDimensions();
        if (dim == null) {
            if (myDim == null) {
                XMLParseGenerate.writeElement(var, dim, out, indent, startDim);
            } else {
                int si;
                int n = si = startDim == null ? 0 : startDim.length;
                if (myDim.length > si) {
                    var.getLastDimension();
                    dim = new int[si + 1];
                    int i = 1;
                    while (i <= myDim[si]) {
                        dim[si] = i++;
                        XMLParseGenerate.scanElement(var, dim, out, indent, startDim);
                    }
                } else {
                    XMLParseGenerate.writeElement(var, startDim, out, indent, startDim);
                }
            }
        } else if (dim.length == myDim.length) {
            XMLParseGenerate.writeElement(var, dim, out, indent, startDim);
        } else {
            int i;
            int[] newDim = new int[myDim.length];
            for (i = 0; i < dim.length; ++i) {
                newDim[i] = dim[i];
            }
            dim = newDim;
            i = 1;
            while (i <= myDim[myDim.length - 1]) {
                dim[myDim.length - 1] = i++;
                XMLParseGenerate.scanElement(var, dim, out, indent, startDim);
            }
        }
    }

    private static void writeElement(ICobolVar var, int[] dim, StringBuffer out, String indent, int[] startDim) {
        String label;
        IXMLAttributes xmlattr = var.getIXMLAttributes();
        Enumeration chldrn = var.getChildren();
        if (xmlattr == null || (label = xmlattr.getIdentifier()) == null) {
            label = var.getName();
        }
        if ("FILLER".equals(label)) {
            return;
        }
        if (chldrn != null && chldrn.hasMoreElements()) {
            out.append(indent);
            out.append("<");
            out.append(label);
            out.append(">");
            chldrn = var.getChildren();
            while (chldrn.hasMoreElements()) {
                ICobolVar child = (ICobolVar)chldrn.nextElement();
                XMLParseGenerate.scanElement(child, dim, out, indent + "", startDim);
            }
            out.append(indent);
        } else {
            int i;
            String value = dim == null ? XMLParseGenerate.myTrim(var) : XMLParseGenerate.myTrim(var.intIAt(dim));
            int len = value.length();
            StringBuffer res = null;
            block8: for (i = 0; i < len; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '<': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&lt;");
                        continue block8;
                    }
                    case '&': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&amp;");
                        continue block8;
                    }
                    case '>': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&apos;");
                        continue block8;
                    }
                    default: {
                        if (c < ' ') break block8;
                        if (res == null) continue block8;
                        res.append(c);
                    }
                }
            }
            if (i < len) {
                res = new StringBuffer();
                label = "hex." + label;
                byte[] bval = var.getBytes();
                for (i = 0; i < bval.length; ++i) {
                    int h = bval[i] & 0xFF;
                    if (h < 16) {
                        res.append("0");
                    }
                    res.append(Integer.toHexString(h).toUpperCase());
                }
                value = res.toString();
            } else if (res != null) {
                value = res.toString();
            }
            out.append(indent);
            out.append("<");
            out.append(label);
            out.append(">");
            out.append(value);
        }
        out.append("</");
        out.append(label);
        out.append(">");
    }
}

