/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICoverageClassLoader;
import com.iscobol.rts.IDumpCreator;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolModule;
import com.iscobol.rts.IscobolStackTraceElement;
import com.iscobol.rts.SMAPReader;
import com.iscobol.rts.Unloaded;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class LayoutExceptionCobol {
    public static final String eol = System.getProperty("line.separator", "\n");
    private Throwable exc;
    private String javaName;
    private IscobolStackTraceElement[] stackTrace;
    private StackTraceElement[] javaTopTrace;
    private String msg;
    private final IDumpCreator dumpCreator;
    private boolean SMAPInfo;

    static boolean isNumber(String msg) {
        try {
            Double.parseDouble(msg);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public LayoutExceptionCobol(Throwable e) {
        this(e, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutExceptionCobol(Throwable e, IDumpCreator dc) {
        this.dumpCreator = dc;
        this.exc = e;
        this.msg = e.getLocalizedMessage();
        if (this.msg == null || this.msg.length() == 0 || LayoutExceptionCobol.isNumber(this.msg)) {
            this.msg = e.getClass().getName() + " caught! (" + this.msg + ")";
        }
        if (!Config.getProperty(".exception.java", false)) {
            HashMap<String, ClassAndSmap> classes = new HashMap<String, ClassAndSmap>();
            try {
                int i;
                StackTraceElement[] st = e.getStackTrace();
                Vector<IscobolStackTraceElement> cobSt = new Vector<IscobolStackTraceElement>();
                Vector<StackTraceElement> javaSt = new Vector<StackTraceElement>();
                boolean foundCobol = false;
                CallLoader ld = Factory.getLoader();
                for (i = 0; i < st.length; ++i) {
                    String mthd;
                    char mthd1chr;
                    String s = st[i].getClassName();
                    ClassAndSmap cas = (ClassAndSmap)classes.get(s);
                    if (cas == null) {
                        InputStream is;
                        block41: {
                            cas = new ClassAndSmap();
                            try {
                                if (ld != null) {
                                    int traceLevel = Config.getProperty(".tracelevel", 0);
                                    try {
                                        Config.setProperty(".tracelevel", "0");
                                        cas.clazz = ld.loadClass(s);
                                        break block41;
                                    }
                                    catch (ClassNotFoundException _ex) {
                                        cas.clazz = Class.forName(s);
                                        break block41;
                                    }
                                    finally {
                                        Config.setProperty(".tracelevel", Integer.toString(traceLevel));
                                    }
                                }
                                cas.clazz = Factory.classForName(s);
                            }
                            catch (NoClassDefFoundError _e) {
                                cas.clazz = Unloaded.class;
                            }
                        }
                        if (cas.clazz.getClassLoader() instanceof ICoverageClassLoader) {
                            byte[] b = ((ICoverageClassLoader)((Object)cas.clazz.getClassLoader())).getOriginalBytes(cas.clazz.getName());
                            is = b != null ? new ByteArrayInputStream(b) : null;
                        } else {
                            String res = cas.clazz.getName();
                            int j = res.lastIndexOf(46);
                            if (j >= 0) {
                                res = res.substring(j + 1, res.length());
                            }
                            if (IscobolModule.class.isAssignableFrom(cas.clazz) && (j = res.indexOf(36)) > 0) {
                                res = res.substring(0, j);
                            }
                            res = res + ".class";
                            is = cas.clazz.getResourceAsStream(res);
                        }
                        if (is != null) {
                            try {
                                cas.smap = new SMAPReader(is);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        classes.put(s, cas);
                    }
                    if (cas.smap != null && cas.smap.isOk()) {
                        SMAPReader.CobolInfo ci = cas.smap.getLineInfo(st[i].getLineNumber());
                        this.SMAPInfo = true;
                        foundCobol = true;
                        if (!IscobolCall.class.isAssignableFrom(cas.clazz) && !IscobolModule.class.isAssignableFrom(cas.clazz) || (mthd1chr = (mthd = st[i].getMethodName()).charAt(0)) != '_' && !Character.isUpperCase(mthd1chr)) continue;
                        cobSt.addElement(new IscobolStackTraceElement(st[i].getClassName(), st[i].getMethodName(), ci.fileName, ci.line, cas.clazz));
                        continue;
                    }
                    if (Unloaded.class == cas.clazz) {
                        foundCobol = true;
                        mthd = st[i].getMethodName();
                        cobSt.addElement(new IscobolStackTraceElement(st[i].getClassName(), mthd, null, 0, cas.clazz, s));
                        continue;
                    }
                    if (IscobolCall.class.isAssignableFrom(cas.clazz) || IscobolModule.class.isAssignableFrom(cas.clazz)) {
                        foundCobol = true;
                        mthd = st[i].getMethodName();
                        mthd1chr = mthd.charAt(0);
                        if (mthd1chr != '_' && !Character.isUpperCase(mthd1chr)) continue;
                        cobSt.addElement(new IscobolStackTraceElement(st[i].getClassName(), mthd, null, 0, cas.clazz));
                        continue;
                    }
                    if (foundCobol) continue;
                    javaSt.addElement(st[i]);
                }
                this.stackTrace = new IscobolStackTraceElement[cobSt.size()];
                for (i = 0; i < this.stackTrace.length; ++i) {
                    this.stackTrace[i] = (IscobolStackTraceElement)cobSt.elementAt(i);
                }
                this.javaTopTrace = new StackTraceElement[javaSt.size()];
                for (i = 0; i < this.javaTopTrace.length; ++i) {
                    this.javaTopTrace[i] = (StackTraceElement)javaSt.elementAt(i);
                }
                if (this.dumpCreator != null) {
                    this.dumpCreator.dump(this.stackTrace);
                }
            }
            catch (Throwable _ex) {
                System.out.println(_ex);
            }
        } else if (Config.getProperty(".exception.message", 0) == 3 || Config.getProperty(".exception_message", ".display_message", 0) == 3) {
            HashMap<String, Class> classes = new HashMap<String, Class>();
            try {
                StackTraceElement[] st = e.getStackTrace();
                CallLoader ld = Factory.getLoader();
                for (int i = 0; i < st.length; ++i) {
                    String mthd;
                    char mthd1chr;
                    String s = st[i].getClassName();
                    Class clazz = (Class)classes.get(s);
                    if (clazz == null) {
                        block43: {
                            try {
                                if (ld != null) {
                                    int traceLevel = Config.getProperty(".tracelevel", 0);
                                    try {
                                        Config.setProperty(".tracelevel", "0");
                                        clazz = ld.loadClass(s);
                                        break block43;
                                    }
                                    catch (ClassNotFoundException _ex) {
                                        clazz = Class.forName(s);
                                        break block43;
                                    }
                                    finally {
                                        Config.setProperty(".tracelevel", Integer.toString(traceLevel));
                                    }
                                }
                                clazz = Factory.classForName(s);
                            }
                            catch (NoClassDefFoundError _e) {
                                clazz = Unloaded.class;
                            }
                        }
                        classes.put(s, clazz);
                    }
                    if (!IscobolCall.class.isAssignableFrom(clazz) && !IscobolModule.class.isAssignableFrom(clazz) || (mthd1chr = (mthd = st[i].getMethodName()).charAt(0)) != '_' && !Character.isUpperCase(mthd1chr)) continue;
                    this.javaName = clazz.getName();
                    break;
                }
            }
            catch (Throwable _ex) {
                System.out.println(_ex);
            }
        }
    }

    public String getName() {
        if (this.stackTrace != null && this.stackTrace.length > 0) {
            return this.stackTrace[0].name;
        }
        if (this.javaName != null) {
            return this.javaName;
        }
        return "ads-dump";
    }

    public String getLocalizedMessage() {
        return this.msg;
    }

    public String toString(PrintWriter pw) {
        if (this.stackTrace == null) {
            return this.exc.toString();
        }
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.msg);
        if (this.stackTrace.length > 0) {
            Return2.append("  in ");
            Return2.append(this.stackTrace[0].toString());
        }
        return Return2.toString();
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.stackTrace == null) {
            if (pw != null) {
                this.exc.printStackTrace(pw);
            } else {
                this.exc.printStackTrace();
            }
        } else {
            String dumpInfo;
            int i;
            StringBuffer Return2 = new StringBuffer();
            Return2.append(this.msg);
            Return2.append(eol);
            if (this.stackTrace.length > 0) {
                Return2.append("  in ");
                Return2.append(this.stackTrace[0].toString());
                Return2.append(eol);
                for (i = 1; i < this.stackTrace.length; ++i) {
                    Return2.append("     ");
                    Return2.append(this.stackTrace[i].toString());
                    Return2.append(eol);
                }
            }
            if (this.javaTopTrace != null && this.javaTopTrace.length > 0) {
                Return2.append("(Top of stack)");
                Return2.append(eol);
                for (i = 0; i < this.javaTopTrace.length; ++i) {
                    Return2.append("   (");
                    Return2.append(this.javaTopTrace[i].toString());
                    Return2.append(")");
                    Return2.append(eol);
                }
            }
            if (this.dumpCreator != null && (dumpInfo = this.dumpCreator.getDumpInfo()) != null) {
                Return2.append(dumpInfo);
            }
            if (pw != null) {
                pw.print(Return2.toString());
            } else {
                System.err.print(Return2.toString());
            }
        }
    }

    public boolean hasSMAPInfo() {
        return this.SMAPInfo;
    }

    private static class ClassAndSmap {
        Class clazz;
        SMAPReader smap;

        private ClassAndSmap() {
        }
    }
}

