/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.HTTPClient;
import com.iscobol.rts.HTTPData;
import com.iscobol.rts.ICobolVar;
import com.sun.net.httpserver.Headers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;

public class HTTPClientHelper
implements HTTPClient.IHTTPClientHelper {
    private int connectTimeout = Integer.MAX_VALUE;
    private String user;
    private String password;
    private String proxyHost;
    private int proxyPort;
    private HTTPData.Params parameters;
    private int debugFlg = Config.getProperty("iscobol.tracelevel", -1);
    private static final String eol = System.getProperty("line.separator", "\n");
    private ArrayList headerProperties;
    private int responseCode;
    private HttpClient httpConn;
    private HttpRequest request;
    private HttpResponse<String> response;

    @Override
    public void test() {
        System.out.println("HTTPClientHelper.test");
    }

    @Override
    public void setConnectionTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setAuth(ICobolVar usr, ICobolVar pwd) {
        this.user = usr.toString();
        this.password = pwd == null ? null : pwd.toString();
    }

    @Override
    public void setProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    @Override
    public void setParameters(HTTPData.Params parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setHeaderProperties(ArrayList headerProperties) {
        this.headerProperties = headerProperties;
    }

    private synchronized void setConnection(String strUrl, String type, String content) throws MalformedURLException, IOException {
        try {
            String lcu = ((String)strUrl).toLowerCase();
            this.logString(null, "===============================");
            this.logString(null, "Connection requested at " + new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.ms").format(new Date()));
            this.logString(null, "Connecting to: " + lcu);
            if (lcu.startsWith("https://")) {
                String prop = Config.getProperty(".net.ssl.trust_store", null);
                if (prop != null && prop.length() > 0 && !"*".equals(prop)) {
                    System.setProperty("javax.net.ssl.trustStore", prop);
                    prop = Config.getProperty(".net.ssl.trust_store_password", null);
                    if (prop != null) {
                        System.setProperty("javax.net.ssl.trustStorePassword", prop);
                    }
                }
            } else if (!((String)strUrl).toLowerCase().startsWith("http://")) {
                strUrl = "http://" + (String)strUrl;
            }
            URL url = new URL((String)strUrl);
            ProxySelector proxy = this.proxyHost != null ? ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort)) : ProxySelector.getDefault();
            Headers headers = new Headers();
            if (type != null) {
                headers.add("Content-Type", type);
            }
            if (this.headerProperties != null) {
                int num = this.headerProperties.size();
                for (int i = 0; i < num; ++i) {
                    HTTPData.Pair cp = (HTTPData.Pair)this.headerProperties.get(i);
                    headers.add(cp.key, cp.value);
                }
            }
            HttpRequest.BodyPublisher payload = content != null ? HttpRequest.BodyPublishers.ofString(content) : HttpRequest.BodyPublishers.noBody();
            Authenticator authenticator = this.user != null ? new UsernamePasswordAuthenticator(this.user, this.password) : Authenticator.getDefault();
            Duration timeoutDuration = this.connectTimeout > 0 ? Duration.ofSeconds(this.connectTimeout) : Duration.ofSeconds(60L);
            this.httpConn = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
            try {
                this.request = HttpRequest.newBuilder().uri(URI.create(((String)strUrl).trim())).timeout(timeoutDuration).header("Content-Type", "application/json").method("PATCH", payload).build();
            }
            catch (Exception ex) {
                throw new MalformedURLException(ex.getMessage());
            }
        }
        catch (Exception ex) {
            this.logString(null, "An exception occurred opening connection:");
            this.logString(null, ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void doPatchEx(String strUrl, ICobolVar type, ICobolVar content, ICobolVar hasDummyRoot) throws IOException, InterruptedException {
        this.setConnection(strUrl, type != null ? type.toString() : null, content != null ? content.toString() : null);
        this.response = this.httpConn.send(this.request, HttpResponse.BodyHandlers.ofString());
    }

    @Override
    public int getResponseCode() {
        return this.response.statusCode();
    }

    @Override
    public byte[] getResponse() {
        return this.response.body().getBytes();
    }

    @Override
    public String getContentType() {
        return this.response.headers().firstValue("Content-Type").get();
    }

    private void logString(HttpClient connection, String string) {
        block7: {
            if (Config.getProperty("iscobol.httpclient.logging", false) && Config.getProperty("iscobol.httpclient.logfile", null) != null) {
                String logFileName = Config.getProperty("iscobol.httpclient.logfile", null);
                try {
                    File file = new File(logFileName);
                    if (!file.exists()) {
                        File parent = file.getParentFile();
                        if (parent != null && !parent.exists() && !parent.mkdirs()) {
                            parent.mkdirs();
                        }
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    FileWriter fw = new FileWriter(file, true);
                    BufferedWriter out = new BufferedWriter(fw);
                    out.write(string);
                    out.newLine();
                    out.close();
                }
                catch (IOException ex) {
                    if (this.debugFlg <= 10) break block7;
                    System.out.print(String.format("An error occurred creating HTTPClient logfile '%s'%sMessage: %s%s", logFileName, eol, ex.getMessage(), eol));
                }
            }
        }
    }

    public static class UsernamePasswordAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public UsernamePasswordAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String prompt = this.getRequestingPrompt();
            String hostname = this.getRequestingHost();
            InetAddress ipaddr = this.getRequestingSite();
            int port = this.getRequestingPort();
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

