/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.EsqlCursorHndl;
import com.iscobol.rts.EsqlRuntime;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.ObjectVar;
import com.iscobol.types.PicNativeDouble;
import com.iscobol.types.PicNativeFloat;
import com.iscobol.types.PicX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class EsqlHostVar {
    final Logger log = LoggerFactory.get(256);
    private static final String objNoColToGet = "columnNotEnought";
    public static final int HVT_UNKNOWN = 0;
    public static final int HVT_CSTRING = 1;
    public static final int HVT_SHORT = 2;
    public static final int HVT_LONG = 3;
    public static final int HVT_FLOAT = 4;
    public static final int HVT_DOUBLE = 5;
    public static final int HVT_CHARNUM = 6;
    public static final int HVT_COBALPHA = 7;
    public static final int HVT_PACKED = 8;
    public static final int HVT_BINARY = 9;
    public static final int TRIM_NONE = -1;
    public static final int TRIM_ALL = 0;
    public static final int TRIM_LEAVE1 = 1;
    public static final int TRIM_ALL2 = 2;
    public static final int MODE_IO_NONE = -1;
    public static final int MODE_IO_IN = 1;
    public static final int MODE_IO_OUT = 2;
    public static final int MODE_IO_INOUT = 3;
    public static SimpleDateFormat dateFormat;
    public static SimpleDateFormat timeFormat;
    public static DateTimeFormatter timestampFormat;
    public CobolVar hostVar;
    public int type;
    public int col;
    public short fSqlType;
    public NumericVar esqlInd;
    public boolean resultNull = false;
    public NumericVar esqlLen;
    public EsqlCursorHndl cursHndl;
    public int modeIO;
    private String name;
    private int specType;
    private short sqlType;
    static char[] HEX_ARRAY;

    public EsqlHostVar() {
    }

    public EsqlHostVar(CobolVar hostVar, int type, int col, NumericVar esqlInd, NumericVar esqlLen) {
        this(hostVar, type, col, esqlInd, esqlLen, null);
    }

    public EsqlHostVar(CobolVar hostVar, int type, int col, NumericVar esqlInd, NumericVar esqlLen, String modeIO) {
        this(hostVar, type, col, esqlInd, esqlLen, modeIO, -1);
    }

    public EsqlHostVar(CobolVar hostVar, int type, int col, NumericVar esqlInd, NumericVar esqlLen, String modeIO, short sqlType) {
        this.hostVar = hostVar;
        this.type = type;
        this.col = col;
        this.type = type;
        this.esqlInd = esqlInd;
        this.esqlLen = esqlLen;
        this.modeIO = modeIO == null ? -1 : ("IN".equals(modeIO) ? 1 : ("OUT".equals(modeIO) ? 2 : 3));
        this.fSqlType = hostVar instanceof PicNativeFloat ? (short)7 : (hostVar instanceof PicNativeDouble ? (short)8 : (hostVar instanceof ObjectVar ? (short)-4 : (hostVar instanceof NumericVar ? (short)2 : (short)1)));
        if (sqlType != -1) {
            this.fSqlType = sqlType;
        }
    }

    private boolean toVar(int col, ResultContainer rs, int typeIndTrunk) throws SQLException {
        int len = 0;
        byte[] varBytes = null;
        this.resultNull = false;
        if (this.hostVar instanceof PicNativeFloat) {
            ((PicNativeFloat)this.hostVar).set(rs.getFloat(col));
            len = 0;
        } else if (this.hostVar instanceof PicNativeDouble) {
            ((PicNativeDouble)this.hostVar).set(rs.getDouble(col));
            len = 0;
        } else if (this.hostVar instanceof ObjectVar) {
            Object obj = null;
            if (this.hostVar.getName().startsWith("@")) {
                try {
                    obj = rs.getClob(col);
                }
                catch (SQLException e) {
                    obj = rs.getObject(col);
                }
                ((ObjectVar)this.hostVar).setId(obj);
            } else {
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd != null) {
                    switch (rsmd.getColumnType(col)) {
                        case 2004: {
                            Blob blob = rs.getBlob(col);
                            len = (int)blob.length();
                            obj = blob.getBytes(1L, len);
                            break;
                        }
                        default: {
                            obj = rs.getObject(col);
                            break;
                        }
                    }
                } else {
                    obj = null;
                }
                if (obj != null) {
                    if (this.cursHndl != null) {
                        if (obj instanceof ResultSet) {
                            this.cursHndl.setRs((ResultSet)obj);
                        } else {
                            this.cursHndl.setRs(null);
                        }
                    } else {
                        ((ObjectVar)this.hostVar).setId(obj);
                    }
                    len = 0;
                } else {
                    len = -1;
                }
            }
        } else if (this.hostVar instanceof NumericVar) {
            Object obj = rs.getObject(col);
            if (obj != null) {
                if (obj instanceof BigDecimal) {
                    ((NumericVar)this.hostVar).set((BigDecimal)obj);
                } else {
                    ((NumericVar)this.hostVar).set(obj.toString());
                }
                len = 0;
            } else {
                ((NumericVar)this.hostVar).set(0);
                len = -1;
            }
        } else if (this.hostVar instanceof PicX && (this.hostVar.isSqlBinary() || EsqlRuntime.picXHandling == 1)) {
            byte[] b = rs.getBytes(col);
            this.hostVar.sqlSetBytes(b);
            if (this.esqlLen != null) {
                this.esqlLen.set(b.length);
            }
        } else {
            Object obj;
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                obj = rs.getDb2Object(col);
                if (obj == objNoColToGet) {
                    return true;
                }
            } else {
                obj = rs.getObject(col);
            }
            if (obj != null) {
                String str;
                if (timeFormat != null && obj instanceof Time) {
                    str = timeFormat.format(obj);
                } else if (timestampFormat != null && obj instanceof Timestamp) {
                    try {
                        str = timestampFormat.format(((Timestamp)obj).toLocalDateTime());
                    }
                    catch (Exception _ex) {
                        if (this.log != null) {
                            this.log.info("EsqlHostVar: Exception on TimeStamp formatting, TimeStamp converted to String " + this.hostVar.getName() + _ex);
                        }
                        str = obj.toString();
                    }
                } else if (dateFormat != null && obj instanceof Date) {
                    str = dateFormat.format(obj);
                } else if (obj instanceof Clob) {
                    str = ((Clob)obj).getSubString(1L, (int)((Clob)obj).length());
                } else if (obj instanceof Blob) {
                    str = new String(((Blob)obj).getBytes(1L, (int)((Blob)obj).length()));
                } else if (EsqlRuntime.db2DataRowAsByteThreshold > 0 && EsqlRuntime.picXHandling != 1) {
                    varBytes = rs.getDataAsBytes(col);
                    str = new String(varBytes);
                    if (this.log != null) {
                        try {
                            rs.getObject(col);
                        }
                        catch (Exception _ex) {
                            this.log.info("EsqlHostVar: Exception getObject on col " + col + " " + rs.getMetaData().getTableName(col) + "." + rs.getMetaData().getColumnName(col));
                        }
                    }
                } else if (EsqlRuntime.picXHandling == 2 && (rs.getMetaData().getColumnType(col) == -3 || rs.getMetaData().getColumnType(col) == -2)) {
                    varBytes = rs.getBytes(col);
                    str = new String(varBytes);
                } else if (EsqlRuntime.picXHandling == 1) {
                    varBytes = rs.getBytes(col);
                    str = new String(varBytes);
                } else {
                    str = obj.toString();
                }
                if (this.esqlLen != null) {
                    this.esqlLen.set(str.length());
                }
                if (varBytes != null) {
                    if (this.log != null) {
                        this.log.info("EsqlHostVar: before setBytes [" + EsqlHostVar.bytesToHex(varBytes) + "]");
                    }
                    this.hostVar.sqlSetBytes(varBytes);
                } else {
                    this.hostVar.set(str);
                }
                if (typeIndTrunk == 2) {
                    int strLen;
                    for (int i = strLen = str.length(); i > 0; --i) {
                        if (str.charAt(i - 1) == ' ') {
                            --strLen;
                            continue;
                        }
                        i = 0;
                    }
                    len = strLen > this.hostVar.getLength() ? strLen : 0;
                } else {
                    len = typeIndTrunk == 3 ? 0 : (str.length() > this.hostVar.getLength() ? str.length() : 0);
                }
            } else {
                if (this.esqlInd != null) {
                    this.hostVar.set("");
                }
                len = -1;
            }
        }
        if (this.esqlInd != null) {
            if (rs.wasNull(col)) {
                this.esqlInd.set(-1);
            } else {
                this.esqlInd.set(len);
            }
        } else if (rs.wasNull(col)) {
            this.resultNull = true;
        }
        return len > 0;
    }

    boolean toVar(int col, ResultSet rs) throws SQLException {
        return this.toVar(col, new ResultContainer(rs), 1);
    }

    boolean toVar(int col, CallableStatement cs, int typeIndTrunk) throws SQLException {
        if (this.modeIO != 1) {
            return this.toVar(col, new ResultContainer(cs), typeIndTrunk);
        }
        return false;
    }

    public static String rtrim(CobolVar v, int charToLeave, int trimType) {
        int i;
        char[] ca = v.toString().toCharArray();
        for (i = ca.length - 1; i >= charToLeave && !(trimType == 2 ? ca[i] > ' ' : ca[i] > ' ' || ca[i] == '\u0000'); --i) {
        }
        return new String(ca, 0, i + 1);
    }

    void fromVar(int col, PreparedStatement ps, int trimType) {
        block3: {
            if (this.modeIO != 2) {
                try {
                    this._fromVar(col, ps, trimType);
                }
                catch (SQLException _ex) {
                    if (this.log == null) break block3;
                    this.log.info("EsqlHostVar: exception setting parameter " + this.hostVar.getName() + _ex);
                }
            }
        }
    }

    private void _fromVar(int col, PreparedStatement ps, int trimType) throws SQLException {
        block59: {
            if (this.esqlInd.integer() < 0) {
                ps.setNull(col, this.fSqlType);
            } else if (this.hostVar instanceof PicNativeFloat) {
                ps.setFloat(col, ((PicNativeFloat)this.hostVar).tofloat());
            } else if (this.hostVar instanceof PicNativeDouble) {
                ps.setDouble(col, ((PicNativeDouble)this.hostVar).todouble());
            } else if (this.hostVar instanceof ObjectVar) {
                Object obj = ((ObjectVar)this.hostVar).getId();
                if (obj != null) {
                    if (this.hostVar.getName().startsWith("@")) {
                        try {
                            if (obj instanceof Clob) {
                                InputStream is = ((Clob)obj).getAsciiStream();
                                int available = is.available();
                                byte[] bs = new byte[available];
                                is.read(bs);
                                ps.setString(col, new String(bs));
                                break block59;
                            }
                            if (obj instanceof String) {
                                ps.setString(col, (String)obj);
                                break block59;
                            }
                            ps.setObject(col, obj);
                        }
                        catch (Exception is) {}
                    } else if (obj instanceof EsqlCursorHndl) {
                        this.cursHndl = (EsqlCursorHndl)obj;
                    } else if (obj instanceof byte[]) {
                        ps.setObject(col, (byte[])obj);
                    } else {
                        ps.setObject(col, obj);
                    }
                } else {
                    ps.setNull(col, this.fSqlType);
                }
            } else if (this.hostVar instanceof NumericVar) {
                if (((NumericVar)this.hostVar).scale() > 0 || ((NumericVar)this.hostVar).intLength() > 18) {
                    ps.setBigDecimal(col, ((NumericVar)this.hostVar).num().bigDecimalValue());
                } else {
                    ps.setLong(col, ((NumericVar)this.hostVar).num().longValue());
                }
            } else if (this.hostVar instanceof PicX && this.hostVar.isSqlBinary()) {
                int len = this.hostVar.length();
                if (this.esqlLen != null && this.esqlLen.toint() < len) {
                    len = this.esqlLen.toint();
                }
                ByteArrayInputStream bays = new ByteArrayInputStream(this.hostVar.getMemory(), this.hostVar.getOffset(), len);
                ps.setBinaryStream(col, (InputStream)bays, len);
            } else if (this.fSqlType == 2005 && this.modeIO != -1) {
                SerialClob clob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialClob(this.hostVar.toString().substring(0, this.esqlLen.toint()).toCharArray()) : new SerialClob(this.hostVar.toString().toCharArray());
                ps.setClob(col, clob);
            } else if (this.fSqlType == 2004 && this.modeIO != -1) {
                SerialBlob blob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialBlob(this.hostVar.toString().substring(0, this.esqlLen.toint()).getBytes()) : new SerialBlob(this.hostVar.toString().getBytes());
                ps.setBlob(col, blob);
            } else if (this.fSqlType == 1 && (this.modeIO != -1 || EsqlRuntime.picXHandling != 0)) {
                switch (trimType) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                                this.paramSetString(ps, col, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                                break;
                            }
                            if (EsqlRuntime.picXHandling == 1) {
                                ps.setBytes(col, this.hostVar.getMyMemory(this.esqlLen.toint()));
                                break;
                            }
                            ps.setString(col, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                            this.paramSetString(ps, col, this.hostVar.toString());
                            break;
                        }
                        if (EsqlRuntime.picXHandling == 1) {
                            ps.setBytes(col, this.hostVar.getMyMemory(this.hostVar.toString().length()));
                            break;
                        }
                        ps.setString(col, this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, trimType).length()) {
                            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                                this.paramSetString(ps, col, EsqlHostVar.rtrim(this.hostVar, 0, trimType).substring(0, this.esqlLen.toint()));
                                break;
                            }
                            if (EsqlRuntime.picXHandling == 1) {
                                ps.setBytes(col, this.hostVar.getMyMemory(EsqlHostVar.rtrim(this.hostVar, 0, trimType).substring(0, this.esqlLen.toint()).length()));
                                break;
                            }
                            ps.setString(col, EsqlHostVar.rtrim(this.hostVar, 0, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling != 1) {
                            this.paramSetString(ps, col, EsqlHostVar.rtrim(this.hostVar, 0, trimType));
                            break;
                        }
                        if (EsqlRuntime.picXHandling == 1) {
                            ps.setBytes(col, this.hostVar.getMyMemory(EsqlHostVar.rtrim(this.hostVar, 0, trimType).length()));
                            break;
                        }
                        ps.setString(col, EsqlHostVar.rtrim(this.hostVar, 0, trimType));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, trimType).length()) {
                            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                                this.paramSetString(ps, col, EsqlHostVar.rtrim(this.hostVar, 1, trimType).substring(0, this.esqlLen.toint()));
                                break;
                            }
                            if (EsqlRuntime.picXHandling == 1) {
                                ps.setBytes(col, this.hostVar.getMyMemory(EsqlHostVar.rtrim(this.hostVar, 1, trimType).substring(0, this.esqlLen.toint()).length()));
                                break;
                            }
                            ps.setString(col, EsqlHostVar.rtrim(this.hostVar, 1, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                            this.paramSetString(ps, col, EsqlHostVar.rtrim(this.hostVar, 1, trimType));
                            break;
                        }
                        if (EsqlRuntime.picXHandling == 1) {
                            ps.setBytes(col, this.hostVar.getMyMemory(EsqlHostVar.rtrim(this.hostVar, 1, trimType).length()));
                            break;
                        }
                        ps.setString(col, EsqlHostVar.rtrim(this.hostVar, 1, trimType));
                        break;
                    }
                }
            } else {
                switch (trimType) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            ps.setObject(col, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        ps.setObject(col, this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, trimType).length()) {
                            ps.setObject(col, EsqlHostVar.rtrim(this.hostVar, 0, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        ps.setObject(col, EsqlHostVar.rtrim(this.hostVar, 0, trimType));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, trimType).length()) {
                            ps.setObject(col, EsqlHostVar.rtrim(this.hostVar, 1, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        ps.setObject(col, EsqlHostVar.rtrim(this.hostVar, 1, trimType));
                    }
                }
            }
        }
    }

    CobolVar getVar() {
        return this.hostVar;
    }

    int getCol() {
        return this.col;
    }

    void regOutVar(int col, CallableStatement ps) {
        if (this.cursHndl == null) {
            this.regOutVar(col, ps, this.fSqlType);
        } else {
            this.regOutVar(col, ps, this.cursHndl.getCurSqlType());
        }
    }

    void regOutVar(int col, CallableStatement ps, int type) {
        if (this.modeIO != 1) {
            try {
                ps.registerOutParameter(col, type);
            }
            catch (SQLException _ex) {
                this.modeIO = 1;
            }
        }
    }

    boolean isResultNull() {
        return this.resultNull;
    }

    public void setHostVar(CobolVar hostVar, int type, int col, NumericVar esqlInd, NumericVar esqlLen, String modeIO) {
        this.setHostVar(hostVar, type, col, esqlInd, esqlLen, modeIO, (short)-1);
    }

    public void setHostVar(CobolVar hostVar, int type, int col, NumericVar esqlInd, NumericVar esqlLen, String modeIO, short sqlType) {
        this.hostVar = hostVar;
        this.type = type;
        this.sqlType = sqlType;
        this.col = col;
        this.type = type;
        this.esqlInd = esqlInd;
        this.esqlLen = esqlLen;
        this.modeIO = modeIO == null ? -1 : ("IN".equals(modeIO) ? 1 : ("OUT".equals(modeIO) ? 2 : 3));
        this.fSqlType = hostVar instanceof PicNativeFloat ? (short)7 : (hostVar instanceof PicNativeDouble ? (short)8 : (hostVar instanceof ObjectVar ? (short)-4 : (hostVar instanceof NumericVar ? (short)2 : (short)1)));
        if (sqlType != -1) {
            this.fSqlType = sqlType;
        }
    }

    public void updateVar(int col, ResultSet rs) throws SQLException {
        if (this.esqlInd.integer() < 0) {
            rs.updateNull(col);
        } else {
            int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
            if (this.hostVar instanceof PicNativeFloat) {
                rs.updateFloat(col, ((PicNativeFloat)this.hostVar).tofloat());
            } else if (this.hostVar instanceof PicNativeDouble) {
                rs.updateDouble(col, ((PicNativeDouble)this.hostVar).todouble());
            } else if (this.hostVar instanceof ObjectVar) {
                Object obj = ((ObjectVar)this.hostVar).getId();
                if (obj != null) {
                    if (obj instanceof EsqlCursorHndl) {
                        this.cursHndl = (EsqlCursorHndl)obj;
                    } else if (obj instanceof byte[]) {
                        rs.updateObject(col, (Object)((byte[])obj));
                    } else {
                        rs.updateObject(col, obj);
                    }
                } else {
                    rs.updateNull(col);
                }
            } else if (this.hostVar instanceof NumericVar) {
                rs.updateBigDecimal(col, ((NumericVar)this.hostVar).num().bigDecimalValue());
            } else if (this.hostVar instanceof PicX && this.hostVar.isSqlBinary()) {
                int len = this.hostVar.length();
                ByteArrayInputStream bays = new ByteArrayInputStream(this.hostVar.getMemory(), this.hostVar.getOffset(), len);
                rs.updateBinaryStream(col, (InputStream)bays, len);
            } else if (this.fSqlType == 2005 && this.modeIO != -1) {
                SerialClob clob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialClob(this.hostVar.toString().substring(0, this.esqlLen.toint()).toCharArray()) : new SerialClob(this.hostVar.toString().toCharArray());
                rs.updateClob(col, (Clob)clob);
            } else if (this.fSqlType == 2004 && this.modeIO != -1) {
                SerialBlob blob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialBlob(this.hostVar.toString().substring(0, this.esqlLen.toint()).getBytes()) : new SerialBlob(this.hostVar.toString().getBytes());
                rs.updateBlob(col, (Blob)blob);
            } else if (this.fSqlType == 1 && this.modeIO != -1) {
                switch (trimType) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            rs.updateString(col, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        rs.updateString(col, this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, trimType).length()) {
                            rs.updateString(col, EsqlHostVar.rtrim(this.hostVar, 0, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        rs.updateString(col, EsqlHostVar.rtrim(this.hostVar, 0, trimType));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, trimType).length()) {
                            rs.updateString(col, EsqlHostVar.rtrim(this.hostVar, 1, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        rs.updateString(col, EsqlHostVar.rtrim(this.hostVar, 1, trimType));
                        break;
                    }
                }
            } else {
                switch (trimType) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            rs.updateObject(col, (Object)this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        rs.updateObject(col, (Object)this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, trimType).length()) {
                            rs.updateObject(col, (Object)EsqlHostVar.rtrim(this.hostVar, 0, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        rs.updateObject(col, (Object)EsqlHostVar.rtrim(this.hostVar, 0, trimType));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, trimType).length()) {
                            rs.updateObject(col, (Object)EsqlHostVar.rtrim(this.hostVar, 1, trimType).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        rs.updateObject(col, (Object)EsqlHostVar.rtrim(this.hostVar, 1, trimType));
                    }
                }
            }
        }
    }

    public short getFSqlType() {
        return this.fSqlType;
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getName() {
        return this.name;
    }

    public void setSpecType(int typ) {
        this.specType = typ;
    }

    public int getSpecType() {
        return this.specType;
    }

    private void paramSetString(PreparedStatement ps, int col, String value) {
        block11: {
            try {
                int parLen;
                int plen;
                int type;
                block10: {
                    type = -1;
                    plen = this.hostVar.getLength();
                    parLen = -1;
                    try {
                        if (plen >= EsqlRuntime.db2DataRowAsByteThreshold || EsqlRuntime.picXHandling == 2) {
                            type = ps.getParameterMetaData().getParameterType(col);
                            parLen = ps.getParameterMetaData().getPrecision(col);
                        }
                    }
                    catch (Exception _ex) {
                        if (this.log == null) break block10;
                        this.log.info("EsqlHostVar: exception on getType parameter (paramSetString) " + this.hostVar.getName() + _ex);
                    }
                }
                if ((type == 12 || type == 1) && plen >= EsqlRuntime.db2DataRowAsByteThreshold && EsqlRuntime.db2DataRowAsByteThreshold > 0 || (type == -3 || type == -2) && EsqlRuntime.picXHandling == 2) {
                    int len = 0;
                    len = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? this.esqlLen.toint() : this.hostVar.toString().length();
                    if (this.log != null) {
                        this.log.info("EsqlHostVar: paramSetParameter " + this.hostVar.getName() + " len=" + plen + " setBytes " + ps.getParameterMetaData().getParameterType(col) + ", " + value.getBytes().length + ", " + value.getBytes());
                        this.log.info("EsqlHostVar: paramSetParameter value   [" + EsqlHostVar.bytesToHex(value.getBytes()) + "]");
                        this.log.info("EsqlHostVar: paramSetParameter hostVar [" + EsqlHostVar.bytesToHex(this.hostVar.getMyMemory(len)) + "]" + len);
                    }
                    if (parLen > 0 && parLen < len) {
                        ps.setBytes(col, this.hostVar.getMyMemory(parLen));
                    } else {
                        ps.setBytes(col, this.hostVar.getMyMemory(len));
                    }
                } else {
                    ps.setString(col, value);
                }
            }
            catch (Exception _ex) {
                if (this.log == null) break block11;
                this.log.info("EsqlHostVar: exception fromVar parameter (paramSetString) " + this.hostVar.getName() + _ex);
            }
        }
    }

    static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        try {
            dateFormat = new SimpleDateFormat(Config.getProperty(".jdbc.dateformat", null));
        }
        catch (NullPointerException e) {
            dateFormat = null;
        }
        catch (IllegalArgumentException e) {
            dateFormat = null;
        }
        try {
            timeFormat = new SimpleDateFormat(Config.getProperty(".jdbc.timeformat", null));
        }
        catch (NullPointerException e) {
            timeFormat = null;
        }
        catch (IllegalArgumentException e) {
            timeFormat = null;
        }
        try {
            timestampFormat = DateTimeFormatter.ofPattern(Config.getProperty(".jdbc.timestampformat", null));
        }
        catch (NullPointerException e) {
            timestampFormat = null;
        }
        catch (IllegalArgumentException e) {
            timestampFormat = null;
        }
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }

    public static class ResultContainer {
        private static final Logger log = LoggerFactory.get(256);
        private final ResultSet rs;
        private final CallableStatement cs;
        private static Method getDBRowDataAsBytes;
        private static Method getDBRowDescriptor;
        private static Method exec;
        static Class[] nullParamClass;
        static Object[] nullParam;
        private Object[] rowObj = null;
        private byte[] rowData = null;
        private int[] rowOffs = null;
        private int[] rowInfo = null;

        ResultContainer(CallableStatement c) {
            this.rs = null;
            this.cs = c;
        }

        ResultContainer(ResultSet r) {
            this.rs = r;
            this.cs = null;
        }

        boolean wasNull(int col) throws SQLException {
            return this.cs != null ? this.cs.wasNull() : this.intWasNull(col);
        }

        Object getObject(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getObject(colIndex) : this.rs.getObject(colIndex);
        }

        Object getDb2Object(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getObject(colIndex) : this.getIntObject(colIndex);
        }

        float getFloat(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getFloat(colIndex) : this.rs.getFloat(colIndex);
        }

        double getDouble(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getDouble(colIndex) : this.rs.getDouble(colIndex);
        }

        Blob getBlob(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getBlob(colIndex) : this.rs.getBlob(colIndex);
        }

        Clob getClob(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getClob(colIndex) : this.rs.getClob(colIndex);
        }

        ResultSetMetaData getMetaData() throws SQLException {
            return this.cs != null ? this.cs.getMetaData() : this.rs.getMetaData();
        }

        byte[] getBytes(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getBytes(colIndex) : this.rs.getBytes(colIndex);
        }

        byte[] getDataAsBytes(int colIndex) throws SQLException {
            return this.cs != null ? this.cs.getString(colIndex).getBytes() : this.doDb2Bytes(colIndex);
        }

        Object getIntObject(int colIndex) throws SQLException {
            Object Return2 = null;
            if (this.rs.getMetaData().getColumnCount() < colIndex) {
                return EsqlHostVar.objNoColToGet;
            }
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0) {
                int len;
                block6: {
                    if (EsqlRuntime.picXHandling == 1) {
                        return "";
                    }
                    try {
                        this.rowInfo = (int[])getDBRowDescriptor.invoke((Object)this.rs, nullParam);
                    }
                    catch (Exception _ex) {
                        if (log == null) break block6;
                        log.info("EsqlHostVar: exception invoke db2 " + _ex);
                    }
                }
                int colSqlType = this.rowInfo != null ? this.rowInfo[4 * (colIndex - 1) + 1] : 0;
                int n = len = this.rowInfo != null ? this.rowInfo[4 * (colIndex - 1) + 3] : 0;
                Return2 = len >= EsqlRuntime.db2DataRowAsByteThreshold && (colSqlType == 448 || colSqlType == 452 || colSqlType == 453 || colSqlType == 449) ? "" : this.rs.getObject(colIndex);
            } else {
                Return2 = EsqlRuntime.picXHandling == 2 && (this.rs.getMetaData().getColumnType(colIndex) == -3 || this.rs.getMetaData().getColumnType(colIndex) == -2) ? "" : this.rs.getObject(colIndex);
            }
            return Return2;
        }

        boolean intWasNull(int colIndex) throws SQLException {
            int colSqlType;
            boolean Return2 = false;
            Return2 = EsqlRuntime.db2DataRowAsByteThreshold > 0 && this.rowInfo != null && this.rowData != null && this.rowInfo[4 * (colIndex - 1) + 3] >= EsqlRuntime.db2DataRowAsByteThreshold ? ((colSqlType = this.rowInfo[4 * (colIndex - 1) + 1]) == 448 || colSqlType == 452 || colSqlType == 453 || colSqlType == 449 ? this.rowData[this.rowOffs[colIndex - 1]] != 0 || this.rowData[this.rowOffs[colIndex - 1] + 1] != 0 : this.rs.wasNull()) : this.rs.wasNull();
            return Return2;
        }

        byte[] doDb2Bytes(int colIndex) throws SQLException {
            byte[] Return2 = null;
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0) {
                int colSqlType = this.rowInfo[4 * (colIndex - 1) + 1];
                if (colSqlType == 448 || colSqlType == 452 || colSqlType == 453 || colSqlType == 449) {
                    block11: {
                        try {
                            this.rowObj = (Object[])getDBRowDataAsBytes.invoke((Object)this.rs, nullParam);
                            this.rowData = (byte[])this.rowObj[0];
                            this.rowOffs = (int[])this.rowObj[1];
                        }
                        catch (Exception _ex) {
                            if (log == null) break block11;
                            log.info("EsqlHostVar: exception invoke db2 " + _ex);
                        }
                    }
                    byte[] num = new byte[2];
                    int len = 0;
                    int offs = this.rowOffs[colIndex - 1] + 2;
                    if (colSqlType == 448 || colSqlType == 449) {
                        System.arraycopy(this.rowData, this.rowOffs[colIndex - 1] + 2, num, 0, 2);
                        len = num[0] << 8 & 0xFF00 | num[1] << 0 & 0xFF;
                        offs += 2;
                    } else {
                        len = this.rowInfo[4 * (colIndex - 1) + 3];
                    }
                    Return2 = new byte[len];
                    if (log != null) {
                        log.info("EsqlHostVar: doDb2Bytes rowData[" + EsqlHostVar.bytesToHex(this.rowData) + ", " + this.rowData.length + "]" + this.rowOffs[colIndex - 1] + ", " + this.rowInfo[4 * (colIndex - 1) + 3] + ", " + len);
                    }
                    if (this.rowData[this.rowOffs[colIndex - 1]] == 0 && this.rowData[this.rowOffs[colIndex - 1] + 1] == 0) {
                        System.arraycopy(this.rowData, offs, Return2, 0, Return2.length);
                    }
                    if (log != null) {
                        log.info("EsqlHostVar: doDb2Bytes Return[" + EsqlHostVar.bytesToHex(Return2) + "]");
                    }
                } else {
                    Return2 = this.rs.getString(colIndex).getBytes();
                }
            } else {
                Return2 = this.rs.getMetaData().getColumnType(colIndex) == -3 || this.rs.getMetaData().getColumnType(colIndex) == -2 ? this.rs.getBytes(colIndex) : this.rs.getString(colIndex).getBytes();
            }
            return Return2;
        }

        static {
            nullParamClass = new Class[0];
            nullParam = new Object[0];
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0) {
                try {
                    Class<?> Db2Class = Class.forName("com.ibm.db2.jcc.DB2ResultSet");
                    getDBRowDataAsBytes = Db2Class.getMethod("getDBRowDataAsBytes", nullParamClass);
                    getDBRowDescriptor = Db2Class.getMethod("getDBRowDescriptor", nullParamClass);
                }
                catch (Exception e) {
                    throw new IscobolRuntimeException(e);
                }
            }
        }
    }
}

