/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.IEsqlCursor;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.ThreadLocalStorageProvider;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;

public class CallManager {
    private Hashtable<String, CallObj> ht = new Hashtable();
    private LinkedHashMap<String, CallObj> ht_rs;
    private HashMap threadLocalStorages = new HashMap();

    public void registerResultSets() {
        this.ht_rs = new LinkedHashMap();
    }

    public void put(String name, Object call) {
        ThreadLocalStorageProvider tlsp;
        String tlsName;
        CallObj obj = new CallObj(call);
        this.ht.put(name, obj);
        if (this.ht_rs != null) {
            this.ht_rs.put(name, obj);
        }
        if (call instanceof ThreadLocalStorageProvider && !this.threadLocalStorages.containsKey(tlsName = (tlsp = (ThreadLocalStorageProvider)call).threadLocalStorageName())) {
            this.threadLocalStorages.put(tlsName, tlsp.newThreadLocalStorage());
        }
    }

    public ResultSet[] getResults() {
        if (this.ht_rs != null) {
            Vector<ResultSet> v = new Vector<ResultSet>();
            for (CallObj o : this.ht_rs.values()) {
                if (o.withReturnCursors == null) continue;
                Collections.sort(o.withReturnCursors);
                for (ResultSetOwner rso : o.withReturnCursors) {
                    if (rso.rs == null) continue;
                    v.addElement(rso.rs);
                }
            }
            this.ht_rs = null;
            return v.toArray(new ResultSet[v.size()]);
        }
        return new ResultSet[0];
    }

    public void putEsqlCursor(String name, IEsqlCursor c) {
        CallObj o = this.ht.get(name);
        if (o != null) {
            if (o.withReturnCursors == null) {
                o.withReturnCursors = new Vector();
            }
            ResultSetOwner rso = new ResultSetOwner(c.getWithReturn());
            c.setResultSetListener(rso);
            int wr = c.getWithReturn();
            if (wr < Integer.MAX_VALUE) {
                int i;
                int size = o.withReturnCursors.size();
                for (i = 0; i < size; ++i) {
                    if (o.withReturnCursors.elementAt((int)i).withReturn != wr) continue;
                    o.withReturnCursors.setElementAt(rso, i);
                    break;
                }
                if (i == size) {
                    o.withReturnCursors.addElement(rso);
                }
            } else {
                o.withReturnCursors.addElement(rso);
            }
            if (this.ht_rs != null && !this.ht_rs.containsKey(name)) {
                this.ht_rs.put(name, o);
            }
        }
    }

    public Object get(String name) {
        CallObj o = this.ht.get(name);
        return o != null ? o.call : null;
    }

    public Object getThreadLocalStorage(IscobolCall c) {
        if (c instanceof ThreadLocalStorageProvider) {
            return this.threadLocalStorages.get(((ThreadLocalStorageProvider)((Object)c)).threadLocalStorageName());
        }
        return null;
    }

    public Object remove(String name) {
        Object call;
        CallObj o = this.ht.remove(name);
        if (this.ht_rs != null) {
            this.ht_rs.remove(name);
        }
        Object object = call = o != null ? o.call : null;
        if (call instanceof ThreadLocalStorageProvider) {
            this.threadLocalStorages.remove(((ThreadLocalStorageProvider)call).threadLocalStorageName());
        }
        return call;
    }

    public Set<String> keySet() {
        return this.ht.keySet();
    }

    public int size() {
        return this.ht.size();
    }

    public void clear() {
        this.ht.clear();
    }

    private static class CallObj {
        final Object call;
        Vector<ResultSetOwner> withReturnCursors;

        CallObj(Object call) {
            this.call = call;
        }
    }

    private static class ResultSetOwner
    implements Consumer<ResultSet>,
    Comparable<ResultSetOwner> {
        ResultSet rs;
        final Integer withReturn;

        ResultSetOwner(Integer wr) {
            this.withReturn = wr;
        }

        @Override
        public void accept(ResultSet rs) {
            this.rs = rs;
        }

        @Override
        public int compareTo(ResultSetOwner o) {
            return this.withReturn - o.withReturn;
        }
    }
}

