/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.preview;

import com.iscobol.gui.Events;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.IscobolWindow;
import com.iscobol.preview.DrawStringItem;
import com.iscobol.preview.Preview;
import com.iscobol.preview.PreviewDialogSettings;
import com.iscobol.preview.PreviewEvent;
import com.iscobol.preview.PreviewListener;
import com.iscobol.rts.Factory;
import com.iscobol.rts.FindDialog;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class PreviewDialog
implements PreviewListener,
FindDialog.FindListener {
    public static final String DEFAULT_DIALOG_TITLE = "Print Preview";
    private static final Dimension IMAGE_BTN_SIZE = new Dimension(25, 25);
    private static final double FIT_WIDTH = -1.0;
    private static final double FIT_PAGE = -2.0;
    private Window window;
    private JPanel commands;
    private JToolBar commandsTbl;
    private Preview preview;
    private JTextField page;
    private JComboBox zoom;
    private JLabel pageCountLbl;
    private Dimension preferredSize;
    private JButton minMaxBtn;
    private JButton firstPageBtn;
    private JButton nextPageBtn;
    private JButton prevPageBtn;
    private JButton lastPageBtn;
    private JButton saveBtn;
    private JButton printBtn;
    private JButton quitBtn;
    private JButton findBtn;
    private JButton zoomInBtn;
    private JButton zoomOutBtn;
    private JButton pageSetupBtn;
    private JCheckBox showThumbBtn;
    private JCheckBox antialiasingChk;
    private Events events;
    private FindDialog findDialog;
    private Printable printable;
    private PageFormat pageFormat;
    private Vector findTokens;
    private int findTokenIdx;
    private int findTokenStartOffs;
    private int findTokenEndOffs;
    private boolean maximized;
    private Rectangle restoreBounds;
    private Object lock = new Object();
    private Map<Window, Boolean> winMap = new LinkedHashMap<Window, Boolean>();
    private ItemListener zoomItemListener;
    private Object[][] zoomValues = new Object[][]{{"1600%", 16.0}, {"800%", 8.0}, {"400%", 4.0}, {"200%", 2.0}, {"150%", 1.5}, {"100%", 1.0}, {"66%", 0.6666666666666666}, {"50%", 0.5}, {"33%", 0.3333333333333333}, {"25%", 0.25}, {Factory.getSysMsg("fit_width"), -1.0}, {Factory.getSysMsg("fit_page"), -2.0}};
    static final double MAX_SCALE = 16.0;
    static final double MIN_SCALE = 0.25;

    private void handlePageTxtEvent() {
        String text = this.page.getText();
        try {
            int newNum = Integer.parseInt(text);
            this.preview.setPageNumber(newNum);
        }
        catch (NumberFormatException ex) {
            this.page.setText("" + this.preview.getPageNumber());
        }
    }

    public PreviewDialog(Printable prn, PageFormat pf, int n, String fileName, PreviewDialogSettings settings, Events events) {
        Vector menuitems;
        Image restore;
        Image maximize;
        String title = settings.getTitle() != null ? settings.getTitle() : DEFAULT_DIALOG_TITLE;
        Container contentPane = null;
        this.window = null;
        for (Window w : Window.getWindows()) {
            if (!w.isVisible() || !(w instanceof JDialog) || !((JDialog)w).isModal()) continue;
            JDialog d = new JDialog((JDialog)w, title, true);
            d.setIconImage(settings.getIconImage());
            contentPane = d.getContentPane();
            this.window = d;
            break;
        }
        if (this.window == null) {
            JFrame f = new JFrame(title);
            f.setIconImage(settings.getIconImage());
            contentPane = f.getContentPane();
            this.window = f;
        }
        this.events = events;
        this.printable = prn;
        this.pageFormat = pf;
        contentPane.setLayout(new BorderLayout());
        Image firstPage = this.window.getToolkit().getImage(this.getClass().getResource("arrow_beg.png"));
        Image prevPage = this.window.getToolkit().getImage(this.getClass().getResource("arrow_back.png"));
        Image nextPage = this.window.getToolkit().getImage(this.getClass().getResource("arrow_next.png"));
        Image lastPage = this.window.getToolkit().getImage(this.getClass().getResource("arrow_end.png"));
        Image zoomIn = this.window.getToolkit().getImage(this.getClass().getResource("zoom_in.png"));
        Image zoomOut = this.window.getToolkit().getImage(this.getClass().getResource("zoom_out.png"));
        Image alias = this.window.getToolkit().getImage(this.getClass().getResource("antialiasing.gif"));
        Image pdf = this.window.getToolkit().getImage(this.getClass().getResource("file_pdf.gif"));
        Image printer = this.window.getToolkit().getImage(this.getClass().getResource("printer.png"));
        Image pageSetup = this.window.getToolkit().getImage(this.getClass().getResource("pagesetup.png"));
        Image exit = this.window.getToolkit().getImage(this.getClass().getResource("exit.png"));
        Image find = this.window.getToolkit().getImage(this.getClass().getResource("find.gif"));
        Image showThumbs = this.window.getToolkit().getImage(this.getClass().getResource("show_thumbnails.gif"));
        if (!this.isJFrame()) {
            maximize = this.window.getToolkit().getImage(this.getClass().getResource("maximize.png"));
            restore = this.window.getToolkit().getImage(this.getClass().getResource("restore.png"));
        } else {
            restore = null;
            maximize = null;
        }
        this.window.addWindowListener(IsguiUtility.windowClosingAdapter(evt -> this.closeWindow()));
        this.maximized = settings.isMaximized();
        this.commandsTbl = new JToolBar();
        this.commandsTbl.setLayout(new BorderLayout());
        this.commands = new JPanel(new FlowLayout());
        this.preview = new Preview(prn, pf, n, fileName, settings.getPrintableAreaBoxColor(), this);
        this.preview.addPreviewListener(this);
        boolean st = settings.getShowThumbnails();
        this.preview.setShowThumbnails(st);
        if (settings.getShowThumbnailsButton()) {
            this.showThumbBtn = new JCheckBox();
            this.showThumbBtn.setIcon(new ImageIcon(showThumbs));
            this.showThumbBtn.setToolTipText(Factory.getSysMsg("show_thumbs"));
            this.commands.add(this.showThumbBtn);
            this.showThumbBtn.setPreferredSize(IMAGE_BTN_SIZE);
            this.showThumbBtn.setBorderPainted(true);
            this.showThumbBtn.setSelected(st);
            if (st) {
                this.showThumbBtn.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                this.showThumbBtn.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            this.showThumbBtn.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.showThumbBtn.setBorder(BorderFactory.createLoweredBevelBorder());
                    this.preview.setShowThumbnails(true);
                } else {
                    this.showThumbBtn.setBorder(BorderFactory.createRaisedBevelBorder());
                    this.preview.setShowThumbnails(false);
                }
            });
        }
        if (settings.getShowSaveButton()) {
            this.saveBtn = new JButton();
            this.saveBtn.setIcon(new ImageIcon(pdf));
            this.saveBtn.setToolTipText(Factory.getSysMsg("save"));
            this.commands.add(this.saveBtn);
            this.saveBtn.addActionListener(e -> {
                String fn;
                String defDir = settings.getSaveDefaultDirectory();
                String defFilename = settings.getSaveDefaultFilename();
                if (defFilename == null) {
                    defFilename = ((SpoolPrinter)this.printable).getReportName();
                    if (defFilename == null) {
                        defFilename = ((SpoolPrinter)this.printable).getJobName();
                    } else if (defFilename.toLowerCase().startsWith("@[display]:")) {
                        defFilename = defFilename.substring(11);
                    }
                    if (defFilename != null) {
                        int idx = (defFilename = new File(defFilename).getName()).lastIndexOf(46);
                        defFilename = idx >= 0 ? defFilename.substring(0, idx) + ".pdf" : defFilename + ".pdf";
                    }
                }
                if ((fn = this.preview.openSavePdfDialog(this.saveBtn, defDir, defFilename)) != null) {
                    if (settings.isCloseWindowAfterPrintPdf()) {
                        this.closeWindow();
                    } else {
                        try {
                            ((SpoolPrinter)this.printable).printPDF(fn);
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(this.window, e1.getMessage(), e1.getClass().getName(), 0);
                        }
                        finally {
                            this.preview.setDoPdf(false);
                            this.preview.setDoPrint(false);
                        }
                        JOptionPane.showMessageDialog(this.window, "Created file '" + fn + "'");
                    }
                }
            });
            this.saveBtn.setPreferredSize(IMAGE_BTN_SIZE);
        }
        if (settings.getShowPrintButton()) {
            this.printBtn = new JButton();
            this.printBtn.setIcon(new ImageIcon(printer));
            this.printBtn.setToolTipText(Factory.getSysMsg("print"));
            this.commands.add(this.printBtn);
            this.printBtn.addActionListener(e -> {
                SpoolPrinter sp = (SpoolPrinter)this.printable;
                PrinterJob pj = PrinterJob.getPrinterJob();
                PrintRequestAttributeSet aset = null;
                if (!settings.getShowPrintDialog() || (aset = this.setupPrinter(pj, sp)) != null) {
                    sp.setSavedPrintRequestAttributeSet(aset);
                    this.clearPages();
                    if (settings.isCloseWindowAfterPrint()) {
                        this.preview.setDoPrint(true);
                        this.closeWindow();
                    } else {
                        try {
                            pj.setPrintable(sp);
                            pj.setPrintService(sp.getCurrPrintService());
                            pj.print(sp.getPrintRequestAttributeSet());
                        }
                        catch (PrinterException e1) {
                            JOptionPane.showMessageDialog(this.window, e1.getMessage(), e1.getClass().getName(), 0);
                        }
                        sp.restorePrintRequestAttributeSet();
                        this.preview.setPageFormat(sp.getPageFormat(PrinterJob.getPrinterJob()), true);
                        this.preview.setPageCount(sp.getPageCount());
                        this.pageCountLbl.setText("/" + this.preview.getPageCount());
                        this.updateToolbar();
                    }
                }
            });
            this.printBtn.setPreferredSize(IMAGE_BTN_SIZE);
        }
        if (settings.getShowPrintSetupButton()) {
            this.pageSetupBtn = new JButton();
            this.pageSetupBtn.setIcon(new ImageIcon(pageSetup));
            this.pageSetupBtn.setToolTipText(Factory.getSysMsg("page_setup"));
            this.commands.add(this.pageSetupBtn);
            this.pageSetupBtn.setPreferredSize(IMAGE_BTN_SIZE);
            this.pageSetupBtn.addActionListener(e -> {
                SpoolPrinter sp = (SpoolPrinter)this.printable;
                PrinterJob pj = PrinterJob.getPrinterJob();
                PrintRequestAttributeSet aset = this.setupPage(pj, sp);
                if (aset != null) {
                    sp.setSavedPrintRequestAttributeSet(aset);
                    this.clearPages();
                    this.preview.setPageFormat(sp.getPageFormat(PrinterJob.getPrinterJob()), true);
                    this.preview.setPageCount(sp.getPageCount());
                    this.pageCountLbl.setText("/" + this.preview.getPageCount());
                    this.updateToolbar();
                }
            });
        }
        this.quitBtn = new JButton();
        this.quitBtn.setIcon(new ImageIcon(exit));
        this.quitBtn.setToolTipText(Factory.getSysMsg("quit"));
        this.commands.add(this.quitBtn);
        this.quitBtn.addActionListener(e -> this.quit());
        this.quitBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.findBtn = new JButton();
        this.findBtn.setIcon(new ImageIcon(find));
        this.findBtn.setToolTipText(Factory.getSysMsg("find"));
        this.commands.add(this.findBtn);
        this.findBtn.addActionListener(e -> this.find());
        this.findBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.commands.add(new JToolBar.Separator());
        this.firstPageBtn = new JButton();
        this.commands.add(this.firstPageBtn);
        this.firstPageBtn.addActionListener(e -> {
            this.preview.showFirstPage();
            this.updateToolbar();
        });
        this.firstPageBtn.setIcon(new ImageIcon(firstPage));
        this.firstPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.firstPageBtn.setToolTipText(Factory.getSysMsg("first_page"));
        this.prevPageBtn = new JButton();
        this.commands.add(this.prevPageBtn);
        this.prevPageBtn.addActionListener(e -> {
            this.preview.showPreviousPage();
            this.updateToolbar();
        });
        this.prevPageBtn.setIcon(new ImageIcon(prevPage));
        this.prevPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.prevPageBtn.setToolTipText(Factory.getSysMsg("prev_page"));
        this.commands.add(new JLabel(Factory.getSysMsg("page"), 2));
        this.page = new JTextField("" + this.preview.getPageNumber());
        this.commands.add(this.page);
        this.page.addFocusListener(IsguiUtility.focusLostAdapter(e -> {
            this.handlePageTxtEvent();
            this.updateToolbar();
        }));
        this.page.addActionListener(e -> {
            this.handlePageTxtEvent();
            this.updateToolbar();
        });
        this.page.setPreferredSize(new Dimension(50, 25));
        this.page.setHorizontalAlignment(4);
        this.pageCountLbl = new JLabel("/" + this.preview.getPageCount(), 2);
        this.commands.add(this.pageCountLbl);
        this.nextPageBtn = new JButton();
        this.commands.add(this.nextPageBtn);
        this.nextPageBtn.addActionListener(e -> {
            this.preview.showNextPage();
            this.updateToolbar();
        });
        this.nextPageBtn.setIcon(new ImageIcon(nextPage));
        this.nextPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.nextPageBtn.setToolTipText(Factory.getSysMsg("next_page"));
        this.lastPageBtn = new JButton();
        this.commands.add(this.lastPageBtn);
        this.lastPageBtn.addActionListener(e -> {
            this.preview.showLastPage();
            this.updateToolbar();
        });
        this.lastPageBtn.setIcon(new ImageIcon(lastPage));
        this.lastPageBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.lastPageBtn.setToolTipText(Factory.getSysMsg("last_page"));
        this.commands.add(new JToolBar.Separator());
        this.zoomOutBtn = new JButton();
        this.commands.add(this.zoomOutBtn);
        this.zoomOutBtn.addActionListener(e -> {
            int sel = this.zoom.getSelectedIndex();
            if (sel >= 0) {
                if (++sel < this.zoomValues.length && (Double)this.zoomValues[sel][1] > 0.0) {
                    this.zoom.setSelectedIndex(sel);
                    this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                }
            } else {
                try {
                    double scale = this.getScale(this.zoom.getEditor().getItem()) / 100.0;
                    for (int i = 0; i < this.zoomValues.length; ++i) {
                        if (!(scale > (Double)this.zoomValues[i][1])) continue;
                        this.zoom.setSelectedIndex(i);
                        this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.zoomOutBtn.setIcon(new ImageIcon(zoomOut));
        this.zoomOutBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.zoomOutBtn.setToolTipText(Factory.getSysMsg("zoom_out"));
        this.zoom = new JComboBox();
        this.zoom.setEditable(true);
        this.zoom.setEditor(new MyComboEditor());
        for (int i = 0; i < this.zoomValues.length; ++i) {
            this.zoom.addItem((String)this.zoomValues[i][0]);
        }
        this.zoomItemListener = e -> {
            int selIdx = this.zoom.getSelectedIndex();
            if (selIdx >= 0) {
                double scale = (Double)this.zoomValues[selIdx][1];
                this.preview.setScale(scale);
            } else {
                try {
                    double scale = this.getScale(this.zoom.getEditor().getItem());
                    this.changeScale(scale);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.zoom.addItemListener(this.zoomItemListener);
        FontMetrics fm = this.zoom.getFontMetrics(this.zoom.getFont());
        int w1 = fm.stringWidth(this.zoom.getItemAt(this.zoom.getItemCount() - 2).toString());
        int w2 = fm.stringWidth(this.zoom.getItemAt(this.zoom.getItemCount() - 1).toString());
        this.zoom.setPreferredSize(new Dimension(Math.max(w1, w2) + 25, 25));
        this.commands.add(this.zoom);
        this.zoomInBtn = new JButton();
        this.commands.add(this.zoomInBtn);
        this.zoomInBtn.addActionListener(e -> {
            int sel = this.zoom.getSelectedIndex();
            if (sel >= 0) {
                if (--sel >= 0 && (Double)this.zoomValues[sel][1] > 0.0) {
                    this.zoom.setSelectedIndex(sel);
                    this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                }
            } else if (this.zoom.getEditor().getItem() != null) {
                try {
                    double scale = this.getScale(this.zoom.getEditor().getItem()) / 100.0;
                    for (int i = this.zoomValues.length - 3; i >= 0; --i) {
                        if (!(scale < (Double)this.zoomValues[i][1])) continue;
                        this.zoom.setSelectedIndex(i);
                        this.zoom.dispatchEvent(new ItemEvent(this.zoom, 701, this.zoom, 1));
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.zoomInBtn.setIcon(new ImageIcon(zoomIn));
        this.zoomInBtn.setPreferredSize(IMAGE_BTN_SIZE);
        this.zoomInBtn.setToolTipText(Factory.getSysMsg("zoom_in"));
        this.antialiasingChk = new JCheckBox();
        this.commands.add(this.antialiasingChk);
        this.antialiasingChk.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.antialiasingChk.setBorder(BorderFactory.createLoweredBevelBorder());
                this.preview.setAntialiasing(true);
            } else {
                this.antialiasingChk.setBorder(BorderFactory.createRaisedBevelBorder());
                this.preview.setAntialiasing(false);
            }
        });
        this.antialiasingChk.setIcon(new ImageIcon(alias));
        this.antialiasingChk.setPreferredSize(IMAGE_BTN_SIZE);
        this.antialiasingChk.setBorderPainted(true);
        this.antialiasingChk.setBorder(BorderFactory.createRaisedBevelBorder());
        this.antialiasingChk.setToolTipText(Factory.getSysMsg("antialiasing"));
        int[] sch = ((SpoolPrinter)this.printable).getSearchChars();
        int[] smsk = ((SpoolPrinter)this.printable).getSearchMasks();
        if (sch != null && smsk != null && sch.length == smsk.length) {
            for (int i = 0; i < sch.length; ++i) {
                PreviewDialog.addAccelerator(this.findBtn, KeyStroke.getKeyStroke(sch[i], smsk[i]), new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PreviewDialog.this.find();
                    }
                });
            }
        }
        PreviewDialog.addAccelerator(this.quitBtn, KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.quit();
            }
        });
        this.commands.add(new JToolBar.Separator());
        if (!this.isJFrame()) {
            this.minMaxBtn = new JButton();
            this.commands.add(this.minMaxBtn);
            this.minMaxBtn.addActionListener(e -> {
                if (this.maximized) {
                    this.doRestore(maximize);
                } else {
                    this.doMaximize(restore);
                }
            });
            if (this.maximized) {
                this.minMaxBtn.setIcon(new ImageIcon(restore));
                this.minMaxBtn.setToolTipText(Factory.getSysMsg("restore"));
            } else {
                this.minMaxBtn.setIcon(new ImageIcon(maximize));
                this.minMaxBtn.setToolTipText(Factory.getSysMsg("maximize"));
            }
            this.minMaxBtn.setPreferredSize(IMAGE_BTN_SIZE);
        }
        this.commandsTbl.add((Component)this.commands, "West");
        contentPane.add((Component)this.commandsTbl, "North");
        contentPane.add((Component)this.preview, "Center");
        Rectangle bounds = settings.getBounds();
        if (bounds.width > 0 && bounds.height > 0) {
            this.preferredSize = bounds.getSize();
            this.window.setPreferredSize(this.preferredSize);
        }
        if (settings.isShowExportMenu() && !(menuitems = settings.getMenuBar().getChildren()).isEmpty()) {
            JMenuBar mbar = new JMenuBar();
            for (int i = 0; i < menuitems.size(); ++i) {
                PreviewDialogSettings.Menu m = (PreviewDialogSettings.Menu)menuitems.elementAt(i);
                if (m.getChildren().isEmpty()) continue;
                JMenu menu = new JMenu(m.getTitle());
                mbar.add(menu);
                this.addMenuItems(m.getChildren(), menu);
            }
            if (this.isJFrame()) {
                ((JFrame)this.window).setJMenuBar(mbar);
            } else {
                ((JDialog)this.window).setJMenuBar(mbar);
            }
        }
        this.window.pack();
        if (bounds.x > 0 && bounds.y > 0) {
            this.window.setLocation(bounds.getLocation());
        } else if (bounds.x == 0 && bounds.y == 0) {
            this.window.setLocationRelativeTo(null);
        } else if (bounds.x == 0) {
            this.window.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.window.getSize().width) / 2, bounds.y);
        } else if (bounds.y == 0) {
            this.window.setLocation(bounds.x, (Toolkit.getDefaultToolkit().getScreenSize().height - this.window.getSize().height) / 2);
        }
        this.updateToolbar();
        this.antialiasingChk.setSelected(settings.isAntialiasing());
        this.preview.setAntialiasing(settings.isAntialiasing());
        this.changeScale(settings.getScale());
        if (this.maximized) {
            this.doMaximize(restore);
        }
    }

    private void doMaximize(Image restoreImage) {
        if (this.isJFrame()) {
            ((JFrame)this.window).setExtendedState(6);
        } else {
            this.restoreBounds = this.window.getBounds();
            Rectangle maximizedBounds = this.window.getGraphicsConfiguration().getBounds();
            ((JDialog)this.window).setResizable(false);
            this.window.setBounds(maximizedBounds);
            this.minMaxBtn.setIcon(new ImageIcon(restoreImage));
            this.minMaxBtn.setToolTipText(Factory.getSysMsg("restore"));
        }
        this.maximized = true;
    }

    private void doRestore(Image maximizeImage) {
        if (this.isJFrame()) {
            ((JFrame)this.window).setExtendedState(0);
        } else {
            ((JDialog)this.window).setResizable(true);
            this.window.setBounds(this.restoreBounds);
            this.minMaxBtn.setIcon(new ImageIcon(maximizeImage));
            this.minMaxBtn.setToolTipText(Factory.getSysMsg("maximize"));
            this.restoreBounds = null;
        }
        this.maximized = false;
    }

    private static boolean addAccelerator(JButton btn, KeyStroke ks, Action a) {
        ActionMap actionMap = btn.getActionMap();
        InputMap inputMap = btn.getInputMap(2);
        actionMap.put("printPreviewAction", a);
        inputMap.put(ks, "printPreviewAction");
        return true;
    }

    private void quit() {
        this.preview.setDoPrint(false);
        this.closeWindow();
    }

    private boolean isJFrame() {
        return this.window instanceof JFrame;
    }

    private void find() {
        if (this.findDialog == null) {
            this.findDialog = this.isJFrame() ? new FindDialog((JFrame)this.window, Factory.getSysMsg("find"), true) : new FindDialog((JDialog)this.window, Factory.getSysMsg("find"), true);
            this.findDialog.setFindListener(this);
        }
        this.findDialog.setLocationRelativeTo(this.window);
        this.findDialog.open();
        this.findDialog.toFront();
    }

    private void addMenuItems(Vector items, JMenu parentMenu) {
        for (int i = 0; i < items.size(); ++i) {
            PreviewDialogSettings.Menu m = (PreviewDialogSettings.Menu)items.elementAt(i);
            if (m.getChildren().isEmpty()) {
                JMenuItem menuitem = new JMenuItem(m.getTitle(), m.getIcon());
                menuitem.setActionCommand(Integer.toString(m.getActionCode()));
                menuitem.addActionListener(e -> {
                    if (this.events != null) {
                        RemoteRecordAccept rra = new RemoteRecordAccept();
                        rra.setKeyStatus(Integer.parseInt(e.getActionCommand()));
                        try {
                            this.events.fireevent(rra);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                parentMenu.add(menuitem);
                continue;
            }
            JMenu menu = new JMenu(m.getTitle());
            parentMenu.add(menu);
            this.addMenuItems(m.getChildren(), menu);
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize != null ? this.preferredSize : this.window.getPreferredSize();
    }

    private double getScale(Object item) throws NumberFormatException {
        if (item == null) {
            throw new NumberFormatException("null");
        }
        String s = item.toString();
        if (s.endsWith("%")) {
            s = s.substring(0, s.length() - 1);
        }
        return Double.parseDouble(s);
    }

    private void changeScale(double scale) {
        this.zoom.removeItemListener(this.zoomItemListener);
        if (scale == -1.0) {
            this.zoom.setSelectedIndex(this.zoom.getItemCount() - 2);
            this.preview.setScale(scale);
        } else if (scale == -2.0) {
            this.zoom.setSelectedIndex(this.zoom.getItemCount() - 1);
            this.preview.setScale(scale);
        } else {
            double sc = scale / 100.0;
            boolean ok = false;
            int i = 0;
            while (i < this.zoomValues.length & !ok) {
                if (sc == (Double)this.zoomValues[i][1]) {
                    this.zoom.setSelectedIndex(i);
                    this.preview.setScale(sc);
                    ok = true;
                }
                ++i;
            }
            if (!ok) {
                if (sc < 0.25) {
                    sc = 0.25;
                    scale = 0.0;
                }
                if (sc > 16.0) {
                    sc = 16.0;
                    scale = 1600.0;
                }
                this.preview.setScale(sc);
                this.zoom.setSelectedItem("" + scale + "%");
            }
        }
        this.zoom.addItemListener(this.zoomItemListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openWindow() {
        if (this.isJFrame()) {
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (w instanceof IscobolWindow) {
                AbstractGuiFactoryImpl gf;
                long wId = ((IscobolWindow)((Object)w)).getId();
                long prtId = -1L;
                if (this.printable instanceof SpoolPrinter && (gf = ((SpoolPrinter)this.printable).getGuiFactory()) != null) {
                    prtId = gf.getId();
                }
                if (wId == prtId) {
                    while (w instanceof IscobolWindow) {
                        Boolean en = w.isEnabled();
                        w.setEnabled(false);
                        this.winMap.put(w, en);
                        w = w.getOwner();
                    }
                }
            }
            this.window.setVisible(true);
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.window.setVisible(true);
    }

    void updateToolbar() {
        this.page.setText("" + this.preview.getPageNumber());
        if (this.preview.getPageNumber() == 1) {
            this.firstPageBtn.setEnabled(false);
            this.prevPageBtn.setEnabled(false);
            if (this.preview.getPageNumber() == this.preview.getPageCount()) {
                this.nextPageBtn.setEnabled(false);
                this.lastPageBtn.setEnabled(false);
            } else {
                this.nextPageBtn.setEnabled(true);
                this.lastPageBtn.setEnabled(true);
            }
        } else if (this.preview.getPageNumber() == this.preview.getPageCount()) {
            this.firstPageBtn.setEnabled(true);
            this.prevPageBtn.setEnabled(true);
            this.nextPageBtn.setEnabled(false);
            this.lastPageBtn.setEnabled(false);
        } else {
            this.firstPageBtn.setEnabled(true);
            this.prevPageBtn.setEnabled(true);
            this.nextPageBtn.setEnabled(true);
            this.lastPageBtn.setEnabled(true);
        }
    }

    public Preview getPreview() {
        return this.preview;
    }

    @Override
    public void noSuchPage(PreviewEvent e) {
        this.page.setText("" + this.preview.getPageNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWindow() {
        this.preview.removePreviewListener(this);
        if (this.isJFrame()) {
            for (Window w : this.winMap.keySet()) {
                w.setEnabled(this.winMap.get(w));
            }
            this.window.dispose();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        } else {
            this.window.dispose();
        }
    }

    public boolean getAntialiasing() {
        return this.antialiasingChk.isSelected();
    }

    public boolean isMaximized() {
        return this.isJFrame() ? ((JFrame)this.window).getExtendedState() == 6 : this.maximized;
    }

    public Rectangle getRestoreBounds() {
        return this.isJFrame() || !this.maximized ? this.window.getBounds() : this.restoreBounds;
    }

    public double getScale() {
        if (this.zoom.getSelectedIndex() >= 0) {
            if (this.zoom.getSelectedIndex() < this.zoom.getItemCount() - 2) {
                return (Double)this.zoomValues[this.zoom.getSelectedIndex()][1] * 100.0;
            }
            return (Double)this.zoomValues[this.zoom.getSelectedIndex()][1];
        }
        if (this.zoom.getEditor().getItem() != null) {
            return this.getScale(this.zoom.getEditor().getItem());
        }
        return 0.0;
    }

    private void setMargins(SpoolPrinter sp, PrintRequestAttributeSet aset) {
        if (!sp.isReportPreview()) {
            return;
        }
        sp.setMargins(aset);
    }

    private PrintRequestAttributeSet setupPage(PrinterJob pj, SpoolPrinter sp) {
        boolean ok;
        PrintRequestAttributeSet aset = sp.getPrintRequestAttributeSet();
        HashPrintRequestAttributeSet asetSave = new HashPrintRequestAttributeSet(aset);
        MediaPrintableArea mpa = null;
        if (sp.isReportPreview()) {
            mpa = (MediaPrintableArea)aset.get(MediaPrintableArea.class);
            aset.add(sp.getMediaPrintableArea(aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE));
        }
        boolean bl = ok = pj.pageDialog(aset) != null;
        if (ok) {
            Media msn = (Media)aset.get(Media.class);
            if (msn != null && msn instanceof MediaSizeName) {
                sp.setMediaSize((MediaSizeName)msn);
            }
            if (sp.isReportPreview()) {
                this.setMargins(sp, aset);
            }
            return asetSave;
        }
        if (mpa != null) {
            aset.add(mpa);
        }
        return null;
    }

    private PrintRequestAttributeSet setupPrinter(PrinterJob pj, SpoolPrinter sp) {
        boolean ok;
        PrintRequestAttributeSet aset = sp.getPrintRequestAttributeSet();
        HashPrintRequestAttributeSet asetSave = new HashPrintRequestAttributeSet(aset);
        MediaPrintableArea mpa = null;
        if (sp.isReportPreview()) {
            mpa = (MediaPrintableArea)aset.get(MediaPrintableArea.class);
            aset.add(sp.getMediaPrintableArea(aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE));
        }
        if (sp.getCurrPrintService() != null) {
            try {
                pj.setPrintService(sp.getCurrPrintService());
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
        if (ok = pj.printDialog(aset)) {
            Media msn = (Media)aset.get(Media.class);
            if (msn != null && msn instanceof MediaSizeName) {
                sp.setMediaSize((MediaSizeName)msn);
            }
            if (sp.isReportPreview()) {
                this.setMargins(sp, aset);
            }
            if (pj.getPrintService() != null) {
                sp.setCurrPrinter(pj.getPrintService());
            }
            return asetSave;
        }
        if (mpa != null) {
            aset.add(mpa);
        }
        return null;
    }

    @Override
    public void find(FindDialog.FindParam param) {
        if (this.findTokens == null || this.findTokens.isEmpty()) {
            this.clearPages();
            this.buildPages();
        }
        this.find(param.toSearch, param.matchCase, param.backSearch, param.matchMinusUnderscore);
        if (this.findTokenIdx >= 0) {
            DrawStringItem ft = (DrawStringItem)this.findTokens.elementAt(this.findTokenIdx);
            this.preview.setFindToken(ft, this.findTokenStartOffs, this.findTokenEndOffs);
            this.updateToolbar();
        } else {
            JOptionPane.showMessageDialog(this.window, "'" + param.toSearch + "': not found");
            this.preview.setFindToken(null, -1, -1);
            this.resetFind();
        }
    }

    private void clearPages() {
        SpoolPrinter sp = (SpoolPrinter)this.printable;
        sp.clearPages();
        this.resetFind();
    }

    private void buildPages() {
        SpoolPrinter sp = (SpoolPrinter)this.printable;
        PreviewGraphics graphics = new PreviewGraphics();
        sp.buildPages(graphics, this.pageFormat, true);
    }

    private void resetFind() {
        this.findTokens = new Vector();
        this.findTokenIdx = 0;
        this.findTokenStartOffs = 0;
        this.findTokenEndOffs = 0;
    }

    private String normalizeString(String str, boolean matchCase, boolean matchMinusUnderscore) {
        if (!matchCase) {
            str = str.toUpperCase();
        }
        if (!matchMinusUnderscore) {
            str = str.replace('-', '_');
        }
        return str;
    }

    private int find(String str, boolean matchCase, boolean backward, boolean matchMinusUnderscore) {
        int tokenCount = this.findTokens.size();
        if (tokenCount == 0) {
            this.resetFind();
            return -1;
        }
        str = this.normalizeString(str, matchCase, matchMinusUnderscore);
        int idx = -1;
        if (this.findTokenIdx < 0 || this.findTokenIdx >= tokenCount) {
            this.findTokenIdx = 0;
        }
        int tokenIndex = this.findTokenIdx;
        if (backward) {
            int idx0;
            String tokenStr;
            DrawStringItem token;
            int i;
            for (i = tokenIndex; i >= 0; --i) {
                token = (DrawStringItem)this.findTokens.elementAt(i);
                if (i == tokenIndex) {
                    if (this.findTokenStartOffs == 0) {
                        continue;
                    }
                } else {
                    this.findTokenStartOffs = token.text.length();
                }
                tokenStr = token.text;
                idx0 = (tokenStr = this.normalizeString(tokenStr, matchCase, matchMinusUnderscore)).lastIndexOf(str, this.findTokenStartOffs);
                if (idx0 < 0 || i == tokenIndex || idx0 == this.findTokenStartOffs) continue;
                idx = i;
                this.findTokenStartOffs = idx0;
                break;
            }
            if (idx < 0) {
                for (i = tokenCount - 1; i >= tokenIndex; --i) {
                    token = (DrawStringItem)this.findTokens.elementAt(i);
                    tokenStr = token.text;
                    idx0 = (tokenStr = this.normalizeString(tokenStr, matchCase, matchMinusUnderscore)).lastIndexOf(str);
                    if (idx0 < 0) continue;
                    idx = i;
                    this.findTokenStartOffs = idx0;
                    break;
                }
            }
        } else {
            int idx0;
            String tokenStr;
            DrawStringItem token;
            int i;
            for (i = tokenIndex; i < tokenCount; ++i) {
                token = (DrawStringItem)this.findTokens.elementAt(i);
                if (i == tokenIndex) {
                    if (this.findTokenEndOffs == token.text.length()) {
                        continue;
                    }
                } else {
                    this.findTokenEndOffs = 0;
                }
                tokenStr = token.text;
                idx0 = (tokenStr = this.normalizeString(tokenStr, matchCase, matchMinusUnderscore)).indexOf(str, this.findTokenEndOffs);
                if (idx0 < 0) continue;
                idx = i;
                this.findTokenStartOffs = idx0;
                break;
            }
            if (idx < 0) {
                for (i = 0; i <= tokenIndex; ++i) {
                    token = (DrawStringItem)this.findTokens.elementAt(i);
                    tokenStr = token.text;
                    idx0 = (tokenStr = this.normalizeString(tokenStr, matchCase, matchMinusUnderscore)).indexOf(str);
                    if (idx0 < 0) continue;
                    idx = i;
                    this.findTokenStartOffs = idx0;
                    break;
                }
            }
        }
        this.findTokenIdx = idx;
        if (idx >= 0) {
            this.findTokenEndOffs = this.findTokenStartOffs + str.length();
        }
        return idx;
    }

    public Window getWindow() {
        return this.window;
    }

    private static class MyComboEditor
    extends JTextField
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;

        MyComboEditor() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.getText();
        }

        @Override
        public void setItem(Object o) {
            this.setText(o != null ? o.toString() : "");
        }
    }

    class PreviewGraphics
    extends Graphics2D {
        private Font font;
        private Color foreground;
        private Color background;
        private final FontRenderContext frc = new FontRenderContext(null, false, false);

        public PreviewGraphics() {
            this.font = PreviewDialog.this.window.getFont();
            this.foreground = PreviewDialog.this.window.getForeground();
            this.background = PreviewDialog.this.window.getBackground();
        }

        @Override
        public void draw(Shape s) {
        }

        @Override
        public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
            return false;
        }

        @Override
        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        }

        @Override
        public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        }

        @Override
        public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        }

        @Override
        public void drawString(String str, int x, int y) {
        }

        @Override
        public void drawString(String str, float x, float y) {
            PreviewDialog.this.findTokens.addElement(new DrawStringItem(str, x, y, ((SpoolPrinter)PreviewDialog.this.printable).getPageCount() + 1, this.getFont()));
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        }

        @Override
        public void drawGlyphVector(GlyphVector g, float x, float y) {
        }

        @Override
        public void fill(Shape s) {
        }

        @Override
        public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
            return false;
        }

        @Override
        public GraphicsConfiguration getDeviceConfiguration() {
            return PreviewDialog.this.window.getGraphicsConfiguration();
        }

        @Override
        public void setComposite(Composite comp) {
        }

        @Override
        public void setPaint(Paint paint) {
        }

        @Override
        public void setStroke(Stroke s) {
        }

        @Override
        public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        }

        @Override
        public Object getRenderingHint(RenderingHints.Key hintKey) {
            return null;
        }

        public void setRenderingHints(Map hints) {
        }

        public void addRenderingHints(Map hints) {
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }

        @Override
        public void translate(int x, int y) {
        }

        @Override
        public void translate(double tx, double ty) {
        }

        @Override
        public void rotate(double theta) {
        }

        @Override
        public void rotate(double theta, double x, double y) {
        }

        @Override
        public void scale(double sx, double sy) {
        }

        @Override
        public void shear(double shx, double shy) {
        }

        @Override
        public void transform(AffineTransform Tx) {
        }

        @Override
        public void setTransform(AffineTransform Tx) {
        }

        @Override
        public AffineTransform getTransform() {
            return null;
        }

        @Override
        public Paint getPaint() {
            return null;
        }

        @Override
        public Composite getComposite() {
            return null;
        }

        @Override
        public void setBackground(Color color) {
            this.background = color;
        }

        @Override
        public Color getBackground() {
            return this.background;
        }

        @Override
        public Stroke getStroke() {
            return null;
        }

        @Override
        public void clip(Shape s) {
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            return this.frc;
        }

        @Override
        public Graphics create() {
            return null;
        }

        @Override
        public Color getColor() {
            return this.foreground;
        }

        @Override
        public void setColor(Color c) {
            this.foreground = c;
        }

        @Override
        public void setPaintMode() {
        }

        @Override
        public void setXORMode(Color c1) {
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        @Override
        public void setFont(Font font) {
            this.font = font;
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return PreviewDialog.this.window.getFontMetrics(this.getFont());
        }

        @Override
        public Rectangle getClipBounds() {
            return null;
        }

        @Override
        public void clipRect(int x, int y, int width, int height) {
        }

        @Override
        public void setClip(int x, int y, int width, int height) {
        }

        @Override
        public Shape getClip() {
            return null;
        }

        @Override
        public void setClip(Shape clip) {
        }

        @Override
        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
        }

        @Override
        public void fillRect(int x, int y, int width, int height) {
        }

        @Override
        public void clearRect(int x, int y, int width, int height) {
        }

        @Override
        public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        }

        @Override
        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        }

        @Override
        public void drawOval(int x, int y, int width, int height) {
        }

        @Override
        public void fillOval(int x, int y, int width, int height) {
        }

        @Override
        public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        }

        @Override
        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        }

        @Override
        public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        }

        @Override
        public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        }

        @Override
        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        }

        @Override
        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            return false;
        }

        @Override
        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            return false;
        }

        @Override
        public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
            return false;
        }

        @Override
        public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
            return false;
        }

        @Override
        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            return false;
        }

        @Override
        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
            return false;
        }

        @Override
        public void dispose() {
        }
    }
}

