/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.export.xlsx;

import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class XLSXExportHelper
extends SSExportHelper {
    private final Map<Integer, XSSFColor> COLORS = new HashMap<Integer, XSSFColor>();
    private List<StringBuilder> mergedCellsXml = new ArrayList<StringBuilder>();

    @Override
    public int computeAnchorX(int colWidth, int left) {
        return left * 9525;
    }

    @Override
    public int computeAnchorY(int rowHeight, int top) {
        return top * 9525;
    }

    @Override
    public void setBorderedCellStyleAttrs(CellStyle cs, boolean top, boolean bottom, boolean left, boolean right, int borderWidth, Color borderColor) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)cs;
        BorderStyle borderStyle = this.getBorder(borderWidth);
        XSSFColor color = this.getColor(borderColor.getRGB());
        if (top) {
            cellStyle.setBorderTop(borderStyle);
            cellStyle.setTopBorderColor(color);
        }
        if (bottom) {
            cellStyle.setBorderBottom(borderStyle);
            cellStyle.setBottomBorderColor(color);
        }
        if (left) {
            cellStyle.setBorderLeft(borderStyle);
            cellStyle.setLeftBorderColor(color);
        }
        if (right) {
            cellStyle.setBorderRight(borderStyle);
            cellStyle.setRightBorderColor(color);
        }
    }

    @Override
    public void setFontColor(Font font, Color foreground) {
        ((XSSFFont)font).setColor(this.getColor(foreground.getRGB()));
    }

    public XSSFColor getColor(int rgb) {
        Integer I2 = new Integer(rgb &= 0xFFFFFF);
        XSSFColor Return2 = this.COLORS.get(I2);
        if (Return2 == null) {
            Return2 = new XSSFColor(new Color(rgb));
            this.COLORS.put(I2, Return2);
        }
        return Return2;
    }

    @Override
    public int getSheetColorCount() {
        return this.COLORS.size();
    }

    public BorderStyle getBorder(int borderWidth) {
        if (borderWidth > 0) {
            short pts = (short)UnitConverter.pixel2ExcelHeightPoints(borderWidth);
            if (pts >= 4) {
                return BorderStyle.THICK;
            }
            if (pts >= 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THIN;
        }
        return BorderStyle.NONE;
    }

    @Override
    protected Workbook createWorkbook() {
        return new SXSSFWorkbook(null, -1, false, true);
    }

    @Override
    public void flushRows(Sheet sheet) {
        try {
            ((SXSSFSheet)sheet).flushRows();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getMaxRowsPerSheet() {
        return 0x100000;
    }

    @Override
    public Sheet createSheet(String reportName) {
        SXSSFSheet sheet = (SXSSFSheet)super.createSheet(reportName);
        sheet.setRandomAccessWindowSize(-1);
        this.mergedCellsXml.add(new StringBuilder());
        return sheet;
    }

    @Override
    public void addMergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        int sheetIdx = this.getWorkbook().getSheetIndex(sheet);
        StringBuilder sb = this.mergedCellsXml.get(sheetIdx);
        if (sb.length() == 0) {
            sb.append("<mergeCells>");
        }
        sb.append("<mergeCell ref=\"");
        sb.append(XLSXExportHelper.getColRef(firstCol));
        sb.append(firstRow + 1);
        sb.append(":");
        sb.append(XLSXExportHelper.getColRef(lastCol));
        sb.append(lastRow + 1);
        sb.append("\"/>");
    }

    private static String getColRef(int cIdx) {
        StringBuilder s = new StringBuilder();
        while (cIdx >= 26) {
            s.insert(0, (char)(cIdx % 26 + 65));
            cIdx = cIdx / 26 - 1;
        }
        s.insert(0, (char)(cIdx % 26 + 65));
        return s.toString();
    }

    @Override
    public void write(String outputFile) throws IOException {
        FileOutputStream fileOut;
        this.flushRows(this.getSheetAt(this.getSheetCount() - 1));
        boolean hasMergedRegions = false;
        for (StringBuilder sb : this.mergedCellsXml) {
            if (sb.length() <= 0) continue;
            hasMergedRegions = true;
            break;
        }
        File tmpfile = null;
        if (hasMergedRegions) {
            tmpfile = File.createTempFile("tmp", ".xlsx");
            fileOut = new FileOutputStream(tmpfile);
        } else {
            fileOut = new FileOutputStream(outputFile);
        }
        Workbook workbook = this.getWorkbook();
        workbook.write((OutputStream)fileOut);
        fileOut.close();
        workbook.close();
        ((SXSSFWorkbook)workbook).dispose();
        if (!hasMergedRegions) {
            return;
        }
        ZipFile zfile = new ZipFile(tmpfile);
        fileOut = new FileOutputStream(outputFile);
        ZipOutputStream zout = new ZipOutputStream(fileOut);
        BufferedOutputStream bzout = new BufferedOutputStream(zout);
        Pattern ptn = Pattern.compile("sheet(\\d+)\\.xml$");
        Enumeration<? extends ZipEntry> en = zfile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory()) continue;
            String entryBaseName = new File(entry.getName()).getName();
            BufferedInputStream entryis = new BufferedInputStream(zfile.getInputStream(entry));
            zout.putNextEntry(new ZipEntry(entry.getName()));
            Matcher m = ptn.matcher(entryBaseName);
            if (m.find()) {
                int sheetIdx = Integer.parseInt(m.group(1)) - 1;
                StringBuilder sb = this.mergedCellsXml.get(sheetIdx);
                if (sb.length() > 0) {
                    byte[] bytes = "</sheetData>".getBytes();
                    sb.append("</mergeCells>");
                    int i = 0;
                    int b = ((InputStream)entryis).read();
                    while (b >= 0) {
                        bzout.write(b);
                        if (b == bytes[i]) {
                            if (i == bytes.length - 1) {
                                bzout.write(sb.toString().getBytes());
                            } else {
                                ++i;
                            }
                        } else {
                            i = 0;
                        }
                        b = ((InputStream)entryis).read();
                    }
                } else {
                    int b = ((InputStream)entryis).read();
                    while (b >= 0) {
                        bzout.write(b);
                        b = ((InputStream)entryis).read();
                    }
                }
            } else {
                int b = ((InputStream)entryis).read();
                while (b >= 0) {
                    bzout.write(b);
                    b = ((InputStream)entryis).read();
                }
            }
            bzout.flush();
            zout.closeEntry();
            ((InputStream)entryis).close();
        }
        tmpfile.deleteOnExit();
        zfile.close();
        bzout.close();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.COLORS.clear();
        this.mergedCellsXml.clear();
    }

    @Override
    public void setBackgroundAttrs(CellStyle cellStyle, Color background) {
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ((XSSFCellStyle)cellStyle).setFillForegroundColor(this.getColor(background.getRGB()));
    }

    @Override
    public Color getBackgroundColor(CellStyle cellStyle) {
        Color Return2 = null;
        XSSFColor xc = ((XSSFCellStyle)cellStyle).getFillForegroundColorColor();
        if (xc != null) {
            byte[] rgb = xc.getRGB();
            Return2 = new Color(this.toInt(rgb[0]), this.toInt(rgb[1]), this.toInt(rgb[2]));
        }
        return Return2;
    }

    private int toInt(byte b) {
        return b < 0 ? 256 + b : b;
    }
}

