/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.ConfigEntry;
import com.veryant.vision4j.file.FileInfoHelper;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.TransactionLogEntry;
import com.veryant.vision4j.file.VisionContext;
import com.veryant.vision4j.file.VisionFactory;
import com.veryant.vision4j.file.internals.KeyInfo;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PhysicalAttributes;
import java.util.Arrays;

public class DynamicVisionJ
implements DynamicFile,
RuntimeErrorsNumbers {
    private static final String VERSION = "VisionJ 6";
    private static final int WAIT_TIMEOUT;
    private final Config config = new Config();
    private int fileId;
    private String filePath;
    private FileInfoHelper fileInfo;
    private VisionContext visionContext;
    private final VisionFactory visionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicVisionJ() {
        for (ConfigEntry configEntry : this.config.ALL_ENTRIES) {
            configEntry.parse(com.iscobol.rts.Config.getProperty(".visionj." + configEntry.getName(), null));
        }
        this.visionContext = (VisionContext)IscobolSystem.get(VisionContext.class);
        if (this.visionContext == null) {
            IscobolSystem.Context context = IscobolSystem.getContext();
            synchronized (context) {
                this.visionContext = (VisionContext)IscobolSystem.get(VisionContext.class);
                if (this.visionContext == null) {
                    this.visionContext = new VisionContext(new FileTable(Config.V_MAX_FILES.getIntegerValue()), new TransactionLog());
                    IscobolSystem.set(VisionContext.class, this.visionContext);
                }
            }
        }
        this.visionFactory = new VisionFactory(this.config, this.visionContext.getFileTable());
    }

    @Override
    public boolean isKeySelectedByNum() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.fileId > 0;
    }

    @Override
    public String getDescription() {
        return this.filePath;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int getCobErrno() {
        switch (this.visionFactory.getErrno()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 133;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 125;
            }
            case 5: {
                return 107;
            }
            case 6: {
                return 105;
            }
            case 7: {
                return 100;
            }
            case 8: {
                return 111;
            }
            case 9: {
                return 112;
            }
            case 10: {
                return 127;
            }
            case 11: {
                return 113;
            }
            case 12: {
                return 128;
            }
            case 13: {
                return 140;
            }
            case 14: {
                return 116;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 131;
            }
            case 17: {
                return 126;
            }
            case 18: {
                return 129;
            }
            case 101: {
                return 200;
            }
        }
        return 134;
    }

    @Override
    public String getSysErrno() {
        return String.format("%02d", this.visionFactory.getIntErrno());
    }

    @Override
    public String getErrMsg() {
        return "";
    }

    protected void finalize() {
        if (this.isOpen()) {
            this.close(true);
        }
    }

    private int mapOpen(int openMode, int lockMode) {
        int vOpenMode;
        switch (openMode) {
            case 1: {
                vOpenMode = 0;
                break;
            }
            case 2: {
                vOpenMode = 1;
                break;
            }
            case 3: {
                vOpenMode = 2;
                break;
            }
            case 6: {
                vOpenMode = 3;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (lockMode & 0xF) {
            case 1: 
            case 2: 
            case 4: {
                vOpenMode |= 0x200;
                break;
            }
            case 3: 
            case 5: {
                vOpenMode |= 0x100;
            }
        }
        if ((lockMode & 0x100) != 0) {
            vOpenMode |= 0x10;
        }
        if ((lockMode & 0x800) != 0) {
            vOpenMode |= 0x4000;
        }
        return vOpenMode;
    }

    private int findKey(KeyDescription key) {
        int keyCount = this.getNumKeys();
        for (int keyNum = 0; keyNum < keyCount; ++keyNum) {
            if (!key.equals(this.getKey(keyNum))) continue;
            return keyNum;
        }
        return -1;
    }

    @Override
    public synchronized int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compression, int encryption, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean ignored) {
        KeyInfo[] keyInfo = new KeyInfo[keys.length];
        for (int i = 0; i < keyInfo.length; ++i) {
            KeyDescription kd = keys[i];
            int segNum = kd.segment.length;
            int[] offsets = new int[segNum];
            int[] sizes = new int[segNum];
            for (int k = 0; k < segNum; ++k) {
                offsets[k] = kd.segment[k].offset;
                sizes[k] = kd.segment[k].size;
            }
            keyInfo[i] = new KeyInfo(keys[i].duplicates, offsets, sizes);
        }
        PhysicalAttributes physicalAttributes = new PhysicalAttributes(blockingFactor, preAllocate, extensionFactor);
        LogicalAttributes logicalAttributes = new LogicalAttributes(minRecordSize, maxRecordSize, keyInfo, compression);
        return this.visionFactory.make(path, physicalAttributes, logicalAttributes, collating) ? 1 : 0;
    }

    @Override
    public synchronized int open(String filePath, int openMode, int lockMode, KeyDescription[] keys, int maxRec, int minRec, int numKeys, int accessMode, boolean optional, boolean ignored) {
        this.fileId = this.visionFactory.open(filePath, this.mapOpen(openMode, lockMode));
        if (this.fileId > 0) {
            this.filePath = filePath;
            this.fileInfo = this.visionFactory.getFileInfo(this.fileId);
            return 1;
        }
        return 0;
    }

    @Override
    public int close() {
        return this.close(false);
    }

    private int close(boolean force) {
        TransactionLog transactionLog = force ? null : this.visionContext.getTransactionLog();
        int ret = this.visionFactory.close(this.fileId, transactionLog) ? 1 : 0;
        this.fileId = 0;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(byte[] record, int ignored, int keyNum, int lock) {
        while (true) {
            boolean retry;
            int readBytes;
            DynamicVisionJ dynamicVisionJ = this;
            synchronized (dynamicVisionJ) {
                this.config.F_NO_LOCK = lock > 0 ? 0 : 1;
                readBytes = this.visionFactory.read(this.fileId, record, keyNum);
                retry = this.visionFactory.getErrno() == 5 && lock == 3;
            }
            if (!retry) {
                return readBytes == 0 ? 0L : (long)readBytes;
            }
            try {
                Thread.sleep(WAIT_TIMEOUT);
            }
            catch (InterruptedException e) {
                return 0L;
            }
        }
    }

    @Override
    public long read(byte[] bytes, int ignored, KeyDescription keyDescription, int lock) {
        return this.read(bytes, ignored, this.findKey(keyDescription), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(byte[] record, int ignored, int lock) {
        while (true) {
            boolean retry;
            int readBytes;
            DynamicVisionJ dynamicVisionJ = this;
            synchronized (dynamicVisionJ) {
                this.config.F_NO_LOCK = lock > 0 ? 0 : 1;
                readBytes = this.visionFactory.next(this.fileId, record);
                retry = this.visionFactory.getErrno() == 5 && lock == 3;
            }
            if (!retry) {
                return readBytes == 0 ? 0L : (long)readBytes;
            }
            try {
                Thread.sleep(WAIT_TIMEOUT);
            }
            catch (InterruptedException e) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long previous(byte[] record, int ignored, int lock) {
        while (true) {
            boolean retry;
            int readBytes;
            DynamicVisionJ dynamicVisionJ = this;
            synchronized (dynamicVisionJ) {
                this.config.F_NO_LOCK = lock > 0 ? 0 : 1;
                readBytes = this.visionFactory.previous(this.fileId, record);
                retry = this.visionFactory.getErrno() == 5 && lock == 3;
            }
            if (!retry) {
                return readBytes == 0 ? 0L : (long)readBytes;
            }
            try {
                Thread.sleep(WAIT_TIMEOUT);
            }
            catch (InterruptedException e) {
                return 0L;
            }
        }
    }

    @Override
    public synchronized long start(byte[] record, int ignored, int keyNum, int keySize, int mode) {
        boolean success;
        switch (mode) {
            case 0: {
                byte[] lowValues = new byte[record.length];
                success = this.visionFactory.start(this.fileId, lowValues, keyNum, keySize, 1);
                break;
            }
            case 1: {
                byte[] highValues = new byte[record.length];
                Arrays.fill(highValues, (byte)-1);
                success = this.visionFactory.start(this.fileId, highValues, keyNum, keySize, 4);
                break;
            }
            case 5: {
                success = this.visionFactory.start(this.fileId, record, keyNum, keySize, 0);
                break;
            }
            case 6: {
                success = this.visionFactory.start(this.fileId, record, keyNum, keySize, 2);
                break;
            }
            case 7: {
                success = this.visionFactory.start(this.fileId, record, keyNum, keySize, 1);
                break;
            }
            case 8: {
                success = this.visionFactory.start(this.fileId, record, keyNum, keySize, 3);
                break;
            }
            case 9: {
                success = this.visionFactory.start(this.fileId, record, keyNum, keySize, 4);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return success ? 1L : 0L;
    }

    @Override
    public long start(byte[] bytes, int ignored, KeyDescription keyDescription, int keySize, int mode) {
        return this.start(bytes, ignored, this.findKey(keyDescription), keySize, mode);
    }

    @Override
    public synchronized long write(byte[] record, int ignored, int size, boolean lock) {
        return this.visionFactory.write(this.fileId, record, size, this.visionContext.getTransactionLog()) ? 1L : 0L;
    }

    @Override
    public synchronized long rewrite(byte[] record, int offs, int size, boolean lock) {
        return this.visionFactory.rewrite(this.fileId, record, size, this.visionContext.getTransactionLog()) ? 1L : 0L;
    }

    @Override
    public synchronized long delete(byte[] record, int ignored) {
        return this.visionFactory.delete(this.fileId, record, this.visionContext.getTransactionLog()) ? 1L : 0L;
    }

    @Override
    public synchronized int unlock() {
        return this.visionFactory.unlock(this.fileId) ? 1 : 0;
    }

    @Override
    public synchronized int remove(String fileName) {
        return this.visionFactory.remove(fileName) ? 1 : 0;
    }

    @Override
    public synchronized int rename(String oldName, String newName) {
        return this.visionFactory.rename(oldName, newName) ? 1 : 0;
    }

    @Override
    public synchronized void sync(int ignored) {
        this.visionFactory.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int begin() {
        TransactionLog transactionLog;
        TransactionLog transactionLog2 = transactionLog = this.visionContext.getTransactionLog();
        synchronized (transactionLog2) {
            if (transactionLog.nestedIndex == Integer.MAX_VALUE) {
                return 0;
            }
            ++transactionLog.nestedIndex;
            if (transactionLog.nestedIndex == 1) {
                transactionLog.init();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commit(int ctx) {
        TransactionLog transactionLog;
        TransactionLog transactionLog2 = transactionLog = this.visionContext.getTransactionLog();
        synchronized (transactionLog2) {
            if (transactionLog.nestedIndex > 0) {
                --transactionLog.nestedIndex;
                if (transactionLog.nestedIndex == 0) {
                    int[] fileIds;
                    boolean success = true;
                    for (int fileId : fileIds = transactionLog.getPostponedCloseList()) {
                        if (this.visionFactory.close(fileId, null)) continue;
                        success = false;
                    }
                    transactionLog.clear();
                    return success ? 1 : 0;
                }
            }
            transactionLog.nestedIndex = 0;
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int rollback() {
        TransactionLog transactionLog;
        TransactionLog transactionLog2 = transactionLog = this.visionContext.getTransactionLog();
        synchronized (transactionLog2) {
            if (transactionLog.nestedIndex > 0) {
                --transactionLog.nestedIndex;
                if (transactionLog.nestedIndex == 0) {
                    int[] fileIds;
                    boolean success = true;
                    block8: for (TransactionLogEntry entry = transactionLog.getLast(); success && entry != null; entry = entry.getPrev()) {
                        switch (entry.getType()) {
                            case 2: {
                                success = this.visionFactory.write(entry.getFileId(), entry.getRecord(), entry.getSize(), null);
                                continue block8;
                            }
                            case 0: {
                                success = this.visionFactory.delete(entry.getFileId(), entry.getRecord(), null);
                                continue block8;
                            }
                            case 1: {
                                success = this.visionFactory.rewrite(entry.getFileId(), entry.getRecord(), entry.getSize(), null);
                            }
                        }
                    }
                    for (int fileId : fileIds = transactionLog.getPostponedCloseList()) {
                        this.visionFactory.close(fileId, null);
                    }
                    transactionLog.clear();
                    return success ? 1 : 0;
                }
            }
            transactionLog.nestedIndex = 0;
            return 1;
        }
    }

    @Override
    public int recover() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCurrentRecord(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCurrentRecord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumKeys() {
        return this.fileInfo.getNumKeys();
    }

    @Override
    public int getMaxRecordSize() {
        return this.fileInfo.getMaxRecSize();
    }

    @Override
    public int getMinRecordSize() {
        return this.fileInfo.getMinRecSize();
    }

    @Override
    public KeyDescription getKey(int index) {
        if (index < 0 || index >= this.fileInfo.getNumKeys()) {
            return null;
        }
        KeyInfo keyInfo = this.fileInfo.getKey(index);
        KeyDescription tmp = new KeyDescription(keyInfo.getSegments(), keyInfo.isDuplicate());
        for (int i = 0; i < keyInfo.getSegments(); ++i) {
            tmp.segment[i].offset = keyInfo.getOffset(i);
            tmp.segment[i].size = keyInfo.getSize(i);
        }
        return tmp;
    }

    @Override
    public long getNumRecords() {
        this.fileInfo = this.visionFactory.getFileInfo(this.fileId);
        return this.fileInfo.getTotalRecords();
    }

    @Override
    public byte[] getSequence() {
        return this.visionFactory.info(this.fileId, -5, null);
    }

    static {
        for (ConfigEntry configEntry : Config.ALL_STATIC_ENTRIES) {
            configEntry.parse(com.iscobol.rts.Config.getProperty(".visionj." + configEntry.getName(), null));
        }
        WAIT_TIMEOUT = Config.V_WAIT_TIMEOUT.getIntegerValue();
    }
}

