/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.DictInfo64;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc64;
import IT.picosoft.isam.KeyPart;
import com.iscobol.io.BaseFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;

public class DynamicJIsam
implements DynamicFile,
RuntimeErrorsNumbers,
Cloneable {
    public static final int ISAM_NO_ENCR_KEY = 140;
    private Isam theFile;
    private int openMode = 0;
    private KeyDescription[] keys;
    private KeyDesc64[] isamKeys;
    private int maxRecordSize;
    private int minRecordSize;
    private boolean lockMulti;
    private boolean exclLock;
    private String path = "";
    private int errno;
    private Exception errio;
    private static boolean readLockWait = false;
    private static boolean readLockTest = false;
    private static boolean outLock = Config.getProperty(".file.output_lock", true);
    private static boolean extLock = Config.getProperty(".file.extend_lock", true);

    @Override
    public String getSysErrno() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    @Override
    public String getErrMsg() {
        if (this.errio != null) {
            return this.errio.getMessage();
        }
        return "";
    }

    private static String getEncryptionKey() throws IsamException {
        String Return2 = Config.getProperty(".file.encryption.key", null);
        if (Return2 == null || Return2.length() == 0) {
            throw new IsamException(140, "Missing encryption key");
        }
        return Return2;
    }

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 0: {
                return 0;
            }
            case 100: {
                return 100;
            }
            case 133: {
                return 133;
            }
            case 102: {
                return 102;
            }
            case 104: {
                return 104;
            }
            case 125: {
                return 125;
            }
            case 107: {
                return 107;
            }
            case 106: {
                return 106;
            }
            case 105: {
                return 105;
            }
            case 108: {
                return 108;
            }
            case 111: {
                return 111;
            }
            case 110: {
                return 110;
            }
            case 112: {
                return 112;
            }
            case 127: {
                return 127;
            }
            case 113: {
                return 113;
            }
            case 128: {
                return 128;
            }
            case 116: {
                return 116;
            }
            case 130: {
                return 130;
            }
            case 131: {
                return 131;
            }
            case 126: {
                return 126;
            }
            case 129: {
                return 129;
            }
            case 122: {
                return 122;
            }
            case 132: {
                return 132;
            }
            case 103: {
                return 103;
            }
            case 140: {
                return 149;
            }
        }
        return 134;
    }

    @Override
    public synchronized long getNumRecords() {
        DictInfo64 dict = new DictInfo64();
        try {
            this.theFile.indexInfo(dict);
        }
        catch (IsamException _ex) {
            this.mapError(_ex);
        }
        return dict.di_nrecords64;
    }

    @Override
    public synchronized int getNumKeys() {
        if (this.keys == null) {
            DictInfo64 dict = new DictInfo64();
            try {
                this.theFile.indexInfo(dict);
            }
            catch (IsamException _ex) {
                this.mapError(_ex);
            }
            this.maxRecordSize = this.minRecordSize = dict.di_recsize64;
            this.keys = new KeyDescription[dict.di_nkeys];
            this.isamKeys = new KeyDesc64[dict.di_nkeys];
        }
        return this.keys.length;
    }

    @Override
    public int getMaxRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.maxRecordSize;
    }

    @Override
    public int getMinRecordSize() {
        if (this.keys == null) {
            this.getNumKeys();
        }
        return this.minRecordSize;
    }

    @Override
    public synchronized KeyDescription getKey(int num) {
        KeyDescription Return2;
        if (num >= 0 && num < this.getNumKeys()) {
            if (this.keys[num] == null) {
                this.isamKeys[num] = new KeyDesc64();
                try {
                    this.theFile.indexInfo(this.isamKeys[num], num + 1);
                }
                catch (IsamException _ex) {
                    this.mapError(_ex);
                }
                this.keys[num] = new KeyDescription(this.isamKeys[num].k_nparts, (this.isamKeys[num].k_flags & 1) == 1);
                for (int i = 0; i < this.isamKeys[num].k_nparts; ++i) {
                    this.keys[num].setSegment(i, this.isamKeys[num].k_part[i].kp_leng, this.isamKeys[num].k_part[i].kp_start);
                }
            }
            Return2 = this.keys[num];
        } else {
            Return2 = null;
            this.mapError(new IsamException(102));
        }
        return Return2;
    }

    @Override
    public byte[] getSequence() {
        byte[] Return2;
        try {
            Return2 = this.theFile.getCollatingSequence();
        }
        catch (IsamException _ex) {
            Return2 = null;
            this.mapError(_ex);
        }
        return Return2;
    }

    private KeyDesc64 findKey(int num) {
        this.getKey(num);
        return this.isamKeys[num];
    }

    private KeyDesc64 findKey(KeyDescription key) {
        int nKeys = this.getNumKeys();
        try {
            for (int i = 0; i < nKeys; ++i) {
                if (!key.equals(this.getKey(i))) continue;
                return this.isamKeys[i];
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private int mapError(IsamException ex) {
        this.errno = ex.getIserrno();
        this.errio = ex.getIserrio();
        return 0;
    }

    int mapOpen(int mode, int lockType) {
        int Return2;
        switch (mode) {
            default: {
                Return2 = 0;
                break;
            }
            case 2: {
                Return2 = 1;
                break;
            }
            case 3: 
            case 6: {
                Return2 = 2;
            }
        }
        switch (lockType & 0xF) {
            default: {
                Return2 |= 0x400;
                break;
            }
            case 1: 
            case 6: {
                Return2 |= 0x800;
                this.exclLock = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Return2 |= 0x400;
            }
        }
        if ((lockType & 0x100) != 0 && (Return2 & 0x800) == 0) {
            this.lockMulti = true;
            Return2 |= 0x400;
        }
        if ((lockType & 0x800) != 0) {
            Return2 |= 4;
        }
        return Return2;
    }

    @Override
    public int build(String path, String comment, int blockingFactor, int preAllocate, int extensionFactor, int compressionFactor, int encryptionFlag, int maxRecordSize, int minRecordSize, KeyDescription[] keys, byte[] collating, boolean assignExt) {
        int Return2;
        int i;
        if (maxRecordSize == 0) {
            throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
        }
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        KeyDesc64 kdi = new KeyDesc64();
        if (keys != null && keys.length > 0 && keys[0] != null) {
            kdi.k_flags = keys[0].isDup() ? (short)1 : 0;
            kdi.k_nparts = (short)keys[0].getNumSegments();
            for (i = 0; i < kdi.k_nparts && i < 16; ++i) {
                kdi.k_part[i] = new KeyPart();
                kdi.k_part[i].kp_leng = (short)keys[0].segment[i].size;
                kdi.k_part[i].kp_start = (short)keys[0].segment[i].offset;
                kdi.k_part[i].kp_type = 0;
            }
        } else {
            kdi.k_flags = 0;
            kdi.k_nparts = 0;
        }
        Isam rc = null;
        String encrKey = null;
        try {
            if (encryptionFlag != 0) {
                encrKey = DynamicJIsam.getEncryptionKey();
                rc = Isam.open(path, 2050, encrKey);
            } else {
                rc = Isam.open(path, 2050);
            }
            Isam.erase(path);
            rc.close();
        }
        catch (IsamException _ex) {
            switch (_ex.getIserrno()) {
                case 133: {
                    if (rc != null) {
                        try {
                            rc.close();
                            Isam.erase(path);
                            break;
                        }
                        catch (IsamException __ex) {
                            return this.mapError(__ex);
                        }
                    }
                    return this.mapError(_ex);
                }
                case 130: {
                    if (rc != null) break;
                    try {
                        Isam.erase(path);
                    }
                    catch (IsamException isamException) {}
                    break;
                }
                case 105: {
                    try {
                        Isam.erase(path);
                    }
                    catch (IsamException isamException) {}
                    break;
                }
                default: {
                    return this.mapError(_ex);
                }
            }
        }
        try {
            rc = Config.getProperty(".jisam.version", 2) == 1 ? Isam.buildNodeSize(path, maxRecordSize, kdi, 2049, (short)0, (short)0, 1) : (encryptionFlag != 0 ? Isam.build(path, maxRecordSize, kdi, 2049, collating, encrKey) : Isam.build(path, maxRecordSize, kdi, 2049, collating));
            if (keys != null && keys.length > 1) {
                for (int j = 1; j < keys.length; ++j) {
                    if (keys[j] == null) continue;
                    kdi.k_flags = keys[j].isDup() ? (short)1 : 0;
                    kdi.k_nparts = (short)keys[j].getNumSegments();
                    for (i = 0; i < kdi.k_nparts && i < 16; ++i) {
                        kdi.k_part[i] = new KeyPart();
                        kdi.k_part[i].kp_leng = (short)keys[j].segment[i].size;
                        kdi.k_part[i].kp_start = (short)keys[j].segment[i].offset;
                        kdi.k_part[i].kp_type = 0;
                    }
                    rc.addindex(kdi);
                }
            }
            rc.close();
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public synchronized int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        int Return2;
        boolean encrypted;
        boolean bl = encrypted = (lockType & 0x1000) != 0;
        if (assignExt) {
            path = BaseFile.expandFileName(path);
        }
        if (openType == 2 && outLock) {
            lockType = 1;
        } else if (openType == 6 && extLock) {
            lockType = 1;
        }
        switch (openType) {
            case 2: 
            case 6: {
                lockType = 1;
            }
            case 1: 
            case 3: {
                try {
                    this.theFile = encrypted ? Isam.open(path, this.mapOpen(openType, lockType), !Config.getProperty(".jisam.autolock_allowed", false), DynamicJIsam.getEncryptionKey()) : Isam.open(path, this.mapOpen(openType, lockType), !Config.getProperty(".jisam.autolock_allowed", false));
                    Return2 = 1;
                    this.openMode = openType;
                    this.path = path;
                }
                catch (IsamException _ex) {
                    Return2 = this.mapError(_ex);
                }
                break;
            }
            default: {
                throw new IscobolRuntimeException(3, new IllegalArgumentException("OPEN").toString());
            }
        }
        return Return2;
    }

    @Override
    public synchronized void setCurrentRecord(long nRec) {
        this.theFile.setRecNum((int)nRec);
    }

    @Override
    public synchronized long getCurrentRecord() {
        return this.theFile.getRecNum();
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public synchronized int close() {
        int Return2;
        if (this.theFile != null) {
            try {
                this.theFile.close();
                Return2 = 1;
                this.theFile = null;
                this.keys = null;
                this.openMode = 0;
                this.path = "";
            }
            catch (IsamException _ex) {
                Return2 = this.mapError(_ex);
            }
        } else {
            Return2 = 1;
        }
        return Return2;
    }

    @Override
    public boolean isOpen() {
        return this.openMode != 0;
    }

    @Override
    public synchronized long write(byte[] record, int offs, int size, boolean lock) {
        int Return2;
        this.errno = 0;
        try {
            this.theFile.write(record, offs);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public synchronized long rewrite(byte[] record, int offs, int size, boolean lock) {
        int Return2;
        this.errno = 0;
        try {
            this.theFile.rewrite(record, offs);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public synchronized long delete(byte[] record, int offs) {
        int Return2;
        try {
            this.theFile.delete(record, offs);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    private synchronized int setLock(int mode, int lock) throws IsamException {
        int Return2 = mode;
        if (lock > 0 && !this.exclLock) {
            Return2 |= 0x100;
            if (!this.lockMulti) {
                this.theFile.release();
            }
        }
        if (lock > 0 && (readLockWait || lock == 3)) {
            Return2 |= 0x1000;
        }
        if (lock == 0 && readLockTest) {
            Return2 |= 0x2000;
            Return2 |= 0x100;
        }
        return Return2;
    }

    @Override
    public synchronized long next(byte[] record, int offs, int lock) {
        int Return2;
        this.errno = 0;
        try {
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            this.theFile.read(record, offs, this.setLock(2, lock));
            Return2 = this.getMaxRecordSize();
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public synchronized long previous(byte[] record, int offs, int lock) {
        int Return2;
        this.errno = 0;
        try {
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            this.theFile.read(record, offs, this.setLock(3, lock));
            Return2 = this.getMaxRecordSize();
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    private synchronized int read(byte[] record, int offs, KeyDesc64 key, int lock) {
        int Return2;
        this.errno = 0;
        try {
            this.theFile.start(key, 0, record, offs, 5);
            if (!this.exclLock && !this.lockMulti) {
                this.theFile.release();
            }
            this.theFile.read(record, offs, this.setLock(2, lock));
            Return2 = this.getMaxRecordSize();
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        return this.read(record, offs, this.findKey(keyNum), lock);
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        return this.read(record, offs, this.findKey(key), lock);
    }

    private synchronized int start(byte[] record, int offs, KeyDesc64 key, int kSize, int mode) {
        int Return2;
        try {
            switch (mode) {
                case 0: {
                    this.theFile.start(key, kSize, record, offs, 0);
                    break;
                }
                case 1: {
                    this.theFile.start(key, kSize, record, offs, 1);
                    break;
                }
                case 5: {
                    this.theFile.start(key, kSize, record, offs, 5);
                    break;
                }
                case 6: {
                    this.theFile.start(key, kSize, record, offs, 6);
                    break;
                }
                case 7: {
                    this.theFile.start(key, kSize, record, offs, 7);
                    break;
                }
                case 8: {
                    this.theFile.start(key, kSize, record, offs, 8);
                    break;
                }
                case 9: {
                    this.theFile.start(key, kSize, record, offs, 9);
                    break;
                }
                default: {
                    throw new IscobolRuntimeException(3, new IllegalArgumentException("START").toString());
                }
            }
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        return this.start(record, offs, this.findKey(kNum), kSize, mode);
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, this.findKey(k), kSize, mode);
    }

    @Override
    public synchronized int unlock() {
        int Return2;
        try {
            this.theFile.release();
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public synchronized int recover() {
        int Return2;
        try {
            this.theFile.rebuild();
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public void sync(int allFiles) {
    }

    @Override
    public int remove(String name) {
        int Return2;
        try {
            Isam.erase(name);
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public int rename(String src, String dst) {
        int Return2;
        try {
            Isam.rename(src, dst);
            Return2 = 1;
        }
        catch (IsamException _ex) {
            Return2 = this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public int begin() {
        return 1;
    }

    @Override
    public int commit(int ctx) {
        return 1;
    }

    @Override
    public int rollback() {
        return 1;
    }

    @Override
    public String getVersion() {
        return Isam.version();
    }

    @Override
    public boolean isKeySelectedByNum() {
        return false;
    }

    public void finalize() {
        this.close();
    }

    static {
        if (Config.getProperty(".file.index.lock_wait", false)) {
            readLockWait = true;
        }
        if (Config.getProperty(".file.index.read_lock_test", false)) {
            readLockTest = true;
        }
        if (Config.getProperty(".file.index.lock_read_anyhow", false)) {
            Isam.LOCK_READ_ANYHOW = true;
        }
        Isam.setFileNameExtension(Config.getProperty(".file.index.data_suffix", null), Config.getProperty(".file.index.index_suffix", null));
    }
}

