/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.invoke;

import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.java.IsCobol;
import com.iscobol.java.StopRunAsException;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.CoverageFactory;
import com.iscobol.rts.DumpCreator;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICoverage;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.LayoutExceptionCobol;
import com.iscobol.rts.LicenseCheck;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.Version;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.UIManager;

public class Isrun {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final String usage = "usage:" + eol + "<command> [--system | --metal | --motif | --GTK | --nimbus] [-utility] [-update] [-uc updater-conf-file] [-c conf-file | -conly conf-file] [-d run with debugger] [-t run for terminal] progname [arg1 [arg2] ...]" + eol + "<command> [--system | --metal | --motif | --GTK | --nimbus] [-update] [-uc updater-conf-file] [-c conf-file | -conly conf-file] [-t run for terminal] [-coverage | -profile] progname [arg1 [arg2] ...]" + eol + "<command> [--system | --metal | --motif | --GTK | --nimbus] [-update] [-uc updater-conf-file] [-c conf-file | -conly conf-file] [-t run for terminal] [-coverage | -profile] -iut" + eol + "<command> -joe [--system | --metal | --motif | --GTK | --nimbus] [-c conf-file | -conly conf-file] joescript [arg1 [arg2] ...]" + eol + "<command> [-d] -r [hostname portnumber] run with remote debugger" + eol + "<command> -v print version number" + eol + "<command> -vv print runtime and file handler version number" + eol + "<command> -info progname" + eol + "<command> -license" + eol + "<command> -help print usage";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) {
        boolean runWithDebugger = false;
        boolean runWithConfig = false;
        boolean runWithRemoteDebugger = false;
        boolean runWithCharva = false;
        boolean update = false;
        boolean unitTest = false;
        boolean coverage = false;
        boolean profile = false;
        boolean isUtility = false;
        boolean joe = false;
        boolean isCp = false;
        int errs = 0;
        String lookAndFeel = null;
        String updaterPropFileName = null;
        String[] propNames = new String[]{"iscobol.default_program", "iscobol.default_options"};
        String[] defs = new String[3];
        String[] propValues = Config.getPropertiesSeparateThread(propNames, defs);
        String defaultPrg = propValues[0];
        String defaultOpts = propValues[1];
        if (defaultOpts != null) {
            String[] ss = RtsUtil.parseArguments(defaultOpts);
            String[] newArgs = new String[ss.length + argv.length];
            System.arraycopy(ss, 0, newArgs, 0, ss.length);
            System.arraycopy(argv, 0, newArgs, ss.length, argv.length);
            argv = newArgs;
        }
        String configFile = null;
        for (int i = 0; i < argv.length; ++i) {
            boolean[] get;
            boolean getProps;
            if ((argv[i].equalsIgnoreCase("-c") || argv[i].equalsIgnoreCase("-conly")) && argv.length > i + 1) {
                File file;
                if (!((file = new File(configFile = argv[++i])).exists() && file.isFile() && file.canRead())) {
                    FileNotFoundException ex = new FileNotFoundException(configFile);
                    Isrun.showErrorBox(ex, isCp);
                    System.exit(1);
                }
                if (argv[i - 1].equalsIgnoreCase("-conly")) {
                    System.setProperty("iscobol.conf.only", configFile);
                } else {
                    System.setProperty("iscobol.conf", configFile);
                }
                getProps = false;
                get = new boolean[propValues.length];
            } else {
                if (!argv[i].startsWith("-")) break;
                continue;
            }
            for (int j = 0; j < propValues.length; ++j) {
                get[j] = propValues[j] == null;
                if (get[j]) {
                    getProps = true;
                    continue;
                }
                propNames[j] = null;
            }
            if (!getProps) break;
            propValues = Config.getPropertiesSeparateThread(propNames, defs);
            if (get[0]) {
                defaultPrg = propValues[0];
            }
            if (!get[1] || (defaultOpts = propValues[1]) == null) break;
            String[] ss = RtsUtil.parseArguments(defaultOpts);
            String[] newArgs = new String[ss.length + argv.length];
            System.arraycopy(ss, 0, newArgs, 0, ss.length);
            System.arraycopy(argv, 0, newArgs, ss.length, argv.length);
            argv = newArgs;
            break;
        }
        String prg = null;
        int prgIdx = -1;
        int fontHandling = 0;
        try {
            fontHandling = Integer.parseInt(System.getProperty("iscobol.font.handling", "0"));
        }
        catch (NumberFormatException get) {
            // empty catch block
        }
        switch (fontHandling) {
            case 1: {
                System.setProperty("awt.useSystemAAFontSettings", "on");
                break;
            }
            case 2: {
                System.setProperty("awt.useSystemAAFontSettings", "off");
                break;
            }
        }
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            UIManager.getDefaults().put("Button.showMnemonics", Boolean.TRUE);
        }
        if (argv.length == 0 && defaultPrg == null) {
            SwingErrorBox.message("Usage", usage, true);
            System.exit(1);
        }
        try {
            block21: for (int i = 0; i < argv.length; ++i) {
                UIManager.LookAndFeelInfo[] lafs;
                if (runWithRemoteDebugger && argv[i].startsWith("-") && !argv[i].equalsIgnoreCase("-d")) {
                    SwingErrorBox.message("Command line error: " + argv[i], usage, false);
                    System.exit(1);
                }
                if (prg == null && (argv[i].equalsIgnoreCase("-c") || argv[i].equalsIgnoreCase("-conly")) && argv.length > i + 1) {
                    if (runWithConfig) {
                        SwingErrorBox.message("Command line error: " + argv[i], usage, false);
                        System.exit(1);
                    }
                    runWithConfig = true;
                    ++i;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--system") && prg == null) {
                    lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--metal") && prg == null) {
                    lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--motif") && prg == null) {
                    lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--GTK") && prg == null) {
                    lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                    continue;
                }
                if (argv[i].equalsIgnoreCase("--nimbus") && prg == null) {
                    lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                    lafs = UIManager.getInstalledLookAndFeels();
                } else {
                    if (argv[i].equalsIgnoreCase("-joe") && prg == null) {
                        joe = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-update") && prg == null) {
                        update = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-coverage") && prg == null) {
                        if (profile) {
                            SwingErrorBox.message("-coverage and -profiler can't be used together", usage, false);
                            System.exit(1);
                        }
                        coverage = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-profile") && prg == null) {
                        if (coverage) {
                            SwingErrorBox.message("-coverage and -profiler can't be used together", usage, false);
                            System.exit(1);
                        }
                        profile = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-iut") && prg == null) {
                        unitTest = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-uc") && argv.length > i + 1 && prg == null) {
                        File file;
                        if ((file = new File(updaterPropFileName = argv[++i])).exists() && file.isFile() && file.canRead()) continue;
                        FileNotFoundException ex = new FileNotFoundException(updaterPropFileName);
                        Isrun.showErrorBox(ex, isCp);
                        System.exit(1);
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-noupdate") && prg == null) {
                        update = false;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-utility")) {
                        isUtility = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-d") && prg == null) {
                        runWithDebugger = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-r") && prg == null) {
                        runWithRemoteDebugger = true;
                        runWithDebugger = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-t") && prg == null) {
                        System.setProperty("iscobol.guifactory.class", "com.iscobol.gui.client.charva.GuiFactoryImpl");
                        System.setProperty("charva.color", "1");
                        runWithCharva = true;
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-help") && prg == null) {
                        Config.markNoIscobolRuntimeThread();
                        SwingErrorBox.message("Help", usage, true);
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-v") && prg == null) {
                        Config.markNoIscobolRuntimeThread();
                        SwingErrorBox.message(RuntimeProperties.getFullVersionNumber(), Isrun.getFullVersion(false), true);
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-vv") && prg == null) {
                        Config.markNoIscobolRuntimeThread();
                        SwingErrorBox.message(RuntimeProperties.getFullVersionNumber(), Isrun.getFullVersion(true), true);
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-license") && prg == null) {
                        Config.markNoIscobolRuntimeThread();
                        Isrun.licCheck();
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equalsIgnoreCase("-info") && prg == null) {
                        Config.markNoIscobolRuntimeThread();
                        Isrun.info(argv[i + 1]);
                        System.exit(0);
                        continue;
                    }
                    if (argv[i] != null) {
                        if (prg == null && !argv[i].startsWith("-")) {
                            if (runWithRemoteDebugger) {
                                prg = "-r";
                            } else {
                                if (argv[i].endsWith(".class")) {
                                    argv[i] = argv[i].substring(0, argv[i].length() - 6);
                                }
                                prg = argv[i];
                            }
                            prgIdx = i;
                        }
                        if (prg != null || defaultPrg != null || !argv[i].startsWith("-") || !joe && runWithDebugger) continue;
                        SwingErrorBox.message("Command line error: " + argv[i], usage, false);
                        System.exit(1);
                        continue;
                    }
                    SwingErrorBox.message("Command line error: " + argv[i], usage, false);
                    System.exit(1);
                    continue;
                }
                for (int y = 0; y < lafs.length; ++y) {
                    if (!"Nimbus".equals(lafs[y].getName())) continue;
                    lookAndFeel = lafs[y].getClassName();
                    continue block21;
                }
            }
        }
        catch (Exception e) {
            SwingErrorBox.message("Command line error: " + e.getMessage(), e);
            System.exit(1);
        }
        if (joe && (runWithDebugger || runWithCharva || isUtility || update)) {
            SwingErrorBox.message("Command line error", usage, false);
            System.exit(1);
        }
        if ((coverage || profile) && (runWithDebugger || isUtility)) {
            SwingErrorBox.message("Command line error", usage, false);
            System.exit(1);
        }
        if (runWithDebugger || runWithRemoteDebugger) {
            Config.markNoIscobolRuntimeThread();
        }
        if (prg == null) {
            if (runWithRemoteDebugger) {
                prg = "-r";
            } else if (defaultPrg == null && !joe && !unitTest) {
                SwingErrorBox.message("Command line error", usage, false);
                System.exit(1);
            }
        }
        if (System.getProperty("swing.defaultlaf") == null && lookAndFeel != null) {
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception e) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Exception file) {
                    // empty catch block
                }
            }
        }
        if (update) {
            try {
                if (Factory.launchSoftwareUpdater(null, Isrun.class.getName(), argv, false, updaterPropFileName)) {
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        String prg0 = prg;
        if (runWithDebugger) {
            prg = "com.iscobol.debugger.GraphDebugger";
        }
        if (joe) {
            if (prg != null) {
                args.add(prg);
            }
            prg = "com.iscobol.cobshell.CobShell";
        }
        if (runWithDebugger && !runWithRemoteDebugger) {
            if (lookAndFeel != null) {
                args.add("-Dswing.defaultlaf=" + lookAndFeel);
            }
            if (configFile != null) {
                args.add("-Discobol.conf=" + configFile);
            }
            if (runWithCharva) {
                args.add("-Discobol.guifactory.class=com.iscobol.gui.client.charva.GuiFactoryImpl");
                args.add("-Dcharva.color=1");
            }
        }
        for (int i = 0; i < argv.length; ++i) {
            if (i < prgIdx) {
                if (argv[i].equalsIgnoreCase("-c") || argv[i].equalsIgnoreCase("-conly")) {
                    ++i;
                    continue;
                }
                if (argv[i].equalsIgnoreCase("-d") || argv[i].equalsIgnoreCase("-t") || argv[i].equalsIgnoreCase("--system") || argv[i].equalsIgnoreCase("--metal") || argv[i].equalsIgnoreCase("--motif") || argv[i].equalsIgnoreCase("--nimbus") || argv[i].equalsIgnoreCase("--GTK") || !runWithDebugger) continue;
                args.add(argv[i]);
                continue;
            }
            if (runWithRemoteDebugger) {
                if (!argv[i].equalsIgnoreCase("-r") && (prgIdx < 0 || prgIdx > i)) continue;
                args.add(argv[i]);
                continue;
            }
            if (!runWithDebugger && (prgIdx < 0 || prgIdx >= i)) continue;
            args.add(argv[i]);
        }
        try {
            String codePrefix;
            String[] ss;
            if (prg == null && defaultPrg != null) {
                String[] ss0 = RtsUtil.parseArguments(defaultPrg);
                prg = ss0[0];
                ss = new String[ss0.length - 1];
                System.arraycopy(ss0, 1, ss, 0, ss.length);
            } else if (prg0 == null && defaultPrg != null) {
                ss = RtsUtil.parseArguments(defaultPrg);
            } else {
                ss = new String[args.size()];
                args.toArray(ss);
            }
            String string = codePrefix = joe || runWithDebugger ? null : Config.getProperty("iscobol.code_prefix", null);
            if (unitTest) {
                errs = Isrun.unitTest(coverage, profile, isCp, isUtility, codePrefix, ss);
            } else {
                Isrun.setCoverage(prg, coverage, profile);
                Class cl = joe || runWithDebugger ? Class.forName(prg) : Isrun.loadClass(codePrefix, prg, isUtility);
                isCp = Isrun.isCp(cl);
                Method mt = cl.getMethod("main", String[].class);
                mt.invoke(null, new Object[]{ss});
            }
        }
        catch (NoSuchMethodException e) {
            Isrun.showErrorBox(e, isCp);
            System.exit(2);
        }
        catch (ClassNotFoundException e) {
            SwingErrorBox.message("Cannot load program", "Cannot load program '" + prg + "'", false);
            System.exit(2);
        }
        catch (InvocationTargetException e) {
            Isrun.showErrorBox(e.getCause() != null ? e.getCause() : e, isCp);
            System.exit(2);
        }
        catch (IllegalAccessException e) {
            Isrun.showErrorBox(e, isCp);
            System.exit(2);
        }
        if (unitTest) {
            System.exit(errs);
        }
    }

    private static String getFullVersion(boolean vv) {
        String infolic = Config.getProperty("iscobol.licinfo", "Missing license!");
        String exdate = infolic.substring(infolic.length() - 8).equals("99991231") ? "None" : infolic.substring(infolic.length() - 8);
        int chr = 95;
        int indexChr = 0;
        if (infolic.substring(infolic.lastIndexOf(47)).indexOf(95) >= 0 || infolic.substring(infolic.lastIndexOf(47)).indexOf(64) >= 0) {
            if (infolic.substring(infolic.lastIndexOf(47)).indexOf(64) >= 0) {
                chr = 64;
            }
            indexChr = infolic.lastIndexOf(47);
            indexChr += infolic.substring(infolic.lastIndexOf(47)).indexOf(chr);
            infolic = infolic.substring(0, indexChr) + infolic.substring(infolic.length() - 8);
        }
        String[] licid = infolic.substring(0, infolic.length() - 8).split("(##)");
        if (infolic.substring(infolic.lastIndexOf(47)).indexOf(95) >= 0 || infolic.substring(infolic.lastIndexOf(47)).indexOf(64) >= 0) {
            licid[1] = licid[1].substring(0, licid[1].indexOf(chr) + 1);
        }
        String Return2 = null;
        String fileHandlerVersion = "";
        if (vv) {
            fileHandlerVersion = "DB " + Config.getProperty(".file.index.version", "version unknown") + eol;
        }
        Return2 = RuntimeProperties.getFullVersionNumber() + eol + RuntimeProperties.getProductCopyright() + eol + fileHandlerVersion + "C/S version: " + "96" + ", F/S version: " + "19" + ", UID version: " + Version.getUIDVersion() + eol + eol + "Company : " + licid[0] + eol + "License ID: ";
        Return2 = licid.length > 1 ? Return2 + licid[1] + eol : Return2 + "Missing" + eol;
        Return2 = Return2 + "Expiration Date: " + exdate + eol + eol + "Default Java used:" + eol + " version: " + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + eol + " home: " + System.getProperty("java.home") + eol + " arch: " + System.getProperty("sun.arch.data.model") + " bit";
        return Return2;
    }

    public static void licCheck() {
        int dispMessage;
        if (GraphicsEnvironment.isHeadless()) {
            dispMessage = 1;
        } else {
            try {
                dispMessage = Integer.parseInt(System.getProperty("iscobol.display_message", "0"));
            }
            catch (Exception ex) {
                dispMessage = 0;
            }
        }
        ArrayList msgs = LicenseCheck.doCheck();
        String title = msgs.get(0).toString();
        StringBuffer msg = new StringBuffer();
        for (int i = 1; i < msgs.size(); ++i) {
            msg.append(msgs.get(i).toString());
            msg.append(eol);
        }
        SwingErrorBox.message(title, msg.toString(), "Information", "Inform.gif", dispMessage);
    }

    public static void info(String prg) {
        String codePrefix = Config.getProperty("iscobol.code_prefix", null);
        if (prg != null) {
            try {
                if (prg.endsWith(".class")) {
                    prg = prg.substring(0, prg.length() - 6);
                }
                Class clazz = Isrun.loadClass(codePrefix, prg, false);
                System.out.println(Factory.info(clazz));
            }
            catch (ClassNotFoundException _ex) {
                System.out.println(prg + ": Unknown file type");
            }
            catch (InstantiationException _ex) {
                System.out.println(prg + ": Unknown file type");
            }
            catch (IllegalAccessException _ex) {
                System.out.println(prg + ": Unknown file type");
            }
            catch (NoSuchMethodError _ex) {
                System.out.println(prg + ": java OBJECTs");
            }
            System.exit(0);
        } else {
            System.out.println("usage: isrun -info CLASS_NAME[.class]");
            System.exit(2);
        }
    }

    private static Class loadClass(String codePrefix, String progName, boolean isUtility) throws ClassNotFoundException {
        try {
            return Isrun.loadClass0(codePrefix, progName, isUtility);
        }
        catch (Throwable ex) {
            return Isrun.loadClass0(codePrefix, Factory.prepareCallName(progName), isUtility);
        }
    }

    private static Class loadClass0(String codePrefix, String progName, boolean isUtility) throws ClassNotFoundException {
        if (isUtility) {
            progName = "com.iscobol.lib." + progName;
        }
        if (progName.indexOf(46) < 0 && codePrefix != null && codePrefix.length() > 0) {
            return CallLoader.getInstance(codePrefix).loadClass(progName);
        }
        return Factory.classForName(progName);
    }

    private static void showErrorBox(Throwable ex, boolean isCp) {
        if (isCp) {
            com.iscobol.rts_n.ErrorBox.show(ex);
        } else {
            ErrorBox.show(ex);
        }
    }

    private static boolean isCp(Class cls) {
        try {
            String[] compFlags;
            Field f = cls.getField("$comp_flags$");
            for (String opt : compFlags = (String[])f.get(null)) {
                if (!"-cp".equals(opt)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static int unitTest(boolean coverage, boolean profile, boolean isCp, boolean isUtility, String codePrefix, String[] ss) {
        String nameList = Config.getProperty("iscobol.unit_test.list_file", "");
        String xmlFile = Config.getProperty("iscobol.unit_test.xml", null);
        String htmlDir = coverage ? Config.getProperty("iscobol.coverage.html", null) : Config.getProperty("iscobol.unit_test.html", null);
        if (htmlDir == null && xmlFile == null) {
            htmlDir = "./htmlReport";
        }
        String[] nameFI = nameList.split(";");
        BufferedReader finp = null;
        String prg = "isCobolProgName";
        StringBuffer buf = new StringBuffer();
        String err = "";
        long totalTime = 0L;
        int nPrg = 0;
        int nPrgS = 0;
        Isrun.xmlHeader(buf, nameFI.length);
        boolean htmlDirExists = true;
        IscobolSystem.setUnitTest(true);
        Isrun.setCoverage(prg, coverage, profile);
        Thread.currentThread().getContextClassLoader().setDefaultAssertionStatus(true);
        for (int i = 0; i < nameFI.length; ++i) {
            File outD;
            StringBuffer htmlBuf = new StringBuffer();
            if (htmlDir != null) {
                Isrun.htmlHeader(htmlBuf, nameFI[i], htmlDir, coverage);
            }
            buf.append("   <test name='" + nameFI[i] + "'>" + eol);
            prg = null;
            try {
                finp = new BufferedReader(new FileReader(nameFI[i]));
                prg = finp.readLine();
                nPrg = 0;
                nPrgS = 0;
                int numRow = 0;
                long millis = 0L;
                DumpCreator dc = new DumpCreator();
                while (prg != null) {
                    if (prg.length() > 0 && prg.charAt(0) != '#') {
                        PrintWriter pw;
                        StringWriter sw;
                        LayoutExceptionCobol lec;
                        ++nPrg;
                        try {
                            Class cl = Isrun.loadClass(codePrefix, prg, isUtility);
                            isCp = Isrun.isCp(cl);
                            millis = System.currentTimeMillis();
                            if (isCp) {
                                IsCobol.callNoStop(prg, IsCobol.NOARGS_CP);
                            } else {
                                IsCobol.callNoStop(prg, null);
                            }
                            err = "Test successful";
                            ++nPrgS;
                        }
                        catch (StopRunAsException e) {
                            err = "Test successful";
                            ++nPrgS;
                        }
                        catch (AssertionError e) {
                            lec = ((Throwable)((Object)e)).getCause() != null ? new LayoutExceptionCobol(((Throwable)((Object)e)).getCause(), dc) : new LayoutExceptionCobol((Throwable)((Object)e), dc);
                            err = "";
                            sw = new StringWriter();
                            pw = new PrintWriter(sw);
                            if (lec.hasSMAPInfo()) {
                                lec.printStackTrace(pw);
                            } else {
                                err = "<b>" + ((Throwable)((Object)e)).getMessage() + "</b><br> ";
                                ((Throwable)((Object)e)).printStackTrace(pw);
                            }
                            err = err + sw.toString();
                        }
                        catch (ClassNotFoundException e) {
                            err = "Cannot load program";
                        }
                        catch (Exception e) {
                            lec = e.getCause() != null ? new LayoutExceptionCobol(e.getCause(), dc) : new LayoutExceptionCobol(e, dc);
                            err = "<b>Exception</b> ";
                            sw = new StringWriter();
                            pw = new PrintWriter(sw);
                            if (lec.hasSMAPInfo()) {
                                lec.printStackTrace(pw);
                            } else {
                                err = "<b>" + e.getMessage() + "</b><br> ";
                                e.printStackTrace(pw);
                            }
                            err = err + sw.toString();
                        }
                        millis = err.equals("Cannot load program") ? 0L : System.currentTimeMillis() - millis;
                        totalTime += millis;
                        Isrun.xmlRow(buf, prg, err.replace("<b>", "").replace("</b>", "").replace("<br>", ""), millis);
                        if (htmlDir != null) {
                            Isrun.htmlTableRow(htmlBuf, prg, err, htmlDir, coverage, numRow, millis);
                        }
                    }
                    prg = finp.readLine();
                    ++numRow;
                }
            }
            catch (FileNotFoundException e) {
                buf.append("              File not found '" + nameFI[i] + "'" + eol);
            }
            catch (IOException e) {
                buf.append("              Exception IO on '" + nameFI[i] + "'" + eol);
            }
            buf.append("   </test>" + eol);
            Isrun.htmlFoot(htmlBuf, nPrg, nPrgS, totalTime);
            FileOutputStream out = null;
            htmlDirExists = true;
            if (!(htmlDir == null || htmlDir.equals(".") || (outD = new File(htmlDir)) == null || outD.exists() || outD.mkdirs())) {
                System.err.println("Cannot create '" + outD + "'");
                htmlDirExists = false;
            }
            if (htmlDir == null || !htmlDirExists) continue;
            try {
                out = nameFI[i].replace('\\', '/').lastIndexOf(47) >= 0 ? new FileOutputStream(htmlDir + "/" + nameFI[i].replace('\\', '/').substring(nameFI[i].replace('\\', '/').lastIndexOf(47) + 1) + ".html") : new FileOutputStream(htmlDir + "/" + nameFI[i] + ".html");
                out.write(htmlBuf.toString().getBytes());
                out.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!coverage && !profile && htmlDir != null && htmlDirExists) {
            ICoverage cov = CoverageFactory.getCoverageInstance(prg, 1);
            if (cov != null) {
                try {
                    cov.createResources(htmlDir);
                }
                catch (IOException out) {}
            } else {
                System.out.println("Coverage null");
            }
        }
        buf.append("</testUnit>" + eol);
        if (xmlFile != null) {
            FileOutputStream out = null;
            try {
                if (xmlFile.length() != 0) {
                    out = new FileOutputStream(xmlFile);
                    out.write(buf.toString().getBytes());
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nPrg == nPrgS) {
            System.out.println(eol + "All " + nPrg + " tests \"ok\"");
        } else if (nPrgS == 0) {
            System.out.println(eol + "All " + nPrg + " tests \"failed\"");
        } else {
            System.out.println(eol + nPrgS + " of " + nPrg + " tests \"failed\"");
        }
        if (xmlFile != null) {
            System.out.print(", for details see " + xmlFile);
        }
        return nPrg - nPrgS;
    }

    private static void xmlHeader(StringBuffer buf, int num) {
        buf.append("<!-- Generated by " + RuntimeProperties.getFullVersionNumber() + "-->" + eol);
        buf.append("<!-- On " + new Date() + "-->" + eol);
        buf.append("<!-- " + RuntimeProperties.getProductCopyright() + "-->" + eol);
        buf.append("<!-- F/S  version: 19-->" + eol);
        buf.append("<!-- Generated on " + new Date() + "-->" + eol);
        buf.append(eol);
        buf.append("<testUnit numUnit='" + num + "'>" + eol);
    }

    private static void xmlRow(StringBuffer buf, String prg, String err, long millis) {
        buf.append("       <program name='" + prg + "' time ='" + millis + "' test='");
        if (err.equals("Test successful")) {
            buf.append("Success'>" + eol);
        } else if (err.startsWith("Exception ")) {
            buf.append("Error'>" + eol);
        } else {
            buf.append("Failure'>" + eol);
        }
        buf.append("               " + err.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + eol);
        buf.append("       </program>" + eol);
    }

    private static void htmlHeader(StringBuffer htmlBuf, String title, String html, boolean coverage) {
        htmlBuf.append("<html>" + eol);
        htmlBuf.append("  <head>" + eol);
        htmlBuf.append("    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />" + eol);
        htmlBuf.append("    <link rel=\"stylesheet\" href=\"resources/report.css\" type=\"text/css\" />" + eol);
        htmlBuf.append("    <link rel=\"shortcut icon\" href=\"resources/report.gif\" type=\"image/gif\" />" + eol);
        htmlBuf.append("    <script type=\"text/javascript\" src=\"resources/sort.js\"></script>" + eol);
        htmlBuf.append("    <title>" + title + "</title>");
        htmlBuf.append("  </head>" + eol);
        htmlBuf.append("  <body onload=\"initialSort(['breadcrumb'])\">");
        if (coverage) {
            htmlBuf.append("     <h1><center>isCOBOL Unit Testing</center><br><center><a href='index.html'>" + title + "</a></center></h1>" + eol);
        } else {
            htmlBuf.append("     <h1><center>isCOBOL Unit Testing</center><br><center>" + title + "</center></h1>" + eol);
        }
        DateFormat df = DateFormat.getDateTimeInstance(1, 2);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        htmlBuf.append("      <div class=\"el_source_lnk\"><i>Executed " + df.format(cal.getTime()) + "</i></div><br>" + eol);
        htmlBuf.append("     <table class=\"coverage\" cellspacing=\"0\" id=\"coveragetable\">" + eol);
        htmlBuf.append("      <thead>" + eol);
        htmlBuf.append("       <tr>" + eol);
        htmlBuf.append("         <td class=\"sortable\" id=\"a\" onclick=\"toggleSort(this)\">Program</td>" + eol);
        htmlBuf.append("         <td class=\"down sortable bar\" id=\"b\" onclick=\"toggleSort(this)\">Time spent<br>(seconds)</td>" + eol);
        htmlBuf.append("         <td class=\"down sortable bar\" id=\"c\" onclick=\"toggleSort(this)\">Test result</td>" + eol);
        htmlBuf.append("       </tr>" + eol);
        htmlBuf.append("      </thead>" + eol);
        htmlBuf.append("      <tbody style=\"text-align left\">" + eol);
    }

    private static void htmlTableRow(StringBuffer htmlBuf, String prg, String err, String html, boolean coverage, int numRow, long mil) {
        float mils = mil;
        htmlBuf.append("       <tr>" + eol);
        err = err.replaceAll(eol, "<br>&ensp;");
        if (coverage && !err.equals("Cannot load program")) {
            htmlBuf.append("         <td class=\"ctr1\" id=\"a" + numRow + "\"><a href=\"" + prg + ".html\">" + prg + "</a></td>" + eol);
        } else {
            htmlBuf.append("         <td class=\"ctr1\" id=\"a" + numRow + "\">" + prg + "</a></td>" + eol);
            err = "<b>" + err + "</b>";
        }
        htmlBuf.append("         <td class=\"ctr2\" id=\"b" + numRow + "\">" + mils / 1000.0f + "</td>" + eol);
        if (err.equals("Test successful")) {
            htmlBuf.append("         <td class=\"ctr3\" id=\"c" + numRow + "\"><b>" + err + "</b></td>" + eol);
        } else {
            htmlBuf.append("         <td class=\"ctr3\" id=\"c" + numRow + "\">" + err + "</td>" + eol);
        }
        htmlBuf.append("       </tr>" + eol);
    }

    private static void htmlFoot(StringBuffer htmlBuf, int nPrg, int nPrgS, long totalTime) {
        float tot = totalTime;
        htmlBuf.append("      </tbody>" + eol);
        htmlBuf.append("        <tfoot>" + eol);
        htmlBuf.append("          <br><br>" + eol);
        htmlBuf.append("          <tr>" + eol);
        htmlBuf.append("            <td class=\"ctr1\">Total programs " + nPrg + "</td>" + eol);
        htmlBuf.append("            <td class=\"ctr2\">Total time spent " + tot / 1000.0f + "</td>" + eol);
        htmlBuf.append("            <td class=\"ctr3\">Programs with success " + nPrgS + "</td>" + eol);
        htmlBuf.append("          </tr>" + eol);
        htmlBuf.append("        </tfoot>" + eol);
        htmlBuf.append("    </table>" + eol);
        htmlBuf.append("  </body>" + eol);
        htmlBuf.append("</html>" + eol);
    }

    private static void setCoverage(String prg, boolean coverage, boolean profile) {
        if (coverage || profile) {
            ICoverage cov;
            int flags = 0;
            if (coverage) {
                ++flags;
            }
            if (profile) {
                flags += 2;
            }
            if ((cov = CoverageFactory.getCoverageInstance(prg, flags)) != null) {
                cov.startSession();
            }
        }
    }
}

