/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter.xls;

import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlexporter.ss.SSExporter;
import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.misc.export.xls.XLSExportHelper;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class XLSExporter
extends SSExporter {
    public XLSExporter(String reportName, String inputFile, String outFile) {
        super(reportName, inputFile, outFile);
    }

    @Override
    protected void setCellStyleAttrs(CellStyle cellStyle, RptComponent cmp, RptStyle style, String numericFormat) {
        VerticalAlignment verticalAlign = VerticalAlignment.TOP;
        HorizontalAlignment horizontalAlign = HorizontalAlignment.LEFT;
        Font font = this.getFont(cmp.font, cmp.foreground);
        XLSExportHelper ee = (XLSExportHelper)this.exportHelper;
        cellStyle.setFont(font);
        if (!this.ignoreCellBackground) {
            cellStyle.setFillForegroundColor(ee.getColor(cmp.background, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (cmp.inputType != null) {
            cellStyle.setIndention((short)2);
            verticalAlign = VerticalAlignment.CENTER;
        }
        if (cmp.align != null) {
            if (cmp.align.equals("left")) {
                horizontalAlign = HorizontalAlignment.LEFT;
            } else if (cmp.align.equals("right")) {
                horizontalAlign = HorizontalAlignment.RIGHT;
            } else if (cmp.align.equals("center")) {
                horizontalAlign = HorizontalAlignment.CENTER;
            }
        }
        cellStyle.setAlignment(horizontalAlign);
        cellStyle.setVerticalAlignment(verticalAlign);
        if (style.border != null && !this.ignoreCellBorder) {
            BorderStyle border = ee.getBorder(style.border.width);
            if (style.border.color == null) {
                style.border.color = cmp.foreground;
            }
            short colIdx = ee.getColor(style.border.color, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
            if (style.border.top) {
                cellStyle.setBorderTop(border);
                cellStyle.setTopBorderColor(colIdx);
            }
            if (style.border.left) {
                cellStyle.setBorderLeft(border);
                cellStyle.setLeftBorderColor(colIdx);
            }
            if (style.border.right) {
                cellStyle.setRightBorderColor(colIdx);
                cellStyle.setBorderRight(border);
            }
            if (style.border.bottom) {
                cellStyle.setBottomBorderColor(colIdx);
                cellStyle.setBorderBottom(border);
            }
        }
        cellStyle.setWrapText(this.cellWrap);
        cellStyle.setLocked(this.cellLock);
        if (numericFormat != null) {
            cellStyle.setDataFormat(this.exportHelper.getFormat(numericFormat));
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: java com.iscobol.htmlexporter.xls.XLSExporter reportName inputFile outputFile [options]");
            System.exit(1);
        }
        XLSExporter exporter = new XLSExporter(args[0], args[1], args[2]);
        exporter.setupPage(args);
        exporter.export();
        exporter.log();
        exporter.dispose();
        System.out.println("Created file '" + exporter.getOutputFile() + "'");
        System.exit(0);
    }

    @Override
    protected SSExportHelper createExportHelper() {
        return new XLSExportHelper();
    }
}

