/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter;

import com.iscobol.htmlexporter.HTMLNode;
import com.iscobol.htmlexporter.RptBorder;
import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptExporter;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlrenderer.CSSStyle;
import com.iscobol.htmlrenderer.SAHParser;
import com.iscobol.rts.IscobolRuntimeException;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLParser {
    private final Map<String, CSSStyle> styles = new HashMap<String, CSSStyle>();
    private final Stack<HTMLNode> nodeStack = new Stack();

    public void addStyle(CSSStyle style, RptExporter exporter) {
        this.styles.put(style.getName(), style);
        if (exporter != null) {
            RptStyle rptStyle = new RptStyle(style.getName());
            this.addStyleAttributes(style, rptStyle);
            exporter.addStyle(rptStyle);
        }
    }

    public CSSStyle getStyle(String styleName) {
        return this.styles.get(styleName);
    }

    public int parseStream(InputStream in, final RptExporter rptHandler) {
        try {
            new SAHParser(in, null).parse(new DefaultHandler(){
                String text;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    HTMLNode p;
                    HTMLNode n;
                    HTMLNode hTMLNode = n = localName.equals("style") ? new HTMLNodeStyle() : new HTMLNode();
                    if (HTMLParser.this.nodeStack.isEmpty()) {
                        p = null;
                    } else {
                        p = (HTMLNode)HTMLParser.this.nodeStack.peek();
                        p.incChildCount();
                    }
                    n.init(HTMLParser.this, localName, p, attributes);
                    HTMLParser.this.nodeStack.push(n);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (HTMLParser.this.nodeStack.size() > 1) {
                        HTMLNode p = (HTMLNode)HTMLParser.this.nodeStack.pop();
                        if (p instanceof HTMLNodeStyle) {
                            String style = this.text;
                            int len = style.length();
                            for (int i = 0; i < len; ++i) {
                                char c = style.charAt(i);
                                if (c <= ' ') continue;
                                CSSStyle sty = new CSSStyle(style, i);
                                try {
                                    i = sty.parse();
                                    HTMLParser.this.addStyle(sty, rptHandler);
                                    continue;
                                }
                                catch (CSSStyle.BadFormatException _ex) {
                                    _ex.printStackTrace();
                                }
                            }
                        } else if (p.getChildCount() == 0) {
                            for (int i = 1; i < HTMLParser.this.nodeStack.size(); ++i) {
                                HTMLNode pp = (HTMLNode)HTMLParser.this.nodeStack.elementAt(i);
                                if (pp.getComponent() != null) continue;
                                pp.cmp = i > 1 ? new RptComponent(((HTMLNode)HTMLParser.this.nodeStack.get(i - 1)).getComponent(), pp.getName(), pp.getChildCount()) : new RptComponent();
                                HTMLParser.this.analyze(pp, pp.getComponent());
                                if (i == 2 && pp.getName().equals("div")) {
                                    if (rptHandler == null) continue;
                                    rptHandler.newPage();
                                    continue;
                                }
                                if (i == 3 && pp.getName().equals("div")) {
                                    if (rptHandler == null) continue;
                                    pp.getComponent().rptType = "sec";
                                    continue;
                                }
                                if (rptHandler == null) continue;
                                rptHandler.addGroupComponent(pp.getComponent());
                            }
                            HTMLNode pp = (HTMLNode)HTMLParser.this.nodeStack.elementAt(HTMLParser.this.nodeStack.size() - 1);
                            p.cmp = new RptComponent(pp.getComponent(), p.getName(), pp.getChildCount());
                            HTMLParser.this.analyze(p, p.getComponent());
                            if (this.text != null) {
                                p.cmp.text = this.text;
                            }
                            if (rptHandler != null) {
                                rptHandler.addComponent(p.getComponent());
                            }
                        }
                        this.text = null;
                    } else if (HTMLParser.this.nodeStack.isEmpty()) {
                        throw new SAXException("Empty stack! " + localName);
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    String s = new String(ch, start, length).trim();
                    this.text = this.text != null ? this.text + s : s;
                }
            });
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            if (_ex.getException() != null) {
                throw new IscobolRuntimeException(_ex.getException());
            }
            throw new IscobolRuntimeException(_ex);
        }
        try {
            in.close();
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        return 0;
    }

    protected void analyze(HTMLNode n, RptComponent cmp) {
        CSSStyle style;
        String attrVal;
        Attributes attrs = n.getAttributes();
        if (attrs != null && (attrVal = attrs.getValue("class")) != null) {
            style = this.getStyle(attrVal);
            cmp.cssClass = attrVal;
            String[] ss = cmp.cssClass.split("\\-");
            if (ss.length > 1) {
                cmp.rptType = ss[1];
            }
        }
        if (n.getStyle() != null) {
            style = n.getStyle();
            this.addStyleAttributes(style, cmp);
        }
        if (n.getName().equals("a")) {
            attrVal = attrs.getValue("href");
            if (attrVal != null) {
                cmp.hyperlink = attrVal;
            }
        } else if (n.getName().equals("img")) {
            attrVal = attrs.getValue("src");
            if (attrVal != null) {
                cmp.imageFile = attrVal;
            }
        } else if (n.getName().equals("strong")) {
            cmp.font.bold = true;
        } else if (n.getName().equals("em")) {
            cmp.font.italic = true;
        } else if (n.getName().equals("u")) {
            cmp.font.underline = true;
        } else if (n.getName().equals("input")) {
            attrVal = attrs.getValue("type");
            if (attrVal.equals("checkbox")) {
                cmp.inputType = attrs.getValue("checked") != null ? "$CheckedCheckBox$" : "$UncheckedCheckBox$";
            } else {
                attrVal = attrs.getValue("type");
                if (attrVal.equals("radio")) {
                    cmp.inputType = attrs.getValue("checked") != null ? "$CheckedRadioButton$" : "$UncheckedRadioButton$";
                }
            }
        }
    }

    private void addStyleAttributes(CSSStyle style, RptComponent context) {
        Object obj = style.get("top");
        if (obj != null) {
            int y = (Integer)obj;
            context.y = context.name.equals("img") ? y : (context.y += y);
        }
        if ((obj = style.get("left")) != null) {
            int x = (Integer)obj;
            context.x = context.name.equals("img") ? x : (context.x += x);
        }
        if ((obj = style.get("width")) != null) {
            context.width = (Integer)obj;
        }
        if ((obj = style.get("height")) != null) {
            context.height = (Integer)obj;
        }
        if ((obj = style.get("color")) != null) {
            context.foreground = (Color)obj;
        }
        if ((obj = style.get("background-color")) != null && obj != CSSStyle.TRANSPARENT_COLOR) {
            context.background = (Color)obj;
        }
        if ((obj = style.get("text-align")) != null) {
            context.align = (String)obj;
        }
        if ((obj = style.get("letter-spacing")) != null) {
            context.letterSpacing = (String)obj;
        }
        if ((obj = style.get("position")) != null) {
            context.position = (String)obj;
        }
        if ((obj = style.get("font-size")) != null) {
            context.font.size = ((CSSStyle.FontSizePt)obj).getValue().floatValue();
        }
        if ((obj = style.get("font-family")) != null) {
            context.font.family = (String)obj;
        }
    }

    private RptBorder getRptBorder(CSSStyle style) {
        CSSStyle.Border brd;
        RptBorder border = null;
        Object obj = style.get("border");
        if (obj != null) {
            brd = (CSSStyle.Border)obj;
            if (border == null) {
                border = new RptBorder();
            }
            border.color = brd.getColor();
            border.width = brd.getDepth();
        }
        if ((obj = style.get("border-top")) != null) {
            brd = (CSSStyle.Border)obj;
            if (border == null) {
                border = new RptBorder();
            }
            border.color = brd.getColor();
            border.width = brd.getDepth();
            border.top = true;
        }
        if ((obj = style.get("border-left")) != null) {
            brd = (CSSStyle.Border)obj;
            if (border == null) {
                border = new RptBorder();
            }
            border.color = brd.getColor();
            border.width = brd.getDepth();
            border.left = true;
        }
        if ((obj = style.get("border-style")) != null) {
            obj = style.get("border-color");
            if (obj != null) {
                if (border == null) {
                    border = new RptBorder(true, true, true, true);
                }
                border.color = (Color)obj;
            }
            if ((obj = style.get("border-width")) != null) {
                if (border == null) {
                    border = new RptBorder(true, true, true, true);
                }
                border.width = (Integer)obj;
            }
        }
        return border;
    }

    private void addStyleAttributes(CSSStyle style, RptStyle rptStyle) {
        Object obj = style.get("top");
        if (obj != null) {
            rptStyle.y = (Integer)obj;
        }
        if ((obj = style.get("left")) != null) {
            rptStyle.x = (Integer)obj;
        }
        if ((obj = style.get("width")) != null) {
            rptStyle.width = (Integer)obj;
        }
        if ((obj = style.get("height")) != null) {
            rptStyle.height = (Integer)obj;
        }
        rptStyle.border = this.getRptBorder(style);
    }

    public Collection getStyles() {
        return this.styles.values();
    }

    private static class HTMLNodeStyle
    extends HTMLNode {
        private HTMLNodeStyle() {
        }
    }
}

