/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing.treetable;

import com.iscobol.gui.client.swing.treetable.AbstractCellEditor;
import com.iscobol.gui.client.swing.treetable.TreeTableCellRenderer;
import com.iscobol.gui.client.swing.treetable.TreeTableModel;
import com.iscobol.gui.client.swing.treetable.TreeTableModelAdapter;
import com.iscobol.gui.client.swing.treetable.TreeTableModelExt;
import com.iscobol.gui.client.swing.treetable.TreeTableMouseEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel treeTableModel) {
        this(null, treeTableModel);
    }

    public JTreeTable(TreeTableCellRenderer tree, TreeTableModel treeTableModel) {
        if (tree == null) {
            tree = new TreeTableCellRenderer(treeTableModel, this);
        }
        this.tree = tree;
        super.setModel(new TreeTableModelAdapter(treeTableModel, tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener x) {
        this.tree.addTreeSelectionListener(x);
    }

    public void removeTreeSelectionListener(TreeSelectionListener x) {
        this.tree.removeTreeSelectionListener(x);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void setRootVisible(boolean b) {
        this.tree.setRootVisible(b);
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void reload() {
        TreeModel treeModel = this.tree.getModel();
        if (treeModel instanceof TreeTableModelExt) {
            TreeTableModelExt treeTableModel = (TreeTableModelExt)treeModel;
            treeTableModel.fireTreeStructureChanged(treeTableModel, new Object[]{treeTableModel.getRoot()}, null, null);
            TreeTableModelAdapter tableModel = (TreeTableModelAdapter)this.getModel();
            tableModel.fireTableChanged(new TableModelEvent(tableModel));
        }
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.tree.getModel();
    }

    public JTree getTreeTableCellRenderer() {
        return this.tree;
    }

    protected boolean shouldFireMouseEventsInEditor() {
        return true;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent && JTreeTable.this.shouldFireMouseEventsInEditor()) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    TreeTableMouseEvent newME = new TreeTableMouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }
}

