/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.FilterableTreeViewNode;
import com.iscobol.gui.client.swing.TreeViewRootNode;
import java.awt.Color;
import java.awt.Image;
import javax.swing.ImageIcon;

public class TreeViewNode
extends FilterableTreeViewNode {
    private int id;
    private int[] imgNumber;
    private int[] imgWidth;
    private int[] imgTrail;
    private String[] hint;
    private int color;
    private int backgroundColor;
    private int foregroundColor;
    private Color foreground;
    private Color background;
    private String[] text;
    private Object[] hiddenData;
    private int hasChildren;

    public TreeViewNode(int id, String[] text) {
        this.text = text;
        this.imgNumber = new int[this.text.length];
        if (this.imgNumber.length > 0) {
            this.imgNumber[0] = 1;
        }
        this.imgWidth = new int[this.text.length];
        this.imgTrail = new int[this.text.length];
        this.hiddenData = new Object[this.text.length];
        this.hint = new String[this.text.length];
        this.id = id;
    }

    int compareText(String[] text) {
        int r = 0;
        int i = 0;
        for (int j = 0; r == 0 && i < text.length && j < text.length; ++i, ++j) {
            r = text[i].compareTo(text[j]);
        }
        return r;
    }

    public void setHasChildren(int flag) {
        this.hasChildren = flag;
    }

    public int getHasChildren() {
        return this.hasChildren;
    }

    @Override
    public boolean isLeaf() {
        return super.isLeaf() && this.hasChildren == 0;
    }

    public TreeViewNode setText(int columnIndex, String s) {
        if (columnIndex >= 0 && columnIndex < this.text.length) {
            this.text[columnIndex] = s;
        }
        return this;
    }

    public String getText(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.text.length) {
            return this.text[columnIndex];
        }
        return "";
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        for (String t : this.text) {
            sb.append(t);
        }
        return sb.toString();
    }

    public TreeViewNode setHiddenData(int columnIndex, Object s) {
        if (columnIndex >= 0 && columnIndex < this.hiddenData.length) {
            this.hiddenData[columnIndex] = s;
        }
        return this;
    }

    public Object getHiddenData(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.hiddenData.length) {
            return this.hiddenData[columnIndex];
        }
        return null;
    }

    public void setHint(String s) {
        for (int i = 0; i < this.hint.length; ++i) {
            this.hint[i] = s;
        }
    }

    public void setHint(int columnIndex, String s) {
        if (columnIndex >= 0 && columnIndex < this.hint.length) {
            this.hint[columnIndex] = s;
        }
    }

    public String getHint(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.hint.length) {
            return this.hint[columnIndex];
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    public void setImgNumber(int columnIndex, int n) {
        if (columnIndex >= 0 && columnIndex < this.imgNumber.length) {
            this.imgNumber[columnIndex] = n;
        }
    }

    public int getImgNumber(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.imgNumber.length) {
            return this.imgNumber[columnIndex];
        }
        return 0;
    }

    public void setImgTrailing(int columnIndex, int n) {
        if (columnIndex >= 0 && columnIndex < this.imgTrail.length) {
            this.imgTrail[columnIndex] = n;
        }
    }

    public int getImgTrailing(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.imgTrail.length) {
            return this.imgTrail[columnIndex];
        }
        return 0;
    }

    public void setImgWidth(int columnIndex, int w) {
        if (columnIndex >= 0 && columnIndex < this.imgWidth.length) {
            this.imgWidth[columnIndex] = w;
        }
    }

    public int getImgWidth(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.imgWidth.length && this.imgWidth[columnIndex] > 0) {
            return this.imgWidth[columnIndex];
        }
        return this.root instanceof TreeViewRootNode ? ((TreeViewRootNode)this.root).getImgWidth(0) : 0;
    }

    public Image getImage() {
        return this.root instanceof TreeViewRootNode ? ((TreeViewRootNode)this.root).getImage() : null;
    }

    public ImageIcon getIcon(int columnIndex) {
        if (this.imgNumber[columnIndex] > 0 && this.root instanceof TreeViewRootNode && ((TreeViewRootNode)this.root).getImage() != null) {
            return ((TreeViewRootNode)this.root).getIcon(this.imgNumber[columnIndex], this.getImgWidth(columnIndex));
        }
        return null;
    }

    @Override
    public void setExpanded(boolean e) {
        this.expanded = e;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    public int getColor() {
        return this.color;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setForegroundColor(int foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    protected boolean accept(FilterableTreeViewNode ftvn, String fs, boolean cs) {
        if (ftvn instanceof TreeViewNode) {
            TreeViewNode n = (TreeViewNode)ftvn;
            if (n.text != null) {
                for (String t : n.text) {
                    if (!cs) {
                        t = t.toLowerCase();
                    }
                    if (t.indexOf(fs) < 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getMatchCount(String fs, boolean cs) {
        int Return2 = 0;
        if (!cs) {
            fs = fs.toLowerCase();
        }
        int fslen = fs.length();
        if (this.text != null) {
            for (String t : this.text) {
                if (t == null) continue;
                int idx = 0;
                if (!cs) {
                    t = t.toLowerCase();
                }
                while ((idx = t.indexOf(fs, idx)) >= 0) {
                    ++Return2;
                    idx += fslen;
                }
            }
        }
        return Return2;
    }

    public String toString() {
        return this.text.length > 0 ? this.text[0] : "";
    }
}

