/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.RemoteFileDialog;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.swing.ImagePreview;
import com.iscobol.gui.client.swing.MyFilter;
import com.iscobol.rmi.server.UnicastRemoteObject;
import com.iscobol.rts.Factory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;

public class RemoteFileDialogImpl
extends UnicastRemoteObject
implements RemoteFileDialog,
HierarchyListener {
    private static final long serialVersionUID = 5653654635463L;
    private JFileChooser theDialog;
    private int mode;
    private int flags;
    private int returnCode = -1;
    private boolean acuCompatibility;
    private boolean multiSelection;
    private boolean checkReplace;
    private FileSystemView view = FileSystemView.getFileSystemView();
    private boolean internalFilterEnabled;
    private final AbstractGuiFactoryImpl gf;

    public RemoteFileDialogImpl() {
        this.gf = null;
    }

    public RemoteFileDialogImpl(boolean acuCompatibility, boolean intFilterEn, AbstractGuiFactoryImpl gf) {
        this.acuCompatibility = acuCompatibility;
        this.internalFilterEnabled = intFilterEn;
        this.gf = gf;
    }

    private boolean check() {
        File d;
        int rc;
        File selectedFile = this.theDialog.getSelectedFile();
        if (selectedFile == null) {
            return true;
        }
        if (this.checkReplace && (this.mode == 1 || this.mode == 3) && selectedFile.exists() && (rc = JOptionPane.showConfirmDialog(null, Factory.getSysMsg("replace_file"), null, 0)) != 0) {
            return false;
        }
        if (this.mode == 0 || this.mode == 1) {
            if ((this.flags & 0x800) != 0 && selectedFile.getParentFile() != null && !selectedFile.getParentFile().exists()) {
                JOptionPane.showMessageDialog(null, Factory.getSysMsg("path_dont_exist"), null, 2);
                return false;
            }
            if (selectedFile.exists()) {
                if ((this.flags & 0x8000) != 0 && !selectedFile.canWrite()) {
                    JOptionPane.showMessageDialog(null, Factory.getSysMsg("file_read_only"), null, 2);
                    return false;
                }
            } else if (this.mode == 0) {
                if ((this.flags & 0x2000) != 0) {
                    rc = JOptionPane.showConfirmDialog(null, Factory.getSysMsg("create_file"), null, 0);
                    if (rc != 0) {
                        return false;
                    }
                } else if ((this.flags & 0x1000) != 0) {
                    JOptionPane.showMessageDialog(null, Factory.getSysMsg("file_not_found"), null, 2);
                    return false;
                }
            }
        }
        if ((d = selectedFile.getParentFile()) != null && !d.isDirectory()) {
            JOptionPane.showMessageDialog(null, Factory.getSysMsg("invalid_selection"), null, 2);
            return false;
        }
        return true;
    }

    @Override
    public void init(String title, int mod, String filter, int defFltr, int fl) throws IOException {
        final FileSystemView fsw = FileSystemView.getFileSystemView();
        this.theDialog = new JFileChooser(com.iscobol.rts.File.getcwd()){

            @Override
            public void approveSelection() {
                if (RemoteFileDialogImpl.this.check()) {
                    super.approveSelection();
                }
            }

            @Override
            public boolean accept(File f) {
                if ((RemoteFileDialogImpl.this.flags & 2) != 0 && fsw.isComputerNode(f) && f.getPath().startsWith("\\\\")) {
                    return false;
                }
                return super.accept(f);
            }

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog d = super.createDialog(parent);
                if (RemoteFileDialogImpl.this.gf != null && RemoteFileDialogImpl.this.gf.getIcon() != null) {
                    d.setIconImage(RemoteFileDialogImpl.this.gf.getIcon());
                }
                return d;
            }
        };
        this.theDialog.setAcceptAllFileFilterUsed(Client.isWebClient());
        this.flags = fl;
        if ((this.flags & 1) == 1) {
            this.theDialog.setAccessory(new ImagePreview(this.theDialog));
        }
        this.theDialog.setDialogTitle(title);
        this.multiSelection = (mod & 0x10) != 0;
        this.theDialog.setMultiSelectionEnabled(this.multiSelection);
        this.checkReplace = (mod & 0x20) != 0 || (this.flags & 2) != 0;
        this.mode = mod & 0xF;
        if (this.mode == 3 || this.mode == 2) {
            if ((this.flags & 0x4000) != 0) {
                this.theDialog.setFileSelectionMode(2);
            } else {
                this.theDialog.setFileSelectionMode(1);
            }
        } else {
            this.theDialog.setFileSelectionMode(0);
        }
        if (filter != null) {
            FileSystemView fsv = this.internalFilterEnabled ? this.view : null;
            MyFilter first = null;
            StringTokenizer st = new StringTokenizer(filter, "|");
            int i = 1;
            while (st.hasMoreTokens()) {
                FileFilter f;
                String d = st.nextToken();
                if (Client.isWebClient()) {
                    if (st.hasMoreTokens()) {
                        String tk = st.nextToken();
                        StringTokenizer st2 = new StringTokenizer(tk, ";");
                        ArrayList<String> ext = new ArrayList<String>();
                        while (st2.hasMoreTokens()) {
                            String e = st2.nextToken();
                            int idx = e.lastIndexOf(46);
                            if (idx < 0 || (e = e.substring(idx + 1)).equals("") || e.equals("*")) continue;
                            ext.add(e);
                        }
                        f = !ext.isEmpty() ? new FileNameExtensionFilter(d, ext.toArray(new String[ext.size()])) : null;
                    } else {
                        f = null;
                    }
                } else {
                    f = st.hasMoreTokens() ? new MyFilter(d, st.nextToken(), fsv) : new MyFilter(d, "*", fsv);
                }
                if (f != null) {
                    this.theDialog.addChoosableFileFilter(f);
                }
                if (first == null) {
                    first = f;
                }
                if (i == defFltr) {
                    first = f;
                }
                ++i;
            }
            if (first != null) {
                this.theDialog.setFileFilter(first);
            }
        } else if (this.internalFilterEnabled) {
            this.theDialog.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File name) {
                    return RemoteFileDialogImpl.intAccept(name, RemoteFileDialogImpl.this.view);
                }

                @Override
                public String getDescription() {
                    return "";
                }
            });
        }
    }

    static boolean intAccept(File name, FileSystemView view) {
        return view.isFileSystem(name) || view.isComputerNode(name) || name.isFile();
    }

    @Override
    public int getTheObjectId() throws IOException {
        return 0;
    }

    @Override
    public void setFile(String name) throws IOException {
        this.theDialog.setSelectedFile(new File(name));
    }

    @Override
    public String[] getFiles() throws IOException {
        if (this.returnCode == 0) {
            String[] stringArray;
            if (this.multiSelection) {
                File[] f = this.theDialog.getSelectedFiles();
                if (f == null) {
                    f = new File[]{};
                }
                String[] Return2 = new String[f.length];
                for (int i = 0; i < f.length; ++i) {
                    Return2[i] = f[i].getName();
                }
                return Return2;
            }
            File f = this.theDialog.getSelectedFile();
            if (f != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = f.getName();
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        return null;
    }

    @Override
    public void setDirectory(String dir) throws IOException {
        File curDir = dir != null ? com.iscobol.rts.File.get(dir) : this.getDefaultDirectory();
        this.theDialog.setCurrentDirectory(curDir);
    }

    private File getDefaultDirectory() {
        File currDir = new File(System.getProperty("user.dir", ".")).getAbsoluteFile();
        if (this.acuCompatibility) {
            File computer = this.findComputerDirectory(currDir);
            return computer != null ? computer : currDir;
        }
        return currDir;
    }

    private File findComputerDirectory(File currDir) {
        File Return2 = currDir;
        while (Return2 != null && !this.view.isDrive(Return2)) {
            Return2 = this.view.getParentDirectory(Return2);
        }
        if (Return2 != null) {
            Return2 = this.view.getParentDirectory(Return2);
        }
        return Return2;
    }

    @Override
    public String getDirectory() throws IOException {
        if (this.returnCode == 0) {
            File f = this.theDialog.getCurrentDirectory();
            File selFile = this.theDialog.getSelectedFile();
            if (f != null && selFile != null && f.toString().equals(selFile.toString())) {
                return selFile.toPath().getParent().toString();
            }
            return f != null ? f.getAbsolutePath() : null;
        }
        return null;
    }

    @Override
    public void show() throws IOException {
        KeyboardBuffer.enable(null);
        if (!Client.isWebClient()) {
            this.theDialog.addHierarchyListener(this);
        }
        if (this.mode == 1 || this.mode == 3) {
            this.multiSelection = false;
            this.returnCode = this.theDialog.showSaveDialog(null);
        } else {
            this.checkReplace = false;
            this.returnCode = this.theDialog.showOpenDialog(null);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) == 4L && this.theDialog.isDisplayable()) {
            Container c;
            for (c = this.theDialog.getParent(); c != null && !(c instanceof JDialog); c = c.getParent()) {
            }
            if (c != null) {
                final JDialog dialog = (JDialog)c;
                final Dimension origSize = dialog.getSize();
                dialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        Dimension newSize = dialog.getSize();
                        if (newSize.width < origSize.width || newSize.height < origSize.height) {
                            newSize.width = Math.max(origSize.width, newSize.width);
                            newSize.height = Math.max(origSize.height, newSize.height);
                            dialog.setSize(newSize);
                        }
                    }
                });
            }
        }
    }

    @Override
    public String[] createFile(String theDir, String theFile) throws IOException {
        File res = theDir == null || new File(theFile).isAbsolute() ? new File(theFile) : new File(theDir, theFile);
        return new String[]{res.getName(), res.getAbsolutePath()};
    }

    @Override
    public String createDir(String theDir) throws IOException {
        if (theDir != null) {
            return new File(theDir).getAbsolutePath();
        }
        return null;
    }
}

