/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ParamsValues;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.DateEntry;
import com.iscobol.gui.client.swing.DateEntryChangeListener;
import com.iscobol.gui.client.swing.DateEntryEvent;
import com.iscobol.gui.client.swing.DateEntryListener;
import com.iscobol.gui.client.swing.DateEntryVetoException;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.OutAcceptEvent;
import com.iscobol.gui.client.swing.PicobolDateEntry;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.border.MatteBorder;

public class RemoteDateEntry
extends RemoteBaseGUIControl
implements DateEntryListener,
DateEntryChangeListener {
    public static final int DEFAULT_WIDTH = 50;
    private Date value;
    private Date illegalDateVal;
    private Date maxVal;
    private Date minVal;
    private String displayFormat;
    private int valueFormat = -1;
    private int bitmapNumber;
    private int bitmapWidth;
    private int bitmapHeight;
    private Image image;
    private LocalFontCmp calendarFont;
    private boolean allowEmptyStyle;
    private boolean noF4Style;
    private boolean notifyChangeStyle;
    private boolean rightAlignStyle;
    private boolean showNoneStyle;
    private boolean timeStyle;
    private boolean centuryDateStyle;
    private boolean numericStyle;
    private boolean readOnlyStyle;
    private boolean longDateStyle;
    private boolean decBackVisibleStyle = true;
    private boolean decBordersVisibleStyle;
    private boolean weekOfYearVisibleStyle = true;
    private boolean noautoselStyle;
    private Color decBackColor;
    private ColorCmp decBackColorCmp;
    private int decBackColorIdx;
    private Color sunForeColor;
    private ColorCmp sunForeColorCmp;
    private int sunForeColorIdx;
    private Color wdForeColor;
    private ColorCmp wdForeColorCmp;
    private int wdForeColorIdx;
    private int maxDayChars;
    private Date newDate;
    private String timeStyleFormat;
    private String shortDateStyleFormat;
    private String centuryDateStyleFormat = "dd/MM/yyyy";
    private String longDateStyleFormat;
    private String valueStr;
    private boolean validateDate;
    private String validateErrMsg;
    private int _2DigitsYearStart;
    private PropertyChangeListener pcListener;
    private boolean selfAct;
    private boolean defaultShortcutsEnabled;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private String disabledFieldColor;
    private boolean backgroundSet;
    private boolean foregroundSet;

    public RemoteDateEntry(GuiFactoryImpl gf) {
        super(gf);
        this.setTimeStyleFormat(gf.getCsProperty().get("iscobol.gui.date_entry.time", IsguiUtility.getDefaultTimeDateFormat()));
        this.setShortDateStyleFormat(gf.getCsProperty().get("iscobol.gui.date_entry.display_format", IsguiUtility.getDefaultShortDateFormat()));
        this.setCenturyDateStyleFormat(gf.getCsProperty().get("iscobol.gui.date_entry.century_date", IsguiUtility.getDefaultCenturyDateFormat()));
        this.setLongDateStyleFormat(gf.getCsProperty().get("iscobol.gui.date_entry.long_date", IsguiUtility.getDefaultLongDateFormat()));
        this.defaultShortcutsEnabled = gf.getCsProperty().get("iscobol.key.default_shortcuts_enabled", true);
        this.validateDate = gf.getCsProperty().get("iscobol.gui.date_entry.validate", false);
        this.validateErrMsg = gf.getCsProperty().get("iscobol.gui.date_entry.errormessage", Factory.getSysMsg("de_invalid_input"));
        this._2DigitsYearStart = gf.getCsProperty().get("iscobol.gui.date_entry.cutoff", -1);
        this.disabledFieldColor = gf.getCsProperty().get("iscobol.gui.disabled_field_color", null);
        this.pcListener = evt -> {
            if (gf != null) {
                String key = evt.getPropertyName();
                if (key.equals("iscobol.gui.date_entry.time")) {
                    this.setTimeStyleFormat(gf.getCsProperty().get(key, "HH:mm:ss"));
                } else if (key.equals("iscobol.gui.date_entry.display_format")) {
                    this.setShortDateStyleFormat(gf.getCsProperty().get(key, "dd/MM/yyyy"));
                } else if (key.equals("iscobol.gui.date_entry.long_date")) {
                    this.setLongDateStyleFormat(gf.getCsProperty().get(key, "EEEE dd MMMM yyyy"));
                } else if (key.equals("iscobol.gui.date_entry.century_date")) {
                    this.setCenturyDateStyleFormat(gf.getCsProperty().get(key, "dd/MM/yyyy"));
                } else if (key.equals("iscobol.gui.date_entry.validate")) {
                    this.validateDate = gf.getCsProperty().get("iscobol.gui.date_entry.validate", false);
                } else if (key.equals("iscobol.gui.date_entry.errormessage")) {
                    this.validateErrMsg = gf.getCsProperty().get("iscobol.gui.date_entry.errormessage", Factory.getSysMsg("de_invalid_input"));
                } else if (key.equals("iscobol.gui.disabled_field_color")) {
                    this.setDisabledFieldColor(gf.getCsProperty().get(key, null));
                } else if (key.equals("iscobol.gui.date_entry.cutoff")) {
                    this._2DigitsYearStart = gf.getCsProperty().get("iscobol.gui.date_entry.cutoff", -1);
                    if (this.guiComponent != null) {
                        ((DateEntry)((Object)this.guiComponent)).set2DigitsYearStart(this._2DigitsYearStart);
                    }
                }
            }
        };
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    @Override
    public void setColorBackgroundIdx(int idx) {
        boolean oldVal = this.backgroundSet;
        super.setColorBackgroundIdx(idx);
        boolean bl = this.backgroundSet = this.getBackground() != null;
        if (oldVal != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorBackground(int r, int g, int b) {
        boolean oldVal = this.backgroundSet;
        super.setColorBackground(r, g, b);
        boolean bl = this.backgroundSet = this.getBackground() != null;
        if (oldVal != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForegroundIdx(int idx) {
        boolean oldVal = this.foregroundSet;
        super.setColorForegroundIdx(idx);
        boolean bl = this.foregroundSet = this.getForeground() != null;
        if (oldVal != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForeground(int r, int g, int b) {
        boolean oldVal = this.foregroundSet;
        super.setColorForeground(r, g, b);
        boolean bl = this.foregroundSet = this.getForeground() != null;
        if (oldVal != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    private void setDisabledFieldColor(String value) {
        this.disabledFieldColor = value;
        if (this.guiComponent != null) {
            boolean[] applyAlways = new boolean[1];
            Color[] fieldColors = this.getFieldColors(this.disabledFieldColor, applyAlways);
            DateEntry de = (DateEntry)((Object)this.guiComponent);
            if (applyAlways[0] || !this.backgroundSet) {
                de.setDisabledBackground(fieldColors[0]);
            } else {
                de.setDisabledBackground(null);
            }
            if (applyAlways[0] || !this.foregroundSet) {
                de.setDisabledForeground(fieldColors[1]);
            } else {
                de.setDisabledForeground(null);
            }
        }
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        return 1.4f;
    }

    @Override
    public float getDefaultWidth() {
        return 9.0f;
    }

    @Override
    public int getGUIControlHeight(float height) {
        if (this.font != null) {
            return (int)((float)this.font.getHeight() * height);
        }
        return 20;
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl opposite, MouseEvent me, RemoteRecordAccept rra) {
        return opposite != null && opposite.isSelfAct() || opposite == this || this.check(opposite);
    }

    private boolean check(RemoteBaseGUIControl opposite) {
        if (this.validateDate) {
            String text = ((PicobolDateEntry)this.guiComponent).getText();
            String emptyMaskPattern = ((PicobolDateEntry)this.guiComponent).getEmptyMaskPattern();
            if (emptyMaskPattern == null) {
                emptyMaskPattern = "";
            }
            if (!this.allowEmptyStyle || !text.equals(emptyMaskPattern)) {
                SimpleDateFormat df = new SimpleDateFormat(this.getDateFormat());
                df.setLenient(false);
                Date d = null;
                try {
                    d = df.parse(text, new ParsePosition(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d == null) {
                    if (opposite != null) {
                        opposite.skipNextEvent();
                    }
                    JOptionPane.showMessageDialog(null, this.validateErrMsg, Factory.getSysMsg("de_error_msg_title"), 0);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int getGUIControlWidth(float width) {
        if (this.font != null) {
            return (int)((float)this.font.getWidth() * width) + 50;
        }
        return 200;
    }

    @Override
    public String getProp(int key) {
        switch (key) {
            case 244: {
                return Integer.toString(this.getValueFormat());
            }
            case 65: {
                if (this.decBackColorCmp != null) {
                    return Integer.toString(this.decBackColorIdx >= 0 ? this.decBackColorIdx : this.decBackColorCmp.getForeground());
                }
                return null;
            }
            case 230: {
                if (this.sunForeColorCmp != null) {
                    return Integer.toString(this.sunForeColorIdx >= 0 ? this.sunForeColorIdx : this.sunForeColorCmp.getForeground());
                }
                return null;
            }
            case 248: {
                if (this.wdForeColorCmp != null) {
                    return Integer.toString(this.wdForeColorIdx >= 0 ? this.wdForeColorIdx : this.wdForeColorCmp.getForeground());
                }
                return null;
            }
            case 152: {
                if (this.minVal != null) {
                    return this.date2String(this.minVal);
                }
                return null;
            }
            case 148: {
                if (this.maxVal != null) {
                    return this.date2String(this.maxVal);
                }
                return null;
            }
            case 420: {
                if (this.illegalDateVal != null) {
                    return this.date2String(this.illegalDateVal);
                }
                return null;
            }
            case 325: {
                if (this.borderColorCmp == null) break;
                return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
            }
        }
        return super.getProp(key);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        RemoteBaseGUIControl fown = null;
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (rdw != null) {
            fown = (RemoteBaseGUIControl)rdw.getPreviousFocusOwner();
        }
        if (!(!this.isControlEditor() && fown == this || this.getActiveAccept() || this.isSelfAct() || this.parentWindow == null || this.isExcludedEvent(3))) {
            this.parentWindow.setCmdGotoSent(true, this);
            this.bufferedOutAcceptEvent(new OutAcceptEvent(evt), false);
            return;
        }
        this.guiComponent.requestFocusInWindow();
        super.mousePressed(evt);
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        switch (ke.getKeyCode()) {
            case 115: {
                if (this.noF4Style) break;
                de.showPopup();
                return;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
            case 67: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                if (!ke.isControlDown() || !this.defaultShortcutsEnabled) break;
                return;
            }
        }
        super.keyPressed(ke);
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        String dateFormat = this.getDateFormat();
        this.guiComponent = new PicobolDateEntry(this.numericStyle ? 1 : 0, dateFormat);
        super.intInitialize();
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        de.setDefaultShortcutsEnabled(this.defaultShortcutsEnabled);
        if (this.name != null) {
            de.setName(this.name);
        }
        de.addOutAcceptListener(this);
        de.setDateEntryListener(this);
        de.setAllowEmpty(this.allowEmptyStyle);
        de.set2DigitsYearStart(this._2DigitsYearStart);
        if (this.calendarFont != null) {
            de.setCalendarFont(this.calendarFont.getFont());
        }
        if (this.numericStyle) {
            this.setDateFormat0(de, dateFormat);
        } else {
            this.setDateFormat(de, dateFormat);
        }
        if (this.rightAlignStyle) {
            de.setRightAlignment(this.rightAlignStyle);
        }
        if (this.showNoneStyle) {
            de.setShowNone(this.showNoneStyle);
        }
        if (this.value == null && !this.allowEmptyStyle) {
            if (this.valueStr != null && this.valueStr.length() == this.valueStr.trim().length()) {
                this.setValue(this.valueStr);
            } else {
                this.value = this.getInitialValue();
            }
        }
        de.setDate(this.value);
        if (this.maxVal != null) {
            de.setMaxSelectableDate(this.maxVal);
        }
        if (this.minVal != null) {
            de.setMinSelectableDate(this.minVal);
        }
        if (this.illegalDateVal != null) {
            de.setIllegalDate(this.illegalDateVal);
        }
        if (this.decBackColor != null) {
            de.getJCalendar().setDecorationBackgroundColor(this.decBackColor);
        }
        if (this.sunForeColor != null) {
            de.getJCalendar().setSundayForeground(this.sunForeColor);
        }
        if (this.wdForeColor != null) {
            de.getJCalendar().setWeekdayForeground(this.wdForeColor);
        }
        if (!this.decBackVisibleStyle) {
            de.getJCalendar().setDecorationBackgroundVisible(this.decBackVisibleStyle);
        }
        if (this.decBordersVisibleStyle) {
            de.getJCalendar().setDecorationBordersVisible(this.decBordersVisibleStyle);
        }
        if (!this.weekOfYearVisibleStyle) {
            de.getJCalendar().setWeekOfYearVisible(this.weekOfYearVisibleStyle);
        }
        de.setReadOnly(this.readOnlyStyle);
        if (this.maxDayChars >= 0) {
            de.getJCalendar().setMaxDayCharacters(this.maxDayChars);
        }
        de.addKeyListener(this);
        de.setChangeListener(this);
        if (this.valueStr != null) {
            this.setValue(this.valueStr);
        } else {
            de.setShowNoneChecked(true);
        }
        this.guiComponent.setSelfAct(this.selfAct);
        this.setDisabledFieldColor(this.disabledFieldColor);
        this.setBoxedStyle();
    }

    private void setDateFormat(PicobolDateEntry de, String dateFormat) {
        if (de == null) {
            return;
        }
        this.setDateFormat0(de, dateFormat);
        de.setDateFormatString(dateFormat);
        if (this.tooltipText != null) {
            de.setToolTipText(this.tooltipText);
        }
    }

    private void setDateFormat0(PicobolDateEntry de, String dateFormat) {
        if (de == null) {
            return;
        }
        de.getCalendarButton().setVisible(!this.timeStyle);
    }

    private String getDateFormat() {
        if (this.displayFormat != null) {
            return this.displayFormat;
        }
        if (this.timeStyle) {
            return this.getTimeStyleFormat();
        }
        if (this.centuryDateStyle) {
            return this.getCenturyDateStyleFormat();
        }
        if (this.longDateStyle) {
            return this.getLongDateStyleFormat();
        }
        return this.getShortDateStyleFormat();
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
        Rectangle r = this.getBounds();
        viewWidth = r.width;
        viewHeight = r.height;
        if (viewWidth != 0) {
            this.image = this.getLocalImage(imageId);
            this.bitmapHeight = viewHeight;
            PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
            if (de != null && this.image != null) {
                de.setIcon(this.getIcon(this.bitmapNumber));
            }
        }
    }

    @Override
    public String setProp(Integer key, String v, int length) {
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        try {
            intValue = (int)Float.parseFloat(v);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        boolean isrgb = false;
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        switch (key) {
            case 420: {
                this.illegalDateVal = this.string2Date(v);
                if (de == null) break;
                de.setIllegalDate(this.illegalDateVal);
                break;
            }
            case 68: {
                String saveval = null;
                if (this.displayFormat != null && !this.displayFormat.equals(v.trim())) {
                    saveval = this.getValue();
                }
                this.displayFormat = v.trim();
                if (!this.numericStyle) {
                    this.setDateFormat(de, this.getDateFormat());
                }
                if (saveval != null) {
                    this.setValue(saveval);
                }
                Return2 = "1";
                break;
            }
            case 244: {
                if (error) break;
                this.valueFormat = intValue;
                if (this.valueStr != null) {
                    this.setValue(this.valueStr);
                }
                Return2 = "1";
                break;
            }
            case 25: {
                if (error) break;
                this.calendarFont = (LocalFontCmp)this.gf.getClient().getId(intValue);
                if (this.calendarFont != null && de != null) {
                    de.setCalendarFont(this.calendarFont.getFont());
                }
                Return2 = "1";
                break;
            }
            case 20: {
                if (error) break;
                this.bitmapWidth = intValue;
                Return2 = "1";
                break;
            }
            case 12: {
                if (error) break;
                this.bitmapNumber = intValue;
                if (de != null && this.image != null) {
                    de.setIcon(this.getIcon(this.bitmapNumber));
                }
                Return2 = "1";
                break;
            }
            case 143: {
                if (error) break;
                this.maxDayChars = intValue;
                if (de != null) {
                    de.getJCalendar().setMaxDayCharacters(this.maxDayChars);
                }
                Return2 = "1";
                break;
            }
            case 148: {
                this.maxVal = this.string2Date(v);
                if (de == null) break;
                de.setMaxSelectableDate(this.maxVal);
                break;
            }
            case 152: {
                this.minVal = this.string2Date(v);
                if (de == null) break;
                de.setMinSelectableDate(this.minVal);
                break;
            }
            case 65: 
            case 66: {
                isrgb = key.equals(ParamsValues.getParamValue("DECORATION-BACKGROUND-RGB"));
                if (intValue < 0 || isrgb) {
                    this.decBackColorCmp = new ColorCmp(true);
                    this.decBackColorIdx = -1;
                    this.decBackColorCmp.setForeRGB(intValue);
                    this.decBackColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.decBackColorCmp.getForeground(), false));
                } else {
                    this.decBackColorCmp = new ColorCmp(intValue);
                    this.decBackColorIdx = intValue;
                    this.decBackColor = this.gf.getRemotePalette().getDefaultColor(this.decBackColorCmp.getForeground());
                }
                if (de == null || this.decBackColor == null) break;
                de.getJCalendar().setDecorationBackgroundColor(this.decBackColor);
                break;
            }
            case 230: 
            case 231: {
                isrgb = key.equals(ParamsValues.getParamValue("SUNDAY-FOREGROUND-RGB"));
                if (intValue < 0 || isrgb) {
                    this.sunForeColorCmp = new ColorCmp(true);
                    this.sunForeColorIdx = -1;
                    this.sunForeColorCmp.setForeRGB(intValue);
                    this.sunForeColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.sunForeColorCmp.getForeground(), false));
                } else {
                    this.sunForeColorCmp = new ColorCmp(intValue);
                    this.sunForeColorIdx = intValue;
                    this.sunForeColor = this.gf.getRemotePalette().getDefaultColor(this.sunForeColorCmp.getForeground());
                }
                if (de == null || this.sunForeColor == null) break;
                de.getJCalendar().setSundayForeground(this.sunForeColor);
                break;
            }
            case 248: 
            case 249: {
                isrgb = key.equals(ParamsValues.getParamValue("WEEKDAY-FOREGROUND-RGB"));
                if (intValue < 0 || isrgb) {
                    this.wdForeColorCmp = new ColorCmp(true);
                    this.wdForeColorIdx = -1;
                    this.wdForeColorCmp.setForeRGB(intValue);
                    this.wdForeColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.wdForeColorCmp.getForeground(), false));
                } else {
                    this.wdForeColorCmp = new ColorCmp(intValue);
                    this.wdForeColorIdx = intValue;
                    this.wdForeColor = this.gf.getRemotePalette().getDefaultColor(this.wdForeColorCmp.getForeground());
                }
                if (de == null || this.wdForeColor == null) break;
                de.getJCalendar().setWeekdayForeground(this.wdForeColor);
                break;
            }
            case 253: {
                this.guiComponent.requestFocusInWindow();
                new IsguiWorker(false, () -> ((DateEntry)((Object)this.guiComponent)).showPopup()).start();
                break;
            }
            case 254: {
                if (this.newDate == null || this.guiComponent == null) break;
                this.value = this.newDate;
                ((DateEntry)((Object)this.guiComponent)).setDate(this.newDate);
                if (!this.notifyChangeStyle) break;
                CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4100, true, true, true));
                this.pushEvent(cc);
                break;
            }
            case 325: 
            case 326: {
                isrgb = key.equals(ParamsValues.getParamValue("BORDER-COLOR-RGB"));
                if (intValue < 0 || isrgb) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(intValue);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(intValue);
                    this.borderColorIdx = intValue;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                this.setBoxedStyle();
                break;
            }
            case 374: {
                this.handleBorderWidths(v);
                this.setBoxedStyle();
            }
        }
        return super.setProp(key, v, length);
    }

    private ImageIcon getIcon(int strip) {
        if (strip > 0) {
            Image imageStrip = ScreenUtility.getImage(this.bitmapWidth, this.bitmapHeight, this.image, strip);
            if (imageStrip != null) {
                return new ImageIcon(imageStrip);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setRowsCols(float r, float c) {
    }

    public String getTimeStyleFormat() {
        return this.timeStyleFormat;
    }

    public void setTimeStyleFormat(String format) {
        this.timeStyleFormat = format;
    }

    public String getShortDateStyleFormat() {
        return this.shortDateStyleFormat;
    }

    public void setShortDateStyleFormat(String format) {
        this.shortDateStyleFormat = format;
    }

    public String getCenturyDateStyleFormat() {
        return this.centuryDateStyleFormat;
    }

    public void setCenturyDateStyleFormat(String format) {
        this.centuryDateStyleFormat = format;
    }

    public String getLongDateStyleFormat() {
        return this.longDateStyleFormat;
    }

    public void setLongDateStyleFormat(String format) {
        this.longDateStyleFormat = format;
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        if ((s & 0x400000) == 0x400000) {
            this.selfAct = set;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(set);
            }
        }
        if ((s & 4) == 4) {
            this.noF4Style = set;
        }
        if ((s & 0x8000) == 32768) {
            this.notifyChangeStyle = set;
        }
        if ((s & 0x10) == 16) {
            this.rightAlignStyle = set;
            if (de != null) {
                de.setRightAlignment(set);
            }
        }
        if ((s & 0x20) == 32) {
            this.showNoneStyle = set;
            if (de != null) {
                de.setShowNone(set);
            }
        }
        if ((s & 3) == 3) {
            this.timeStyle = set;
            if (!this.numericStyle) {
                this.setDateFormat(de, this.getDateFormat());
            }
        } else {
            if ((s & 2) == 2) {
                this.longDateStyle = set;
                if (!this.numericStyle) {
                    this.setDateFormat(de, this.getDateFormat());
                }
            }
            if ((s & 1) == 1) {
                this.centuryDateStyle = set;
                if (!this.numericStyle) {
                    this.setDateFormat(de, this.getDateFormat());
                }
            }
            if (!(this.longDateStyle || this.centuryDateStyle || this.numericStyle)) {
                this.setDateFormat(de, this.getDateFormat());
            }
        }
        if ((s & 0x40) == 64) {
            this.decBackVisibleStyle = set;
            if (de != null) {
                de.getJCalendar().setDecorationBackgroundVisible(this.decBackVisibleStyle);
            }
        }
        if ((s & 0x80) == 128) {
            this.decBordersVisibleStyle = set;
            if (de != null) {
                de.getJCalendar().setDecorationBordersVisible(this.decBordersVisibleStyle);
            }
        }
        if ((s & 0x100) == 256) {
            this.weekOfYearVisibleStyle = set;
            if (de != null) {
                de.getJCalendar().setWeekOfYearVisible(this.weekOfYearVisibleStyle);
            }
        }
        if ((s & 0x200) == 512) {
            this.noautoselStyle = set;
        }
        if ((s & 0x20000) == 131072) {
            this.numericStyle = set;
        }
        if ((s & 0x400) == 1024) {
            this.allowEmptyStyle = set;
        }
        if ((s & 0x80000) == 524288) {
            this.readOnlyStyle = set;
            if (de != null) {
                de.setReadOnly(this.readOnlyStyle);
            }
        }
    }

    @Override
    public void setTitle(String v) {
    }

    @Override
    public String getTitle() {
        return null;
    }

    private String zeroPad(int nDigits, String numStr) {
        int diff = nDigits - numStr.length();
        for (int i = 0; i < diff; ++i) {
            numStr = "0" + numStr;
        }
        return numStr;
    }

    @Override
    public String getValue() {
        String Return2;
        if (this.guiComponent != null) {
            PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
            if (!de.isShowNoneChecked()) {
                Return2 = this.timeStyle ? "9" : "0";
            } else {
                Date[] d = new Date[1];
                new SwingWorker(true, () -> {
                    d[0] = de.getDate();
                }).start();
                this.value = d[0];
                Return2 = this.date2String(this.value);
            }
        } else {
            Return2 = this.date2String(this.value);
        }
        return Return2;
    }

    private String date2String(Date date) {
        if (date == null) {
            return "";
        }
        StringBuffer Return2 = new StringBuffer();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int vf = this.getValueFormat();
        switch (vf) {
            case 0: {
                Return2.append(this.zeroPad(4, Integer.toString(calendar.get(1))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                break;
            }
            case 1: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(1) % 100)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                break;
            }
            case 4: {
                Return2.append(this.zeroPad(4, Integer.toString(calendar.get(1))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(11))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(12))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(13))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(14) / 10)));
                break;
            }
            case 5: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                Return2.append(this.zeroPad(4, Integer.toString(calendar.get(1))));
                break;
            }
            case 6: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(1) % 100)));
                break;
            }
            case 7: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                Return2.append(this.zeroPad(4, Integer.toString(calendar.get(1))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(11))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(12))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(13))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(14) / 10)));
                break;
            }
            case 8: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(4, Integer.toString(calendar.get(1))));
                break;
            }
            case 9: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(1) % 100)));
                break;
            }
            case 10: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(5))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(2) + 1)));
                Return2.append(this.zeroPad(4, Integer.toString(calendar.get(1))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(11))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(12))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(13))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(14) / 10)));
                break;
            }
            case 2: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(11))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(12))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(13))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(14) / 10)));
                break;
            }
            case 3: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(11))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(12))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(13))));
                break;
            }
            case 11: {
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(11))));
                Return2.append(this.zeroPad(2, Integer.toString(calendar.get(12))));
            }
        }
        return Return2.toString();
    }

    private int getValueFormat() {
        int vf = this.valueFormat;
        if (vf == -1) {
            vf = this.timeStyle ? 3 : 0;
        }
        return vf;
    }

    private Date string2Date(String val) {
        String v = ScreenUtility.rightTrim(val);
        if (v != null) {
            v = v.replaceAll("\\D", "");
        }
        Date Return2 = null;
        GregorianCalendar calendar = new GregorianCalendar();
        long lVal = 0L;
        if (v != null) {
            try {
                lVal = Long.parseLong(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (lVal == 0L && !this.timeStyle) {
            if (this.allowEmptyStyle) {
                return null;
            }
            return calendar.getTime();
        }
        int year = calendar.get(1);
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int vf = this.getValueFormat();
        try {
            switch (vf) {
                case 0: {
                    v = this.adjustLen(v, 8);
                    calendar.set(1, Integer.parseInt(v.substring(0, 4)));
                    calendar.set(2, Integer.parseInt(v.substring(4, 6)) - 1);
                    calendar.set(5, Integer.parseInt(v.substring(6, 8)));
                    Return2 = calendar.getTime();
                    break;
                }
                case 5: {
                    v = this.adjustLen(v, 8);
                    calendar.set(2, Integer.parseInt(v.substring(0, 2)) - 1);
                    calendar.set(5, Integer.parseInt(v.substring(2, 4)));
                    calendar.set(1, Integer.parseInt(v.substring(4, 8)));
                    Return2 = calendar.getTime();
                    break;
                }
                case 8: {
                    v = this.adjustLen(v, 8);
                    calendar.set(5, Integer.parseInt(v.substring(0, 2)));
                    calendar.set(2, Integer.parseInt(v.substring(2, 4)) - 1);
                    calendar.set(1, Integer.parseInt(v.substring(4, 8)));
                    Return2 = calendar.getTime();
                    break;
                }
                case 1: {
                    v = this.adjustLen(v, 6);
                    calendar.set(1, year - year % 100 + Integer.parseInt(v.substring(0, 2)));
                    calendar.set(2, Integer.parseInt(v.substring(2, 4)) - 1);
                    calendar.set(5, Integer.parseInt(v.substring(4, 6)));
                    Return2 = calendar.getTime();
                    break;
                }
                case 6: {
                    v = this.adjustLen(v, 6);
                    calendar.set(2, Integer.parseInt(v.substring(0, 2)) - 1);
                    calendar.set(5, Integer.parseInt(v.substring(2, 4)));
                    calendar.set(1, year - year % 100 + Integer.parseInt(v.substring(4, 6)));
                    Return2 = calendar.getTime();
                    break;
                }
                case 9: {
                    v = this.adjustLen(v, 6);
                    calendar.set(5, Integer.parseInt(v.substring(0, 2)));
                    calendar.set(2, Integer.parseInt(v.substring(2, 4)) - 1);
                    calendar.set(1, year - year % 100 + Integer.parseInt(v.substring(4, 6)));
                    Return2 = calendar.getTime();
                    break;
                }
                case 4: {
                    v = this.adjustLen(v, 16);
                    calendar.set(1, Integer.parseInt(v.substring(0, 4)));
                    calendar.set(2, Integer.parseInt(v.substring(4, 6)) - 1);
                    calendar.set(5, Integer.parseInt(v.substring(6, 8)));
                    calendar.set(11, Integer.parseInt(v.substring(8, 10)));
                    calendar.set(12, Integer.parseInt(v.substring(10, 12)));
                    calendar.set(13, Integer.parseInt(v.substring(12, 14)));
                    calendar.set(14, Integer.parseInt(v.substring(14, 16)) * 10);
                    Return2 = calendar.getTime();
                    break;
                }
                case 7: {
                    v = this.adjustLen(v, 16);
                    calendar.set(2, Integer.parseInt(v.substring(0, 2)) - 1);
                    calendar.set(5, Integer.parseInt(v.substring(2, 4)));
                    calendar.set(1, Integer.parseInt(v.substring(4, 8)));
                    calendar.set(11, Integer.parseInt(v.substring(8, 10)));
                    calendar.set(12, Integer.parseInt(v.substring(10, 12)));
                    calendar.set(13, Integer.parseInt(v.substring(12, 14)));
                    calendar.set(14, Integer.parseInt(v.substring(14, 16)) * 10);
                    Return2 = calendar.getTime();
                    break;
                }
                case 10: {
                    v = this.adjustLen(v, 16);
                    calendar.set(5, Integer.parseInt(v.substring(0, 2)));
                    calendar.set(2, Integer.parseInt(v.substring(2, 4)) - 1);
                    calendar.set(1, Integer.parseInt(v.substring(4, 8)));
                    calendar.set(11, Integer.parseInt(v.substring(8, 10)));
                    calendar.set(12, Integer.parseInt(v.substring(10, 12)));
                    calendar.set(13, Integer.parseInt(v.substring(12, 14)));
                    calendar.set(14, Integer.parseInt(v.substring(14, 16)) * 10);
                    Return2 = calendar.getTime();
                    break;
                }
                case 2: {
                    v = this.adjustLen(v, 8);
                    calendar.set(11, Integer.parseInt(v.substring(0, 2)));
                    calendar.set(12, Integer.parseInt(v.substring(2, 4)));
                    calendar.set(13, Integer.parseInt(v.substring(4, 6)));
                    calendar.set(14, Integer.parseInt(v.substring(6, 8)) * 10);
                    Return2 = calendar.getTime();
                    break;
                }
                case 3: {
                    v = this.adjustLen(v, 6);
                    calendar.set(11, Integer.parseInt(v.substring(0, 2)));
                    calendar.set(12, Integer.parseInt(v.substring(2, 4)));
                    calendar.set(13, Integer.parseInt(v.substring(4, 6)));
                    Return2 = calendar.getTime();
                    break;
                }
                case 11: {
                    v = this.adjustLen(v, 4);
                    calendar.set(11, Integer.parseInt(v.substring(0, 2)));
                    calendar.set(12, Integer.parseInt(v.substring(2, 4)));
                    Return2 = calendar.getTime();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Return2;
    }

    private boolean isAll(String val, char character) {
        if (val == null) {
            return false;
        }
        char[] c = val.trim().toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == character) continue;
            return false;
        }
        return true;
    }

    @Override
    public String setValue(String val) {
        if (val != null && val.trim().length() == 0) {
            val = null;
        }
        this.valueStr = val;
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        if (de != null) {
            Date newDate;
            this.value = newDate = this.string2Date(val);
            if (this.isAll(val, '0') && !this.timeStyle || this.isAll(val, '9') && this.timeStyle) {
                de.setShowNoneChecked(false);
                if (this.allowEmptyStyle) {
                    new SwingWorker(true, () -> de.setDate(this.value)).start();
                }
            } else if (this.value != null) {
                new SwingWorker(true, () -> {
                    boolean b = this.notifyChangeStyle;
                    this.notifyChangeStyle = false;
                    try {
                        de.setDate(this.value);
                    }
                    finally {
                        this.notifyChangeStyle = b;
                    }
                    de.setShowNoneChecked(true);
                }).start();
            }
        }
        return val;
    }

    private Date getInitialValue() {
        Date Return2 = null;
        GregorianCalendar initialCal = new GregorianCalendar();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int vf = this.getValueFormat();
        switch (vf) {
            case 4: 
            case 7: 
            case 10: {
                calendar.set(11, initialCal.get(11));
                calendar.set(12, initialCal.get(12));
                calendar.set(13, initialCal.get(13));
                calendar.set(14, initialCal.get(14));
            }
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                calendar.set(1, initialCal.get(1));
                calendar.set(2, initialCal.get(2));
                calendar.set(5, initialCal.get(5));
                Return2 = calendar.getTime();
                break;
            }
            case 2: {
                calendar.set(14, initialCal.get(14));
            }
            case 3: {
                calendar.set(13, initialCal.get(13));
            }
            case 11: {
                calendar.set(11, initialCal.get(11));
                calendar.set(12, initialCal.get(12));
                Return2 = calendar.getTime();
            }
        }
        return Return2;
    }

    @Override
    public void destroy() {
        if (this.guiComponent != null) {
            ((DateEntry)((Object)this.guiComponent)).dispose();
        }
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        super.handleResponse(eventAction, rra);
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    public void intFocusGained(boolean restore) {
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    public void focusGained(CobolFocusEvent cfe) {
        if (!cfe.isGoto() && !this.isControlEditor()) {
            RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
            if (this.guiComponent != null && !this.noautoselStyle && rdw.getPreviousFocusOwner() != this) {
                PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
                new SwingWorker(false, () -> de.selectAll()).start();
            }
        }
        super.focusGained(cfe);
    }

    @Override
    public void popupWillBecameVisible(DateEntryEvent evt) throws DateEntryVetoException {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        RemoteBaseGUIControl fown = (RemoteBaseGUIControl)rdw.getFocusOwner();
        if (fown != this) {
            rdw.setFocusOwner(this);
            CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(16, 23, 0));
            this.pushEvent(cc);
            throw new DateEntryVetoException();
        }
    }

    @Override
    public void stateWillChange(DateEntryEvent evt) throws DateEntryVetoException {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        RemoteBaseGUIControl fown = (RemoteBaseGUIControl)rdw.getFocusOwner();
        if (fown != this) {
            rdw.setFocusOwner(this);
            this.newDate = evt.getNewDate();
            CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(16, 24, 0));
            this.pushEvent(cc);
            throw new DateEntryVetoException();
        }
    }

    private boolean equals(Date d1, Date d2) {
        if (d1 != null) {
            if (d2 != null) {
                return d1.equals(d2);
            }
            return false;
        }
        return d2 == null;
    }

    @Override
    public void stateChanged(DateEntryEvent evt) {
        if (this.guiComponent == null) {
            return;
        }
        DateEntry de = (DateEntry)((Object)this.guiComponent);
        if (evt.getSource() == de.getShowNoneButton()) {
            if (this.notifyChangeStyle) {
                this.pushNtfChangedEvent();
            }
        } else {
            Date d;
            if (!this.allowEmptyStyle || (d = evt.getNewDate()) == null) {
                d = de.getDate();
            }
            if (!this.equals(d, this.value)) {
                this.value = d;
                if (this.notifyChangeStyle) {
                    this.pushNtfChangedEvent();
                }
            }
        }
    }

    private void pushNtfChangedEvent() {
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4100, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    public String getType() {
        return "dateentry";
    }

    @Override
    public void endClearOutAcceptEvents() {
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        if (de != null) {
            de.hidePopup();
        }
    }

    private String adjustLen(String v, int len) {
        if (v == null) {
            v = "";
        }
        if (len > v.length()) {
            return "0000000000000000".substring(0, len - v.length()) + v;
        }
        if (len < v.length()) {
            return v.substring(v.length() - len);
        }
        return v;
    }

    public void setDate(Date d) {
        if (this.guiComponent != null) {
            PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
            new SwingWorker(true, () -> de.setDate(d)).start();
        }
    }

    protected String getTextFormatted() {
        String Return2 = "";
        if (this.guiComponent != null) {
            try {
                PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
                SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
                Date d1 = de.getDate();
                Return2 = d1 != null ? sdf.format(d1) : de.getText();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Return2;
    }

    @Override
    public void putEditorValue(String datetxt) {
        if (this.guiComponent != null) {
            PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormat());
            Date d1 = sdf.parse(datetxt, new ParsePosition(0));
            if (d1 == null) {
                d1 = this.getInitialValue();
            }
            if (d1 != null) {
                this.setDate(d1);
                de.getJCalendar().setDate(d1);
            }
        }
    }

    @Override
    public void startCellEditing() {
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        if (de != null) {
            de.showPopup();
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean removelistener, Dimension scalebitmaptosize) {
        PicobolDateEntry de = (PicobolDateEntry)this.guiComponent;
        de.removeKeyListener(this);
        de.setChangeListener(null);
        RemoteDateEntry clone = null;
        try {
            clone = (RemoteDateEntry)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setComponent(null);
        clone.controlinfo = 0;
        clone.initialize();
        if (this.value != null) {
            clone.value = (Date)this.value.clone();
        }
        if (this.maxVal != null) {
            clone.maxVal = (Date)this.maxVal.clone();
        }
        if (this.minVal != null) {
            clone.minVal = (Date)this.minVal.clone();
        }
        if (this.illegalDateVal != null) {
            clone.illegalDateVal = (Date)this.illegalDateVal.clone();
        }
        if (this.newDate != null) {
            clone.newDate = (Date)this.newDate.clone();
        }
        return clone;
    }

    @Override
    protected void addZoomLayoutDataFonts(ZoomLayout.ZoomLayoutData lData) {
        super.addZoomLayoutDataFonts(lData);
        lData.putAdditionalOrigFont(new ZoomLayout.FontProvider(){

            @Override
            public void setFont(Font f) {
                ((DateEntry)((Object)RemoteDateEntry.this.guiComponent)).setCalendarFont(f);
            }

            @Override
            public Font getFont() {
                return ((DateEntry)((Object)RemoteDateEntry.this.guiComponent)).getCalendarFont();
            }
        });
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle Return2 = super.getBounds();
        if (Return2 != null && Return2.width > 0) {
            Return2.width -= 50;
        }
        return Return2;
    }

    protected void setBoxedStyle() {
        DateEntry pc = (DateEntry)((Object)this.guiComponent);
        if (pc != null) {
            Object border = null;
            if (this.borderWidths != null && this.borderWidths.size() > 0) {
                pc.setBorderW(new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray));
            }
        }
    }

    @Override
    public JComponent getDragDropComponent() {
        DateEntry pc = (DateEntry)((Object)this.guiComponent);
        if (pc != null) {
            return pc.getDragDropComponent();
        }
        return null;
    }

    @Override
    public boolean isDnDStandard() {
        return true;
    }

    @Override
    public void initializeDnDStandard() {
        DateEntry pc = (DateEntry)((Object)this.guiComponent);
        if (pc != null) {
            if (this.dragmode > 0) {
                pc.setDragComponent(this);
            } else {
                pc.setDragComponent(null);
            }
        }
    }
}

