/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusEvent;
import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.ComboBox;
import com.iscobol.gui.client.swing.EntryField;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolChoice;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class RemoteComboBox
extends RemoteBaseGUIControl {
    private static final float DEFAULT_INSETS = 0.4f;
    private static final float DEFAULT_WIDTH_INSETS = 8.0f;
    private static final float DEFAULT_WIDTH = 12.0f;
    private static final JTextField target = new JTextField();
    private int cursorPos;
    private boolean notifySelChange;
    private boolean notifyDblClik;
    private boolean textToUpper;
    private boolean textToLower;
    private boolean unsorted;
    private boolean dropList;
    private boolean noAutosel;
    private int insertionIndex;
    private int lastselected = -1;
    private int resetCombo;
    private Vector<String> items = new Vector();
    private String valueStr = "";
    private float rows;
    private int maxText;
    private int queryIndex;
    private Image image;
    private int bitmapWidth = 16;
    private ActionListener listener;
    private boolean additemwithpopup;
    private String disabledFieldColor;
    private PropertyChangeListener pcListener;
    private boolean f4DropsCombo = true;
    private int configBcolor = -1;
    private int configFcolor = -1;
    private Color defaultBackground;
    private Color defaultForeground;
    private boolean backgroundSet;
    private boolean foregroundSet;
    private boolean isNative;
    private String placeholder;
    private Color placeholderColor;
    private int upperLowerMethod;
    private boolean defaultShortcutsEnabled;
    private String acceptedControlCharacters;
    private Integer selectionColor;
    private Integer selectionBackgroundColor;
    private Integer selectionForegroundColor;
    private boolean selectionBackgroundRgb;
    private boolean selectionForegroundRgb;
    private float itemheight = -1.0f;
    private boolean setoncompsave;
    private float hsave = -1.0f;
    private int massUpdate;
    private String inputFilter;

    public RemoteComboBox(final GuiFactoryImpl gf) {
        super(gf);
        this.isNative = gf.getCsProperty().get("iscobol.gui.native_style", false);
        this.disabledFieldColor = gf.getCsProperty().get("iscobol.gui.disabled_field_color", null);
        this.f4DropsCombo = gf.getCsProperty().get("iscobol.key.f4.system", gf.getCsProperty().get("iscobol.gui.f4_drops_combobox", true));
        this.configBcolor = gf.getCsProperty().get("iscobol.gui.curr_bcolor", -1);
        this.configFcolor = gf.getCsProperty().get("iscobol.gui.curr_fcolor", -1);
        this.upperLowerMethod = gf.getUpperLowerMethod();
        this.defaultShortcutsEnabled = gf.getCsProperty().get("iscobol.key.default_shortcuts_enabled", true);
        this.acceptedControlCharacters = gf.getCsProperty().get("iscobol.key.accepted_control_characters", null);
        this.setPlaceholderColor();
        this.pcListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String key = evt.getPropertyName();
                if (gf != null) {
                    if (key.equals("iscobol.gui.disabled_field_color")) {
                        RemoteComboBox.this.setDisabledFieldColor(gf.getCsProperty().get(key, null));
                    } else if (key.equals("iscobol.gui.f4_drops_combobox")) {
                        RemoteComboBox.this.setF4DropsCombo(gf.getCsProperty().get(key, true));
                    } else if (key.equals("iscobol.key.f4.system")) {
                        RemoteComboBox.this.setF4DropsCombo(gf.getCsProperty().get(key, true));
                    } else if (key.equals("iscobol.gui.curr_bcolor")) {
                        RemoteComboBox.this.configBcolor = gf.getCsProperty().get(key, -1);
                    } else if (key.equals("iscobol.gui.curr_fcolor")) {
                        RemoteComboBox.this.configFcolor = gf.getCsProperty().get(key, -1);
                    } else if (key.equals("iscobol.gui.placeholder_color")) {
                        RemoteComboBox.this.setPlaceholderColor();
                    } else if (key.equals("iscobol.key.accepted_control_characters")) {
                        RemoteComboBox.this.acceptedControlCharacters = gf.getCsProperty().get("iscobol.key.accepted_control_characters", null);
                        if (RemoteComboBox.this.guiComponent != null) {
                            ((PicobolChoice)RemoteComboBox.this.guiComponent).setAcceptedControlCharacters(RemoteComboBox.this.acceptedControlCharacters);
                        }
                    }
                }
            }
        };
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    private void setPlaceholderColor() {
        try {
            int colorNum = Integer.parseInt(this.gf.getCsProperty().get("iscobol.gui.placeholder_color", null));
            this.placeholderColor = this.getForegroundColor(colorNum, false);
        }
        catch (Exception e) {
            this.placeholderColor = null;
        }
        if (this.guiComponent != null) {
            ((PicobolChoice)this.guiComponent).setPlaceholderColor(this.placeholderColor);
        }
    }

    private void setF4DropsCombo(boolean b) {
        this.f4DropsCombo = b;
        if (this.guiComponent != null) {
            ((PicobolChoice)this.guiComponent).setF4DropsCombo(this.f4DropsCombo);
        }
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultHeight() {
        return 1.4f;
    }

    @Override
    public float getDefaultWidth() {
        float f;
        float Return2 = 0.0f;
        Return2 = this.valueStr.length();
        if (f > 0.0f) {
            return Return2;
        }
        return 12.0f;
    }

    @Override
    public int getGUIControlHeight(float height) {
        if (this.itemheight == -1.0f) {
            this.hsave = height;
            return (int)(this.getDefaultHeight() * (float)this.font.getHeight());
        }
        int Return2 = -1;
        Return2 = this.linesInPixel ? (int)this.itemheight : (this.linesInCells && this.getParentBGW() != null ? RemoteComboBox.roundToPix(this.itemheight * (float)this.getParentBGW().getCellHeight()) : (int)(this.itemheight * (float)this.font.getHeight()));
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float width) {
        int Return2 = (int)((float)this.font.getWidth() * width);
        Return2 = (int)((float)Return2 + 8.0f);
        return Return2 += 2 * this.font.getWidth();
    }

    private void updateCursorProps() {
        PicobolChoice pc = (PicobolChoice)this.guiComponent;
        if (pc != null && pc.isEditable()) {
            this.cursorPos = pc.getCaretPosition() + 1;
        }
    }

    @Override
    public String getProp(int key) {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        switch (key) {
            case 142: {
                return "" + this.massUpdate;
            }
            case 147: {
                return "" + this.maxText;
            }
            case 128: 
            case 132: {
                if (cb != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount()) {
                    String Return2 = cb.getItemAt(this.queryIndex - 1).toString();
                    if (this.textToUpper || this.gf.getGuiKdbUpper()) {
                        return Factory.toUpperCase(Return2, this.upperLowerMethod);
                    }
                    if (this.textToLower || this.gf.getGuiKdbLower()) {
                        return Factory.toLowerCase(Return2, this.upperLowerMethod);
                    }
                    return Return2;
                }
                return null;
            }
            case 177: {
                return Integer.toString(this.queryIndex);
            }
            case 127: {
                return Integer.toString(cb.getSelectedIndex() + 1);
            }
            case 59: {
                this.updateCursorProps();
                return "" + this.cursorPos;
            }
            case 324: {
                return this.placeholder;
            }
            case 287: {
                if (!this.selectionBackgroundRgb && this.selectionBackgroundColor != null) {
                    return this.selectionBackgroundColor.toString();
                }
                if (cb.getSelectionBackground() != null) {
                    ColorCmp cmp = new ColorCmp(true);
                    cmp.setBackRGB(cb.getSelectionBackground().getRGB());
                    Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                    return Integer.toString(color != null ? color.getRGB() : 0);
                }
                return "0";
            }
            case 288: {
                if (!this.selectionForegroundRgb && this.selectionForegroundColor != null) {
                    return this.selectionForegroundColor.toString();
                }
                if (cb.getSelectionForeground() != null) {
                    ColorCmp cmp = new ColorCmp(true);
                    cmp.setForeRGB(cb.getSelectionForeground().getRGB());
                    Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                    return Integer.toString(color != null ? color.getRGB() : 0);
                }
                return "0";
            }
            case 383: {
                if (this.selectionColor != null) {
                    return this.selectionColor.toString();
                }
                return "0";
            }
        }
        return super.getProp(key);
    }

    @Override
    public Object getPropObject(int key) {
        Object Return2 = null;
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        switch (key) {
            case 115: {
                Return2 = cb.getHiddenDataAt(this.queryIndex - 1);
            }
        }
        return Return2;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        return cb.getText();
    }

    @Override
    public void setControlEditor(boolean b) {
        super.setControlEditor(b);
        PicobolChoice pc = (PicobolChoice)this.guiComponent;
        if (pc != null) {
            pc.setDrawBorder(!b);
            pc.setControlEditor(b);
        }
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        final PicobolChoice pc = new PicobolChoice(this.isNative, !this.unsorted);
        if (this.name != null) {
            pc.setName(this.name);
        }
        this.guiComponent = pc;
        pc.setDefaultShortcutsEnabled(this.defaultShortcutsEnabled);
        pc.setEditable(!this.dropList);
        pc.setUpperLowerMethod(this.upperLowerMethod);
        if (this.popupListener == null && !this.dropList) {
            this.popupListener = new PopupListener(pc);
        }
        this.guiComponent.addKeyListener(this);
        pc.addOutAcceptListener(this);
        super.intInitialize();
        if (this.itemheight > 0.0f && this.hsave > 0.0f) {
            this.height = this.getGUIControlHeight(this.hsave);
            super.setSize(this.width, this.height, this.setoncompsave);
        }
        if (super.getBackground() == null) {
            this.guiComponent.setBackground(target.getBackground());
        }
        pc.setMaximumRowCount((int)this.rows);
        pc.setAcceptedControlCharacters(this.acceptedControlCharacters);
        this.guiComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(RemoteComboBox.this.guiComponent == null || e.getOppositeComponent() == null || e.getOppositeComponent() == RemoteComboBox.this.guiComponent || RemoteComboBox.this.popupListener != null && RemoteComboBox.this.popupListener.isDefaultPopupVisible())) {
                    pc.setPopupVisible(false);
                    pc.clearSelection();
                }
            }
        });
        pc.addHierarchyListener(e -> {
            if ((e.getChangeFlags() | 4L) == 4L && !pc.isShowing()) {
                pc.clearSelection();
            }
        });
        pc.setMaxText(this.maxText);
        if (this.textToUpper) {
            pc.setUpper(this.textToUpper);
        } else if (this.textToLower) {
            pc.setLower(this.textToLower);
        } else {
            pc.setLower(this.gf.getGuiKdbLower());
            pc.setUpper(this.gf.getGuiKdbUpper());
        }
        pc.setPlaceholder(this.placeholder);
        pc.setPlaceholderColor(this.placeholderColor);
        if (this.inputFilter != null) {
            pc.setInputFilter(this.inputFilter);
        }
        if (this.items.size() > 0) {
            for (String s : this.items) {
                this.additem0(s);
            }
            this.items.clear();
        }
        this.setValue(this.valueStr);
        this.setDisabledFieldColor(this.disabledFieldColor);
        this.setF4DropsCombo(this.f4DropsCombo);
        if (this.selectionColor != null) {
            Color[] cs = this.getColors(this.selectionColor);
            pc.setSelectionBackground(cs[0]);
            pc.setSelectionForeground(cs[1]);
        } else {
            if (this.selectionBackgroundColor != null) {
                Color bg = this.getBackgroundColor(this.selectionBackgroundColor, this.selectionBackgroundRgb);
                pc.setSelectionBackground(bg);
            }
            if (this.selectionForegroundColor != null) {
                Color fg = this.getForegroundColor(this.selectionForegroundColor, this.selectionForegroundRgb);
                pc.setSelectionForeground(fg);
            }
        }
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (this.items.size() > 0) {
            for (String s : this.items) {
                this.additem0(s);
            }
            this.items.clear();
            this.setValue(this.valueStr);
        }
        if (this.listener == null && this.guiComponent != null) {
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RemoteComboBox.this.guiComponent != null) {
                        RemoteComboBox.this.responseOnAction();
                    }
                }
            };
            ((PicobolChoice)this.guiComponent).addActionListener(this.listener);
        }
        if (v) {
            this.loadcursor();
        }
    }

    private void setDisabledFieldColor(String value) {
        this.disabledFieldColor = value;
        if (this.guiComponent != null) {
            boolean[] applyAlways = new boolean[1];
            Color[] fieldColors = this.getFieldColors(this.disabledFieldColor, applyAlways);
            ComboBox cb = (ComboBox)((Object)this.guiComponent);
            if (applyAlways[0] || !this.backgroundSet) {
                cb.setDisabledBackground(fieldColors[0]);
            } else {
                cb.setDisabledBackground(null);
            }
            if (applyAlways[0] || !this.foregroundSet) {
                cb.setDisabledForeground(fieldColors[1]);
            } else {
                cb.setDisabledForeground(null);
            }
        }
    }

    private void responseOnAction() {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        int currselected = ((PicobolChoice)this.guiComponent).getSelectedIndex();
        if (this.notifySelChange) {
            CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4099, (short)(currselected + 1), 0, true, true, true));
            this.pushEvent(cc);
        }
        if (!this.noAutosel) {
            ((PicobolChoice)this.guiComponent).selectAll();
        }
        this.lastselected = currselected;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.notifyDblClik && this.guiComponent.isEnabled() && evt.getClickCount() == 2) {
            int currselected = ((PicobolChoice)this.guiComponent).getSelectedIndex();
            CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(16, 18, (short)(currselected + 1)));
            this.pushEvent(cc);
        }
    }

    @Override
    protected boolean isMenuKeyPressed(KeyEvent evt) {
        if (((PicobolChoice)this.guiComponent).isPopupVisible()) {
            return false;
        }
        return super.isMenuKeyPressed(evt);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        switch (key) {
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return;
            }
            case 115: {
                if (!this.f4DropsCombo) break;
                return;
            }
            case 27: {
                if (((PicobolChoice)this.guiComponent).isPopupVisible()) {
                    return;
                }
            }
            case 67: 
            case 86: 
            case 88: 
            case 89: 
            case 90: {
                if (!evt.isControlDown() || this.dropList || !this.defaultShortcutsEnabled) break;
                return;
            }
        }
        super.keyPressed(evt);
    }

    @Override
    protected void intFocusGained(boolean restore) {
        if (!this.noAutosel) {
            ((PicobolChoice)this.guiComponent).selectAll();
        }
        if (!restore) {
            this.setconfigBF();
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    protected void setAction(int actionValue) {
        int action = actionValue;
        PicobolChoice pc = (PicobolChoice)this.guiComponent;
        if (pc != null && pc.isVisible() && pc.isEnabled()) {
            switch (action) {
                case 2: {
                    pc.copy();
                    break;
                }
                case 3: {
                    if (!ScreenUtility.canPaste(EntryField.class)) break;
                    pc.paste();
                    break;
                }
                case 1: {
                    pc.cut();
                    break;
                }
                case 4: {
                    pc.replaceSelection("");
                    break;
                }
                case 5: {
                    pc.undo();
                    break;
                }
                case 6: {
                    pc.redo();
                    break;
                }
                case 7: {
                    pc.selectAll();
                    break;
                }
                default: {
                    super.setAction(actionValue);
                }
            }
        }
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int idx) {
        this.queryIndex = idx;
    }

    @Override
    public void setElementAt(int[] idxs) {
        this.queryIndex = idxs[0];
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
        this.image = this.getLocalImage(imageId);
    }

    @Override
    public String setProp(Integer key, byte[] value, int length) {
        String Return2 = "0";
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        switch (key) {
            case 115: {
                if (cb != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount()) {
                    cb.setHiddenDataAt(this.queryIndex - 1, value);
                }
                Return2 = "1";
            }
        }
        return Return2;
    }

    @Override
    public String setProp(Integer key, String[] values) {
        String Return2 = "0";
        if (values == null) {
            return "0";
        }
        if (key == 129) {
            boolean notifySelChangeSave = this.notifySelChange;
            this.notifySelChange = false;
            for (int i = 0; i < values.length; ++i) {
                String v = ScreenUtility.rightTrim(values[i]);
                if (v.length() <= 0) continue;
                this.additem(v);
            }
            this.notifySelChange = notifySelChangeSave;
            Return2 = "" + this.queryIndex;
        }
        return Return2;
    }

    private void loadcursor() {
        PicobolChoice pc = (PicobolChoice)this.guiComponent;
        if (pc != null && pc.isEditable()) {
            if (this.cursorPos > 0) {
                this.setCursorPos();
            } else if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getPreviousFocusOwner() != this) {
                pc.setCaretPosition(0);
            }
        }
    }

    private void setCursorPos() {
        PicobolChoice pc;
        if (this.cursorPos == 0) {
            this.cursorPos = 1;
        }
        if ((pc = (PicobolChoice)this.guiComponent) != null && pc.isEditable()) {
            try {
                pc.setCaretPosition(this.cursorPos - 1);
            }
            catch (IllegalArgumentException e) {
                pc.setCaretPosition(pc.getText().length());
            }
        }
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        boolean isrgb = false;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        switch (key) {
            case 142: {
                if (error) break;
                this.massUpdate = intValue;
                Return2 = "1";
                break;
            }
            case 59: {
                if (error) break;
                this.cursorPos = intValue;
                if (this.cursorPos == -1 && cb != null) {
                    cb.selectAll();
                } else {
                    this.setCursorPos();
                }
                Return2 = "1";
                break;
            }
            case 124: {
                if (error) break;
                this.insertionIndex = intValue;
                if (this.insertionIndex < 1) {
                    this.insertionIndex = 1;
                }
                if (this.insertionIndex > this.getItemCount()) {
                    this.insertionIndex = this.getItemCount();
                }
                Return2 = "1";
                break;
            }
            case 127: 
            case 177: {
                if (error) break;
                this.queryIndex = intValue;
                Return2 = "1";
                break;
            }
            case 128: 
            case 132: {
                if (cb != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount()) {
                    String v = ScreenUtility.rightTrim(value);
                    cb.modifyItemAt(this.queryIndex - 1, v);
                }
                Return2 = "1";
                break;
            }
            case 20: {
                if (error) break;
                this.bitmapWidth = intValue;
                Return2 = "1";
                break;
            }
            case 12: {
                Image strip;
                if (error) break;
                if (cb != null && this.image != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount() && (strip = ScreenUtility.getImage(this.bitmapWidth, -1, this.image, intValue)) != null) {
                    cb.modifyItemAt(this.queryIndex - 1, new ImageIcon(strip));
                }
                Return2 = "1";
                break;
            }
            case 115: {
                if (cb != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount()) {
                    cb.setHiddenDataAt(this.queryIndex - 1, value);
                }
                Return2 = "1";
                break;
            }
            case 369: {
                if (error) break;
                if (cb != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount()) {
                    Color[] cs = this.getColors(intValue);
                    cb.setColorAt(this.queryIndex - 1, intValue, cs[0], cs[1]);
                }
                Return2 = "1";
                break;
            }
            case 371: {
                isrgb = true;
            }
            case 370: {
                if (error) break;
                if (cb != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount()) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    cb.setBackgroundColorAt(this.queryIndex - 1, intValue, bg);
                }
                Return2 = "1";
                break;
            }
            case 373: {
                isrgb = true;
            }
            case 372: {
                if (error) break;
                if (cb != null && this.queryIndex > 0 && this.queryIndex <= cb.getItemCount()) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    cb.setForegroundColorAt(this.queryIndex - 1, intValue, fg);
                }
                Return2 = "1";
                break;
            }
            case 383: {
                if (error) break;
                this.selectionColor = intValue;
                if (cb != null) {
                    Color[] cs = this.getColors(intValue);
                    cb.setSelectionBackground(cs[0]);
                    cb.setSelectionForeground(cs[1]);
                }
                Return2 = "1";
                break;
            }
            case 384: {
                isrgb = true;
            }
            case 287: {
                if (error) break;
                this.selectionBackgroundColor = intValue;
                this.selectionBackgroundRgb = isrgb;
                if (cb != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    cb.setSelectionBackground(bg);
                }
                Return2 = "1";
                break;
            }
            case 385: {
                isrgb = true;
            }
            case 288: {
                if (error) break;
                this.selectionForegroundColor = intValue;
                this.selectionForegroundRgb = isrgb;
                if (cb != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    cb.setSelectionForeground(fg);
                }
                Return2 = "1";
                break;
            }
            case 130: {
                if (error) break;
                if (intValue > 0) {
                    this.removeitem(intValue - 1);
                }
                Return2 = "1";
                break;
            }
            case 129: {
                String v = ScreenUtility.rightTrim(value);
                if (v.length() > 0) {
                    this.additem(v);
                }
                Return2 = "" + this.queryIndex;
                break;
            }
            case 190: {
                if (error) break;
                this.resetCombo = intValue;
                if (this.resetCombo != 0) {
                    this.removeAll();
                }
                Return2 = "1";
                break;
            }
            case 324: {
                this.placeholder = value.trim();
                if (cb != null) {
                    cb.setPlaceholder(this.placeholder);
                }
                Return2 = "1";
                break;
            }
            case 147: {
                if (error) break;
                this.maxText = intValue;
                if (cb != null) {
                    cb.setMaxText(this.maxText);
                }
                Return2 = "1";
                break;
            }
            case 386: {
                float f = -1.0f;
                boolean ferror = false;
                try {
                    f = Float.parseFloat(value.replace(',', '.'));
                }
                catch (NumberFormatException e) {
                    ferror = true;
                }
                if (ferror) break;
                this.itemheight = f;
                if (this.guiComponent == null) break;
                this.height = this.getGUIControlHeight(this.hsave);
                super.setSize(this.width, this.height, this.setoncompsave);
                break;
            }
            case 436: {
                this.setInputFilter(value);
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    private void additem(String origItem) {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        if ((origItem = ScreenUtility.rightTrim(origItem)).length() == 0) {
            return;
        }
        int index = 0;
        if (this.insertionIndex <= 0) {
            int end = this.getItemCount();
            index = this.unsorted ? end + 1 : this.getInsertionIndex(origItem) + 1;
        } else {
            index = this.insertionIndex;
            this.insertionIndex = 0;
        }
        if (cb != null) {
            if (!this.additemwithpopup && (this.additemwithpopup = cb.isPopupVisible())) {
                cb.hidePopup();
            }
            this.insertitem(origItem, index - 1);
        } else {
            this.items.add(index - 1, origItem);
        }
        this.queryIndex = index;
    }

    private void insertitem(String s, int idx) {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        cb.insertItemAt(s, idx);
        if (this.valueStr != null) {
            this.intSetValue(this.valueStr);
        }
    }

    private void additem0(String s) {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        cb.addItem(s);
    }

    private void removeitem(int idx) {
        if (idx < this.getItemCount()) {
            if (this.guiComponent != null) {
                PicobolChoice cb = (PicobolChoice)this.guiComponent;
                cb.removeItemAt(idx);
                if (this.lastselected == idx) {
                    this.lastselected = cb.getSelectedIndex();
                }
            } else {
                this.items.removeElementAt(idx);
            }
        }
    }

    @Override
    public void setRowsCols(float r, float c) {
        if (r > 0.0f) {
            this.rows = r < 2.0f ? 1.0f : r - 1.0f;
        }
        if (this.maxText == 0 && c > 0.0f) {
            this.maxText = (int)c;
        }
    }

    @Override
    protected Rectangle paramdisplaysetSize(ParamElementSize ps) {
        if (ps.getlines == 0.0f) {
            this.rows = 4.0f;
        }
        return super.paramdisplaysetSize(ps);
    }

    @Override
    protected float parammodifyLines(ParamElementSize ps) {
        if (ps.getlines == 0.0f) {
            this.rows = 4.0f;
        }
        return super.parammodifyLines(ps);
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolChoice pc = (PicobolChoice)this.guiComponent;
        if ((s & 0x200) == 512) {
            this.notifySelChange = set;
        }
        if ((s & 0x100) == 256) {
            this.notifyDblClik = set;
        }
        if ((s & 0x800) == 2048) {
            this.textToUpper = set;
            boolean bl = this.textToLower = !set;
            if (pc != null) {
                pc.setUpper(true);
                pc.setLower(false);
            }
        }
        if ((s & 0x1000) == 4096) {
            this.textToLower = set;
            boolean bl = this.textToUpper = !set;
            if (pc != null) {
                pc.setLower(true);
                pc.setUpper(false);
            }
        }
        if ((s & 0x2000) == 8192) {
            this.noAutosel = set;
        }
        if ((s & 1) == 1) {
            this.unsorted = set;
        }
        if ((s & 4) == 4) {
            this.dropList = set;
        }
    }

    @Override
    public void setTitle(String v) {
    }

    private int getItemCount() {
        if (this.guiComponent != null) {
            return ((PicobolChoice)this.guiComponent).getItemCount();
        }
        return this.items.size();
    }

    @Override
    public String setValue(String v) {
        this.valueStr = v;
        if (this.guiComponent != null) {
            this.intSetValue(v);
            this.loadcursor();
        }
        return this.valueStr;
    }

    private void intSetValue(String v) {
        String tmpstr = ScreenUtility.rightTrim(v);
        if (tmpstr.length() > 0) {
            this.setSelectedItem(tmpstr);
        } else {
            this.setSelectedIndex(-1);
        }
    }

    private void setSelectedIndex(int idx) {
        this.lastselected = idx;
        ((PicobolChoice)this.guiComponent).select(idx);
    }

    private int getIndexOfExactItem(Object[] items, String str) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().equals(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfExactItemIgnoreCase(Object[] items, String str) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().equalsIgnoreCase(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfItemStartingWith(Object[] items, String str) {
        str = str.toLowerCase();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].toString().toLowerCase().startsWith(str)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfItem(Object[] items, String str) {
        int i = this.getIndexOfExactItem(items, str);
        if (i >= 0) {
            return i;
        }
        i = this.getIndexOfExactItemIgnoreCase(items, str);
        if (i >= 0) {
            return i;
        }
        return this.getIndexOfItemStartingWith(items, str);
    }

    private boolean setSelectedItem(final String s) {
        final PicobolChoice cb = (PicobolChoice)this.guiComponent;
        if (cb == null) {
            return false;
        }
        Object[] items = new Object[cb.getItemCount()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = cb.getItemAt(i);
        }
        int index = this.getIndexOfItem(items, s);
        if (index != this.lastselected) {
            this.setSelectedIndex(index);
        }
        if (!this.dropList) {
            new SwingWorker(true){

                @Override
                public void launch() {
                    cb.setText(s);
                }
            }.start();
        }
        return true;
    }

    private void removeAll() {
        if (this.guiComponent != null) {
            ((PicobolChoice)this.guiComponent).removeAllItems();
            this.lastselected = -1;
        } else {
            this.items.clear();
        }
        this.valueStr = "";
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        this.pcListener = null;
        super.destroy();
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        super.handleResponse(eventAction, rra);
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        this.width = w;
        if (this.itemheight == -1.0f || this.linesInCells || this.linesInPixel) {
            this.hsave = h;
            this.setoncompsave = setOnComp;
        }
        this.height = this.getGUIControlHeight(1.0f);
        if (this.rows == 0.0f) {
            this.rows = (int)((float)h / (float)this.font.getHeight()) - 1;
        }
        if (this.guiComponent != null && setOnComp) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        if (ps.ccOlen != -1) {
            return ps.ccOlen;
        }
        if (ps.ccIlen != -1) {
            return ps.ccIlen;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public String getType() {
        return "combobox";
    }

    @Override
    public void endloadParams() {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        if (cb != null && this.additemwithpopup) {
            cb.showPopup();
        }
        this.additemwithpopup = false;
    }

    @Override
    public void endClearOutAcceptEvents() {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        if (cb != null) {
            cb.hidePopup();
        }
    }

    @Override
    public void endRepostOutAcceptEvents() {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        if (cb != null) {
            cb.myshowPopup();
        }
    }

    @Override
    public void startCellEditing() {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        if (cb != null) {
            cb.showPopup();
        }
    }

    private Color getOriginalBackground() {
        Color Return2 = this.getBackground();
        if (Return2 == null) {
            Return2 = this.defaultBackground;
        }
        return Return2;
    }

    private Color getOriginalForeground() {
        Color Return2 = this.getForeground();
        if (Return2 == null) {
            Return2 = this.defaultForeground;
        }
        return Return2;
    }

    private void restoreBF() {
        if (this.guiComponent != null) {
            Color c;
            if (this.configBcolor != -1 && (c = this.getOriginalBackground()) != null) {
                this.guiComponent.setBackground(c);
            }
            if ((this.configFcolor != -1 || this.configBcolor != -1) && (c = this.getOriginalForeground()) != null) {
                this.guiComponent.setForeground(c);
            }
        }
    }

    private void setconfigBF() {
        if (this.guiComponent != null) {
            if (this.configBcolor != -1) {
                if (this.defaultBackground == null) {
                    this.defaultBackground = ((PicobolChoice)this.guiComponent).background();
                }
                this.guiComponent.setBackground(this.gf.getRemotePalette().getDefaultColor(this.configBcolor));
            }
            if (this.configFcolor != -1) {
                if (this.defaultForeground == null) {
                    this.defaultForeground = ((PicobolChoice)this.guiComponent).foreground();
                }
                this.guiComponent.setForeground(this.gf.getRemotePalette().getDefaultColor(this.configFcolor));
            } else if (this.configBcolor != -1) {
                if (this.defaultForeground == null) {
                    this.defaultForeground = ((PicobolChoice)this.guiComponent).foreground();
                }
                this.guiComponent.setForeground(((PicobolChoice)this.guiComponent).foreground());
            }
        }
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl opposite, MouseEvent me, RemoteRecordAccept rra) {
        if (opposite != this) {
            this.restoreBF();
        }
        return true;
    }

    @Override
    public void focusLost(CobolFocusEvent cfe) {
        this.restoreBF();
        super.focusLost(cfe);
    }

    @Override
    public void focusGained(CobolFocusEvent cfe) {
        if (cfe.isGoto()) {
            this.setconfigBF();
        }
        super.focusGained(cfe);
    }

    @Override
    public void setColorBackgroundIdx(int idx) {
        boolean oldVal = this.backgroundSet;
        super.setColorBackgroundIdx(idx);
        boolean bl = this.backgroundSet = this.getBackground() != null;
        if (oldVal != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorBackground(int r, int g, int b) {
        boolean oldVal = this.backgroundSet;
        super.setColorBackground(r, g, b);
        boolean bl = this.backgroundSet = this.getBackground() != null;
        if (oldVal != this.backgroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForegroundIdx(int idx) {
        boolean oldVal = this.foregroundSet;
        super.setColorForegroundIdx(idx);
        boolean bl = this.foregroundSet = this.getForeground() != null;
        if (oldVal != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public void setColorForeground(int r, int g, int b) {
        boolean oldVal = this.foregroundSet;
        super.setColorForeground(r, g, b);
        boolean bl = this.foregroundSet = this.getForeground() != null;
        if (oldVal != this.foregroundSet) {
            this.setDisabledFieldColor(this.disabledFieldColor);
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean removelistener, Dimension scalebitmaptosize) {
        RemoteComboBox clone = null;
        try {
            clone = (RemoteComboBox)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setComponent(null);
        if (this.items != null && this.items.size() > 0) {
            clone.copyitems(this.items);
            clone.initialize();
        } else {
            clone.initialize();
            clone.copyitems2((PicobolChoice)this.guiComponent);
        }
        return clone;
    }

    private void copyitems(Vector itemsource) {
        if (itemsource != null && itemsource.size() > 0) {
            this.items = new Vector();
            Enumeration en = itemsource.elements();
            while (en.hasMoreElements()) {
                this.items.add((String)en.nextElement());
            }
        }
    }

    public void copyitems2(PicobolChoice source) {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        cb.copyItems(source);
    }

    private int getInsertionIndex(String element) {
        int leftIndex = 0;
        int rightIndex = this.getItemCount() - 1;
        int index = leftIndex + (rightIndex - leftIndex) / 2;
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        while (leftIndex <= rightIndex) {
            String item = cb != null ? cb.getItemAt(index).toString() : this.items.elementAt(index);
            int c = item.compareToIgnoreCase(element);
            if (c == 0) {
                return index;
            }
            if (c > 0) {
                rightIndex = index - 1;
            } else {
                leftIndex = index + 1;
            }
            index = leftIndex + (rightIndex - leftIndex) / 2;
        }
        return index;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle Return2 = super.getBounds();
        if (Return2 != null && Return2.width > 0) {
            Return2.width = (int)((float)Return2.width - 8.0f);
            Return2.width -= 2 * this.font.getWidth();
        }
        return Return2;
    }

    @Override
    public JComponent getDragDropComponent() {
        PicobolChoice cb = (PicobolChoice)this.guiComponent;
        if (cb != null) {
            return cb.getDragDropComponent();
        }
        return null;
    }

    @Override
    public boolean isDnDStandard() {
        boolean Return2 = false;
        PicobolChoice pc = (PicobolChoice)this.guiComponent;
        if (pc != null && pc.isEditable()) {
            Return2 = true;
        }
        return Return2;
    }

    @Override
    public void initializeDnDStandard() {
        PicobolChoice pc = (PicobolChoice)this.guiComponent;
        if (pc != null) {
            if (this.dragmode > 0) {
                pc.setDragComponent(this);
            } else {
                pc.setDragComponent(null);
            }
        }
    }

    private void setInputFilter(String ifstr) {
        if (this.inputFilter == null || !this.inputFilter.equals(ifstr)) {
            PicobolChoice pc = (PicobolChoice)this.guiComponent;
            this.inputFilter = ifstr;
            if (pc != null) {
                pc.setInputFilter(this.inputFilter);
            }
        }
    }
}

