/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.Terminal;
import com.iscobol.gui.client.swing.BorderedPanel;
import com.iscobol.gui.client.swing.PicobolStatusBar;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class MainPanel
extends BorderedPanel {
    private int width;
    private int height;
    private int origWidth;
    private int origHeight;
    private boolean expandable;
    private Component rightmostComponent;
    private int rightmostX = -1;
    private Component bottommostComponent;
    private int bottommostY = -1;
    private ComponentListener listener = new ComponentAdapter(){

        private void handleEvent(ComponentEvent e) {
            if (e.getComponent() == MainPanel.this.rightmostComponent || e.getComponent() == MainPanel.this.bottommostComponent) {
                MainPanel.this.setBottomRightmostComponent();
                if (MainPanel.this.rightmostX >= 0 || MainPanel.this.bottommostY >= 0) {
                    MainPanel.this.adjustSize();
                }
            } else {
                MainPanel.this.setBottomRightmostComponent(e.getComponent());
                if (MainPanel.this.rightmostComponent == e.getComponent() || MainPanel.this.bottommostComponent == e.getComponent()) {
                    MainPanel.this.adjustSize();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.handleEvent(e);
        }
    };

    public MainPanel(RemoteDisplayWindow dw, boolean paintSW) {
        super(dw, paintSW);
    }

    public MainPanel(boolean paintSW) {
        this((RemoteDisplayWindow)null, paintSW);
    }

    @Override
    public Component add(Component comp) {
        return this.add(comp, -1);
    }

    @Override
    public Component add(Component comp, int idx) {
        if (this.getLayout() == null && this.expandable && this.isValidComponent(comp)) {
            this.setBottomRightmostComponent(comp);
            if (comp == this.rightmostComponent || comp == this.bottommostComponent) {
                this.adjustSize();
            }
            comp.addComponentListener(this.listener);
        }
        Component Return2 = idx >= 0 ? super.add(comp, idx) : super.add(comp);
        return Return2;
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        if (this.getLayout() == null && this.expandable && this.isValidComponent(comp)) {
            comp.removeComponentListener(this.listener);
            if (comp == this.rightmostComponent || comp == this.bottommostComponent) {
                this.setBottomRightmostComponent();
                if (this.rightmostX >= 0 || this.bottommostY >= 0) {
                    this.adjustSize();
                }
            }
        }
    }

    private boolean isValidComponent(Component comp) {
        return !(comp instanceof Terminal) && !(comp instanceof PicobolStatusBar);
    }

    private void adjustSize() {
        this.mySetSize(Math.max(this.origWidth, this.rightmostX), Math.max(this.origHeight, this.bottommostY));
    }

    public Dimension getOrigSize() {
        return new Dimension(this.origWidth, this.origHeight);
    }

    private void setBottomRightmostComponent(Component c) {
        if (this.rightmostX >= 0 || this.bottommostY >= 0) {
            Rectangle r = c.getBounds();
            if (r.x + r.width > this.rightmostX) {
                this.rightmostComponent = c;
                this.rightmostX = r.x + r.width;
            }
            if (r.y + r.height > this.bottommostY) {
                this.bottommostComponent = c;
                this.bottommostY = r.y + r.height;
            }
        } else if (this.rightmostX == -1 && this.bottommostY == -1) {
            this.rightmostComponent = c;
            this.bottommostComponent = c;
            Rectangle r = c.getBounds();
            this.rightmostX = r.x + r.width;
            this.bottommostY = r.y + r.height;
        }
    }

    private void setBottomRightmostComponent() {
        Component[] components = this.getComponents();
        Component c = null;
        Point p = new Point();
        for (int i = 0; i < components.length; ++i) {
            if (!this.isValidComponent(components[i])) continue;
            c = components[i];
            Rectangle r = c.getBounds();
            int lastX = r.x + r.width;
            int lastY = r.y + r.height;
            if (lastX > p.x) {
                p.x = lastX;
                this.rightmostComponent = c;
                this.rightmostX = lastX;
            }
            if (lastY <= p.y) continue;
            p.y = lastY;
            this.bottommostComponent = c;
            this.bottommostY = lastY;
        }
    }

    public Dimension myGetSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myGetSize();
    }

    public void mySetSize(int w, int h) {
        if (this.width != w || this.height != h) {
            this.width = w;
            this.height = h;
            this.setSize(w, h);
        }
    }

    public void setInitD(int w, int h) {
        this.origWidth = w;
        this.origHeight = h;
        this.mySetSize(this.origWidth, this.origHeight);
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }
}

